<?php
/*------------------------------------------------------------------------
# mod_sidebar_social_share - Sidebar Social Share
# ------------------------------------------------------------------------
# author    Contona Services
# copyright Copyright (C) 2012-13, www.contona.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.contona.com
-------------------------------------------------------------------------*/
// no direct access
defined('_JEXEC') or die('Direct Access to this location is not allowed.');


use Joomla\CMS\Factory;
 
$doc = Factory::getDocument();

$place = $params->get('place', '');
$v_place = $params->get('v_place', '');
$show = $params->get('show', '');
$popup = $params->get('popup', '');
$popup_width = $params->get('popup_width', '');
$popup_height = $params->get('popup_height', '');

$mail = $params->get('mail', '');
$facebook = $params->get('facebook', '');
$linkedin = $params->get('linkedin', '');
$odnoklassniki = $params->get('odnoklassniki', '');
$pinterest = $params->get('pinterest', '');
$reddit = $params->get('reddit', '');
$telegram = $params->get('telegram', '');
$tumblr = $params->get('tumblr', '');
$twitter = $params->get('twitter', '');
$viber = $params->get('viber', '');
$vk = $params->get('vk', '');
$whatsapp = $params->get('whatsapp', '');
$instagram = $params->get('instagram', '');
$insta_url = $params->get('insta_url', '');

$order = $params->get('order', '');

$mail_o = $params->get('mail_o', '');
$facebook_o = $params->get('facebook_o', '');
$linkedin_o = $params->get('linkedin_o', '');
$odnoklassniki_o = $params->get('odnoklassniki_o', '');
$pinterest_o = $params->get('pinterest_o', '');
$reddit_o = $params->get('reddit_o', '');
$telegram_o = $params->get('telegram_o', '');
$tumblr_o = $params->get('tumblr_o', '');
$twitter_o = $params->get('twitter_o', '');
$viber_o = $params->get('viber_o', '');
$vk_o = $params->get('vk_o', '');
$whatsapp_o = $params->get('whatsapp_o', '');
$instagram_o = $params->get('instagram_o', '');

$doc->addScript('modules/mod_sidebar_social_share/assets/jquery.floating-social-share.js'); 
$doc->addStyleSheet('modules/mod_sidebar_social_share/assets/min/jquery.floating-social-share.min.css');

$style = '
    #floatingSocialShare {
        position: absolute;
        z-index: 999;
    }
    #floatingSocialShare .top-left, #floatingSocialShare .top-right, #floatingSocialShare .content-left, #floatingSocialShare .content-right {
        top: '.$v_place.';
    }
    @media only screen and (max-width: 961px) {
        #floatingSocialShare .top-left, #floatingSocialShare .top-right, #floatingSocialShare .content-left, #floatingSocialShare .content-right {
            top: auto;
            bottom: 0;
        }
    }
    #floatingSocialShare .instagram {
        background-color: #ed444f;
    }
';
$doc->addStyleDeclaration($style);




if ($show) { 
    $orderArray=[
        $mail_o=>'mail',
        $facebook_o=>'facebook',
        $linkedin_o=>'linkedin',
        $odnoklassniki_o=>'odnoklassniki',
        $pinterest_o=>'pinterest',
        $reddit_o=>'reddit',
        $telegram_o=>'telegram',
        $tumblr_o=>'tumblr',
        $twitter_o=>'twitter',
        $viber_o=>'viber',
        $vk_o=>'vk',
        $whatsapp_o=>'whatsapp',
        $instagram_o=>'instagram'
    ];
    if($order){
        ksort($orderArray);
    } else{
        krsort($orderArray);
    }
    $buttons = '';
    foreach($orderArray as $key => $value) {
        $buttons .= '"'.$value.'",';
    }
} else{ 

    $orderArray=[];

    ($mail) ? $orderArray[$mail_o] = $mail : '';
    ($facebook) ? $orderArray[$facebook_o] = $facebook : '';
    ($linkedin) ? $orderArray[$linkedin_o] = $linkedin : '';
    ($odnoklassniki) ? $orderArray[$odnoklassniki_o] = $odnoklassniki : '';
    ($pinterest) ? $orderArray[$pinterest_o] = $pinterest : "";
    ($reddit) ? $orderArray[$reddit_o] = $reddit : "";
    ($telegram) ? $orderArray[$telegram_o] = $telegram : "";
    ($tumblr) ? $orderArray[$tumblr_o] = $tumblr : "";
    ($twitter) ? $orderArray[$twitter_o] = $twitter : "";
    ($viber) ? $orderArray[$viber_o] = $viber : "";
    ($vk) ? $orderArray[$vk_o] = $vk : "";
    ($whatsapp) ? $orderArray[$whatsapp_o] = $whatsapp : "";
    ($instagram) ? $orderArray[$instagram_o] = $instagram : "";

    if($order){
        ksort($orderArray);
    } else{
        krsort($orderArray);
    }
    $buttons = '';
    foreach($orderArray as $key => $value) {
        $buttons .= '"'.$value.'",';
    }
} 

$script = '
jQuery.noConflict();
jQuery(document).ready(function() {
    jQuery("body").floatingSocialShare({
        place: "'.$place.'", 
        counter: false, 
        facebook_token: null,
        buttons: ['.$buttons.'],
        title: document.title, 
        url: window.location.href,
        insta_url: "'.$insta_url.'",  
        text_title_case: true,
        description: jQuery("meta[name=\"description\"]").attr("content"), 
        media: jQuery("meta[property=\"og:image\"]").attr("content"), 
        target: true,
        popup: '.$popup.',
        popup_width: '.$popup_width.',
        popup_height: '.$popup_height.'
    });
})
';
$doc->addScriptDeclaration($script);