/**ABDB**/CREATE TABLE `#__workflows` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_extension` (`extension`),
  KEY `idx_default` (`default`),
  KEY `idx_created` (`created`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_modified` (`modified`),
  KEY `idx_modified_by` (`modified_by`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflows`  VALUES 
('1', '56', '1', 'COM_WORKFLOW_BASIC_WORKFLOW', '', 'com_content.article', '1', '1', '2022-05-16 05:45:59', '49', '2022-05-16 05:45:59', '49', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_transitions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `workflow_id` int NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_stage_id` int NOT NULL,
  `to_stage_id` int NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_transitions`  VALUES 
('1', '58', '1', '1', '1', 'UNPUBLISH', '', '-1', '1', '{\"publishing\":\"0\"}', NULL, NULL),
('2', '59', '2', '1', '1', 'PUBLISH', '', '-1', '1', '{\"publishing\":\"1\"}', NULL, NULL),
('3', '60', '3', '1', '1', 'TRASH', '', '-1', '1', '{\"publishing\":\"-2\"}', NULL, NULL),
('4', '61', '4', '1', '1', 'ARCHIVE', '', '-1', '1', '{\"publishing\":\"2\"}', NULL, NULL),
('5', '62', '5', '1', '1', 'FEATURE', '', '-1', '1', '{\"featuring\":\"1\"}', NULL, NULL),
('6', '63', '6', '1', '1', 'UNFEATURE', '', '-1', '1', '{\"featuring\":\"0\"}', NULL, NULL),
('7', '64', '7', '1', '1', 'PUBLISH_AND_FEATURE', '', '-1', '1', '{\"publishing\":\"1\",\"featuring\":\"1\"}', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_stages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `workflow_id` int NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_workflow_id` (`workflow_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_default` (`default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_stages`  VALUES 
('1', '57', '1', '1', '1', 'COM_WORKFLOW_BASIC_STAGE', '', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_associations` (
  `item_id` int NOT NULL DEFAULT '0' COMMENT 'Extension table id value',
  `stage_id` int NOT NULL COMMENT 'Foreign Key to #__workflow_stages.id',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`,`extension`),
  KEY `idx_item_stage_extension` (`item_id`,`stage_id`,`extension`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_stage_id` (`stage_id`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_associations`  VALUES 
('1', '1', 'com_content.article'),
('2', '1', 'com_content.article'),
('3', '1', 'com_content.article'),
('4', '1', 'com_content.article'),
('5', '1', 'com_content.article'),
('6', '1', 'com_content.article'),
('7', '1', 'com_content.article'),
('8', '1', 'com_content.article'),
('9', '1', 'com_content.article'),
('10', '1', 'com_content.article'),
('11', '1', 'com_content.article');
/**ABDB**/CREATE TABLE `#__webauthn_credentials` (
  `id` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'User handle',
  `label` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int NOT NULL DEFAULT '0',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '2', '[6,2,8]'),
('3', 'Special', '3', '[6,3,8]'),
('5', 'Guest', '1', '[9]'),
('6', 'Super Users', '4', '[8]');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block` tinyint NOT NULL DEFAULT '0',
  `sendEmail` tinyint DEFAULT '0',
  `registerDate` datetime NOT NULL,
  `lastvisitDate` datetime DEFAULT NULL,
  `activation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastResetTime` datetime DEFAULT NULL COMMENT 'Date of last password reset',
  `resetCount` int NOT NULL DEFAULT '0' COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint NOT NULL DEFAULT '0' COMMENT 'Require user to reset password on next login',
  `authProvider` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Name of used authentication plugin',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_name` (`name`(100)),
  KEY `idx_block` (`block`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('49', 'Admin', 'admin', 'admin@admin.com', '$2y$10$bE8FBIlRHTv2oUkXatwn0e.kB1mqLDB/PbFqFMHGG3rUS1Czs2api', '0', '1', '2022-05-16 05:46:03', '2022-08-23 05:11:19', '0', '', NULL, '0', '', '', '0', '');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Adjacency List Reference Id',
  `lft` int NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`) 
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__users.id',
  `group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('49', '8');
/**ABDB**/CREATE TABLE `#__user_profiles` (
  `user_id` int NOT NULL,
  `profile_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `review_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_keys` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `series` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uastring` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int NOT NULL AUTO_INCREMENT,
  `update_site_id` int DEFAULT '0',
  `extension_id` int DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint DEFAULT '0',
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text COLLATE utf8mb4_unicode_ci,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=321 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('272', '2', '0', 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', '0', '4.0.2.1', '', 'https://update.joomla.org/language/details4/ar-AA_details.xml', '', '', ''),
('273', '2', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '4.1.5.1', '', 'https://update.joomla.org/language/details4/bg-BG_details.xml', '', '', ''),
('274', '2', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '4.0.4.2', '', 'https://update.joomla.org/language/details4/ca-ES_details.xml', '', '', ''),
('275', '2', '0', 'Chinese, Simplified', '', 'pkg_zh-CN', 'package', '', '0', '4.1.0.3', '', 'https://update.joomla.org/language/details4/zh-CN_details.xml', '', '', ''),
('276', '2', '0', 'Chinese, Traditional', '', 'pkg_zh-TW', 'package', '', '0', '4.1.4.2', '', 'https://update.joomla.org/language/details4/zh-TW_details.xml', '', '', ''),
('277', '2', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/cs-CZ_details.xml', '', '', ''),
('278', '2', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/da-DK_details.xml', '', '', ''),
('279', '2', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/nl-NL_details.xml', '', '', ''),
('280', '2', '0', 'English, Australia', '', 'pkg_en-AU', 'package', '', '0', '4.1.2.1', '', 'https://update.joomla.org/language/details4/en-AU_details.xml', '', '', ''),
('281', '2', '0', 'English, Canada', '', 'pkg_en-CA', 'package', '', '0', '4.1.2.1', '', 'https://update.joomla.org/language/details4/en-CA_details.xml', '', '', ''),
('282', '2', '0', 'English, New Zealand', '', 'pkg_en-NZ', 'package', '', '0', '4.1.2.1', '', 'https://update.joomla.org/language/details4/en-NZ_details.xml', '', '', ''),
('283', '2', '0', 'English, USA', '', 'pkg_en-US', 'package', '', '0', '4.1.2.1', '', 'https://update.joomla.org/language/details4/en-US_details.xml', '', '', ''),
('284', '2', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '4.1.5.1', '', 'https://update.joomla.org/language/details4/et-EE_details.xml', '', '', ''),
('285', '2', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '4.1.1.2', '', 'https://update.joomla.org/language/details4/fi-FI_details.xml', '', '', ''),
('286', '2', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/nl-BE_details.xml', '', '', ''),
('287', '2', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/fr-FR_details.xml', '', '', ''),
('288', '2', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/ka-GE_details.xml', '', '', ''),
('289', '2', '0', 'German', '', 'pkg_de-DE', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/de-DE_details.xml', '', '', ''),
('290', '2', '0', 'German, Austria', '', 'pkg_de-AT', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/de-AT_details.xml', '', '', ''),
('291', '2', '0', 'German, Liechtenstein', '', 'pkg_de-LI', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/de-LI_details.xml', '', '', ''),
('292', '2', '0', 'German, Luxembourg', '', 'pkg_de-LU', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/de-LU_details.xml', '', '', ''),
('293', '2', '0', 'German, Switzerland', '', 'pkg_de-CH', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/de-CH_details.xml', '', '', ''),
('294', '2', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/el-GR_details.xml', '', '', ''),
('295', '2', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '4.1.5.1', '', 'https://update.joomla.org/language/details4/hu-HU_details.xml', '', '', ''),
('296', '2', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '4.2.0.4', '', 'https://update.joomla.org/language/details4/it-IT_details.xml', '', '', ''),
('297', '2', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/ja-JP_details.xml', '', '', ''),
('298', '2', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '4.1.2.1', '', 'https://update.joomla.org/language/details4/kk-KZ_details.xml', '', '', ''),
('299', '2', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '4.2.1.2', '', 'https://update.joomla.org/language/details4/lt-LT_details.xml', '', '', ''),
('300', '2', '0', 'Norwegian Bokmål', '', 'pkg_nb-NO', 'package', '', '0', '4.0.1.1', '', 'https://update.joomla.org/language/details4/nb-NO_details.xml', '', '', ''),
('301', '2', '0', 'Persian Farsi', '', 'pkg_fa-IR', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/fa-IR_details.xml', '', '', ''),
('302', '2', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/pl-PL_details.xml', '', '', ''),
('303', '2', '0', 'Portuguese, Brazil', '', 'pkg_pt-BR', 'package', '', '0', '4.0.3.1', '', 'https://update.joomla.org/language/details4/pt-BR_details.xml', '', '', ''),
('304', '2', '0', 'Portuguese, Portugal', '', 'pkg_pt-PT', 'package', '', '0', '4.0.0-rc4.2', '', 'https://update.joomla.org/language/details4/pt-PT_details.xml', '', '', ''),
('305', '2', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '4.1.5.1', '', 'https://update.joomla.org/language/details4/ro-RO_details.xml', '', '', ''),
('306', '2', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/ru-RU_details.xml', '', '', ''),
('307', '2', '0', 'Serbian, Latin', '', 'pkg_sr-YU', 'package', '', '0', '4.1.4.1', '', 'https://update.joomla.org/language/details4/sr-YU_details.xml', '', '', ''),
('308', '2', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '4.0.6.1', '', 'https://update.joomla.org/language/details4/sk-SK_details.xml', '', '', ''),
('309', '2', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '4.1.5.1', '', 'https://update.joomla.org/language/details4/sl-SI_details.xml', '', '', ''),
('310', '2', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '4.1.5.1', '', 'https://update.joomla.org/language/details4/es-ES_details.xml', '', '', ''),
('311', '2', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '4.1.5.1', '', 'https://update.joomla.org/language/details4/sv-SE_details.xml', '', '', ''),
('312', '2', '0', 'Tamil, India', '', 'pkg_ta-IN', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/ta-IN_details.xml', '', '', ''),
('313', '2', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/th-TH_details.xml', '', '', ''),
('314', '2', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/tr-TR_details.xml', '', '', ''),
('315', '2', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '4.0.3.2', '', 'https://update.joomla.org/language/details4/uk-UA_details.xml', '', '', ''),
('316', '2', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/cy-GB_details.xml', '', '', ''),
('317', '16', '0', 'Quix Launcher', 'iQuix is an installer extension', 'com_iquix', 'component', '', '0', '1.7.0', '', 'https://raw.githubusercontent.com/themexpert/iquix/master/mainfest.xml', 'https://github.com/themexpert/iquix/releases/tag/v1.7.0', NULL, ''),
('320', '1', '220', 'Joomla', '', 'joomla', 'file', '', '0', '4.1.5', '', 'https://update.joomla.org/core/sts/extension_sts.xml', '', '', '');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int NOT NULL DEFAULT '0',
  `extension_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '220'),
('2', '221'),
('3', '24'),
('14', '225'),
('15', '226'),
('16', '227'),
('17', '246'),
('18', '247'),
('19', '251');
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int DEFAULT '0',
  `last_check_timestamp` bigint DEFAULT '0',
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'collection', 'https://update.joomla.org/core/list.xml', '1', '1661231887', '', NULL, NULL),
('2', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_4.xml', '1', '1661230970', '', NULL, NULL),
('3', 'Joomla! Update Component', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1661230970', '', NULL, NULL),
('14', 'T4 System Plugin', 'extension', 'http://update.joomlart.com/service/tracking/j31/plg_system_t4.xml', '1', '1661230991', '', NULL, NULL),
('15', 'TX Financio', 'extension', 'https://www.themexpert.com/index.php?option=com_digicom&task=responses&source=release&format=xml&provider=joomla&pid=226', '1', '1661230992', '', NULL, NULL),
('16', 'iQuix', 'extension', 'https://raw.githubusercontent.com/themexpert/iquix/master/mainfest.xml', '1', '1661230992', '', NULL, NULL),
('17', 'JMedia Update Site', 'extension', 'https://www.themexpert.com/index.php?option=com_digicom&task=responses&source=release&format=xml&provider=joomla&pid=224', '1', '1661230994', '', NULL, NULL),
('18', 'Quix Update Site', 'extension', 'https://www.themexpert.com/index.php?option=com_digicom&task=responses&source=release&format=xml&provider=joomla&pid=116', '1', '1661230995', 'username=swopnil&key=988d328f1bd53989ba79c7469203b43a&activated=1', NULL, NULL),
('19', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '1661230997', '', NULL, NULL);
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8mb4_unicode_ci,
  `core_state` tinyint NOT NULL DEFAULT '0',
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int unsigned DEFAULT NULL,
  `core_access` int unsigned NOT NULL DEFAULT '0',
  `core_params` text COLLATE utf8mb4_unicode_ci,
  `core_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'ID from the individual type table',
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8mb4_unicode_ci,
  `core_urls` text COLLATE utf8mb4_unicode_ci,
  `core_hits` int unsigned NOT NULL DEFAULT '0',
  `core_version` int unsigned NOT NULL DEFAULT '1',
  `core_ordering` int NOT NULL DEFAULT '0',
  `core_metakey` text COLLATE utf8mb4_unicode_ci,
  `core_metadesc` text COLLATE utf8mb4_unicode_ci,
  `core_catid` int unsigned NOT NULL DEFAULT '0',
  `core_type_id` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/INSERT INTO `#__ucm_content`  VALUES 
('1', 'com_content.article', 'Building An Emergency Fund: Why You Need One & How To Fund It', 'building-an-emergency-fund-why-you-need-one-how-to-fund-it', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '49', '', '2022-05-23 08:48:00', '49', '2022-06-06 10:37:22', '*', '2022-05-23 08:48:00', NULL, '10', '139', '{\"image_intro\":\"images\\/financio\\/blog\\/blog1.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog1.jpg?width=1500&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/financio\\/blog\\/blog1.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog1.jpg?width=1500&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '3', '0', '', '', '8', '1'),
('2', 'com_content.article', 'Ten Steps to Creating a Solid Financial Plan For Yourself', 'ten-steps-to-creating-a-solid-financial-plan-for-yourself', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '49', '', '2022-05-23 08:47:11', '49', '2022-06-06 10:37:46', '*', '2022-05-23 08:47:11', NULL, '9', '140', '{\"image_intro\":\"images\\/financio\\/blog\\/blog2.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog2.jpg?width=1500&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/financio\\/blog\\/blog2.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog2.jpg?width=1500&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '2', '1', '', '', '8', '1'),
('3', 'com_content.article', 'The Ultimate List of Best Personal Finance Books, Career, Business & Personal Development Books', 'the-ultimate-list-of-best-personal-finance-books-career-business-personal-development-books', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '49', '', '2022-05-23 08:46:31', '49', '2022-06-06 10:37:57', '*', '2022-05-23 08:46:31', NULL, '8', '141', '{\"image_intro\":\"images\\/financio\\/blog\\/blog3.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog3.jpg?width=1500&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/financio\\/blog\\/blog3.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog3.jpg?width=1500&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '2', '2', '', '', '8', '1'),
('4', 'com_content.article', 'How To Budget: Create a Budget That Works', 'how-to-budget-create-a-budget-that-works', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '49', '', '2022-05-23 08:45:46', '49', '2022-06-06 10:38:08', '*', '2022-05-23 08:45:46', NULL, '7', '142', '{\"image_intro\":\"images\\/financio\\/blog\\/blog4.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog4.jpg?width=1500&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/financio\\/blog\\/blog4.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog4.jpg?width=1500&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '2', '3', '', '', '8', '1'),
('5', 'com_content.article', 'The 12 Best Work From Home Jobs to Earn Extra Money', 'the-12-best-work-from-home-jobs-to-earn-extra-money', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '49', '', '2022-05-23 08:44:45', '49', '2022-06-06 10:38:35', '*', '2022-05-23 08:44:45', NULL, '6', '143', '{\"image_intro\":\"images\\/financio\\/blog\\/blog5.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog5.jpg?width=1500&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/financio\\/blog\\/blog5.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog5.jpg?width=1500&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '3', '2', '4', '', '', '8', '1'),
('6', 'com_content.article', 'How to Build Generational Wealth', 'how-to-build-generational-wealth', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '49', '', '2022-05-23 08:44:02', '49', '2022-06-06 10:38:45', '*', '2022-05-23 08:44:02', NULL, '5', '144', '{\"image_intro\":\"images\\/financio\\/blog\\/blog6.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog6.jpg?width=1500&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/financio\\/blog\\/blog6.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog6.jpg?width=1500&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '2', '5', '', '', '8', '1'),
('7', 'com_content.article', '6 Things To Do Now If You Have No Savings', '6-things-to-do-now-if-you-have-no-savings', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '49', '', '2022-05-23 08:43:14', '49', '2022-06-06 10:38:57', '*', '2022-05-23 08:43:14', NULL, '4', '145', '{\"image_intro\":\"images\\/financio\\/blog\\/blog7.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog7.jpg?width=1500&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/financio\\/blog\\/blog7.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog7.jpg?width=1500&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '2', '6', '', '', '8', '1'),
('8', 'com_content.article', 'Investing for Beginners: How to Get Started with a Little Money', 'investing-for-beginners-how-to-get-started-with-a-little-money', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '49', '', '2022-05-23 08:42:22', '49', '2022-06-06 10:39:10', '*', '2022-05-23 08:42:22', NULL, '3', '146', '{\"image_intro\":\"images\\/financio\\/blog\\/blog8.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog8.jpg?width=1500&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/financio\\/blog\\/blog8.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog8.jpg?width=1500&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '2', '7', '', '', '8', '1'),
('9', 'com_content.article', 'Is Debt Consolidation a Good Idea?', 'is-debt-consolidation-a-good-idea', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '49', '', '2022-05-23 08:33:59', '49', '2022-06-06 10:39:19', '*', '2022-05-23 08:33:59', NULL, '2', '147', '{\"image_intro\":\"images\\/financio\\/blog\\/blog9.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog9.jpg?width=1500&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/financio\\/blog\\/blog9.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog9.jpg?width=1500&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '4', '8', '', '', '8', '1'),
('10', 'com_content.article', 'The 10 Best Recession-Proof Businesses', 'the-10-best-recession-proof-businesses', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '49', '', '2022-05-23 08:31:05', '49', '2022-06-06 10:39:29', '*', '2022-05-23 08:31:05', NULL, '1', '148', '{\"image_intro\":\"images\\/financio\\/blog\\/blog10.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog10.jpg?width=1500&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/financio\\/blog\\/blog10.jpg#joomlaImage:\\/\\/local-images\\/financio\\/blog\\/blog10.jpg?width=1500&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '3', '9', '', '', '8', '1');
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int unsigned NOT NULL,
  `ucm_item_id` int NOT NULL,
  `ucm_type_id` int NOT NULL,
  `ucm_language_id` int NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__ucm_base`  VALUES 
('1', '10', '1', '0'),
('2', '9', '1', '0'),
('3', '8', '1', '0'),
('4', '7', '1', '0'),
('5', '6', '1', '0'),
('6', '5', '1', '0'),
('7', '4', '1', '0'),
('8', '3', '1', '0'),
('9', '2', '1', '0'),
('10', '1', '1', '0');
/**ABDB**/CREATE TABLE `#__template_styles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint unsigned NOT NULL DEFAULT '0',
  `home` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `inheritable` tinyint NOT NULL DEFAULT '0',
  `parent` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_styles`  VALUES 
('10', 'atum', '1', '1', 'Atum - Default', '1', '', '{\"hue\":\"hsl(214, 63%, 20%)\",\"bg-light\":\"#f0f4fb\",\"text-dark\":\"#495057\",\"text-light\":\"#ffffff\",\"link-color\":\"#2a69b8\",\"special-color\":\"#001b4c\",\"monochrome\":\"0\",\"loginLogo\":\"\",\"loginLogoAlt\":\"\",\"logoBrandLarge\":\"\",\"logoBrandLargeAlt\":\"\",\"logoBrandSmall\":\"\",\"logoBrandSmallAlt\":\"\"}'),
('11', 'cassiopeia', '0', '0', 'Cassiopeia - Default', '1', '', '{\"brand\":\"1\",\"logoFile\":\"\",\"siteTitle\":\"\",\"siteDescription\":\"\",\"useFontScheme\":\"0\",\"colorName\":\"colors_standard\",\"fluidContainer\":\"0\",\"stickyHeader\":0,\"backTop\":0}'),
('12', 'tx_financio', '0', '1', 'Tx Financio - Default', '0', '', '{\"tplhelper\":\"{}\",\"typelist-site\":\"default\",\"typelist-navigation\":\"default\",\"typelist-theme\":\"default\",\"typelist-layout\":\"default\",\"sub-layout\":\"\",\"system_t4frontendedit\":\"1\",\"system_optimizecss_exclude\":\"\",\"system_optimizejs_exclude\":\"\",\"system_advancedCodeAfterHead\":\"\",\"system_advancedCodeBeforeHead\":\"\",\"system_advancedCodeAfterBody\":\"\",\"system_advancedCodeBeforeBody\":\"\",\"system_addons\":[\"font.awesome5\",\"font.awesome4\",\"font.iconmoon\"]}'),
('13', 'atom', '0', '0', 'Atom - Default', '0', '', '{\"logo_type\":\"svg\",\"logoFile\":\"\",\"sitetitle\":\"\",\"primaryColor\":\"\",\"secondaryColor\":\"\",\"layout\":\"0\",\"layoutWidth\":\"80\",\"layoutBackgroundcolor\":\"#fff\",\"hide_nav\":\"1\",\"hide_footer\":\"1\",\"http2_push\":\"1\",\"reduceHttp\":\"1\"}'),
('14', 'tx_financio', '0', '0', 'Tx Financio - Home 1', '0', '', '{\"tplhelper\":\"{}\",\"typelist-site\":\"default\",\"typelist-navigation\":\"default\",\"typelist-theme\":\"default\",\"typelist-layout\":\"Home-1\",\"sub-layout\":\"\",\"system_t4frontendedit\":\"1\",\"system_optimizecss_exclude\":\"\",\"system_optimizejs_exclude\":\"\",\"system_advancedCodeAfterHead\":\"\",\"system_advancedCodeBeforeHead\":\"\",\"system_advancedCodeAfterBody\":\"\",\"system_advancedCodeBeforeBody\":\"\",\"system_addons\":[\"font.awesome5\",\"font.awesome4\",\"font.iconmoon\"]}'),
('15', 'tx_financio', '0', '0', 'Tx Financio - Home 2', '0', '', '{\"tplhelper\":\"{}\",\"typelist-site\":\"Violet\",\"typelist-navigation\":\"default\",\"typelist-theme\":\"Violet\",\"typelist-layout\":\"Home-2\",\"sub-layout\":\"\",\"system_t4frontendedit\":\"1\",\"system_optimizecss_exclude\":\"\",\"system_optimizejs_exclude\":\"\",\"system_advancedCodeAfterHead\":\"\",\"system_advancedCodeBeforeHead\":\"\",\"system_advancedCodeAfterBody\":\"\",\"system_advancedCodeBeforeBody\":\"\",\"system_addons\":[\"font.awesome5\",\"font.awesome4\",\"font.iconmoon\"]}'),
('16', 'tx_financio', '0', '0', 'Tx Financio - Home 3', '0', '', '{\"tplhelper\":\"{}\",\"typelist-site\":\"Red\",\"typelist-navigation\":\"default\",\"typelist-theme\":\"Red\",\"typelist-layout\":\"Home-3\",\"sub-layout\":\"\",\"system_t4frontendedit\":\"1\",\"system_optimizecss_exclude\":\"\",\"system_optimizejs_exclude\":\"\",\"system_advancedCodeAfterHead\":\"\",\"system_advancedCodeBeforeHead\":\"\",\"system_advancedCodeAfterBody\":\"\",\"system_advancedCodeBeforeBody\":\"\",\"system_addons\":[\"font.awesome5\",\"font.awesome4\",\"font.iconmoon\"]}');
/**ABDB**/CREATE TABLE `#__template_overrides` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hash_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension_id` int DEFAULT '0',
  `state` tinyint NOT NULL DEFAULT '0',
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint unsigned NOT NULL DEFAULT '0',
  `created_date` datetime NOT NULL,
  `modified_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_extension_id` (`extension_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_overrides`  VALUES 
('1', 'atom', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcmllcy9kZWZhdWx0X2l0ZW1zLnBocA==', '240', '1', 'Joomla Update', '0', '2022-05-26 06:56:21', '2022-05-26 06:56:21'),
('2', 'atom', 'L2h0bWwvY29tX2ZpbmRlci9zZWFyY2gvZGVmYXVsdF9yZXN1bHQucGhw', '240', '1', 'Joomla Update', '0', '2022-05-26 06:56:21', '2022-05-26 06:56:21'),
('3', 'atom', 'L2h0bWwvY29tX3RhZ3MvdGFnL2RlZmF1bHQucGhw', '240', '1', 'Joomla Update', '0', '2022-05-26 06:56:21', '2022-05-26 06:56:21'),
('4', 'atom', 'L2h0bWwvY29tX3RhZ3MvdGFnL2RlZmF1bHRfaXRlbXMucGhw', '240', '1', 'Joomla Update', '0', '2022-05-26 06:56:21', '2022-05-26 06:56:21'),
('5', 'atom', 'L2h0bWwvY29tX3RhZ3MvdGFnL2xpc3QucGhw', '240', '1', 'Joomla Update', '0', '2022-05-26 06:56:21', '2022-05-26 06:56:21'),
('6', 'atom', 'L2h0bWwvY29tX3RhZ3MvdGFncy9kZWZhdWx0LnBocA==', '240', '1', 'Joomla Update', '0', '2022-05-26 06:56:21', '2022-05-26 06:56:21'),
('7', 'atom', 'L2h0bWwvY29tX3RhZ3MvdGFncy9kZWZhdWx0X2l0ZW1zLnBocA==', '240', '1', 'Joomla Update', '0', '2022-05-26 06:56:21', '2022-05-26 06:56:21'),
('8', 'atom', 'L2h0bWwvY29tX3VzZXJzL2xvZ2luL2RlZmF1bHRfbG9naW4ucGhw', '240', '1', 'Joomla Update', '0', '2022-05-26 06:56:21', '2022-05-26 06:56:21'),
('9', 'atom', 'L2h0bWwvY29tX3VzZXJzL2xvZ2luL2RlZmF1bHRfbG9nb3V0LnBocA==', '240', '1', 'Joomla Update', '0', '2022-05-26 06:56:21', '2022-05-26 06:56:21'),
('10', 'atom', 'L2h0bWwvbW9kX2JyZWFkY3J1bWJzL2RlZmF1bHQucGhw', '240', '1', 'Joomla Update', '0', '2022-05-26 06:56:21', '2022-05-26 06:56:21'),
('11', 'atom', 'L2h0bWwvY29tX2NvbnRlbnQvYXJ0aWNsZS9kZWZhdWx0LnBocA==', '240', '1', 'Joomla Update', '0', '2022-08-21 04:44:11', '2022-08-21 04:44:11'),
('12', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL3BhcmVudF9jYXRlZ29yeS5waHA=', '240', '1', 'Joomla Update', '0', '2022-08-21 04:44:11', '2022-08-21 04:44:11');
/**ABDB**/CREATE TABLE `#__tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tags`  VALUES 
('1', '0', '0', '9', '0', '', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '', '', '', '', '49', '2022-05-16 05:45:58', '', '49', '2022-05-16 05:45:58', '', '', '0', '*', '1', NULL, NULL),
('2', '1', '1', '2', '1', 'joomla-4', 'Joomla 4', 'joomla-4', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '49', '2022-06-06 10:36:24', '', '49', '2022-06-06 10:36:43', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '2', NULL, NULL),
('3', '1', '3', '4', '1', 'quix-4', 'Quix 4', 'quix-4', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '49', '2022-06-06 10:36:32', '', '49', '2022-06-06 10:36:32', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '1', NULL, NULL),
('4', '1', '5', '6', '1', 'quix-page-builder', 'Quix Page Builder', 'quix-page-builder', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '49', '2022-06-06 10:36:57', '', '49', '2022-06-06 10:36:57', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '3', '*', '1', NULL, NULL),
('5', '1', '7', '8', '1', 'finance', 'Finance', 'finance', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '49', '2022-06-06 10:37:10', '', '49', '2022-06-06 10:37:10', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__session` (
  `session_id` varbinary(192) NOT NULL,
  `client_id` tinyint unsigned DEFAULT NULL,
  `guest` tinyint unsigned DEFAULT '1',
  `time` int NOT NULL DEFAULT '0',
  `data` mediumtext COLLATE utf8mb4_unicode_ci,
  `userid` int DEFAULT '0',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `userid` (`userid`),
  KEY `time` (`time`),
  KEY `client_id_guest` (`client_id`,`guest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__schemas` (
  `extension_id` int NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__schemas`  VALUES 
('220', '4.1.3-2022-04-08'),
('228', '1.1'),
('249', '9.0.10-20211130');
/**ABDB**/CREATE TABLE `#__scheduler_tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'unique identifier for job defined by plugin',
  `execution_rules` text COLLATE utf8mb4_unicode_ci COMMENT 'Execution Rules, Unprocessed',
  `cron_rules` text COLLATE utf8mb4_unicode_ci COMMENT 'Processed execution rules, crontab-like JSON form',
  `state` tinyint NOT NULL DEFAULT '0',
  `last_exit_code` int NOT NULL DEFAULT '0' COMMENT 'Exit code when job was last run',
  `last_execution` datetime DEFAULT NULL COMMENT 'Timestamp of last run',
  `next_execution` datetime DEFAULT NULL COMMENT 'Timestamp of next (planned) run, referred for execution on trigger',
  `times_executed` int DEFAULT '0' COMMENT 'Count of successful triggers',
  `times_failed` int DEFAULT '0' COMMENT 'Count of failures',
  `locked` datetime DEFAULT NULL,
  `priority` smallint NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0' COMMENT 'Configurable list ordering',
  `cli_exclusive` smallint NOT NULL DEFAULT '0' COMMENT 'If 1, the task is only accessible via CLI',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_state` (`state`),
  KEY `idx_last_exit` (`last_exit_code`),
  KEY `idx_next_exec` (`next_execution`),
  KEY `idx_locked` (`locked`),
  KEY `idx_priority` (`priority`),
  KEY `idx_cli_exclusive` (`cli_exclusive`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__redirect_links` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `old_url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_url` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int unsigned NOT NULL DEFAULT '0',
  `published` tinyint NOT NULL,
  `created_date` datetime NOT NULL,
  `modified_date` datetime NOT NULL,
  `header` smallint NOT NULL DEFAULT '301',
  PRIMARY KEY (`id`),
  KEY `idx_old_url` (`old_url`(100)),
  KEY `idx_link_modified` (`modified_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__quix_imgstats` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_id` int NOT NULL,
  `item_type` varchar(100) NOT NULL,
  `images_count` int NOT NULL,
  `original_size` int NOT NULL,
  `optimise_size` int NOT NULL,
  `mobile_size` int NOT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_elements421` (
  `id` smallint NOT NULL AUTO_INCREMENT,
  `alias` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `params` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_elements4111` (
  `id` smallint NOT NULL AUTO_INCREMENT,
  `alias` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `params` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_elements4110` (
  `id` smallint NOT NULL AUTO_INCREMENT,
  `alias` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `params` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_elements` (
  `id` smallint NOT NULL AUTO_INCREMENT,
  `alias` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `params` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_editor_map` (
  `id` int NOT NULL AUTO_INCREMENT,
  `context` varchar(100) NOT NULL,
  `context_id` int NOT NULL,
  `collection_id` int NOT NULL,
  `status` tinyint NOT NULL DEFAULT '1',
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_configs` (
  `name` varchar(255) NOT NULL,
  `params` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Store any configuration in key => params maps';
/**ABDB**/INSERT INTO `#__quix_configs`  VALUES 
('username', 'swopnil'),
('key', '988d328f1bd53989ba79c7469203b43a'),
('activated', '1');
/**ABDB**/CREATE TABLE `#__quix_conditions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_id` int NOT NULL,
  `item_type` varchar(100) NOT NULL,
  `component` varchar(100) NOT NULL,
  `condition_type` varchar(100) NOT NULL COMMENT 'articles, categories, menus',
  `condition_id` int NOT NULL COMMENT 'type id',
  `condition_info` varchar(100) NOT NULL COMMENT 'type info direct to search',
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/**ABDB**/INSERT INTO `#__quix_conditions`  VALUES 
('1', '17', 'footer', 'core', 'all-menu', '0', '', '{\"typeCondition\":\"include\",\"type\":\"all-menu\",\"subType\":\"\",\"parent_menu\":\"\"}');
/**ABDB**/CREATE TABLE `#__quix_collections421` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `uid` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'section',
  `catid` int NOT NULL,
  `builder` enum('classic','frontend') NOT NULL DEFAULT 'classic',
  `builder_version` varchar(10) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `metadata` longtext NOT NULL,
  `language` varchar(5) NOT NULL,
  `ordering` int NOT NULL,
  `state` tinyint(1) NOT NULL,
  `access` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `params` longtext NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `hits` int NOT NULL,
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_catid` (`catid`),
  KEY `idx_state` (`state`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3;
/**ABDB**/INSERT INTO `#__quix_collections421`  VALUES 
('1', '100', '44d9feaea3bd56add06fea27d7e93e8e', 'home-1', 'layout', '0', 'frontend', '4.1.10', '{\"type\":\"layout\",\"data\":[{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_type\":\"fluid\",\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\"},\"phone\":{\"top\":0,\"bottom\":0},\"tablet\":{\"top\":0,\"bottom\":0}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-7316\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-19319\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":0}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-56320\"}}},\"children\":[{\"slug\":\"slider-pro\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"slider-pro_fg_element\":[{\"title\":\"We are ready for any kinds of financial  help\",\"description\":\"We are high experienced financial service provider. We are providing financial services about ten years.\",\"slide_background_image\":\"\",\"background\":{\"source\":\"/financio/slide-1.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"button_text\":\"Get Started\",\"link\":{\"url\":\"#\"},\"slide_thumb_image\":\"\",\"thumb_image\":{\"source\":\"libraries/quix/assets/images/placeholder.png\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Take our help & grow your business\",\"description\":\"We are high experienced financial service provider. We are providing financial services about ten years.\",\"slide_background_image\":\"\",\"background\":{\"source\":\"/financio/slide-2.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"button_text\":\"Get Started\",\"link\":{\"url\":\"#\"},\"slide_thumb_image\":\"\",\"thumb_image\":{\"source\":\"libraries/quix/assets/images/placeholder.png\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Make an investment, we will manage the risk\",\"description\":\"We are high experienced financial service provider. We are providing financial services about ten years.\",\"slide_background_image\":\"\",\"background\":{\"source\":\"/financio/slide-3.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"button_text\":\"Get Started\",\"link\":{\"url\":\"#\"},\"slide_thumb_image\":\"\",\"thumb_image\":{\"source\":\"libraries/quix/assets/images/placeholder.png\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}}],\"slider-pro_fg_alignment\":{\"text_alignment\":\"center\",\"horizontal_position\":\"center\",\"vertical_position\":\"center\"},\"slider-pro_fg_display\":{\"enable_icon\":true,\"icon\":{\"source\":\"qxio-ios-arrow-thin-right\",\"properties\":{\"size\":{\"value\":30,\"unit\":\"px\"},\"color\":\"rgba(0 ,  0,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"icon_alignment\":\"right\"},\"slider-pro_fg_overlay\":{\"overlay_bg_color\":\"rgba(19 ,  15,  64, 0.5)\"},\"slider-pro_fg_animation\":{\"slide_animation\":\"slide\",\"slide_kenburns\":false,\"slide_kenburns_reverse\":false},\"slider-pro_fg_transitions\":{\"heading_paraIN\":{\"value\":0,\"unit\":\"none\"},\"heading_ParaOut\":{\"value\":0,\"unit\":\"none\"},\"desc_paraIN\":{\"value\":0,\"unit\":\"none\"},\"desc_ParaOut\":{\"value\":0,\"unit\":\"none\"},\"button_paraIN\":{\"value\":0,\"unit\":\"none\"},\"button_ParaOut\":{\"value\":0,\"unit\":\"none\"}},\"slider-pro_fg_height\":{\"height_option\":\"fit-to-screen\"},\"slider-pro_fg_navigation\":{\"navigation\":\"none\"},\"slider-pro_fg_settings\":{\"pause_on_hover\":true,\"autoplay\":true,\"autoplay_speed\":5000,\"infinite_loop\":true}},\"styles\":{\"slider-pro_fg_slider-style\":{\"slider_height_custom\":{\"desktop\":1000,\"tablet\":600,\"phone\":400,\"responsive_preview\":true,\"unit\":\"px\"},\"slides_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"slides_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"content_width\":{\"tablet\":80,\"phone\":90},\"content_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"slider-pro_fg_title-style\":{\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":80,\"tablet\":60,\"phone\":50},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.1,\"phone\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"title_margin\":{\"desktop\":{\"bottom\":30},\"phone\":{\"top\":0,\"bottom\":20,\"left\":0,\"right\":0},\"tablet\":{\"bottom\":25}}},\"slider-pro_fg_description-style\":{\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":20,\"phone\":18},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"description_margin\":{\"desktop\":{\"bottom\":80,\"left\":100,\"right\":100},\"phone\":{\"bottom\":45},\"tablet\":{\"bottom\":50}}},\"slider-pro_fg_image-style\":{\"image_size\":\"cover\"},\"slider-pro_fg_button-style\":{\"btn_text_color\":\"rgba(0 ,  0,  255, 1)\",\"btn_hover_text_color\":\"rgba(255 ,  255,  255, 1)\",\"btn_bg_color\":\"rgba(255 ,  255,  255, 1)\",\"btn_hover_bg_color\":\"rgba(0 ,  0,  255, 1)\",\"hover_icon_color\":\"rgba(255 ,  255,  255, 1)\",\"icon_spacing\":{\"value\":10,\"unit\":\"px\"},\"button_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"left\":35},\"phone\":{\"top\":13,\"bottom\":13,\"left\":25,\"right\":20},\"tablet\":{\"top\":15,\"bottom\":15,\"left\":30,\"right\":30}},\"button_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"button_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"slider-pro_fg_arrow-style\":{\"arrow_color\":\"rgba(255 ,  255,  255, 0.7)\",\"arrow_hover_color\":\"rgba(255 ,  255,  255, 1)\",\"arrow_size\":{\"desktop\":50},\"arrow_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"arrow_nav_spacing\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"arrow_spacing\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"arrow_nav_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"arrow_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"slider-pro_fg_dot-style\":{\"dot_color\":\"rgba(255 ,  255,  255, 0.55)\",\"dot_active_color\":\"rgba(255 ,  255,  255, 1)\",\"dot_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"dot_width\":{\"desktop\":15,\"tablet\":15,\"phone\":15,\"responsive_preview\":true,\"unit\":\"px\"},\"dot_spacing\":{\"desktop\":12,\"tablet\":12,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"dot_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"thumb_width\":{\"desktop\":100,\"tablet\":50,\"phone\":35,\"responsive_preview\":true,\"unit\":\"px\"},\"thumb_height\":{\"desktop\":100,\"tablet\":50,\"phone\":35,\"responsive_preview\":true,\"unit\":\"px\"}},\"slider-pro_fg_bar-style\":{\"bar_width\":{\"desktop\":25,\"tablet\":25,\"phone\":25,\"responsive_preview\":true,\"unit\":\"px\"},\"barActive_width\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"bar_height\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"barActive_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":null,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6{\\n     margin-top: 0 !important\\n}\"}},\"identifier\":{\"id\":\"qx-slider-pro-7324\"}}},\"children\":[]}]}]}]},{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":100,\"bottom\":90},\"phone\":{\"top\":60,\"bottom\":60},\"tablet\":{\"top\":60,\"bottom\":75}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\",\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"size\":\"initial\",\"position\":\"top right\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-9287\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-5490\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"right\":50},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"src\":{\"source\":\"/financio/pattern.png\",\"type\":\"image\",\"properties\":[]},\"size\":\"contain\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-4491\"}}},\"children\":[{\"slug\":\"image\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"image_fields_group\":{\"image\":{\"source\":\"/financio/about-1.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"image_links_fields_group\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}},\"styles\":{\"image_fields_group\":{\"alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"},\"width\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"%\"},\"opacity\":0},\"border_fields_group\":{\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":\"\",\"border_width\":\"\",\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"icon_fields_group\":{\"icon_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"icon_background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"caption_field_group\":{\"caption_field_group_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"caption_field_group_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"caption_field_group_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"caption_background_color\":null,\"caption_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":10,\"left\":10,\"bottom\":10,\"right\":10},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-image-399399\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-29186\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"About Us\",\"subtitle\":\"We are high experienced financial service company\",\"description\":\"<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Donec odio. Quisque volutpat mattis eros. Nullam malesuada erat ut turpis.</p><p>\\nDonec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris sit amet orci.&nbsp;</p>\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"Read More\",\"link\":{\"url\":\"#\"}},\"call_to_action_fg_additional\":{\"title_html_tag\":\"h5\",\"html_subtitle_tag\":\"h2\",\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"left\"},\"element_padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 0.8)\",\"title_spacing\":{\"desktop\":0},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":16,\"tablet\":16,\"phone\":15},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":3},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_color\":\"rgba(10 ,  3,  98, 1)\",\"subtitle_spacing\":{\"desktop\":35,\"tablet\":25,\"phone\":25},\"subtitle_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":50,\"tablet\":45,\"phone\":40},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(128 ,  130,  145, 1)\",\"description_spacing\":{\"desktop\":50,\"tablet\":40,\"phone\":45},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(0 ,  0,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":{\"value\":0.3,\"unit\":\"s\"},\"properties\":{\"color\":\"rgba(0 ,  0,  255, 0.8)\"}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"desktop\":16,\"phone\":14},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":17,\"bottom\":17},\"phone\":{\"top\":15,\"bottom\":15,\"left\":30,\"right\":30},\"tablet\":{\"top\":15,\"bottom\":15,\"left\":36,\"right\":36}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"right\":50},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":700,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-11216\"}}},\"children\":[]}]}]}]},{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":100,\"bottom\":100},\"phone\":{\"top\":60,\"bottom\":60},\"tablet\":{\"top\":80,\"bottom\":80}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(245 ,  245,  245, 1)\",\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_color\":\"rgba(255 ,  255,  255, 1)\",\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":70},\"top_divider_flip\":true},\"divider_bottom_fields_group\":{\"bottom_divider_color\":\"rgba(255 ,  255,  255, 0.95)\",\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":70},\"bottom_divider_flip\":true}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-53245\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"qx-row-align-center\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-70437\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":65,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"size\":\"initial\",\"position\":\"top left\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-60438\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"Services\",\"subtitle\":\"Our dedicated financial services\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"\",\"link\":{\"url\":\"#\"}},\"call_to_action_fg_additional\":{\"title_html_tag\":\"h5\",\"html_subtitle_tag\":\"h2\",\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"left\",\"tablet\":\"left\"},\"element_padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 0.8)\",\"title_spacing\":{\"desktop\":0},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":16,\"tablet\":16,\"phone\":15},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":3},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_color\":\"rgba(10 ,  3,  98, 1)\",\"subtitle_spacing\":{\"desktop\":26,\"tablet\":25,\"phone\":20},\"subtitle_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":50,\"tablet\":45,\"phone\":40},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(128 ,  130,  145, 1)\",\"description_spacing\":{\"desktop\":0},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(55 ,  66,  250, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Nunito\",\"weight\":\"regular\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-752869\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":35,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-73441\"}}},\"children\":[{\"slug\":\"button\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"button_fields_group\":{\"text\":\"All Services\",\"icon\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"button_link_fields_group\":{\"link\":{\"url\":\"#\"}}},\"styles\":{\"button_spacing_fields_group\":{\"nalignment\":{\"desktop\":\"right\",\"tablet\":\"\",\"phone\":\"center\"},\"btn_padding\":{\"desktop\":{\"top\":16,\"left\":35,\"bottom\":16,\"right\":35},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":15,\"bottom\":15}},\"icon_spacing\":{\"desktop\":30,\"tablet\":30,\"phone\":20}},\"button_typo_fields_group\":{\"font\":{\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"desktop\":16,\"phone\":14},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"button_bg_fields_group\":{\"btn_background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(0 ,  0,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":{\"value\":0.3,\"unit\":\"s\"},\"properties\":{\"color\":\"rgba(0 ,  0,  255, 0.8)\"}}}}},\"button_color_fields_group\":{\"text_color\":\"\",\"hover_text_color\":\"\",\"hover_icon_color\":\"\"},\"button_border_group\":{\"btn_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":700,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-button-7745\"}}},\"children\":[]}]}]},{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-38464\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":33.33333,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"size\":\"initial\",\"position\":\"top left\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-3465\"}}},\"children\":[{\"slug\":\"blurb\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Accounting & Taxes\",\"content\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"<?xml version=\\\"1.0\\\" encoding=\\\"iso-8859-1\\\"?>\\r\\n<!-- Generator: Adobe Illustrator 18.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\\r\\n<!DOCTYPE svg PUBLIC \\\"-//W3C//DTD SVG 1.1//EN\\\" \\\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\\\">\\r\\n<svg version=\\\"1.1\\\" id=\\\"Capa_1\\\" xmlns=\\\"http://www.w3.org/2000/svg\\\" xmlns:xlink=\\\"http://www.w3.org/1999/xlink\\\" x=\\\"0px\\\" y=\\\"0px\\\"\\r\\n\\t viewBox=\\\"0 0 60 60\\\" style=\\\"enable-background:new 0 0 60 60;\\\" xml:space=\\\"preserve\\\">\\r\\n<g>\\r\\n\\t<path d=\\\"M56,50v-2.02c1.118-0.101,2-1.033,2-2.177V17.196C58,15.985,57.015,15,55.804,15h-1.636C54.075,15,54,14.925,54,14.832\\r\\n\\t\\tV8.168C54,6.973,53.027,6,51.832,6H30.168C28.973,6,28,6.973,28,8.168v6.664C28,14.925,27.925,15,27.832,15H18v-2h6.287\\r\\n\\t\\tC25.231,13,26,12.231,26,11.286V1.714C26,0.769,25.231,0,24.287,0H5.713C4.769,0,4,0.769,4,1.714v9.572C4,12.231,4.769,13,5.713,13\\r\\n\\t\\tH12v2H4.196C2.985,15,2,15.985,2,17.196v28.607c0,1.144,0.882,2.075,2,2.177V50H0v10h60V50H56z M4,17.196\\r\\n\\t\\tC4,17.088,4.088,17,4.196,17H12v3c0,0.553,0.448,1,1,1s1-0.447,1-1v-3v-1v-5H6V2h18v9h-8v5v1v3c0,0.553,0.448,1,1,1s1-0.447,1-1v-3\\r\\n\\t\\th9.832C29.027,17,30,16.027,30,14.832V8.168C30,8.075,30.075,8,30.168,8h21.664C51.925,8,52,8.075,52,8.168v6.664\\r\\n\\t\\tC52,16.027,52.973,17,54.168,17h1.636C55.912,17,56,17.088,56,17.196v28.607C56,45.912,55.912,46,55.804,46H4.196\\r\\n\\t\\tC4.088,46,4,45.912,4,45.804V17.196z M6,48h48v2H6V48z M58,58H2v-6h2h52h2V58z\\\"/>\\r\\n\\t<path d=\\\"M20,54H6c-0.552,0-1,0.447-1,1s0.448,1,1,1h14c0.552,0,1-0.447,1-1S20.552,54,20,54z\\\"/>\\r\\n\\t<path d=\\\"M55,54h-1c-0.552,0-1,0.447-1,1s0.448,1,1,1h1c0.552,0,1-0.447,1-1S55.552,54,55,54z\\\"/>\\r\\n\\t<path d=\\\"M51,9H31v13h20V9z M49,20H33v-9h16V20z\\\"/>\\r\\n\\t<path d=\\\"M37,24h-6v6h6V24z M35,28h-2v-2h2V28z\\\"/>\\r\\n\\t<path d=\\\"M38,30h6v-6h-6V30z M40,26h2v2h-2V26z\\\"/>\\r\\n\\t<path d=\\\"M45,30h6v-6h-6V30z M47,26h2v2h-2V26z\\\"/>\\r\\n\\t<path d=\\\"M37,31h-6v6h6V31z M35,35h-2v-2h2V35z\\\"/>\\r\\n\\t<path d=\\\"M38,37h6v-6h-6V37z M40,33h2v2h-2V33z\\\"/>\\r\\n\\t<path d=\\\"M45,37h6v-6h-6V37z M47,33h2v2h-2V33z\\\"/>\\r\\n\\t<path d=\\\"M37,38h-6v6h6V38z M35,42h-2v-2h2V42z\\\"/>\\r\\n\\t<path d=\\\"M38,44h6v-6h-6V44z M40,40h2v2h-2V40z\\\"/>\\r\\n\\t<path d=\\\"M45,44h6v-6h-6V44z M47,40h2v2h-2V40z\\\"/>\\r\\n\\t<path d=\\\"M9.382,3.077c-0.244-0.101-0.52-0.101-0.764,0C8.495,3.128,8.385,3.201,8.292,3.294L7.293,4.293\\r\\n\\t\\tc-0.391,0.391-0.391,1.023,0,1.414C7.488,5.902,7.744,6,8,6v3c0,0.553,0.448,1,1,1s1-0.447,1-1V4c0-0.13-0.027-0.26-0.077-0.382\\r\\n\\t\\tC9.822,3.373,9.627,3.178,9.382,3.077z\\\"/>\\r\\n\\t<path d=\\\"M14.707,7.293c-0.391-0.391-1.023-0.391-1.414,0l-1,1c-0.391,0.391-0.391,1.023,0,1.414C12.488,9.902,12.744,10,13,10\\r\\n\\t\\ts0.512-0.098,0.707-0.293l1-1C15.098,8.316,15.098,7.684,14.707,7.293z\\\"/>\\r\\n\\t<path d=\\\"M17,6v3c0,0.553,0.448,1,1,1s1-0.447,1-1V4c0-0.13-0.027-0.26-0.077-0.382c-0.101-0.245-0.296-0.44-0.541-0.541\\r\\n\\t\\tc-0.244-0.101-0.52-0.101-0.764,0c-0.123,0.051-0.233,0.124-0.326,0.217l-0.999,0.999c-0.391,0.391-0.391,1.023,0,1.414\\r\\n\\t\\tC16.488,5.902,16.744,6,17,6z\\\"/>\\r\\n\\t<path d=\\\"M21,6v3c0,0.553,0.448,1,1,1s1-0.447,1-1V4c0-0.13-0.027-0.26-0.077-0.382c-0.101-0.245-0.296-0.44-0.541-0.541\\r\\n\\t\\tc-0.244-0.101-0.52-0.101-0.764,0c-0.123,0.051-0.233,0.124-0.326,0.217l-0.999,0.999c-0.391,0.391-0.391,1.023,0,1.414\\r\\n\\t\\tC20.488,5.902,20.744,6,21,6z\\\"/>\\r\\n\\t<path d=\\\"M6,43h1h16h1c0.552,0,1-0.447,1-1s-0.448-1-1-1h-1V23H7v18H6c-0.552,0-1,0.447-1,1S5.448,43,6,43z M9,25h12v16H9V25z\\\"/>\\r\\n\\t<path d=\\\"M28,45c0.552,0,1-0.447,1-1V19c0-0.553-0.448-1-1-1s-1,0.447-1,1v25C27,44.553,27.448,45,28,45z\\\"/>\\r\\n\\t<path d=\\\"M16,37h-5c-0.552,0-1,0.447-1,1s0.448,1,1,1h5c0.552,0,1-0.447,1-1S16.552,37,16,37z\\\"/>\\r\\n\\t<path d=\\\"M18.29,37.29C18.11,37.479,18,37.74,18,38s0.11,0.52,0.29,0.71C18.48,38.89,18.74,39,19,39c0.26,0,0.52-0.11,0.71-0.29\\r\\n\\t\\tC19.89,38.52,20,38.26,20,38s-0.11-0.521-0.29-0.71C19.34,36.92,18.67,36.92,18.29,37.29z\\\"/>\\r\\n\\t<path d=\\\"M19,27h-5c-0.552,0-1,0.447-1,1s0.448,1,1,1h5c0.552,0,1-0.447,1-1S19.552,27,19,27z\\\"/>\\r\\n\\t<path d=\\\"M19,32h-1c-0.552,0-1,0.447-1,1s0.448,1,1,1h1c0.552,0,1-0.447,1-1S19.552,32,19,32z\\\"/>\\r\\n\\t<path d=\\\"M11,34h1c0.552,0,1-0.447,1-1s-0.448-1-1-1h-1c-0.552,0-1,0.447-1,1S10.448,34,11,34z\\\"/>\\r\\n\\t<path d=\\\"M11,29c0.26,0,0.52-0.11,0.71-0.29C11.89,28.52,12,28.27,12,28c0-0.26-0.11-0.521-0.29-0.71c-0.38-0.37-1.05-0.37-1.42,0\\r\\n\\t\\tC10.11,27.479,10,27.74,10,28c0,0.27,0.11,0.52,0.29,0.71C10.48,28.89,10.74,29,11,29z\\\"/>\\r\\n\\t<path d=\\\"M15.71,33.71C15.89,33.52,16,33.26,16,33s-0.11-0.521-0.29-0.71c-0.38-0.37-1.04-0.37-1.42,0C14.11,32.479,14,32.729,14,33\\r\\n\\t\\tc0,0.26,0.11,0.52,0.29,0.71C14.48,33.89,14.74,34,15,34C15.26,34,15.52,33.89,15.71,33.71z\\\"/>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n</svg>\\r\\n\",\"properties\":{\"size\":{\"value\":50,\"unit\":\"px\"},\"color\":\"rgba(0 ,  0,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"left\",\"img_content_v_align\":\"\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":18,\"tablet\":20,\"phone\":25},\"image_width\":{\"desktop\":70,\"tablet\":30,\"phone\":0,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"left\",\"phone\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":18,\"phone\":16},\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"tablet\":20,\"phone\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2,\"tablet\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"rgba(128 ,  130,  145, 1)\",\"body_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":50,\"left\":25,\"bottom\":50,\"right\":25},\"tablet\":{\"left\":15,\"right\":15},\"phone\":{\"left\":35,\"right\":35}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}},\"border_color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":700,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-blurb-0840\"}}},\"children\":[]},{\"slug\":\"blurb\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Business Finance\",\"content\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"<?xml version=\\\"1.0\\\" encoding=\\\"iso-8859-1\\\"?>\\r\\n<!-- Generator: Adobe Illustrator 18.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\\r\\n<!DOCTYPE svg PUBLIC \\\"-//W3C//DTD SVG 1.1//EN\\\" \\\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\\\">\\r\\n<svg version=\\\"1.1\\\" id=\\\"Capa_1\\\" xmlns=\\\"http://www.w3.org/2000/svg\\\" xmlns:xlink=\\\"http://www.w3.org/1999/xlink\\\" x=\\\"0px\\\" y=\\\"0px\\\"\\r\\n\\t viewBox=\\\"0 0 60 60\\\" style=\\\"enable-background:new 0 0 60 60;\\\" xml:space=\\\"preserve\\\">\\r\\n<g>\\r\\n\\t<path d=\\\"M5.508,12.424c0.502-0.229,0.723-0.822,0.493-1.325c-0.23-0.502-0.822-0.725-1.325-0.493\\r\\n\\t\\tc-0.693,0.316-1.338,0.731-1.915,1.231c-0.417,0.362-0.462,0.994-0.101,1.411c0.198,0.228,0.477,0.345,0.756,0.345\\r\\n\\t\\tc0.232,0,0.466-0.08,0.655-0.244C4.504,12.973,4.987,12.662,5.508,12.424z\\\"/>\\r\\n\\t<path d=\\\"M9,11.884h2c0.553,0,1-0.447,1-1s-0.447-1-1-1H9c-0.553,0-1,0.447-1,1S8.447,11.884,9,11.884z\\\"/>\\r\\n\\t<path d=\\\"M15,11.884h2c0.553,0,1-0.447,1-1s-0.447-1-1-1h-2c-0.553,0-1,0.447-1,1S14.447,11.884,15,11.884z\\\"/>\\r\\n\\t<path d=\\\"M11,23.884H9c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S11.553,23.884,11,23.884z\\\"/>\\r\\n\\t<path d=\\\"M23,23.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S23.553,23.884,23,23.884z\\\"/>\\r\\n\\t<path d=\\\"M17,23.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S17.553,23.884,17,23.884z\\\"/>\\r\\n\\t<path d=\\\"M5.508,23.344c-0.52-0.238-1.003-0.549-1.436-0.925c-0.417-0.361-1.048-0.316-1.411,0.101\\r\\n\\t\\tc-0.361,0.417-0.316,1.049,0.101,1.411c0.577,0.5,1.221,0.914,1.914,1.231c0.135,0.062,0.276,0.091,0.415,0.091\\r\\n\\t\\tc0.38,0,0.742-0.217,0.91-0.584C6.23,24.167,6.01,23.573,5.508,23.344z\\\"/>\\r\\n\\t<path d=\\\"M29,23.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S29.553,23.884,29,23.884z\\\"/>\\r\\n\\t<path d=\\\"M47,23.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S47.553,23.884,47,23.884z\\\"/>\\r\\n\\t<path d=\\\"M53,23.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S53.553,23.884,53,23.884z\\\"/>\\r\\n\\t<path d=\\\"M35,23.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S35.553,23.884,35,23.884z\\\"/>\\r\\n\\t<path d=\\\"M41,23.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S41.553,23.884,41,23.884z\\\"/>\\r\\n\\t<path d=\\\"M5.508,53.344c-0.52-0.238-1.003-0.549-1.436-0.925c-0.417-0.361-1.048-0.316-1.411,0.101\\r\\n\\t\\tc-0.361,0.417-0.316,1.049,0.101,1.411c0.577,0.5,1.221,0.914,1.914,1.231c0.135,0.062,0.276,0.091,0.415,0.091\\r\\n\\t\\tc0.38,0,0.742-0.217,0.91-0.584C6.23,54.167,6.01,53.573,5.508,53.344z\\\"/>\\r\\n\\t<path d=\\\"M17,53.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S17.553,53.884,17,53.884z\\\"/>\\r\\n\\t<path d=\\\"M11,53.884H9c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S11.553,53.884,11,53.884z\\\"/>\\r\\n\\t<path d=\\\"M35,53.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S35.553,53.884,35,53.884z\\\"/>\\r\\n\\t<path d=\\\"M38,54.884c0,0.553,0.447,1,1,1h2c0.553,0,1-0.447,1-1s-0.447-1-1-1h-2C38.447,53.884,38,54.331,38,54.884z\\\"/>\\r\\n\\t<path d=\\\"M45,55.884h2c0.553,0,1-0.447,1-1s-0.447-1-1-1h-2c-0.553,0-1,0.447-1,1S44.447,55.884,45,55.884z\\\"/>\\r\\n\\t<path d=\\\"M29,53.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S29.553,53.884,29,53.884z\\\"/>\\r\\n\\t<path d=\\\"M51,55.884h2c0.553,0,1-0.447,1-1s-0.447-1-1-1h-2c-0.553,0-1,0.447-1,1S50.447,55.884,51,55.884z\\\"/>\\r\\n\\t<path d=\\\"M23,53.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S23.553,53.884,23,53.884z\\\"/>\\r\\n\\t<path d=\\\"M44,38.884c0,2.206,1.794,4,4,4s4-1.794,4-4s-1.794-4-4-4S44,36.678,44,38.884z M48,36.884c1.103,0,2,0.897,2,2\\r\\n\\t\\ts-0.897,2-2,2s-2-0.897-2-2S46.897,36.884,48,36.884z\\\"/>\\r\\n\\t<path d=\\\"M42.942,5.884l-5.436-5.436c-0.443-0.443-1.166-0.443-1.609,0l-2.046,2.046l-2.046-2.046c-0.443-0.443-1.166-0.443-1.609,0\\r\\n\\t\\tL24.76,5.884H8c-4.411,0-8,3.589-8,8v38.848c0,3.943,3.209,7.152,7.152,7.152H60v-14v-14v-10v-2v-14H42.942z M36.702,2.472\\r\\n\\t\\tl3.412,3.412l14,14h-5.391L37.456,8.616c-0.423-0.411-1.086-0.41-1.519,0.011L24.681,19.884H19.29L35.266,3.909l0,0L36.702,2.472z\\r\\n\\t\\t M45.896,19.884H27.509l9.193-9.193L45.896,19.884z M31,2.472l1.437,1.437L16.462,19.884h-2.874l14-14L31,2.472z M8,7.884h14.76\\r\\n\\t\\tl-2.061,2.061c-0.303,0.098-0.535,0.329-0.633,0.633l-9.306,9.306H8c-3.309,0-6-2.691-6-6S4.691,7.884,8,7.884z M58,43.884H47\\r\\n\\t\\tc-2.757,0-5-2.243-5-5s2.243-5,5-5h11V43.884z M58,23.884h-1c-0.553,0-1,0.447-1,1s0.447,1,1,1h1v6H47c-3.859,0-7,3.141-7,7\\r\\n\\t\\ts3.141,7,7,7h11v8h-1c-0.553,0-1,0.447-1,1s0.447,1,1,1h1v2H7.152C4.312,57.884,2,55.573,2,52.732v-2.204\\r\\n\\t\\tc0.233-0.25,0.345-0.603,0.241-0.954C2.081,49.028,2,48.459,2,47.884V20.528c0.233-0.25,0.345-0.603,0.241-0.954\\r\\n\\t\\tc-0.019-0.065-0.026-0.132-0.043-0.197c0.09,0.095,0.181,0.188,0.275,0.278c0.086,0.083,0.175,0.162,0.265,0.241\\r\\n\\t\\tc0.112,0.098,0.226,0.193,0.343,0.285c0.094,0.074,0.19,0.145,0.287,0.215c0.121,0.087,0.246,0.169,0.372,0.249\\r\\n\\t\\tc0.101,0.064,0.202,0.126,0.306,0.186c0.132,0.075,0.267,0.145,0.403,0.213c0.105,0.053,0.21,0.106,0.318,0.154\\r\\n\\t\\tc0.143,0.063,0.289,0.119,0.435,0.174c0.108,0.041,0.215,0.083,0.325,0.119c0.157,0.051,0.317,0.092,0.477,0.134\\r\\n\\t\\tc0.106,0.027,0.21,0.059,0.318,0.082c0.181,0.039,0.365,0.065,0.55,0.091c0.092,0.013,0.182,0.032,0.275,0.042\\r\\n\\t\\tc0.28,0.03,0.564,0.047,0.851,0.047h3.816h2.828h2.874h2.828H25.3h22.805h4.953h2.828H58V23.884z M56.942,19.884l-8-8H49\\r\\n\\t\\tc0.553,0,1-0.447,1-1s-0.447-1-1-1h-2c-0.017,0-0.031,0.009-0.048,0.01l-2.01-2.01H58v12H56.942z\\\"/>\\r\\n\\t<path d=\\\"M55,9.884h-2c-0.553,0-1,0.447-1,1s0.447,1,1,1h2c0.553,0,1-0.447,1-1S55.553,9.884,55,9.884z\\\"/>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n</svg>\\r\\n\",\"properties\":{\"size\":{\"value\":50,\"unit\":\"px\"},\"color\":\"rgba(0 ,  0,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"left\",\"img_content_v_align\":\"\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":18,\"tablet\":20,\"phone\":25},\"image_width\":{\"desktop\":70,\"tablet\":30,\"phone\":0,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"left\",\"phone\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":18,\"phone\":16},\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"tablet\":20,\"phone\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2,\"tablet\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"rgba(128 ,  130,  145, 1)\",\"body_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":50,\"left\":25,\"bottom\":50,\"right\":25},\"tablet\":{\"left\":15,\"right\":15},\"phone\":{\"left\":35,\"right\":35}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}},\"border_color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":1100,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-blurb-831204\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":33.33333,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-42467\"}}},\"children\":[{\"slug\":\"blurb\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Restructuring\",\"content\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"<?xml version=\\\"1.0\\\" encoding=\\\"iso-8859-1\\\"?>\\r\\n<!-- Generator: Adobe Illustrator 18.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\\r\\n<!DOCTYPE svg PUBLIC \\\"-//W3C//DTD SVG 1.1//EN\\\" \\\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\\\">\\r\\n<svg version=\\\"1.1\\\" id=\\\"Capa_1\\\" xmlns=\\\"http://www.w3.org/2000/svg\\\" xmlns:xlink=\\\"http://www.w3.org/1999/xlink\\\" x=\\\"0px\\\" y=\\\"0px\\\"\\r\\n\\t viewBox=\\\"0 0 60 60\\\" style=\\\"enable-background:new 0 0 60 60;\\\" xml:space=\\\"preserve\\\">\\r\\n<path d=\\\"M53,41V29H31V19h7V3H22v16h7v10H7v12H0v16h16V41H9V31h20v10h-7v16h16V41h-7V31h20v10h-7v16h16V41H53z M24,5h12v12H24V5z\\r\\n\\t M14,55H2V43h12V55z M36,55H24V43h12V55z M58,55H46V43h12V55z\\\"/>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n</svg>\\r\\n\",\"properties\":{\"size\":{\"value\":50,\"unit\":\"px\"},\"color\":\"rgba(0 ,  0,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"left\",\"img_content_v_align\":\"\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":18,\"tablet\":20,\"phone\":25},\"image_width\":{\"desktop\":70,\"tablet\":30,\"phone\":0,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"left\",\"phone\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":18,\"phone\":16},\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"tablet\":20,\"phone\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2,\"tablet\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"rgba(128 ,  130,  145, 1)\",\"body_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":50,\"left\":25,\"bottom\":50,\"right\":25},\"tablet\":{\"left\":15,\"right\":15},\"phone\":{\"left\":35,\"right\":35}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}},\"border_color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":850,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-blurb-481028\"}}},\"children\":[]},{\"slug\":\"blurb\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Audit & Evaluation\",\"content\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"<?xml version=\\\"1.0\\\" encoding=\\\"iso-8859-1\\\"?>\\r\\n<!-- Generator: Adobe Illustrator 18.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\\r\\n<!DOCTYPE svg PUBLIC \\\"-//W3C//DTD SVG 1.1//EN\\\" \\\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\\\">\\r\\n<svg version=\\\"1.1\\\" id=\\\"Capa_1\\\" xmlns=\\\"http://www.w3.org/2000/svg\\\" xmlns:xlink=\\\"http://www.w3.org/1999/xlink\\\" x=\\\"0px\\\" y=\\\"0px\\\"\\r\\n\\t viewBox=\\\"0 0 56 56\\\" style=\\\"enable-background:new 0 0 56 56;\\\" xml:space=\\\"preserve\\\">\\r\\n<g>\\r\\n\\t<path d=\\\"M38,0h-2H20h-2H0v56h18h2h16h2h18V0H38z M18,54H2V2h16V54z M36,54H20V2h16V54z M54,54H38V2h16V54z\\\"/>\\r\\n\\t<path d=\\\"M16,4H4v22h12V4z M14,24H6V6h8V24z\\\"/>\\r\\n\\t<path d=\\\"M34,4H22v22h12V4z M32,24h-8V6h8V24z\\\"/>\\r\\n\\t<path d=\\\"M52,4H40v22h12V4z M50,24h-8V6h8V24z\\\"/>\\r\\n\\t<path d=\\\"M10,51c3.309,0,6-2.691,6-6s-2.691-6-6-6s-6,2.691-6,6S6.691,51,10,51z M10,41c2.206,0,4,1.794,4,4s-1.794,4-4,4\\r\\n\\t\\ts-4-1.794-4-4S7.794,41,10,41z\\\"/>\\r\\n\\t<path d=\\\"M28,51c3.309,0,6-2.691,6-6s-2.691-6-6-6s-6,2.691-6,6S24.691,51,28,51z M28,41c2.206,0,4,1.794,4,4s-1.794,4-4,4\\r\\n\\t\\ts-4-1.794-4-4S25.794,41,28,41z\\\"/>\\r\\n\\t<path d=\\\"M46,51c3.309,0,6-2.691,6-6s-2.691-6-6-6s-6,2.691-6,6S42.691,51,46,51z M46,41c2.206,0,4,1.794,4,4s-1.794,4-4,4\\r\\n\\t\\ts-4-1.794-4-4S43.794,41,46,41z\\\"/>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n</svg>\\r\\n\",\"properties\":{\"size\":{\"value\":50,\"unit\":\"px\"},\"color\":\"rgba(0 ,  0,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"left\",\"img_content_v_align\":\"\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":18,\"tablet\":20,\"phone\":25},\"image_width\":{\"desktop\":70,\"tablet\":30,\"phone\":0,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"left\",\"phone\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":18,\"phone\":16},\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"tablet\":20,\"phone\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2,\"tablet\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"rgba(128 ,  130,  145, 1)\",\"body_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":50,\"left\":25,\"bottom\":50,\"right\":25},\"tablet\":{\"left\":15,\"right\":15},\"phone\":{\"left\":35,\"right\":35}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}},\"border_color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":1300,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-blurb-421205\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":33.33333,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-27470\"}}},\"children\":[{\"slug\":\"blurb\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Consumer Markets\",\"content\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris .\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"<?xml version=\\\"1.0\\\" encoding=\\\"iso-8859-1\\\"?>\\r\\n<!-- Generator: Adobe Illustrator 18.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\\r\\n<!DOCTYPE svg PUBLIC \\\"-//W3C//DTD SVG 1.1//EN\\\" \\\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\\\">\\r\\n<svg version=\\\"1.1\\\" id=\\\"Capa_1\\\" xmlns=\\\"http://www.w3.org/2000/svg\\\" xmlns:xlink=\\\"http://www.w3.org/1999/xlink\\\" x=\\\"0px\\\" y=\\\"0px\\\"\\r\\n\\t viewBox=\\\"0 0 60 60\\\" style=\\\"enable-background:new 0 0 60 60;\\\" xml:space=\\\"preserve\\\">\\r\\n<g>\\r\\n\\t<path d=\\\"M1,2h58c0.553,0,1-0.447,1-1s-0.447-1-1-1H1C0.448,0,0,0.447,0,1S0.448,2,1,2z\\\"/>\\r\\n\\t<path d=\\\"M59,58h-2V45v-2V12H47v31v2v13h-1V45v-2V33H36v10v2v13h-1V45v-2V22H25v21v2v13h-1V45v-2V28H14v15v2v13h-1V45v-2v-5H3v5v2\\r\\n\\t\\tv13H1c-0.552,0-1,0.447-1,1s0.448,1,1,1h2h10h1h10h1h10h1h10h1h10h2c0.553,0,1-0.447,1-1S59.553,58,59,58z M5,40h6v3H5V40z M5,58\\r\\n\\t\\tV45h6v13H5z M16,30h6v13h-6V30z M16,58V45h6v13H16z M27,24h6v19h-6V24z M27,58V45h6v13H27z M38,35h6v8h-6V35z M38,58V45h6v13H38z\\r\\n\\t\\t M49,14h6v29h-6V14z M49,58V45h6v13H49z\\\"/>\\r\\n\\t<path d=\\\"M8,13h8c0.552,0,1-0.447,1-1s-0.448-1-1-1H8c-0.552,0-1,0.447-1,1S7.448,13,8,13z\\\"/>\\r\\n\\t<path d=\\\"M2.29,11.29C2.11,11.47,2,11.729,2,12c0,0.27,0.11,0.52,0.29,0.71C2.48,12.89,2.74,13,3,13c0.26,0,0.52-0.11,0.71-0.29\\r\\n\\t\\tC3.89,12.52,4,12.26,4,12c0-0.271-0.11-0.521-0.29-0.71C3.33,10.92,2.66,10.92,2.29,11.29z\\\"/>\\r\\n\\t<path d=\\\"M7,7c0-0.553-0.448-1-1-1H3C2.448,6,2,6.447,2,7s0.448,1,1,1h3C6.552,8,7,7.553,7,7z\\\"/>\\r\\n\\t<path d=\\\"M16,6h-2c-0.552,0-1,0.447-1,1s0.448,1,1,1h2c0.552,0,1-0.447,1-1S16.552,6,16,6z\\\"/>\\r\\n\\t<path d=\\\"M10.71,7.71C10.89,7.52,11,7.26,11,7s-0.11-0.521-0.29-0.71c-0.38-0.37-1.04-0.37-1.42,0C9.11,6.479,9,6.74,9,7\\r\\n\\t\\ts0.11,0.52,0.29,0.71C9.48,7.89,9.74,8,10,8C10.26,8,10.52,7.89,10.71,7.71z\\\"/>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n</svg>\\r\\n\",\"properties\":{\"size\":{\"value\":50,\"unit\":\"px\"},\"color\":\"rgba(0 ,  0,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"left\",\"img_content_v_align\":\"\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":18,\"tablet\":20,\"phone\":25},\"image_width\":{\"desktop\":70,\"tablet\":30,\"phone\":0,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"left\",\"phone\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":18,\"phone\":16},\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"tablet\":20,\"phone\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2,\"tablet\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"rgba(128 ,  130,  145, 1)\",\"body_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":50,\"left\":25,\"bottom\":50,\"right\":25},\"tablet\":{\"left\":15,\"right\":15},\"phone\":{\"left\":35,\"right\":35}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}},\"border_color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":950,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-blurb-37471\"}}},\"children\":[]},{\"slug\":\"blurb\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Strategy & Planning\",\"content\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"<?xml version=\\\"1.0\\\" encoding=\\\"iso-8859-1\\\"?>\\r\\n<!-- Generator: Adobe Illustrator 17.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\\r\\n<!DOCTYPE svg PUBLIC \\\"-//W3C//DTD SVG 1.1//EN\\\" \\\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\\\">\\r\\n<svg version=\\\"1.1\\\" id=\\\"Capa_1\\\" xmlns=\\\"http://www.w3.org/2000/svg\\\" xmlns:xlink=\\\"http://www.w3.org/1999/xlink\\\" x=\\\"0px\\\" y=\\\"0px\\\"\\r\\n\\t viewBox=\\\"0 0 512 512\\\" style=\\\"enable-background:new 0 0 512 512;\\\" xml:space=\\\"preserve\\\">\\r\\n<g>\\r\\n\\t<path d=\\\"M416,32h-80.001c-0.007,0-0.013,0.001-0.02,0.001C328.674,22.292,317.059,16,304,16h-20.39C277.966,6.242,267.481,0,256,0\\r\\n\\t\\ts-21.966,6.242-27.61,16H208c-13.059,0-24.674,6.292-31.979,16.001c-0.007,0-0.014-0.001-0.021-0.001H96c-22.056,0-40,17.944-40,40\\r\\n\\t\\tv400c0,22.056,17.944,40,40,40h320c22.056,0,40-17.944,40-40V72C456,49.944,438.056,32,416,32z M184,56c0-13.233,10.767-24,24-24\\r\\n\\t\\th25.47c3.385,0,6.404-2.131,7.538-5.32C243.278,20.292,249.303,16,256,16s12.722,4.292,14.992,10.68\\r\\n\\t\\tc1.134,3.189,4.153,5.32,7.538,5.32H304c13.233,0,24,10.767,24,24v24H184V56z M440,472c0,13.233-10.767,24-24,24H96\\r\\n\\t\\tc-13.233,0-24-10.767-24-24V72c0-13.233,10.767-24,24-24h72.805c-0.527,2.586-0.805,5.261-0.805,8v32c0,4.418,3.582,8,8,8h160\\r\\n\\t\\tc4.418,0,8-3.582,8-8V56c0-2.739-0.278-5.414-0.805-8H416c13.233,0,24,10.767,24,24V472z\\\"/>\\r\\n\\t<path d=\\\"M416,64h-48c-4.418,0-8,3.582-8,8s3.582,8,8,8h40v384H104V80h40c4.418,0,8-3.582,8-8s-3.582-8-8-8H96c-4.418,0-8,3.582-8,8\\r\\n\\t\\tv400c0,4.418,3.582,8,8,8h320c4.418,0,8-3.582,8-8V72C424,67.582,420.418,64,416,64z\\\"/>\\r\\n\\t<path d=\\\"M256,32c-2.11,0-4.17,0.85-5.66,2.34c-1.49,1.49-2.34,3.55-2.34,5.66c0,2.1,0.85,4.17,2.34,5.66\\r\\n\\t\\tc1.49,1.49,3.55,2.34,5.66,2.34c2.1,0,4.17-0.85,5.66-2.34c1.49-1.49,2.34-3.55,2.34-5.66c0-2.11-0.85-4.17-2.34-5.66\\r\\n\\t\\tC260.17,32.849,258.1,32,256,32z\\\"/>\\r\\n\\t<path d=\\\"M130.343,186.343c-3.125,3.124-3.125,8.189,0,11.313l24,24c1.562,1.562,3.609,2.343,5.657,2.343s4.095-0.781,5.657-2.343\\r\\n\\t\\tl40-40c3.125-3.124,3.125-8.189,0-11.313c-3.124-3.124-8.189-3.124-11.313,0L160,204.686l-18.343-18.343\\r\\n\\t\\tC138.533,183.219,133.467,183.219,130.343,186.343z\\\"/>\\r\\n\\t<path d=\\\"M205.657,258.343c-3.124-3.124-8.189-3.124-11.313,0L160,292.686l-18.343-18.343c-3.124-3.124-8.189-3.124-11.313,0\\r\\n\\t\\tc-3.125,3.124-3.125,8.189,0,11.313l24,24c1.562,1.562,3.609,2.343,5.657,2.343s4.095-0.781,5.657-2.343l40-40\\r\\n\\t\\tC208.781,266.533,208.781,261.467,205.657,258.343z\\\"/>\\r\\n\\t<path d=\\\"M194.343,346.343L160,380.686l-18.343-18.343c-3.124-3.124-8.189-3.124-11.313,0c-3.125,3.124-3.125,8.189,0,11.313l24,24\\r\\n\\t\\tc1.562,1.562,3.609,2.343,5.657,2.343s4.095-0.781,5.657-2.343l40-40c3.125-3.124,3.125-8.189,0-11.313\\r\\n\\t\\tC202.533,343.219,197.467,343.219,194.343,346.343z\\\"/>\\r\\n\\t<path d=\\\"M240,200h136c4.418,0,8-3.582,8-8s-3.582-8-8-8H240c-4.418,0-8,3.582-8,8S235.582,200,240,200z\\\"/>\\r\\n\\t<path d=\\\"M240,288h136c4.418,0,8-3.582,8-8s-3.582-8-8-8H240c-4.418,0-8,3.582-8,8S235.582,288,240,288z\\\"/>\\r\\n\\t<path d=\\\"M240,376h136c4.418,0,8-3.582,8-8s-3.582-8-8-8H240c-4.418,0-8,3.582-8,8S235.582,376,240,376z\\\"/>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n<g>\\r\\n</g>\\r\\n</svg>\\r\\n\",\"properties\":{\"size\":{\"value\":50,\"unit\":\"px\"},\"color\":\"rgba(0 ,  0,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"left\",\"img_content_v_align\":\"\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":18,\"tablet\":20,\"phone\":25},\"image_width\":{\"desktop\":70,\"tablet\":30,\"phone\":0,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"left\",\"phone\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":18,\"phone\":16},\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"tablet\":20,\"phone\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2,\"tablet\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"rgba(128 ,  130,  145, 1)\",\"body_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":50,\"left\":25,\"bottom\":50,\"right\":25},\"tablet\":{\"left\":15,\"right\":15},\"phone\":{\"left\":35,\"right\":35}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}},\"border_color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":1500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-blurb-611206\"}}},\"children\":[]}]}]}]},{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":100,\"bottom\":100},\"phone\":{\"top\":60,\"bottom\":60},\"tablet\":{\"top\":80,\"bottom\":75}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\",\"src\":{\"source\":\"/financio/shape-1.png\",\"type\":\"image\",\"properties\":[]},\"size\":\"initial\",\"position\":\"right\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-84846\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"qx-row-align-center\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-27847\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"phone\":0}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-55848\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"Case Studies\",\"subtitle\":\"Our recent case studies For Financial services\",\"description\":\"\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"\",\"link\":{\"url\":\"#\"}},\"call_to_action_fg_additional\":{\"title_html_tag\":\"h5\",\"html_subtitle_tag\":\"h2\",\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"left\",\"tablet\":\"left\"},\"element_padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 0.8)\",\"title_spacing\":{\"desktop\":0},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":16,\"tablet\":16,\"phone\":15},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":3},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_color\":\"rgba(10 ,  3,  98, 1)\",\"subtitle_spacing\":{\"desktop\":0},\"subtitle_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":50,\"tablet\":45,\"phone\":40},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(128 ,  130,  145, 1)\",\"description_spacing\":{\"desktop\":0},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(55 ,  66,  250, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Nunito\",\"weight\":\"regular\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-73849\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-82850\"}}},\"children\":[{\"slug\":\"text\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"text_fields_group\":{\"content\":\"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Donec odio. Quisque volutpat mattis eros. Nullam malesuada erat ut turpis. Suspendisse urna nibh, viverra non, semper suscipit.\"}},\"styles\":{\"text_fields_group\":{\"alignment\":{\"phone\":\"center\"},\"text_color\":\"rgba(128 ,  130,  145, 1)\"},\"typo_fields_group\":{\"font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-right-medium\",\"animation_delay\":{\"value\":600,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-text-162117\"}}},\"children\":[]}]}]},{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-76427\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":33.33333,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"size\":\"initial\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-56428\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":\"/financio/case-1.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"Business tax auditing and evaluation\",\"subtitle\":\"\",\"description\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris sit amet orci.\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"Read More\",\"link\":{\"url\":\"index.php/pages/other-pages/single-case\"}},\"call_to_action_fg_additional\":{\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"left\",\"tablet\":\"left\"},\"element_padding\":{\"desktop\":{\"top\":35,\"bottom\":45,\"left\":40,\"right\":40},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":30,\"left\":18,\"right\":18}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_spacing\":{\"desktop\":20,\"tablet\":18},\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"tablet\":22},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.3,\"tablet\":1.4},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_spacing\":{\"desktop\":null},\"subtitle_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(128 ,  130,  145, 1)\",\"description_spacing\":{\"desktop\":30,\"tablet\":25},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_text_color\":\"rgba(0 ,  0,  255, 1)\",\"button_hover_text_color\":\"rgba(0 ,  0,  255, 0.8)\",\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"desktop\":16,\"tablet\":15},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":0,\"bottom\":0,\"left\":0,\"right\":0},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":5,\"unit\":\"px\"}}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":600,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-467418\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":33.33333,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"size\":\"initial\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-846462\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":\"/financio/case-2.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"International business development\",\"subtitle\":\"\",\"description\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris sit amet orci.\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"Read More\",\"link\":{\"url\":\"index.php/pages/other-pages/single-case\"}},\"call_to_action_fg_additional\":{\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"left\",\"tablet\":\"left\"},\"element_padding\":{\"desktop\":{\"top\":35,\"bottom\":45,\"left\":40,\"right\":40},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":30,\"left\":18,\"right\":18}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_spacing\":{\"desktop\":20,\"tablet\":18},\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"tablet\":22},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.3,\"tablet\":1.4},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_spacing\":{\"desktop\":null},\"subtitle_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(128 ,  130,  145, 1)\",\"description_spacing\":{\"desktop\":30,\"tablet\":25},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_text_color\":\"rgba(0 ,  0,  255, 1)\",\"button_hover_text_color\":\"rgba(0 ,  0,  255, 0.8)\",\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"desktop\":16,\"tablet\":15},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":0,\"bottom\":0,\"left\":0,\"right\":0},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":5,\"unit\":\"px\"}}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":800,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-857419\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":33.33333,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"size\":\"initial\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-406431\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":\"/financio/case-4.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"Market analysis and data evaluation\",\"subtitle\":\"\",\"description\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris sit amet orci.\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"Read More\",\"link\":{\"url\":\"index.php/pages/other-pages/single-case\"}},\"call_to_action_fg_additional\":{\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"left\",\"tablet\":\"left\"},\"element_padding\":{\"desktop\":{\"top\":35,\"bottom\":45,\"left\":40,\"right\":40},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":30,\"left\":18,\"right\":18}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_spacing\":{\"desktop\":20,\"tablet\":18},\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"tablet\":22},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.3,\"tablet\":1.4},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_spacing\":{\"desktop\":null},\"subtitle_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(128 ,  130,  145, 1)\",\"description_spacing\":{\"desktop\":30,\"tablet\":25},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_text_color\":\"rgba(0 ,  0,  255, 1)\",\"button_hover_text_color\":\"rgba(0 ,  0,  255, 0.8)\",\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"desktop\":16,\"tablet\":15},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":0,\"bottom\":0,\"left\":0,\"right\":0},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":5,\"unit\":\"px\"}}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":1000,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-407420\"}}},\"children\":[]}]}]}]},{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":105,\"bottom\":60,\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":80,\"bottom\":80},\"tablet\":{\"top\":0}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(245 ,  245,  245, 1)\",\"src\":{\"source\":\"/financio/banner-1.jpg\",\"type\":\"image\",\"properties\":[]},\"position\":\"top right\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_color\":\"rgba(255 ,  255,  255, 1)\",\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":70},\"top_divider_flip\":true},\"divider_bottom_fields_group\":{\"bottom_divider_color\":\"rgba(255 ,  255,  255, 0.95)\",\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":70},\"bottom_divider_flip\":true}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-911566\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"qx-row-align-center\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-391567\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":60,\"tablet\":60,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"size\":\"initial\",\"position\":\"top left\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-681568\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"why choose us\",\"subtitle\":\"We area high experienced. We can manage your finance\",\"description\":\"<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Donec odio. Quisque volutpat mattis eros. Nullam malesuada erat ut turpis. Suspendisse urna nibh, viverra non, semper suscipit, posuere a, pede.</p>\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"\",\"link\":{\"url\":\"#\"}},\"call_to_action_fg_additional\":{\"title_html_tag\":\"h5\",\"html_subtitle_tag\":\"h2\",\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"left\",\"tablet\":\"left\"},\"element_padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(255 ,  255,  255, 1)\",\"title_spacing\":{\"desktop\":0},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":16,\"tablet\":16,\"phone\":15},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":3},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_color\":\"rgba(255 ,  255,  255, 1)\",\"subtitle_spacing\":{\"desktop\":35,\"tablet\":30,\"phone\":25},\"subtitle_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":50,\"tablet\":45,\"phone\":40},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(255 ,  255,  255, 0.8)\",\"description_spacing\":{\"desktop\":0},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(55 ,  66,  250, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Nunito\",\"weight\":\"regular\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"right\":0},\"phone\":{\"right\":0}},\"padding\":{\"desktop\":{\"top\":100},\"tablet\":{\"top\":85},\"phone\":{\"top\":0}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-921569\"}}},\"children\":[]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"%\"},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-481570\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-131571\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-141572\"}}},\"children\":[{\"slug\":\"blurb\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"High Experienced\",\"content\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris sit.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"qxio-ios-arrow-thin-right\",\"properties\":{\"size\":{\"value\":40,\"unit\":\"px\"},\"color\":\"rgba(255 ,  255,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"left\",\"img_content_v_align\":\"\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":0,\"tablet\":20},\"image_width\":{\"desktop\":70,\"tablet\":30,\"phone\":0,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"left\",\"phone\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":18,\"phone\":16},\"title_color\":\"rgba(255 ,  255,  255, 1)\",\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"phone\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"rgba(255 ,  255,  255, 0.8)\",\"body_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":50},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":700,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-blurb-571573\"}}},\"children\":[]},{\"slug\":\"blurb\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Expert Accountants\",\"content\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris sit amet.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"qxio-ios-arrow-thin-right\",\"properties\":{\"size\":{\"value\":40,\"unit\":\"px\"},\"color\":\"rgba(255 ,  255,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"left\",\"img_content_v_align\":\"\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":0,\"tablet\":20},\"image_width\":{\"desktop\":75,\"tablet\":30,\"phone\":0,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"left\",\"phone\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":18,\"phone\":16},\"title_color\":\"rgba(255 ,  255,  255, 1)\",\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"phone\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"rgba(255 ,  255,  255, 0.8)\",\"body_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":900,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-blurb-871574\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-481575\"}}},\"children\":[{\"slug\":\"blurb\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Experienced Auditors\",\"content\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris sit.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"qxio-ios-arrow-thin-right\",\"properties\":{\"size\":{\"value\":40,\"unit\":\"px\"},\"color\":\"rgba(255 ,  255,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"left\",\"img_content_v_align\":\"\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":0,\"tablet\":20},\"image_width\":{\"desktop\":70,\"tablet\":30,\"phone\":0,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"left\",\"phone\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":18,\"phone\":16},\"title_color\":\"rgba(255 ,  255,  255, 1)\",\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"phone\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"rgba(255 ,  255,  255, 0.8)\",\"body_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":50},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":700,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-blurb-691576\"}}},\"children\":[]},{\"slug\":\"blurb\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Dedicated Support\",\"content\":\"Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris sit amet.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"qxio-ios-arrow-thin-right\",\"properties\":{\"size\":{\"value\":40,\"unit\":\"px\"},\"color\":\"rgba(255 ,  255,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"left\",\"img_content_v_align\":\"\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":0,\"tablet\":20},\"image_width\":{\"desktop\":75,\"tablet\":30,\"phone\":0,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"left\",\"phone\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":18,\"phone\":16},\"title_color\":\"rgba(255 ,  255,  255, 1)\",\"title_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":24,\"phone\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"rgba(255 ,  255,  255, 0.8)\",\"body_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"%\"},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":900,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-blurb-181577\"}}},\"children\":[]}]}]}]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":40,\"tablet\":40,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-991578\"}}},\"children\":[{\"slug\":\"counter\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"counter_fg_element_mode\":{\"count_end\":\"1200\",\"counter_prefix\":null,\"suffix\":\"+\",\"title\":\"Successfully Completed Cases\",\"alignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"}}},\"styles\":{\"counter_fg_number_style\":{\"number_color\":\"rgba(255 ,  255,  255, 1)\",\"number_typo\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":60,\"tablet\":50,\"phone\":40},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"number_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"counter_fg_title_style\":{\"title_color\":\"rgba(255 ,  255,  255, 1)\",\"title_typo\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":18,\"tablet\":16,\"phone\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"title_padding\":{\"desktop\":{\"top\":15},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":100,\"bottom\":50},\"tablet\":{\"top\":0},\"phone\":{\"top\":0}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-counter-771579\"}}},\"children\":[]},{\"slug\":\"counter\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"counter_fg_element_mode\":{\"count_end\":\"99\",\"counter_prefix\":null,\"suffix\":\"%\",\"title\":\"Satisfaction Rate\",\"alignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"}}},\"styles\":{\"counter_fg_number_style\":{\"number_color\":\"rgba(255 ,  255,  255, 1)\",\"number_typo\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":60,\"tablet\":50,\"phone\":40},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"number_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"counter_fg_title_style\":{\"title_color\":\"rgba(255 ,  255,  255, 1)\",\"title_typo\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":18,\"tablet\":16,\"phone\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"title_padding\":{\"desktop\":{\"top\":15},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":50},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":700,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-counter-131580\"}}},\"children\":[]},{\"slug\":\"counter\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"counter_fg_element_mode\":{\"count_end\":\"850\",\"counter_prefix\":null,\"suffix\":\"+\",\"title\":\"Our Happy Clients\",\"alignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"}}},\"styles\":{\"counter_fg_number_style\":{\"number_color\":\"rgba(255 ,  255,  255, 1)\",\"number_typo\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":60,\"tablet\":50,\"phone\":40},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"number_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"counter_fg_title_style\":{\"title_color\":\"rgba(255 ,  255,  255, 1)\",\"title_typo\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":18,\"tablet\":16,\"phone\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"title_padding\":{\"desktop\":{\"top\":15},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":50},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":900,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-counter-331581\"}}},\"children\":[]},{\"slug\":\"counter\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"counter_fg_element_mode\":{\"count_end\":\"50\",\"counter_prefix\":null,\"suffix\":\"+\",\"title\":\"High Experienced Consultant\",\"alignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"}}},\"styles\":{\"counter_fg_number_style\":{\"number_color\":\"rgba(255 ,  255,  255, 1)\",\"number_typo\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":60,\"tablet\":50,\"phone\":40},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"number_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"counter_fg_title_style\":{\"title_color\":\"rgba(255 ,  255,  255, 1)\",\"title_typo\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":18,\"tablet\":16,\"phone\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"title_padding\":{\"desktop\":{\"top\":15},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":1100,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-counter-151582\"}}},\"children\":[]}]}]}]},{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":100,\"bottom\":\"\"},\"phone\":{\"top\":80},\"tablet\":{\"top\":80}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\",\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0.85,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_color\":\"rgba(255 ,  255,  255, 1)\",\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"},\"bottom_divider_flip\":true}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-12927\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-90928\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"sm\":false},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":20,\"tablet\":15,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-7929\"}}},\"children\":[]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":60,\"tablet\":70,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-41665\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"Want to invest\",\"subtitle\":\"Our investment process\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"\",\"link\":{\"url\":\"#\"}},\"call_to_action_fg_additional\":{\"title_html_tag\":\"h5\",\"html_subtitle_tag\":\"h2\",\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"},\"element_padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 0.8)\",\"title_spacing\":{\"desktop\":0},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":16,\"tablet\":16,\"phone\":15},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":3},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_color\":\"rgba(10 ,  3,  98, 1)\",\"subtitle_spacing\":{\"desktop\":25,\"tablet\":20,\"phone\":20},\"subtitle_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":50,\"tablet\":45,\"phone\":40},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(128 ,  130,  145, 1)\",\"description_spacing\":{\"desktop\":0},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(55 ,  66,  250, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Nunito\",\"weight\":\"regular\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-9666\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"sm\":false},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":20,\"tablet\":15,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-26931\"}}},\"children\":[]}]},{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-35932\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-42939\"}}},\"children\":[{\"slug\":\"video-pro\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"video_fg_text\":{\"custom_video\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"video_poster\":{\"source\":\"libraries/quix/assets/images/placeholder.png\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"autoplay\":true,\"enable_overlay\":true,\"overlay_img\":{\"source\":\"/financio/video-bg-1.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"play_icon\":true,\"upload_Picon\":{\"source\":\"qxif-play-circle\",\"properties\":{\"size\":{\"value\":100,\"unit\":\"px\"},\"color\":\"rgba(255 ,  255,  255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"alignment\":\"\"}},\"styles\":{\"text_fields_group\":{\"height\":{\"desktop\":600},\"width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"wrapper_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":700,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-video-pro-641673\"}}},\"children\":[]}]}]}]},{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"bottom\":100},\"phone\":{\"top\":40,\"bottom\":60},\"tablet\":{\"bottom\":80}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-32158\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-25159\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"sm\":false},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":15,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-90160\"}}},\"children\":[]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":70,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-939612\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"Pricing\",\"subtitle\":\"Our easy pricing plan\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"\",\"link\":{\"url\":\"#\"}},\"call_to_action_fg_additional\":{\"title_html_tag\":\"h5\",\"html_subtitle_tag\":\"h2\",\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"},\"element_padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 0.8)\",\"title_spacing\":{\"desktop\":0},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":16,\"tablet\":16,\"phone\":15},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":3},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_color\":\"rgba(10 ,  3,  98, 1)\",\"subtitle_spacing\":{\"desktop\":25,\"tablet\":20,\"phone\":20},\"subtitle_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":50,\"tablet\":45,\"phone\":40},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(128 ,  130,  145, 1)\",\"description_spacing\":{\"desktop\":0},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(55 ,  66,  250, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Nunito\",\"weight\":\"regular\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-49613\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"sm\":false},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":15,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-15162\"}}},\"children\":[]}]},{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-94163\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":33.33333,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-54166\"}}},\"children\":[{\"slug\":\"pricing-table\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"features\":[{\"title\":\"Accounting & Auditing\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Tax Calculation & Evaluation\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Market Analysis\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Raw Data Analysis & Planing\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Future Market Planing\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Dedicated Support\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}}],\"pricing_header\":{\"header_title\":\"Starter\",\"price\":\"399\",\"image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"pricing_footer\":{\"button\":\"Get Started\",\"link\":{\"url\":\"#\"}},\"pricing_badge\":{\"enable_badge\":false,\"pricing_badge_title\":\"Recommended\",\"badge_alignment\":\"left\",\"tooltip_alignment\":\"right\"}},\"styles\":{\"pricing_style\":{\"content_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"},\"content_padding\":{\"desktop\":{\"top\":20,\"bottom\":50,\"left\":50,\"right\":50},\"phone\":{\"top\":10,\"left\":30,\"right\":30},\"tablet\":{\"top\":15,\"left\":20,\"right\":20}}},\"header_style\":{\"header_padding\":{\"desktop\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"header_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"header_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_spacing\":{\"tablet\":0},\"title_padding\":{\"desktop\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":20,\"tablet\":16,\"phone\":18},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"pricing_price_style\":{\"price_color\":\"rgba(19 ,  15,  64, 1)\",\"price_spacing\":{\"desktop\":30,\"tablet\":25},\"price_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"tablet\":45,\"phone\":45},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"old_price_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"currency_fs\":{\"tablet\":20,\"phone\":20},\"duration_color\":\"rgba(19 ,  15,  64, 0.9)\",\"duration_fs\":{\"tablet\":16,\"phone\":16}},\"pricing_image_style\":{\"image_spacing\":{\"desktop\":30,\"tablet\":30,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"},\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_features_style\":{\"feature_spacing\":{\"desktop\":7},\"feature_item_padding\":{\"desktop\":{\"top\":5,\"bottom\":20,\"left\":0,\"right\":0},\"phone\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0},\"tablet\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0}},\"feature_icon_space\":{\"desktop\":10},\"features_color\":\"rgba(98 ,  100,  116, 1)\",\"features_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16,\"tablet\":15},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"features_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_badge_style\":{\"badge_padding\":{\"desktop\":{\"top\":12,\"bottom\":12,\"left\":50,\"right\":50},\"phone\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":35,\"right\":35}},\"badge_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"badge_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"badge_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"badge_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_button_style\":{\"button_text_color\":\"rgba(245 ,  245,  245, 1)\",\"button_padding\":{\"desktop\":{\"top\":16,\"bottom\":16,\"left\":40,\"right\":40},\"phone\":{\"top\":16,\"bottom\":16},\"tablet\":{\"top\":14,\"bottom\":14}},\"button_margin\":{\"desktop\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"button_font\":{\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(19 ,  15,  64, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":{\"value\":0.3,\"unit\":\"s\"},\"properties\":{\"color\":\"rgba(0 ,  0,  255, 1)\"}}}},\"btn_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":4,\"left\":4,\"bottom\":4,\"right\":4},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":10,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}},\"border_color\":\"rgba(0, 123, 255, 1)\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":1,\"left\":1,\"bottom\":1,\"right\":1},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":600,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-pricing-table-597724\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":33.33333,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-80168\"}}},\"children\":[{\"slug\":\"pricing-table\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"features\":[{\"title\":\"Accounting & Auditing\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Tax Calculation & Evaluation\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Market Analysis\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Raw Data Analysis & Planing\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Future Market Planing\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Dedicated Support\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}}],\"pricing_header\":{\"header_title\":\"Premium\",\"price\":\"699\",\"image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"pricing_footer\":{\"button\":\"Get Started\",\"link\":{\"url\":\"#\"}},\"pricing_badge\":{\"enable_badge\":false,\"pricing_badge_title\":\"Recommended\",\"badge_alignment\":\"left\",\"tooltip_alignment\":\"right\"}},\"styles\":{\"pricing_style\":{\"content_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"},\"content_padding\":{\"desktop\":{\"top\":20,\"bottom\":50,\"left\":50,\"right\":50},\"phone\":{\"top\":12,\"left\":30,\"right\":30},\"tablet\":{\"top\":15,\"left\":20,\"right\":20}}},\"header_style\":{\"header_padding\":{\"desktop\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"header_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"header_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_spacing\":{\"tablet\":0,\"phone\":0},\"title_padding\":{\"desktop\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":20,\"tablet\":16,\"phone\":18},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"pricing_price_style\":{\"price_color\":\"rgba(0 ,  0,  255, 1)\",\"price_spacing\":{\"desktop\":30,\"tablet\":25},\"price_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"tablet\":45,\"phone\":45},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"old_price_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"currency_fs\":{\"tablet\":20,\"phone\":20},\"duration_color\":\"rgba(19 ,  15,  64, 0.9)\",\"duration_fs\":{\"tablet\":16,\"phone\":16}},\"pricing_image_style\":{\"image_spacing\":{\"desktop\":30,\"tablet\":30,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"},\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_features_style\":{\"feature_spacing\":{\"desktop\":7},\"feature_item_padding\":{\"desktop\":{\"top\":5,\"bottom\":20,\"left\":0,\"right\":0},\"phone\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0},\"tablet\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0}},\"feature_icon_space\":{\"desktop\":10},\"features_color\":\"rgba(98 ,  100,  116, 1)\",\"features_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16,\"tablet\":15},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"features_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_badge_style\":{\"badge_padding\":{\"desktop\":{\"top\":12,\"bottom\":12,\"left\":50,\"right\":50},\"phone\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":35,\"right\":35}},\"badge_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"badge_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"badge_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"badge_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_button_style\":{\"button_text_color\":\"rgba(245 ,  245,  245, 1)\",\"button_padding\":{\"desktop\":{\"top\":16,\"bottom\":16,\"left\":40,\"right\":40},\"phone\":{\"top\":16,\"bottom\":16},\"tablet\":{\"top\":14,\"bottom\":12}},\"button_margin\":{\"desktop\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"button_font\":{\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(0 ,  0,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":{\"value\":0.3,\"unit\":\"s\"},\"properties\":{\"color\":\"rgba(10 ,  3,  98, 1)\"}}}},\"btn_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":4,\"left\":4,\"bottom\":4,\"right\":4},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"rgba(0, 123, 255, 1)\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":1,\"left\":1,\"bottom\":1,\"right\":1},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":800,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-pricing-table-613952\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":33.33333,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-29170\"}}},\"children\":[{\"slug\":\"pricing-table\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"features\":[{\"title\":\"Accounting & Auditing\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Tax Calculation & Evaluation\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Market Analysis\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Raw Data Analysis & Planing\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Future Market Planing\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Dedicated Support\",\"tooltip\":\"\",\"icon\":{\"source\":\"qxif-check\",\"properties\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(46 ,  204,  113, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}}],\"pricing_header\":{\"header_title\":\"Extra Pro\",\"price\":\"999\",\"image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"pricing_footer\":{\"button\":\"Get Started\",\"link\":{\"url\":\"#\"}},\"pricing_badge\":{\"enable_badge\":false,\"pricing_badge_title\":\"Recommended\",\"badge_alignment\":\"left\",\"tooltip_alignment\":\"right\"}},\"styles\":{\"pricing_style\":{\"content_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"},\"content_padding\":{\"desktop\":{\"top\":20,\"bottom\":50,\"left\":50,\"right\":50},\"phone\":{\"top\":10,\"left\":30,\"right\":30},\"tablet\":{\"top\":15,\"left\":20,\"right\":20}}},\"header_style\":{\"header_padding\":{\"desktop\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"header_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"header_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 1)\",\"title_spacing\":{\"tablet\":0},\"title_padding\":{\"desktop\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":20,\"tablet\":16,\"phone\":18},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"pricing_price_style\":{\"price_color\":\"rgba(19 ,  15,  64, 1)\",\"price_spacing\":{\"desktop\":30,\"tablet\":25},\"price_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"tablet\":45,\"phone\":45},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"old_price_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"currency_fs\":{\"tablet\":20,\"phone\":20},\"duration_color\":\"rgba(19 ,  15,  64, 0.9)\",\"duration_fs\":{\"tablet\":16,\"phone\":16}},\"pricing_image_style\":{\"image_spacing\":{\"desktop\":30,\"tablet\":30,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"},\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_features_style\":{\"feature_spacing\":{\"desktop\":7},\"feature_item_padding\":{\"desktop\":{\"top\":5,\"bottom\":20,\"left\":0,\"right\":0},\"phone\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0},\"tablet\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0}},\"feature_icon_space\":{\"desktop\":10},\"features_color\":\"rgba(98 ,  100,  116, 1)\",\"features_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16,\"tablet\":15},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"features_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_badge_style\":{\"badge_padding\":{\"desktop\":{\"top\":12,\"bottom\":12,\"left\":50,\"right\":50},\"phone\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":35,\"right\":35}},\"badge_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"badge_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"badge_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"badge_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_button_style\":{\"button_text_color\":\"rgba(245 ,  245,  245, 1)\",\"button_padding\":{\"desktop\":{\"top\":16,\"bottom\":16,\"left\":40,\"right\":40},\"phone\":{\"top\":16,\"bottom\":16},\"tablet\":{\"top\":14,\"bottom\":14}},\"button_margin\":{\"desktop\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"button_font\":{\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(19 ,  15,  64, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":{\"value\":0.3,\"unit\":\"s\"},\"properties\":{\"color\":\"rgba(0 ,  0,  255, 1)\"}}}},\"btn_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":4,\"left\":4,\"bottom\":4,\"right\":4},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"rgba(0, 123, 255, 1)\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":1,\"left\":1,\"bottom\":1,\"right\":1},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.08)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":1000,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-pricing-table-974822\"}}},\"children\":[]}]}]}]},{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_type\":\"fluid\",\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":60,\"bottom\":0},\"tablet\":{\"top\":0,\"bottom\":0}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(245 ,  245,  245, 1)\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-408752\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"qx-row-align-center\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-308763\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":12,\"left\":16,\"bottom\":10,\"right\":10},\"tablet\":{\"top\":12,\"left\":5,\"bottom\":8},\"phone\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"unit\":\"%\"},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-538764\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"Testimonial\",\"subtitle\":\"Our clients valuable commments\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"\",\"link\":{\"url\":\"#\"}},\"call_to_action_fg_additional\":{\"title_html_tag\":\"h5\",\"html_subtitle_tag\":\"h2\",\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"left\"},\"element_padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 0.8)\",\"title_spacing\":{\"desktop\":0},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":16,\"tablet\":16,\"phone\":15},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":3},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_color\":\"rgba(10 ,  3,  98, 1)\",\"subtitle_spacing\":{\"desktop\":25,\"tablet\":20,\"phone\":20},\"subtitle_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":50,\"tablet\":45,\"phone\":40},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(128 ,  130,  145, 1)\",\"description_spacing\":{\"desktop\":0},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"blur\":{\"value\":10,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}}}},\"call_to_action_button_style\":{\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(55 ,  66,  250, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Nunito\",\"weight\":\"regular\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":55},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-651763\"}}},\"children\":[]},{\"slug\":\"testimonial-carousel\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"testimonial-carousel_fg_repeater\":[{\"tname\":\"Adam Smith\",\"content\":\"\\\"My project was a simple & small task, but the persistence and determination turned it into an awesome and great project which make me happy because they help me accelerate my business!\\\"\",\"position\":\"Manager\",\"rating\":false,\"set_rating\":3,\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"tname\":\"John Doe\",\"content\":\"\\\"My project was a simple & small task, but the persistence and determination turned it into an awesome and great project which make me happy because they help me accelerate my business!\\\"\",\"position\":\"Managing Director\",\"rating\":false,\"set_rating\":3,\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"tname\":\"Shane Kyle\",\"content\":\"\\\"My project was a simple & small task, but the persistence and determination turned it into an awesome and great project which make me happy because they help me accelerate my business!\\\"\",\"position\":\"Manager\",\"rating\":false,\"set_rating\":3,\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}}],\"testimonial-carousel_fg_layouts\":{\"layout_grid\":{\"desktop\":null}},\"testimonial-carousel_fg_navigation\":{\"show_arrow_navigation\":false},\"testimonial-carousel_fg_behaviour\":{\"faqpage\":false,\"pause_on_hover\":true,\"auto_play\":true,\"autoplay_speed\":5000,\"infinite_loop\":false}},\"styles\":{\"testimonial-carousel_fg_testimonial\":{\"content_alignment\":{\"desktop\":\"left\"},\"item_gutter\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"testi_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"testi_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"testi_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"slider_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"testimonial-carousel_fg_image\":{\"width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"},\"image_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":15,\"responsive_preview\":true,\"unit\":\"px\"},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"testimonial-carousel_fg_quote\":{\"quote_color\":\"rgba(0 ,  0,  255, 1)\",\"quote_size\":{\"desktop\":35,\"tablet\":35,\"phone\":35,\"responsive_preview\":true,\"unit\":\"px\"},\"quote_gap\":{\"desktop\":15,\"tablet\":15,\"phone\":15,\"responsive_preview\":true,\"unit\":\"px\"}},\"testimonial-carousel_fg_name\":{\"name_spacing\":{\"desktop\":10,\"tablet\":0,\"phone\":0},\"name_color\":\"rgba(0 ,  0,  255, 1)\",\"name_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"testimonial-carousel_fg_position\":{\"position_spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"position_color\":\"rgba(19 ,  15,  64, 1)\",\"position_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"testimonial-carousel_fg_content\":{\"content_color\":\"rgba(10 ,  3,  98, 1)\",\"content_spacing\":{\"desktop\":30,\"tablet\":30,\"phone\":30},\"content_font\":{\"family\":\"Playfair Display\",\"weight\":\"600\",\"size\":{\"desktop\":25,\"phone\":20},\"transform\":\"capitalize\",\"style\":\"italic\",\"spacing\":{\"desktop\":1},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"testimonial-carousel_fg_navigation_style\":{\"arrow_size\":{\"desktop\":25,\"tablet\":25,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"},\"arrow_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"arrow_bd\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"arrow_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":15,\"right\":15},\"phone\":{\"top\":15,\"bottom\":15,\"left\":15,\"right\":15},\"tablet\":{\"top\":15,\"bottom\":15,\"left\":15,\"right\":15}},\"dot_width\":{\"desktop\":15,\"tablet\":15,\"phone\":15,\"responsive_preview\":true,\"unit\":\"px\"},\"dot_spacing\":{\"desktop\":12,\"tablet\":12,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"dot_margin\":{\"desktop\":25,\"tablet\":25,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"bottom\":50}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":700,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-testimonial-carousel-671809\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"%\"},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":200,\"bottom\":200},\"phone\":{\"top\":200,\"bottom\":200}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"src\":{\"source\":\"/financio/case-1.jpg\",\"type\":\"image\",\"properties\":[]},\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-681759\"}}},\"children\":[]}]}]},{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":100,\"bottom\":90,\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":60,\"bottom\":60},\"tablet\":{\"top\":80,\"bottom\":80}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(19 ,  15,  64, 1)\",\"src\":{\"source\":\"/financio/banner-2.jpg\",\"type\":\"image\",\"properties\":[]},\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0.85,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-93982\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"qx-row-align-center\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-163983\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":70,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"zindex\":9},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-883984\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"Need any financial service?\",\"subtitle\":\"We are high experienced financial service provider. Feel Free to contact us\",\"description\":\"\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"\",\"link\":{\"url\":\"#\"}},\"call_to_action_fg_additional\":{\"title_html_tag\":\"h5\",\"html_subtitle_tag\":\"h2\",\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"left\"},\"element_padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(255 ,  255,  255, 1)\",\"title_spacing\":{\"desktop\":0,\"phone\":20},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":16,\"tablet\":16,\"phone\":15},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":3},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_color\":\"rgba(255 ,  255,  255, 1)\",\"subtitle_spacing\":{\"desktop\":0,\"phone\":0},\"subtitle_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":50,\"tablet\":45,\"phone\":40},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2,\"tablet\":1.2,\"phone\":1.3},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(255 ,  255,  255, 0.8)\",\"description_spacing\":{\"desktop\":0},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(55 ,  66,  250, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Nunito\",\"weight\":\"regular\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-473985\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":30,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"%\"},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-373986\"}}},\"children\":[{\"slug\":\"button\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"button_fields_group\":{\"text\":\"Contact With Us\",\"icon\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"button_link_fields_group\":{\"link\":{\"url\":\"index.php/contact\"}}},\"styles\":{\"button_spacing_fields_group\":{\"nalignment\":{\"desktop\":\"right\",\"tablet\":\"center\",\"phone\":\"center\"},\"btn_padding\":{\"desktop\":{\"top\":18,\"left\":30,\"bottom\":18,\"right\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":16,\"bottom\":16}},\"icon_spacing\":{\"desktop\":30,\"tablet\":30,\"phone\":20}},\"button_typo_fields_group\":{\"font\":{\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"button_bg_fields_group\":{\"btn_background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":{\"value\":0.3,\"unit\":\"s\"},\"properties\":{\"color\":\"rgba(10 ,  3,  98, 1)\"}}}}},\"button_color_fields_group\":{\"text_color\":\"rgba(0 ,  0,  255, 1)\",\"hover_text_color\":\"rgba(255 ,  255,  255, 1)\"},\"button_border_group\":{\"btn_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":20}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":700,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-button-393987\"}}},\"children\":[]}]}]}]},{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":100,\"bottom\":100},\"phone\":{\"top\":60,\"bottom\":60},\"tablet\":{\"top\":80,\"bottom\":80}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-47820\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"position\":\"top left\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0.85,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-91821\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"sm\":false},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":20,\"tablet\":15,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0.9,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-59822\"}}},\"children\":[]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":60,\"tablet\":70,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0.9,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\",\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-983940\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"Our Team\",\"subtitle\":\"Our dedicated team members\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"\",\"link\":{\"url\":\"#\"}},\"call_to_action_fg_additional\":{\"title_html_tag\":\"h5\",\"html_subtitle_tag\":\"h2\",\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"},\"element_padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(10 ,  3,  98, 0.8)\",\"title_spacing\":{\"desktop\":0},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":16,\"tablet\":16,\"phone\":15},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":3},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_color\":\"rgba(10 ,  3,  98, 1)\",\"subtitle_spacing\":{\"desktop\":25,\"tablet\":20,\"phone\":20},\"subtitle_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":50,\"tablet\":45,\"phone\":40},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(128 ,  130,  145, 1)\",\"description_spacing\":{\"desktop\":0},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(55 ,  66,  250, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Nunito\",\"weight\":\"regular\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-53941\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"sm\":false},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":20,\"tablet\":15,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-60825\"}}},\"children\":[]}]},{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"zindex\":9},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-37826\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-72827\"}}},\"children\":[{\"slug\":\"person\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"person_fg_image\":{\"image\":{\"source\":\"/financio/team-1.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"person_fg_details\":{\"pname\":\"Adam Smith\",\"position\":\"Accountant\",\"person_image_alignment\":\"\",\"person_content_v_align\":\"\"}},\"styles\":{\"person_fg_panel\":{\"content_alignment\":{\"desktop\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":10,\"bottom\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"person_fg_image_style\":{\"image_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"img_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"img_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"img_background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"person_fg_name_style\":{\"name_spacing\":{\"desktop\":12},\"name_color\":\"rgba(255 ,  255,  255, 1)\",\"name_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_position_style\":{\"position_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"position_color\":\"rgba(255 ,  255,  255, 0.8)\",\"position_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_description_style\":{\"description_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"bottom\":20},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(10 ,  3,  98, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":600,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-person-95828\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-843454\"}}},\"children\":[{\"slug\":\"person\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"person_fg_image\":{\"image\":{\"source\":\"/financio/team-2.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"person_fg_details\":{\"position\":\"Auditor\",\"person_image_alignment\":\"\",\"person_content_v_align\":\"\"}},\"styles\":{\"person_fg_panel\":{\"content_alignment\":{\"desktop\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":10,\"bottom\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"person_fg_image_style\":{\"image_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"img_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"img_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"img_background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"person_fg_name_style\":{\"name_spacing\":{\"desktop\":12},\"name_color\":\"rgba(255 ,  255,  255, 1)\",\"name_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_position_style\":{\"position_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"position_color\":\"rgba(255 ,  255,  255, 0.8)\",\"position_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_description_style\":{\"description_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"bottom\":20},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(10 ,  3,  98, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":800,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-person-643455\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-16829\"}}},\"children\":[{\"slug\":\"person\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"person_fg_image\":{\"image\":{\"source\":\"/financio/team-3.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"person_fg_details\":{\"pname\":\"Shane Kyle\",\"position\":\"Manager\",\"person_image_alignment\":\"\",\"person_content_v_align\":\"\"}},\"styles\":{\"person_fg_panel\":{\"content_alignment\":{\"desktop\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":10,\"bottom\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"person_fg_image_style\":{\"image_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"img_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"img_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"img_background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"person_fg_name_style\":{\"name_spacing\":{\"desktop\":12},\"name_color\":\"rgba(255 ,  255,  255, 1)\",\"name_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_position_style\":{\"position_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"position_color\":\"rgba(255 ,  255,  255, 0.8)\",\"position_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_description_style\":{\"description_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"bottom\":20},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(10 ,  3,  98, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":1000,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-person-773458\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-17831\"}}},\"children\":[{\"slug\":\"person\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"person_fg_image\":{\"image\":{\"source\":\"/financio/team-4.jpg\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"person_fg_details\":{\"pname\":\"Jhon Doe\",\"position\":\"Accountant\",\"person_image_alignment\":\"\",\"person_content_v_align\":\"\"}},\"styles\":{\"person_fg_panel\":{\"content_alignment\":{\"desktop\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":10,\"bottom\":0},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"person_fg_image_style\":{\"image_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"img_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"img_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"img_background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"person_fg_name_style\":{\"name_spacing\":{\"desktop\":12},\"name_color\":\"rgba(255 ,  255,  255, 1)\",\"name_font\":{\"family\":\"Playfair Display\",\"weight\":\"700\",\"size\":{\"desktop\":22},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_position_style\":{\"position_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"position_color\":\"rgba(255 ,  255,  255, 0.8)\",\"position_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_description_style\":{\"description_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"bottom\":20},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(10 ,  3,  98, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(10 ,  3,  98, 0.15)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":40,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":20,\"unit\":\"px\"}},\"transition\":{\"value\":0.3,\"unit\":\"s\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":1200,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-person-63459\"}}},\"children\":[]}]}]}]},{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":0},\"phone\":{\"top\":20,\"bottom\":20,\"left\":0,\"right\":0},\"tablet\":{\"top\":80,\"bottom\":80}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-57437\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-197440\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-207441\"}}},\"children\":[{\"slug\":\"media-carousel\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"media-carousel-fg_element\":[{\"title\":\"Title 1\",\"image\":{\"source\":\"/financio/client_01.png\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"alt_text\":\"\",\"caption\":\"This is a caption\",\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},{\"title\":\"Title 2\",\"image\":{\"source\":\"/financio/client_02.png\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"alt_text\":\"\",\"caption\":\"This is a caption\",\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},{\"title\":\"Title 3\",\"image\":{\"source\":\"/financio/client_03.png\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"alt_text\":\"\",\"caption\":\"This is a caption\",\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},{\"title\":\"Title 4\",\"image\":{\"source\":\"/financio/client_05.png\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"alt_text\":\"\",\"caption\":\"This is a caption\",\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},{\"title\":\"Title 5\",\"image\":{\"source\":\"/financio/client_06.png\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"alt_text\":\"\",\"caption\":\"This is a caption\",\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},{\"title\":\"Title 6\",\"image\":{\"source\":\"/financio/client_02.png\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"alt_text\":\"\",\"caption\":\"This is a caption\",\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}],\"media-carousel-fg_options\":{\"column\":5},\"media-carousel-navigation_style\":{\"show_arrow_navigation\":false,\"show_dot_navigation\":false},\"height-fg_behaviour\":{\"pause_on_hover\":true,\"auto_play\":true,\"autoplay_speed\":5000,\"infinite_loop\":false,\"set\":false}},\"styles\":{\"image_alignment_style\":{\"img_alignment\":{\"tablet\":\"\"},\"img_width\":{\"desktop\":150},\"img_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"media-img_mood_style\":{\"image_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}},\"media-carousel-fg_style\":{\"overlay_color\":\"rgba(0, 0, 0, 0.4)\"},\"content_fg_style\":{\"content_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"},\"content_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"content_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"content_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"image-title-fg_style\":{\"title_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"image-caption-fg_style\":{\"caption_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"navigation-fg_style\":{\"arrow_size\":{\"desktop\":25,\"tablet\":25,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"},\"dot_width\":{\"desktop\":15,\"tablet\":15,\"phone\":15,\"responsive_preview\":true,\"unit\":\"px\"},\"dot_spacing\":{\"desktop\":12,\"tablet\":12,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"dot_margin\":{\"desktop\":25,\"tablet\":25,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"}},\"media_carousel_fg_bar-style\":{\"bar_width\":{\"desktop\":25,\"tablet\":25,\"phone\":25,\"responsive_preview\":true,\"unit\":\"px\"},\"barActive_width\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"bar_height\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"barActive_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-bottom-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-media-carousel-627445\"}}},\"children\":[]}]}]}]},{\"slug\":\"section\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0},\"v_align\":\"\",\"html_tag\":\"div\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":100,\"bottom\":100,\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":60,\"bottom\":60},\"tablet\":{\"top\":80,\"bottom\":80}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\",\"src\":{\"source\":\"/financio/banner-3.jpg\",\"type\":\"image\",\"properties\":[]},\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"label\":\"Section\",\"id\":\"qx-section-289142\"}}},\"children\":[{\"slug\":\"row\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"qx-row-align-center\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"label\":\"Row\",\"id\":\"qx-row-589143\"}}},\"children\":[{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":40,\"tablet\":40,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"zindex\":9},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"src\":{\"source\":null,\"type\":\"unknown\",\"properties\":[]},\"size\":\"contain\",\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-539144\"}}},\"children\":[{\"slug\":\"call-to-action\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"call_to_action_fg_element_mode\":{\"element_mode\":\"classic\",\"image_position\":\"\",\"image\":{\"source\":null,\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_content\":{\"title\":\"get a quote\",\"subtitle\":\"Free Consultation\",\"description\":\"<p>Feel free to send us an email. We are ready for any kinds of help. Please, send us now.</p>\",\"graphics_image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"call_to_action_fg_button\":{\"button\":\"\",\"link\":{\"url\":\"#\"}},\"call_to_action_fg_additional\":{\"title_html_tag\":\"h5\",\"html_subtitle_tag\":\"h2\",\"cta_vertical_position\":\"\"}},\"styles\":{\"call_to_action_fg_element_style\":{\"element_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"element_alignment\":{\"desktop\":\"left\",\"tablet\":\"left\"},\"element_padding\":{\"desktop\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"}}},\"call_to_action_image_style\":{\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_min_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"image_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"}},\"call_to_action_title_style\":{\"title_color\":\"rgba(255 ,  255,  255, 1)\",\"title_spacing\":{\"desktop\":0},\"title_font\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"desktop\":16,\"tablet\":16,\"phone\":15},\"transform\":\"uppercase\",\"spacing\":{\"desktop\":3},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_subtitle_style\":{\"subtitle_color\":\"rgba(255 ,  255,  255, 1)\",\"subtitle_spacing\":{\"desktop\":25,\"tablet\":20,\"phone\":20},\"subtitle_font\":{\"family\":\"Playfair Display\",\"weight\":\"800\",\"size\":{\"desktop\":50,\"tablet\":45,\"phone\":40},\"transform\":\"capitalize\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.2},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_description_style\":{\"description_color\":\"rgba(255 ,  255,  255, 0.8)\",\"description_spacing\":{\"desktop\":0},\"description_font\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.8},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"call_to_action_button_style\":{\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(55 ,  66,  250, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}},\"button_border_new\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_font\":{\"family\":\"Nunito\",\"weight\":\"regular\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}}},\"call_to_action_background_style\":{\"background_overlay_color\":\"\",\"background_overlay_hover_color\":\"\",\"bg_blend_mode\":\"overlay\",\"bg_blend_mode_hover\":\"overlay\"},\"call_to_action_graphics_style\":{\"graphics_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"graphics_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"graphics_border_radius\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255, 255, 255, 0)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-left-medium\",\"animation_delay\":{\"value\":500,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-call-to-action-225122\"}}},\"children\":[]}]},{\"slug\":\"column\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":60,\"tablet\":60,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":false}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"%\"},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"required_parallax\":true}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation_delay\":{\"value\":0,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-789146\"}}},\"children\":[{\"slug\":\"form\",\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"form\":{\"general\":{\"form_fields\":[{\"title\":\"name\",\"item_label\":\"Name\",\"type\":\"text\",\"placeholder\":\"Your Name\",\"required\":true,\"column_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"row\":4,\"height\":{\"value\":150,\"unit\":\"px\"},\"options\":\"\",\"inline\":false,\"multiple\":false,\"acceptance\":\"\",\"acceptance_checked\":false,\"number_min\":\"\",\"number_max\":\"\",\"date_min\":\"\",\"date_max\":\"\",\"date_html5\":false,\"upload_maxsize\":\"\",\"upload_allowedtypes\":\"\",\"upload_max_file\":\"\",\"html\":\"\",\"hidden_value\":\"\",\"shortcode\":\"\",\"desc\":\"\"},{\"title\":\"email\",\"item_label\":\"Email\",\"type\":\"email\",\"placeholder\":\"Your Email\",\"required\":true,\"column_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"row\":4,\"height\":{\"value\":150,\"unit\":\"px\"},\"options\":\"\",\"inline\":false,\"multiple\":false,\"acceptance\":\"\",\"acceptance_checked\":false,\"number_min\":\"\",\"number_max\":\"\",\"date_min\":\"\",\"date_max\":\"\",\"date_html5\":false,\"upload_maxsize\":\"\",\"upload_allowedtypes\":\"\",\"upload_max_file\":\"\",\"html\":\"\",\"hidden_value\":\"\",\"shortcode\":\"\",\"desc\":\"\"},{\"title\":\"subject\",\"item_label\":\"Name\",\"type\":\"text\",\"placeholder\":\"Subject\",\"required\":true,\"column_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"row\":4,\"height\":{\"value\":150,\"unit\":\"px\"},\"options\":\"\",\"inline\":false,\"multiple\":false,\"acceptance\":\"\",\"acceptance_checked\":false,\"number_min\":\"\",\"number_max\":\"\",\"date_min\":\"\",\"date_max\":\"\",\"date_html5\":false,\"upload_maxsize\":\"\",\"upload_allowedtypes\":\"\",\"upload_max_file\":\"\",\"html\":\"\",\"hidden_value\":\"\",\"shortcode\":\"\",\"desc\":\"\"},{\"title\":\"message\",\"item_label\":\"Message\",\"type\":\"textarea\",\"placeholder\":\"Write Your Message\",\"required\":false,\"column_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"row\":4,\"height\":{\"value\":150,\"unit\":\"px\"},\"options\":\"\",\"inline\":false,\"multiple\":false,\"acceptance\":\"\",\"acceptance_checked\":false,\"number_min\":\"\",\"number_max\":\"\",\"date_min\":\"\",\"date_max\":\"\",\"date_html5\":false,\"upload_maxsize\":\"\",\"upload_allowedtypes\":\"\",\"upload_max_file\":\"\",\"html\":\"\",\"hidden_value\":\"\",\"shortcode\":\"\",\"desc\":\"\"}],\"form_basic\":{\"label\":false},\"form_action_after_submit\":{\"actions\":[\"email\"]},\"form_email\":{\"email_meta\":[\"date\",\"time\",\"page_url\",\"credit\"]},\"form_email2\":{\"email2_meta\":[\"date\",\"time\",\"page_url\",\"credit\"]},\"form_submit\":{\"submit_text\":\"Submit Now\",\"submit_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"},\"icon\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"unknown\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}}},\"styles\":{\"form_body\":{\"rows_gap\":{\"desktop\":18}},\"form_field_level\":{\"label_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"label_color\":\"rgba(19 ,  15,  64, 1)\",\"label_typography\":{\"family\":\"Barlow\",\"weight\":\"600\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"form_field\":{\"field_color\":\"rgba(255 ,  255,  255, 1)\",\"field_typography\":{\"family\":\"Montserrat\",\"weight\":\"regular\",\"size\":{\"desktop\":15},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"field_bgcolor\":\"rgba(255, 255, 255, 0)\",\"field_bordercolor\":\"rgba(255 ,  255,  255, 0.3)\",\"field_borderwidth\":{\"desktop\":1,\"tablet\":1,\"phone\":1,\"responsive_preview\":true,\"unit\":\"px\"},\"field_padding\":{\"desktop\":{\"top\":18,\"left\":20,\"bottom\":18},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"form_button\":{\"submit_column\":{\"desktop\":40},\"button_color\":\"rgba(0 ,  0,  255, 1)\",\"button_hover_color\":\"rgba(255 ,  255,  255, 0.8)\",\"button_typography\":{\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_bg\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(255 ,  255,  255, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":{\"value\":0.3,\"unit\":\"s\"},\"properties\":{\"color\":\"rgba(0 ,  0,  255, 0.8)\"}}}},\"button_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":0,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"button_padding\":{\"desktop\":{\"top\":18,\"bottom\":18},\"phone\":{\"top\":15,\"bottom\":15,\"left\":15,\"right\":15},\"tablet\":{\"top\":15,\"bottom\":15,\"left\":15,\"right\":15}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"left\":50},\"tablet\":{\"left\":20},\"phone\":{\"left\":0}},\"padding\":{\"desktop\":{\"top\":50,\"left\":50,\"bottom\":40,\"right\":50},\"tablet\":{\"left\":20,\"bottom\":30,\"right\":20},\"phone\":{\"left\":20,\"bottom\":30,\"right\":20}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color\":\"rgba(8 ,  2,  77, 1)\"}},\"hover\":{\"opacity\":0,\"transition\":0.3,\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(19 ,  15,  64, 0.1)\",\"spread\":{\"value\":0,\"unit\":\"px\"},\"blur\":{\"value\":30,\"unit\":\"px\"},\"horizontal\":{\"value\":0,\"unit\":\"px\"},\"vertical\":{\"value\":0,\"unit\":\"px\"}}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"qx-animation-slide-right-medium\",\"animation_delay\":{\"value\":600,\"unit\":\"ms\"}},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-form-15123\",\"class\":\"contact-form\"}}},\"children\":[]}]}]}]}]}', '', '', '1', '-2', '1', '2022-05-17 09:55:00', '49', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '', '1', '0', '');/**ABDB**/
