<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');
$item = $this->item;
$params = $this->params;
?>

<div id="archive-items">
	<?php foreach ($this->items as $i => $item) : ?>
		<?php $info = $item->params->get('info_block_position', 0); ?>
		<article class="article<?php echo $i % 2; ?> qx-article" itemscope itemtype="https://schema.org/Article">
			<meta property="name" content="<?php echo $this->escape($item->title) ?>">
			<meta property="author" typeof="Person" content="<?php echo $this->escape($item->author) ?>">
			<meta property="dateModified" content="<?php echo $this->escape($item->modified, 'c') ?>">
			<meta property="datePublished" content="<?php echo $this->escape($item->publish_up, 'c') ?>">	
			<meta class="qx-margin-remove-adjacent" property="articleSection" content="<?php echo $this->escape($item->category_title) ?>">				
			<h2 class="qx-article-title" itemprop="headline">
				<?php if ($params->get('link_titles')) : ?>
					<a href="<?php echo JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language)); ?>" itemprop="url">
						<?php echo $this->escape($item->title); ?>
					</a>
				<?php else : ?>
					<?php echo $this->escape($item->title); ?>
				<?php endif; ?>
			</h2>

		<?php // Content is generated by content plugin event "onContentAfterTitle" ?>
		<?php echo $item->event->afterDisplayTitle; ?>
		<p class="qx-article-meta qx-margin-medium">
		<?php if ($params->get('show_author') && !empty($item->author )) : ?>
			<span class="createdby" itemprop="author" itemscope itemtype="https://schema.org/Person">
			<?php $author = $item->created_by_alias ?: $item->author; ?>
			<?php $author = '<span itemprop="name">' . $author . '</span>'; ?>
				<?php if (!empty($item->contact_link) && $params->get('link_author') == true) : ?>
					<?php echo JText::sprintf('COM_CONTENT_WRITTEN_BY', JHtml::_('link', $this->item->contact_link, $author, array('itemprop' => 'url'))); ?>
				<?php else : ?>
					<?php echo JText::sprintf('COM_CONTENT_WRITTEN_BY', $author); ?>
				<?php endif; ?>
			</span>
		<?php endif; ?>
		<?php $useDefList = ($params->get('show_modify_date') || $params->get('show_publish_date') || $params->get('show_create_date')
			|| $params->get('show_hits') || $params->get('show_category') || $params->get('show_parent_category')); ?>
		<?php if ($useDefList && ($info == 0 || $info == 2)) : ?>
			<?php if ($params->get('show_parent_category') && !empty($item->parent_slug)) : ?>
				<span class="parent-category-name">
					<?php $title = $this->escape($item->parent_title); ?>
					<?php if ($params->get('link_parent_category') && !empty($item->parent_slug)) : ?>
						<?php $url = '<a href="' . JRoute::_(ContentHelperRoute::getCategoryRoute($item->parent_slug)) . '" itemprop="genre">' . $title . '</a>'; ?>
						<?php echo JText::sprintf('COM_CONTENT_PARENT', $url); ?>
					<?php else : ?>
						<?php echo JText::sprintf('COM_CONTENT_PARENT', '<span itemprop="genre">' . $title . '</span>'); ?>
					<?php endif; ?>
				</span>
			<?php endif; ?>
			<?php if ($params->get('show_category')) : ?>
				<span class="category-name">
					<?php $title = $this->escape($item->category_title); ?>
					<?php if ($params->get('link_category') && $item->catslug) : ?>
						<?php $url = '<a href="' . JRoute::_(ContentHelperRoute::getCategoryRoute($item->catslug)) . '" itemprop="genre">' . $title . '</a>'; ?>
						<?php echo JText::sprintf('COM_CONTENT_CATEGORY', $url); ?>
					<?php else : ?>
						<?php echo JText::sprintf('COM_CONTENT_CATEGORY', '<span itemprop="genre">' . $title . '</span>'); ?>
					<?php endif; ?>
				</span>
			<?php endif; ?>

			<?php if ($params->get('show_publish_date')) : ?>
				<span class="published">
					<span class="icon-calendar" aria-hidden="true"></span>
					<time datetime="<?php echo JHtml::_('date', $item->publish_up, 'c'); ?>" itemprop="datePublished">
						<?php echo JText::sprintf('COM_CONTENT_PUBLISHED_DATE_ON', JHtml::_('date', $item->publish_up, JText::_('DATE_FORMAT_LC3'))); ?>
					</time>
				</span>
			<?php endif; ?>

				<?php if ($info == 0) : ?>
					<?php if ($params->get('show_modify_date')) : ?>
						<span class="modified">
							<span class="icon-calendar" aria-hidden="true"></span>
							<time datetime="<?php echo JHtml::_('date', $item->modified, 'c'); ?>" itemprop="dateModified">
								<?php echo JText::sprintf('COM_CONTENT_LAST_UPDATED', JHtml::_('date', $item->modified, JText::_('DATE_FORMAT_LC3'))); ?>
							</time>
						</span>
					<?php endif; ?>
					<?php if ($params->get('show_create_date')) : ?>
						<span class="create">
							<span class="icon-calendar" aria-hidden="true"></span>
							<time datetime="<?php echo JHtml::_('date', $item->created, 'c'); ?>" itemprop="dateCreated">
								<?php echo JText::sprintf('COM_CONTENT_CREATED_DATE_ON', JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC3'))); ?>
							</time>
						</span>
					<?php endif; ?>

					<?php if ($params->get('show_hits')) : ?>
						<span class="hits">
							<span class="icon-eye-open"></span>
							<meta itemprop="interactionCount" content="UserPageVisits:<?php echo $item->hits; ?>" />
							<?php echo JText::sprintf('COM_CONTENT_ARTICLE_HITS', $item->hits); ?>
						</span>
					<?php endif; ?>
				<?php endif; ?>
				</dl>
		<?php endif; ?>
		</p>

		<?php // Content is generated by content plugin event "onContentBeforeDisplay" ?>
		<?php echo $item->event->beforeDisplayContent; ?>
		<?php if ($params->get('show_intro')) : ?>
			<div class="intro" itemprop="articleBody"> <?php echo JHtml::_('string.truncateComplex', $item->introtext, $params->get('introtext_limit')); ?> </div>
		<?php endif; ?>

		<?php if ($useDefList && ($info == 1 || $info == 2)) : ?>
			<p class="qx-article-meta qx-margin-medium">

				<?php if ($info == 1) : ?>
					<?php if ($params->get('show_parent_category') && !empty($item->parent_slug)) : ?>
						<span class="parent-category-name">
							<?php $title = $this->escape($item->parent_title); ?>
							<?php if ($params->get('link_parent_category') && $item->parent_slug) : ?>
								<?php $url = '<a href="' . JRoute::_(ContentHelperRoute::getCategoryRoute($item->parent_slug)) . '" itemprop="genre">' . $title . '</a>'; ?>
								<?php echo JText::sprintf('COM_CONTENT_PARENT', $url); ?>
							<?php else : ?>
								<?php echo JText::sprintf('COM_CONTENT_PARENT', '<span itemprop="genre">' . $title . '</span>'); ?>
							<?php endif; ?>
						</span>
					<?php endif; ?>
					<?php if ($params->get('show_category')) : ?>
						<span class="category-name">
							<?php $title = $this->escape($item->category_title); ?>
							<?php if ($params->get('link_category') && $item->catslug) : ?>
								<?php $url = '<a href="' . JRoute::_(ContentHelperRoute::getCategoryRoute($item->catslug)) . '" itemprop="genre">' . $title . '</a>'; ?>
								<?php echo JText::sprintf('COM_CONTENT_CATEGORY', $url); ?>
							<?php else : ?>
								<?php echo JText::sprintf('COM_CONTENT_CATEGORY', '<span itemprop="genre">' . $title . '</span>'); ?>
							<?php endif; ?>
						</span>
					<?php endif; ?>
					<?php if ($params->get('show_publish_date')) : ?>
						<span class="published">
							<span class="icon-calendar" aria-hidden="true"></span>
							<time datetime="<?php echo JHtml::_('date', $item->publish_up, 'c'); ?>" itemprop="datePublished">
								<?php echo JText::sprintf('COM_CONTENT_PUBLISHED_DATE_ON', JHtml::_('date', $item->publish_up, JText::_('DATE_FORMAT_LC3'))); ?>
							</time>
						</span>
					<?php endif; ?>
				<?php endif; ?>

				<?php if ($params->get('show_create_date')) : ?>
					<span class="create">
						<span class="icon-calendar" aria-hidden="true"></span>
						<time datetime="<?php echo JHtml::_('date', $item->created, 'c'); ?>" itemprop="dateCreated">
							<?php echo JText::sprintf('COM_CONTENT_CREATED_DATE_ON', JHtml::_('date', $item->modified, JText::_('DATE_FORMAT_LC3'))); ?>
						</time>
					</span>
				<?php endif; ?>
				<?php if ($params->get('show_modify_date')) : ?>
					<span class="modified">
						<span class="icon-calendar" aria-hidden="true"></span>
						<time datetime="<?php echo JHtml::_('date', $item->modified, 'c'); ?>" itemprop="dateModified">
							<?php echo JText::sprintf('COM_CONTENT_LAST_UPDATED', JHtml::_('date', $item->modified, JText::_('DATE_FORMAT_LC3'))); ?>
						</time>
					</span>
				<?php endif; ?>
				<?php if ($params->get('show_hits')) : ?>
					<span class="hits">
						<span class="icon-eye-open"></span>
						<meta content="UserPageVisits:<?php echo $item->hits; ?>" itemprop="interactionCount" />
						<?php echo JText::sprintf('COM_CONTENT_ARTICLE_HITS', $item->hits); ?>
					</span>
				<?php endif; ?>
			</dl>
		</p>
		<?php endif; ?>
		<?php // Content is generated by content plugin event "onContentAfterDisplay" ?>
		<?php echo $item->event->afterDisplayContent; ?>
	</article>
	<?php endforeach; ?>
</div>
<div class="qx-margin-large qx-margin-remove-bottom">
	<p class="counter qx-align-right"> <?php echo $this->pagination->getPagesCounter(); ?> </p>
	<?php echo $this->pagination->getPagesLinks(); ?>
</div>
