<?php
/**
 * @copyright	Copyright (C) 2005 - 2013 CMSJunkie,  All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
use Joomla\Utilities\ArrayHelper;

jimport( 'joomla.application.component.controlleradmin' );


/**
 * The Contest List Controller
 *
 */
class JClassifiedsManagerControllerAdTypes extends JControllerAdmin
{
	
	
	public function __construct($config = array())
	{
		parent::__construct($config);
        $this->registerTask('saveOrderAjax','saveorder');
        $this->registerTask('unsetDefault',	'setDefault');
    }
	/**
	 * Display the view
	 *
	 * @param	boolean			If true, the view output will be cached
	 * @param	array			An array of safe url parameters and their variable types, for valid values see {@link JFilterInput::clean()}.
	 *
	 * @return	JController		This object to support chaining.

	 */
	public function display($cachable = false, $urlparams = false)
	{
	}

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  object  The model.
	 *
	 */
	public function getModel($name = 'AdTypes', $prefix = 'JClassifiedsManagerModel', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}

	/**
	 * Removes an room
	 */
	public function delete()
	{
		// Check for request forgeries
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN',true));

		// Get items to remove from the request.
		$cid	= JFactory::getApplication()->input->get('cid', array(), '', 'array');

		if (!is_array($cid) || count($cid) < 1) {
			JFactory::getApplication()->enqueueMessage(JText::_('LNG_NO_ADTYPE_SELECTED'), 'warning');
		} else {
			// Get the model.
			$model = $this->getModel();
			
			// Make sure the item ids are integers
			jimport('joomla.utilities.arrayhelper');
			ArrayHelper::toInteger($cid);

			
			// Remove the items.
			if (!$model->delete($cid)) {
				$this->setMessage($model->getError());
			} else {
				$this->setMessage(JText::plural('LNG_ADTYPE_DELETED_SUCCESSFULLY', count($cid)));
			}
		}

		$this->setRedirect('index.php?option=com_jclassifiedsmanager&view=adtypes');
	}
	
	
	function changeState()
	{
		$model = $this->getModel();
		$cid	= JFactory::getApplication()->input->get('cid', array(), '', 'array');
		$cid = $cid[0];
		if ($model->changeState($cid))
		{
			$msg = JText::_( '' ,true);
		} else {
			$msg = JText::_('LNG_ERROR_CHANGE_ADTYPE_STATE',true);
		}
	
		$this->setMessage($msg);
		$this->setRedirect('index.php?option=com_jclassifiedsmanager&view=adtypes');
	}
	

    /**
     * Method to save the submitted ordering values for records via AJAX.
     *
     * @return  void
     *
     * @since   3.0
     */
    public function saveOrderAjax()
    {
        $pks = JFactory::getApplication()->input->get('cid', array(), '', 'array');
        $order = JFactory::getApplication()->input->get('order', array(), '', 'array');


        // Sanitize the input
		jimport('joomla.utilities.arrayhelper');
        ArrayHelper::toInteger($pks);
        ArrayHelper::toInteger($order);

        // Get the model
        $model = $this->getModel("adtypes");

        // Save the ordering
        $return = $model->saveorder($pks, $order);

        if ($return)
        {
            echo "1";
        }

        // Close the application
        JFactory::getApplication()->close();
    }

}
