<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class JClassifiedsManagerControllerCategories extends JControllerLegacy
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	 
	function __construct()
	{
		parent::__construct();
		JFactory::getApplication()->input->set('layout','listing');
	}

	
	function listing(){
		JFactory::getApplication()->input->set('layout','listing');
		JFactory::getApplication()->input->set( 'view', 'categories' );
		return $this->display();
	}
	
	function delete(){
		$model = $this->getModel('categories');
		$post = JFactory::getApplication()->input->post->getArray();
	
		if ($model->deleteCategories($post)) {
			$msg = JText::_('LNG_CATEGORY_DELETED');
		} else {
			$msg = JText::_('LNG_ERROR_DELETING_CATEGORY');
		}
	
		$link = 'index.php?option='.getAdComponentName().'&task=categories.listing';
		$this->setRedirect($link, $msg);
	}
	function changeStatus(){
		$model = $this->getModel('categories');
		$post = JFactory::getApplication()->input->get('cid', array(),'','array');
		$limitstart = JFactory::getApplication()->input->get('limitstart',0);
		if ($model->changeStatus($post)) {
			$msg = JText::_('LNG_STATUS_CHANGED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_STATUS_CHANGED');
		}
	
		$link = 'index.php?option='.getAdComponentName().'&task=categories.listing&limitstart='.$limitstart;
		$this->setRedirect($link, $msg);
	}
	function publish(){
		$model = $this->getModel('categories');
		$post = JFactory::getApplication()->input->post->getArray();
	
		if ($model->publish($post)) {
			$msg = JText::_('LNG_STATUS_CHANGED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_STATUS_CHANGED');
		}
	
		$link = 'index.php?option='.getAdComponentName().'&task=categories.listing';
		$this->setRedirect($link, $msg);
	}
	function unpublish(){
		$model = $this->getModel('categories');
		$post = JFactory::getApplication()->input->post->getArray();
	
		if ($model->unpublish($post)) {
			$msg = JText::_('LNG_STATUS_CHANGED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_STATUS_CHANGED');
		}
	
		$link = 'index.php?option='.getAdComponentName().'&task=categories.listing';
		$this->setRedirect($link, $msg);
	}

	/**
	 * cancel editing a record
	 * @return void
	 */
	function back()
	{
		$this->setRedirect( 'index.php?option='.getAdComponentName(), $msg );
	}
}