<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class JClassifiedsManagerControllerCategoryAttributes extends JControllerLegacy
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	 
	function __construct()
	{
		parent::__construct();
		JFactory::getApplication()->input->set('layout','listing');
	}

	function listing(){
		JFactory::getApplication()->input->set('layout','listing');
		JFactory::getApplication()->input->set( 'view', 'categoryattributes' );
		return $this->display();
	}

	function delete(){
		$model = $this->getModel('categoryattributes');
		$post = JFactory::getApplication()->input->post->getArray();
		
		if ($model->deleteAttributes($post)) {
			$msg = JText::_('LNG_ATTRIBUTE_DELETED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_DELETING_ATTRIBUTE');
		}
		
		$link = 'index.php?option='.getAdComponentName().'&task=categoryattributes.listing';
		$this->setRedirect($link, $msg);
	}
	function changeStatus(){
		$model = $this->getModel('categoryattributes');
		$post = JFactory::getApplication()->input->get('cid', array(),'','array');
		
		if ($model->changeStatus($post)) {
			$msg = JText::_('LNG_STATUS_CHANGED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_STATUS_CHANGED');
		}
		
		$link = 'index.php?option='.getAdComponentName().'&task=categoryattributes.listing';
		$this->setRedirect($link, $msg);
	}
	function publish(){
		$model = $this->getModel('categoryattributes');
		$post = JFactory::getApplication()->input->post->getArray();
		
		if ($model->publish($post)) {
			$msg = JText::_('LNG_STATUS_CHANGED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_STATUS_CHANGED');
		}
		
		$link = 'index.php?option='.getAdComponentName().'&task=categoryattributes.listing';
		$this->setRedirect($link, $msg);
	}
	function unpublish(){
		$model = $this->getModel('categoryattributes');
		$post = JFactory::getApplication()->input->post->getArray();
		
		if ($model->unpublish($post)) {
			$msg = JText::_('LNG_STATUS_CHANGED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_STATUS_CHANGED');
		}
		
		$link = 'index.php?option='.getAdComponentName().'&task=categoryattributes.listing';
		$this->setRedirect($link, $msg);
	}

}