<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport('joomla.application.component.controllerform');

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
require_once( JPATH_COMPONENT_SITE.'/views/editad/view.html.php' );
require_once( JPATH_COMPONENT_SITE.'/models/editad.php' );


class JClassifiedsManagerControllerManageAd extends JControllerForm
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	 
	function __construct()
	{
		JFactory::getApplication()->input->set('layout','edit');
		parent::__construct();
	}

	/**
	* Method to edit an existing record.
	*
	* @param   string  $key     The name of the primary key of the URL variable.
	* @param   string  $urlVar  The name of the URL variable if different from the primary key
	* (sometimes required to avoid router collisions).
	*
	* @return  boolean  True if access level check and checkout passes, false otherwise.
	*
	*/
	public function edit($key = null, $urlVar = 'ad_id')
	{
	$app = JFactory::getApplication();
	//JFactory::getApplication()->input->set('id','ad_id');
	$result = parent::edit("id","ad_id");

	return true;
	}


	public function add()
	 {
	  $app = JFactory::getApplication();
	  $context = 'com_jclassifiedsmanager.edit.managead';
	 
	  $result = parent::add();
	  if ($result)
	  {
	   $this->setRedirect(JRoute::_('index.php?option=com_jclassifiedsmanager&view=managead'. $this->getRedirectToItemAppend(), false));
	   exit();
	  }
	 
	  return $result;
	 }
	 
	 /**
	  * Method override to check if you can add a new record.
	  *
	  * @param   array  $data  An array of input data.
	  *
	  * @return  boolean
	  */
	 
	 protected function allowAdd($data = array())
	 {
	  	$user  = JFactory::getUser();
	    return true;
	 }

	 	 /**
	  * Method override to check if you can edit an existing record.
	  *
	  * @param   array   $data  An array of input data.
	  * @param   string  $key   The name of the key for the primary key.
	  *
	  * @return  boolean
	  */
	 protected function allowEdit($data = array(), $key = 'id')
	 {
	  return true;
	 }

	 /**
	 * save a record (and redirect to main page)
	 * @return void
	 */

	function save($key = null, $urlVar = null){
		$model = $this->getModel('managead');
		$post = JFactory::getApplication()->input->post->getArray();
		$task = JFactory::getApplication()->input->get("task");
		
		if (!$model->saveAd($post)){
			// Save the data in the session.
			$this->ad_id = $model->ad_id;	
			// Redirect back to the edit screen.
			$this->setMessage(JText::sprintf('JLIB_APPLICATION_ERROR_SAVE_FAILED', $model->getError()), 'warning');
			$this->setRedirect(JRoute::_('index.php?option='.getAdComponentName().'&view=managead&task=managead.edit&ad_id='.$model->getAdId(), false));
				
			return false;
		}
		
		$this->setMessage(JText::_('LNG_AD_SUCCESSFULLY_SAVED'));
		

		// Redirect the user and adjust session state based on the chosen task.
		switch ($task)
		{
			case 'apply':
				//Redirect back to the edit screen. 
				$this->setRedirect(JRoute::_('index.php?option='.getAdComponentName().'&view=managead&task=managead.edit&ad_id='.$model->getAdId(), false));
				break;
		
			default:
				//Redirect to the list screen. 
				$this->setRedirect(JRoute::_('index.php?option='.getAdComponentName().'&task=manageads.listing', false));
				break;
		}
	
	}

	/**
	* cancel editing a record
	* @return void
	*/
	function cancel($key = null, $urlVar = null)
	{
		
		$msg = JText::_('LNG_OPERATION_CANCELLED',true);
		$post 		= JFactory::getApplication()->input->post->getArray();
		$this->setRedirect( 'index.php?option='.getAdComponentName().'&view=manageads', $msg );
	}
		
	public function back(){
		$this->setRedirect('index.php?option='.getAdComponentName());
	}

}