<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
require_once( JPATH_COMPONENT_SITE.'/views/editad/view.html.php' );
require_once( JPATH_COMPONENT_SITE.'/models/editad.php' );


class JClassifiedsManagerControllerManageAds extends JControllerLegacy
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	 
	function __construct()
	{
		parent::__construct();
		JFactory::getApplication()->input->set('layout','listing');
		$this->registerTask( 'apply', 'save');
	}
	
	function listing(){
		JFactory::getApplication()->input->set('layout','listing');
		JFactory::getApplication()->input->set( 'view', 'manageads' );
		return $this->display();
	}

	function delete(){
		$model = $this->getModel('manageads');
		$post = JFactory::getApplication()->input->post->getArray();
	
		if ($model->deleteAds($post)) {
			$msg = JText::_('LNG_ADS_DELETED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_DELETING_ADS');
		}
	
		$link = 'index.php?option='.getAdComponentName().'&task=manageads.listing';
		$this->setRedirect($link, $msg);
	}
	
	function changeStatus(){
		$model = $this->getModel('manageads');
        $post = JFactory::getApplication()->input->get('cid', array(),'','array');
        $postData = JFactory::getApplication()->input->get->getArray();
        
		if ($model->changeStatus($post)) {
			$msg = JText::_('LNG_STATUS_CHANGED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_STATUS_CHANGED');
		}
	
		$link = 'index.php?option='.getAdComponentName().'&task=manageads.listing&limitstart='.$postData["limitstart"];
		$this->setRedirect($link, $msg);
	}
	
	function changeFeaturedStatus(){
		$model = $this->getModel('manageads');
        $post = JFactory::getApplication()->input->get('cid', array(),'','array');
        $postData = JFactory::getApplication()->input->get->getArray();
        
		if ($model->changeFeaturedStatus($post)) {
			$msg = JText::_('LNG_STATUS_CHANGED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_STATUS_CHANGED');
		}
	
		$link = 'index.php?option='.getAdComponentName().'&task=manageads.listing&limitstart='.$postData["limitstart"];
		$this->setRedirect($link, $msg);
	}
	
	function publish(){
		$model = $this->getModel('manageads');
		$post = JFactory::getApplication()->input->post->getArray();
	
		if ($model->publishAds($post)) {
			$msg = JText::_('LNG_STATUS_CHANGED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_STATUS_CHANGED');
		}

		$query_array = array();
	    foreach( $post as $key => $key_value ){
	    	if(strpos($key, "filter")===0)
	       	 	$query_array[] = $key . '=' . urlencode( $key_value );
	    }
    	$params =  implode( '&', $query_array );

		$link = 'index.php?option='.getAdComponentName().'&task=manageads.listing&'.$params;
		$this->setRedirect($link, $msg);
	}
	function unpublish(){
		$model = $this->getModel('manageads');
		$post = JFactory::getApplication()->input->post->getArray();
	
		if ($model->unpublish($post)) {
			$msg = JText::_('LNG_STATUS_CHANGED_SUCCESSFULLY');
		} else {
			$msg = JText::_('LNG_ERROR_STATUS_CHANGED');
		}
	
		$query_array = array();
	    foreach( $post as $key => $key_value ){
	    	if(strpos($key, "filter")===0)
	       	 	$query_array[] = $key . '=' . urlencode( $key_value );
	    }
    	$params =  implode( '&', $query_array );

		$link = 'index.php?option='.getAdComponentName().'&task=manageads.listing&'.$params;
		$this->setRedirect($link, $msg);
	}
	
	function changePaymentStatus(){
		$model = $this->getModel('manageads');
		$result =  $model->changePaymentStatus();
		echo $result; 
		exit;
	}
	function promoteAdAdmin(){
		$model = $this->getModel('manageads');
		$result =  $model->promoteAdAdmin();
		echo $result; 
		exit;
	}
	
	function exportAds(){
		//$model = $this->getModel('manageads');
		//$model->setAdEditions();
		//exit;

		JFactory::getApplication()->input->set('layout','export');
		
		return $this->display();
	}

}