<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport('joomla.application.component.controllerform');


class JClassifiedsManagerControllerPaymentProcessor extends JControllerForm
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	 
	function __construct()
	{
		parent::__construct();
	}



	/**
	* Method to edit an existing record.
	*
	* @param   string  $key     The name of the primary key of the URL variable.
	* @param   string  $urlVar  The name of the URL variable if different from the primary key
	* (sometimes required to avoid router collisions).
	*
	* @return  boolean  True if access level check and checkout passes, false otherwise.
	*
	*/
	public function edit($key = null, $urlVar = null)
	{
	$app = JFactory::getApplication();
	$result = parent::edit();

	return true;
	}


	public function add()
	 {
	  $app = JFactory::getApplication();
	  $context = 'com_jclassifiedsmanager.edit.paymentprocessor';
	 
	  $result = parent::add();
	  if ($result)
	  {
	   $this->setRedirect(JRoute::_('index.php?option=com_jclassifiedsmanager&view=paymentprocessor'. $this->getRedirectToItemAppend(), false));
	   exit();
	  }
	 
	  return $result;
	 }
	 
	 /**
	  * Method override to check if you can add a new record.
	  *
	  * @param   array  $data  An array of input data.
	  *
	  * @return  boolean
	  */
	 
	 protected function allowAdd($data = array())
	 {
	  	$user  = JFactory::getUser();
	    return true;
	 }

	 	 /**
	  * Method override to check if you can edit an existing record.
	  *
	  * @param   array   $data  An array of input data.
	  * @param   string  $key   The name of the key for the primary key.
	  *
	  * @return  boolean
	  */
	 protected function allowEdit($data = array(), $key = 'id')
	 {
	  return true;
	 }



	 /**
	 * save a record (and redirect to main page)
	 * @return void
	 */
	function save($key = null, $urlVar = null)
	{
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$model = $this->getModel('paymentprocessor');
		$post = JFactory::getApplication()->input->post->getArray();
		$task = $this->getTask();

		if ($model->store($post)) {
			$msg = JText::_('LNG_PROCESSOR_SAVED');
			
		} else {
			$msg = JText::_('LNG_ERROR_SAVING_PROCESSORS');
		}

		// Redirect based on the chosen task.
		switch ($task)
		{
			case 'apply':
				// Redirect back to the edit screen.
				$this->setRedirect( 'index.php?option='.getAdComponentName().'&view=paymentprocessor&task=paymentprocessor.edit&id='.$model->id, $msg );
				break;
			default:			
				// Redirect to the list screen.
				$this->setRedirect( 'index.php?option='.getAdComponentName().'&task=paymentprocessors.listing', $msg );
				break;
		}
	}

	

	/**
	* cancel editing a record
	* @return void
	*/
	function cancel($key = null, $urlVar = null)
	{
		
		$msg = JText::_('LNG_OPERATION_CANCELLED',true);
		$post 		= JFactory::getApplication()->input->post->getArray();
		$this->setRedirect( 'index.php?option='.getAdComponentName().'&view=paymentprocessors', $msg );
	}

}