<?php
/**
* @copyright	Copyright (C) 2008-2009 CMSJunkie. All rights reserved.
* 
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
* See the GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
use Joomla\Utilities\ArrayHelper;

class JClassifiedsManagerControllerUpdates extends JControllerLegacy
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	 
	function __construct()
	{
		parent::__construct();
	}

	/**
	 * save a record (and redirect to main page)
	 * @return void
	 */
	
	function saveOrder()
	{
		$model = $this->getModel('updates');
		$post = JFactory::getApplication()->input->post->getArray(); 

		if ($model->store($post)) {
			$msg = JText::_('LNG_ORDER_SAVED',true);
		} else {
			$msg = JText::_('LNG_ERROR_SAVING_ORDER',true);
		}
		
		$link = 'index.php?option='.getAdComponentName().'&view=updates';
		$this->setRedirect($link, $msg);
	}

	/**
	 * cancel editing a record
	 * @return void
	 */
	function cancel()
	{
		$msg = JText::_('LNG_OPERATION_CANCELLED',true);
		$this->setRedirect( 'index.php?option='.getAdComponentName, $msg );
	}
	public function findUpdates()
	{
		// Check for request forgeries
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Get the caching duration
		$component = JComponentHelper::getComponent('com_installer');
		$params = $component->params;
		$cache_timeout = $params->get('cachetimeout', 6, 'int');
		$cache_timeout = 3600 * $cache_timeout;
		
		$module = JComponentHelper::getComponent('com_jclassifiedsmanager');
		
		// Find updates
		$model	= $this->getModel('updates');
		$model->findUpdates(array($module->id), $cache_timeout);
        var_dump(JRoute::_('index.php?option='.getAdComponentName().'&view=updates', false));exit;
		$this->setRedirect(JRoute::_('index.php?option='.getAdComponentName().'&view=updates', false));
	}
	function getVersionStatus(){
		$model = $this->getModel('updates');
		$result = $model->getVersionStatus();
		echo $result;
		exit;
		
	}
	
	function update(){
		// Check for request forgeries
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$model = $this->getModel('updates');
		$uid   = JFactory::getApplication()->input->get('cid', array(), 'array');
		
		jimport('joomla.utilities.arrayhelper');
		ArrayHelper::toInteger($uid, array());
		if ($model->update($uid))
		{
			$cache = JFactory::getCache('mod_menu');
			$cache->clean();
		}
	
		$app = JFactory::getApplication();
		$redirect_url = $app->getUserState('com_jclassifiedsmanager.redirect_url');
		if (empty($redirect_url))
		{
			$redirect_url = JRoute::_('index.php?option='.getAdComponentName().'&view=updates', false);
		}
		else
		{
			// Wipe out the user state when we're going to redirect
			$app->setUserState('com_jclassifiedsmanager.redirect_url', '');
			$app->setUserState('com_jclassifiedsmanager.message', '');
			$app->setUserState('com_jclassifiedsmanager.extension_message', '');
		}
		$this->setRedirect($redirect_url);
	}

}