<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );

$span= $params->get('layout_type')=="vertical"?"span12":"span3";

?>

<div class="jcls-container">
	<div class="categories-container  jcls-grid-container categories-style-3">
		<div class="row">
			<?php $index = 1; ?>
			<?php foreach ($items as $mainCategory) {
			if (isset($mainCategory->name)) {  ?>
					<div class="col-xl-3 col-lg-4 col-sm-6 col-12">
						<div class="card jitem-card h-100">
							<div class="jitem-img-wrap">
								<a href="<?php echo JAdsUtil::getCategoryLink($mainCategory->id, $mainCategory->alias) ?>"></a>
								<?php if (!empty($mainCategory->picture_name)) { ?>
									<img title="<?php echo htmlspecialchars($mainCategory->name, ENT_QUOTES) ?>"
										alt="<?php echo htmlspecialchars($mainCategory->name, ENT_QUOTES) ?>"
										src="<?php echo JURI::root() . PATH_PICTURES . CAT_PICTURE_PATH . $mainCategory->id . '/' . $mainCategory->picture_name ?>">
								<?php } else { ?>
									<img title="<?php echo htmlspecialchars($mainCategory->name, ENT_QUOTES) ?>"
										alt="<?php echo htmlspecialchars($mainCategory->name, ENT_QUOTES) ?>"
										src="<?php echo JURI::root().PATH_PICTURES.'/no_image.jpg' ?>">
								<?php } ?>
								<div class="card-hoverable">
									<a href="<?php echo JAdsUtil::getCategoryLink($mainCategory->id, $mainCategory->alias) ?>" class="btn btn-outline-success btn-sm w-auto"><?php echo JText::_("LNG_VIEW")?></a>
								</div>
							</div>
							<div class="jitem-body">
								<div class="jitem-body-content">
									<div class="jitem-title">
										<a class="d-flex align-items-start justify-content-between" href="<?php echo JAdsUtil::getCategoryLink($mainCategory->id, $mainCategory->alias) ?>"><?php echo htmlspecialchars($mainCategory->name, ENT_QUOTES) ?></a>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
			<?php $index++; ?>
			<?php
	}?>
		</div>
	</div>
</div>