<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_jads_user
 *
 * @copyright   Copyright (C) 2005 - 2023 Open Source Matters, Inc. All rights reserved.
 * @license     https://www.gnu.org/licenses/agpl-3.0.en.html; see LICENSE.txt
 */

defined('_JEXEC') or die;

// Include the login functions only once
require_once 'components/com_jclassifiedsmanager/helpers/utils.php';
require_once 'components/com_jclassifiedsmanager/helpers/defines.php';
require_once( dirname(__FILE__).'/helper.php' );

JHtml::_('stylesheet', 'components/com_jclassifiedsmanager/assets/css/line-awesome.css');
JHtml::_('stylesheet', 'components/com_jclassifiedsmanager/assets/css/responsive.css');
JHtml::_('stylesheet', 'components/com_jclassifiedsmanager/assets/css/jcls-style.css');
JHtml::_('stylesheet', 'modules/mod_jads_user/assets/css/style.css');

JHtml::_('stylesheet','administrator/components/com_jclassifiedsmanager/libraries/modal/jquery.modal.css');
JHtml::_('script','administrator/components/com_jclassifiedsmanager/libraries/modal/jquery.modal.js');

$tag = JAdsUtil::getJoomlaLanguage();
JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/js/validation/languages/jquery.validationEngine-".$tag.".js");
JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/js/validation/jquery.validationEngine.js");
JHTML::_('stylesheet', JURI::root().'/components/com_jclassifiedsmanager/assets/css/validation/validationEngine.jquery.css' );

JAdsUtil::loadSiteLanguage();

$appSettings = JAdsUtil::getApplicationSettings();

$params->def('greeting', 1);

$type             = ModJAdsUserHelper::getType();
$return           = ModJAdsUserHelper::getReturnUrl($params, $type);
$twofactormethods = JAuthenticationHelper::getTwoFactorMethods();
$user             = JFactory::getUser();
$layout           = $params->get('layout', 'default');

$dashboardLink = JRoute::_('index.php?option=com_jclassifiedsmanager&view=useraccount');

require JModuleHelper::getLayoutPath('mod_jads_user', $layout);