<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_login
 *
 * @copyright   Copyright (C) 2005 - 2023 Open Source Matters, Inc. All rights reserved.
 * @license     https://www.gnu.org/licenses/agpl-3.0.en.html; see LICENSE.txt
 */

defined('_JEXEC') or die;

JLoader::register('UsersHelperRoute', JPATH_SITE . '/components/com_users/helpers/route.php');

JHtml::_('behavior.keepalive');
$usersConfig = JComponentHelper::getParams('com_users'); 
$userToken = JSession::getFormToken();
$currentUrl = JUri::getInstance();
?>

<div class="jcls-mod-user">
	<?php if(!$user->id){ ?>
    <div class="user-area signin-area">
		<i class="fa fa-user"></i>
        <a href="#jcls-user-login" rel="modal:open"><?php echo JText::_("MOD_JADS_USER_SIGN_IN")?></a>
        <?php if ($usersConfig->get('allowUserRegistration') && $params->get('showregistration')) { ?>
        	<span class="allow-registration">
				<span><?php echo JText::_("MOD_JADS_USER_OR")?></span>
				<?php if ($params->get('external_registration')) {?>
					<a href="<?php echo JRoute::_(ModJAdsUserHelper::getRedirectUrl($params, "external_registration")); ?>">
							<?php echo JText::_('MOD_JADS_USER_REGISTER'); ?> </a>
				<?php }else{ ?>
					<a href="#jcls-user-registration" rel="modal:open"><?php echo JText::_("MOD_JADS_USER_REGISTER")?></a>
				<?php } ?>
			</span>
		<?php } ?>
    </div>
	<?php }else{ ?>
    	<div class="jcls-user-menu">
			<ul class="user-menu menu-animation-fade-up">
				<li class="menu-item has-child"><a href="#" class="jcls-username"><i class="la la-user"></i> <span class="jcls-user-name"><?php echo $user->name?></span></a>
					<div class="dropdown dropdown-main menu-right">
        				<div class="dropdown-inner">
            				<ul class="dropdown-items">
            					<li class="menu-item">
            						<a href="<?php echo $dashboardLink ?>"><?php echo JText::_("MOD_JADS_USER_DASHBOARD")?></a>
            					</li>
            					<li class="menu-item">
            						<a href="<?php echo JRoute::_('index.php?option=com_users&view=profile') ?>"><?php echo JText::_("MOD_JADS_USER_PROFILE")?></a>
            					</li>
            					<li class="menu-item">
            						<a href="<?php echo JRoute::_('index.php?option=com_users&task=user.logout&'.$userToken.'=1&return='.$return)?>"><?php echo JText::_("MOD_JADS_USER_LOGOUT")?></a>
            					</li>
            				</ul>
            			</div>
            		</div>
        		</li>
        	</ul>
    	</div>
   <?php } ?>

    <?php if ($params->get('showcreatelisting')) { ?>
        <div class="jcls-button-container">
            <a href="<?php echo JRoute::_("index.php?option=com_jclassifiedsmanager&view=editad")?>" class="button-create">
                <i class="fa fa-plus"></i> <?php echo JText::_("MOD_JADS_USER_ADD_LISTING")?>
            </a>
        </div>
    <?php } ?>

    <div id="jcls-user-login" class="jcls-container" style="display:none"> 
    	<form action="<?php echo JRoute::_('index.php', true, $params->get('usesecure', 0)); ?>" method="post" id="login-form" class="form-inline">
        	<div class="jmodal-sm">
        		<div class="jmodal-header">
        			<p class="jmodal-header-title"><?php echo JText::_("MOD_JADS_USER_SIGN_IN") ?></p>
        			<a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        		</div>
        		<div class="jmodal-body">
            		<?php if ($params->get('pretext')){ ?>
            			<div class="pretext">
            				<p><?php echo $params->get('pretext'); ?></p>
            			</div>
            		<?php } ?>
            		
            		<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required]" id="jinput-username" name="username" type="text"  required="" > 
                				<label for="jinput-username"><?php echo JText::_('MOD_JADS_USER_VALUE_USERNAME') ?></label>
                    		</div>
    					</div>
    				</div>	
            		<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required]" type="password" name="password" id="modlgn-passwd" required="">
                				<label for="modlgn-passwd"><?php echo JText::_('JGLOBAL_PASSWORD') ?></label> 
                    		</div>
    					</div>
    				</div>	

            		<?php if (count($twofactormethods) > 1) { ?>
            			<div class="row">
        					<div class="col-md-12">
        						<div class="jinput-outline jinput-hover">
                    				<input class="validate[required]" autocomplete="off" type="text" name="secretkey" id="modlgn-secretkey" required="">
                    				<label for="modlgn-secretkey"><?php echo JText::_('JGLOBAL_SECRETKEY') ?></label> 
                        		</div>
        					</div>
        				</div>	
            		<?php } ?>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="jcls-checkbox justify-content-end">
                            </div>
                        </div>
                    </div>

            		<div class="row">
    					<div class="col-md-6">
                    		<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
                				<div class="jcls-checkbox justify-content-end">
                					<label for="modlgn-remember"><?php echo JText::_('MOD_JADS_USER_REMEMBER_ME')?></label>
                                    <input type="checkbox" name="remember" id="modlgn-remember" value="1" value="yes" /> 
                                </div>
                   			<?php endif; ?>
    					</div>
    					<div class="col-md-6 d-flex align-items-center justify-content-md-end">
    						<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>">
            						<?php echo JText::_('MOD_JADS_USER_FORGOT_YOUR_PASSWORD'); ?></a>
    					</div>               			
               		</div>
               		
               		<div class="row">
               			<div class="col-md-12 text-center my-3">
    						<button type="submit" tabindex="0" name="Submit" class="btn btn-primary login-button"><?php echo JText::_('JLOGIN'); ?></button>
    					</div>
    				</div>

					<?php if($usersConfig->get('allowUserRegistration') && $params->get('showregistration')) { ?>
						<?php if ($params->get('external_registration') ) {?>
							<div class="row">
								<div class="col-md-12 text-center">
									<?php echo JText::_('MOD_JADS_USER_NOT_MEMBER'); ?><a href="<?php echo JRoute::_(ModJAdsUserHelper::getRedirectUrl($params, "external_registration")); ?>">
											<?php echo JText::_('MOD_JADS_USER_REGISTER_HERE'); ?> </a>
								</div>
							</div>
						<?php } else { ?>
							<div class="row">
								<div class="col-md-12 text-center">
									<?php echo JText::_('MOD_JADS_USER_NOT_MEMBER'); ?><a href="#jcls-user-registration" rel="modal:open">
											<?php echo JText::_('MOD_JADS_USER_REGISTER_HERE'); ?> </a>
								</div>
							</div>
						<?php } ?>
					<?php } ?>
                    
                    <?php if ($params->get('showforgotuser')) { ?>
        				<div class="row">
                   			<div class="col-md-12 text-center">
                         		 <a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>">
                						<?php echo JText::_('MOD_JADS_FORGOT_YOUR_USERNAME'); ?> </a>
                        	</div>
                        </div>
                    <?php } ?>
               		
               		<?php if ($params->get('posttext')) { ?>
            			<div class="posttext">
            				<p><?php echo $params->get('posttext'); ?></p>
            			</div>
					<?php } ?>
               		
        			<input type="hidden" name="option" value="com_users" />
        			<input type="hidden" name="task" value="user.login" />
        			<input type="hidden" name="return" value="<?php echo $return; ?>" />
        			<?php echo JHtml::_('form.token'); ?>
        		</div>
        	</div>	
    	</form>
    </div>
	
	<div id="jcls-user-registration" class="jcls-container" style="display:none">
		<form id="member-registration" action="<?php echo JRoute::_('index.php?option=com_users&task=useraccount.addUser'); ?>" method="post" class="form-validate form-horizontal well" enctype="multipart/form-data"> 
    		<div class="jmodal-sm">
        		<div class="jmodal-header">
        			<p class="jmodal-header-title"><?php echo JText::_("MOD_JADS_USER_REGISTRATION") ?></p>
        			<a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        		</div>
        		<div class="jmodal-body">
					<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required]" id="jform_name" name="name" type="text"  required="" > 
                				<label for="jform_name"><?php echo JText::_('MOD_JADS_USER_NAME') ?></label>
                    		</div>
    					</div>
    				</div>	
					<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required]" id="jform_username" name="username" type="text"  required=""> 
                				<label for="jform_username"><?php echo JText::_('MOD_JADS_USER_USERNAME') ?></label>
								<p class="usernameWarning" style="color:red"><p>
                    		</div>
    					</div>
    				</div>
    				
    				<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required,minSize[6]]" id="jform_password" name="password" type="password" required="" > 
                				<label for="jform_password"><?php echo JText::_('MOD_JADS_USER_PASSWORD') ?></label>
                    		</div>
    					</div>
    				</div>
    				
    				<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required,custom[email]]" id="jform_email" name="email" type="text" required=""> 
                				<label for="jform_email"><?php echo JText::_('MOD_JADS_USER_EMAIL') ?></label>
								<p class="emailWarning" style="color:red"><p>
                    		</div>
    					</div>
					</div>
                    
                    <div class="row">
                        <div class="col-md-12">
                        	<?php 
                        		if($appSettings->enable_captcha){
        							$namespace="jclassifiedsmanager.contact";
        							$class="none";
        							
        							$captcha = JCaptcha::getInstance("recaptcha", array('namespace' => $namespace));
        																
									if(!empty($captcha)){	
										echo $captcha->display("captcha", "captcha-div", $class);
									}
	        					} 
	        				?>
            			</div>
            		</div>

    				<div class="row">
    					<div class="col-md-12 text-center my-3">
    						<button type="submit" class="btn btn-primary validate">
            					<?php echo JText::_('JREGISTER'); ?>
            				</button>
            			</div>
            		</div>
            	
            		<div class="jcls-user-has-account">
    					<?php echo JText::_('MOD_JADS_USER_HAVE_ACCOUNT'); ?> <a href="#jcls-user-login" rel="modal:open"><?php echo JText::_('MOD_JADS_USER_LOGIN'); ?></a>
    				</div>
    				
    				<input type="hidden" name="option" value="com_jclassifiedsmanager" />
					<input type="hidden" name="view" value="useraccount" />
					<input type="hidden" name="controller" value="useraccount" />
					<input type="hidden" name="task" value="addUser" />
					<input type="hidden" name="registration_redirect" value="<?php echo ModJAdsUserHelper::getReturnUrl($params, "registration_redirect"); ; ?>" />
    			</div>
				<?php echo JHtml::_('form.token'); ?>	
			</div>
		</form>
	</div>

</div>

<script>

	jQuery(document).ready(function () {
		jQuery("#member-registration").validationEngine('attach');
	});

</script>