<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 cmsjunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.cmsjunkie.com
# Technical Support:  Forum - http://www.cmsjunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.plugin.plugin');
if (file_exists(JPATH_SITE.'/components/com_jclassifiedsmanager/helpers/defines.php')) {
	require_once JPATH_SITE.'/components/com_jclassifiedsmanager/helpers/defines.php';
}else{
	return null;
}
require_once JPATH_SITE.'/components/com_jclassifiedsmanager/helpers/utils.php';


require_once 'jclsrouter.php';

/**
 * Joomla! System Remember Me Plugin
 *
 * @package		Joomla.Plugin
 * @subpackage	System.remember
 */
class plgSystemClassifiedsUrlTranslator extends JPlugin
{


	/**
	 * Jooma hook
	 *
	 * @return void
	 */
	public function onAfterInitialise(){
		// get joomla application object
		$app = JFactory::getApplication();
		
		if ($app->isClient('administrator')) {
			return;
		}

		if(php_sapi_name() === 'cli' ){
			return;
		}

		// attach parse and build rules to Joomla router
		if(!JAdsUtil::isJoomla3()){
			$joomlaRouter     = $app->getRouter();
			$router = new JCLSRouter($this->params);
			$joomlaRouter->attachParseRule(array($router, 'parseRule'));
			//$joomlaRouter->attachBuildRule(array($router, 'buildRule'));
		}
	}


	/**
	* onAfterRoute (parses the route and pushes the request parameters into JRequest to be retrieved by the application.)
	* @param  none
	* @return none
	* 
	*/

	function onAfterRoute()
	{

		$app = JFactory::getApplication();

		// No remember me for admin
		if ($app->isClient('administrator')) {
			return;
		}

		if(php_sapi_name() === 'cli' ){
			return;
		}
		
		$jclsRouter = new JCLSRouter($this->params);
		$params = $jclsRouter->getRouteParams();
		$jinput = JFactory::getApplication()->input;
		
		if (!empty($params)) {
			foreach ($params as $key => $param) {
				$jinput->set($key, $param);
			}
		}
	
		return;
	}
}