<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

require_once JPATH_COMPONENT_SITE.'/helpers/defines.php';
require_once JPATH_COMPONENT_SITE.'/helpers/utils.php';
require_once JPATH_COMPONENT_SITE.'/helpers/helper.php';
require_once( JPATH_COMPONENT.DS.'controller.php' );
require_once( JPATH_COMPONENT_SITE.'/helpers/logger.php' );
require_once JPATH_COMPONENT_SITE.'/helpers/tabs.php';

require_once JPATH_COMPONENT_ADMINISTRATOR.'/views/jclsview.php';

JHTML::_('stylesheet', 	'components/'.getAdComponentName().'/assets/css/jcls-style.css');
JHTML::_('stylesheet', 	'administrator/components/'.getAdComponentName().'/assets/css/general.css');
JHtml::_('stylesheet', 'administrator/components/'.getAdComponentName().'/assets/css/jcls-template.css');
JHTML::_('stylesheet','administrator/components/'.getAdComponentName().'/assets/css/joomlatabs.css');

JHTML::_('stylesheet','/components/'.getAdComponentName().'/assets/css/validation/validationEngine.jquery.css');
JHTML::_('stylesheet','/components/'.getAdComponentName().'/assets/css/validation/template.css');



if (version_compare(JVERSION, '3.4.0', '<'))
{
    die('Your host needs to use Joomla 3.4.0 or higher to run this version of J-Classifieds Manager!');
}
if(JAdsUtil::isJoomla3()){
	JHtml::_('jquery.framework', true, true); //load jQuery before other js
}else{
	if(!defined('J_JQUERY_LOADED')) {
		JAdsUtil::includeFile('script', 	'jquery.min.js', 'administrator/components/'.getAdComponentName().'/assets/js/');
		define('J_JQUERY_LOADED', 1);
	}
}

JHTML::_('script','administrator/components/'.getAdComponentName().'/assets/utils.js');
JHTML::_('script','administrator/components/'.getAdComponentName().'/assets/js/coolInterfaces.js');
JHtml::_('script', 'components/'.getAdComponentName().'/assets/js/metisMenu.js');

$tag = JAdsUtil::getJoomlaLanguage();
JHtml::_('script', 'components/'.getAdComponentName().'/assets/js/validation/languages/jquery.validationEngine-'.$tag.'.js');
JHtml::_('script', 'components/'.getAdComponentName().'/assets/js/validation/jquery.validationEngine.js');
		
JAdsUtil::loadAdminLanguage();
JAdsUtil::loadClasses();

$document  =JFactory::getDocument();
$document->addScriptDeclaration('
		window.onload = function()	{
			jQuery.noConflict();
			
			jQuery(".radio.btn-group label").addClass("btn");
			jQuery(".btn-group label:not(.active)").click(function () {
				let label = jQuery(this);
				let input = jQuery("#" + label.attr("for"));
	
				if (!input.prop("checked")) {
					label.closest(".btn-group").find("label").removeClass("active btn-success btn-danger btn-primary");
					if (input.val() == "") {
						label.addClass("active btn-primary");
					} else if (input.val() == 0) {
						label.addClass("active btn-danger");
					} else {
						label.addClass("active btn-success");
					}
					input.prop("checked", true);
				}
			});
			jQuery(".btn-group input[checked=checked]").each(function () {
				if (jQuery(this).val() == "") {
					jQuery("label[for=" + jQuery(this).attr("id") + "]").addClass("active btn-primary");
				} else if (jQuery(this).val() == 0) {
					jQuery("label[for=" + jQuery(this).attr("id") + "]").addClass("active btn-danger");
				} else {
					jQuery("label[for=" + jQuery(this).attr("id") + "]").addClass("active btn-success");
				}
			});
			
		};
		var baseUrl="'.(JURI::base().'index.php?option='.getAdComponentName()).'";
		var baseUrlUpload="'.JURI::root().'";
		'
);


$controller	= JControllerLegacy::getInstance('JClassifiedsManager');
$controller->execute(JFactory::getApplication()->input->get('task'));
$controller->redirect();

