<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.model'); 

use Joomla\CMS\Language\LanguageHelper;

class JClassifiedsManagerModelApplicationSettings extends JModelLegacy
{ 
	function __construct()
	{
		parent::__construct();
	}

	function &getData()
	{
		// Load the data
		$row =$this->getTable();
		$appSettings = $row->getApplicationSettings();
		if(isset($appSettings->id))
			$row->load($appSettings->id);
		else 
			$row->load(0);
		return $row;
	}
	
	
	function store( $data )
	{
		$row =$this->getTable();
		// Bind the form fields to the table
		if (!$row->bind($data)) 
		{
			$this->setError($row->getError());
			return false;
		}
		// Make sure the record is valid
		if (!$row->check()) {
			$this->setError($row->getError());
			return false;
		}

		// Store the web link table to the database
		if (!$row->store()) {
			$this->setError($row->getError());
			return false;
		}
		return true;
	}


	public static function getLanguagess() {
		$languages = JLanguageHelper::getKnownLanguages();
		
		$result = array();
		foreach ($languages as $key=>$language) {
			$name = isset($language["nativeName"])?$language["nativeName"]:$language["name"];
			if (strpos($name, "(")!==false) {
				$name = substr($name, 0, strpos($name, "(")-1);
			}
			if (!isset($result[$name])) {
				$result[$name]=$key;
			} else {
				$name = $language["name"];
				$result[$name]=$key;
			}
		}
		
		asort($result);
		return $result;
	}
	public function getLanguages($pathOnInstall = null) {
		if (!empty($pathOnInstall)) {
			$adminPath = $pathOnInstall;
		} else {
			$adminPath = JPATH_COMPONENT_ADMINISTRATOR;
		}
		$path = LanguageHelper::getLanguagePath($adminPath);
		$lngs = JAdsUtil::getLanguages();
		$lngs = array_flip($lngs);
		$dirs = JFolder::folders($path);
		foreach ($dirs as $dir) {
			if (strlen($dir) != 5) {
				continue;
			}
			$iniFiles = JFolder::files($path . DS . $dir, '.ini', false, false);
			$iniFiles = reset($iniFiles);
			if (empty($iniFiles)) {
				continue;
			}
			$fileName              = basename($iniFiles);
			$oneLanguage           = new stdClass();
			$oneLanguage->language = $dir;
			$oneLanguage->name     = substr($fileName, 0, 5);

			if (isset($lngs[$oneLanguage->name])) {
				$oneLanguage->name = $lngs[$oneLanguage->name];
			}

			$languages[] = $oneLanguage;
		}
		return $languages;
	}



}
?>