<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.modeladmin');

use Joomla\String\StringHelper;

class JClassifiedsManagerModelCategory extends JModelAdmin
{ 
	/**
	 * Returns a Table object, always creating it
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  Table	A database object
	*/
	public function getTable($type = 'Categories', $prefix = 'Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the menu item form.
	 *
	 * @param   array  $data		Data for the form.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		//exit;
		// The folder and element vars are passed when saving the form.
		if (empty($data))
		{
			$item= $this->getItem();
			// The type should already be set.
		}
		// Get the form.
		$form = $this->loadForm('com_jclassifiedsmanager.category', 'item', array('control' => 'jform', 'load_data' => $loadData), true);
		if (empty($form))
		{
			return false;
		}
		
		return $form;
	}

	function __construct()
	{
		parent::__construct();
	
	}

	function getCategories()
	{
		// Load the data
		$row =$this->getTable();
		$categories = $row->getCategories();
		return $categories;
	}

	function getAllAttributes()
	{
		// Load the data
		$row =$this->getTable('categoryattributes');
		$attributes = $row->getAllAttributes("");
		return $attributes;
	}
	function getCategory()
	{
		// Load the data
		$row =$this->getTable();
		$categoryId = JFactory::getApplication()->input->get("id",0);
		$row->load($categoryId);
		return $row;
	}

	function getCategoryImage()
	{
		// Show category pictures
		$row =$this->getTable("CategoryPictures", "Table");
		$categoryId = JFactory::getApplication()->input->get("id",0);
		$categoryPicture = $row->getCategoryPictures($categoryId);
		return $categoryPicture;
	}

	function getCategoryAttributes(){
		$row =$this->getTable();
		$categoryId = JFactory::getApplication()->input->get("id",0);
		$categoryAttributes = $row->getCategoryAttributes($categoryId);
		return $categoryAttributes;
	}
	

	 /**
	 * Check for duplicate alias and generate a new alias
	 * @param unknown_type $alias
	 * @param unknown_type $categoryId
	 */

	function checkAlias($categoryId, $alias){
	  $categoriesTable = $this->getTable();
	  while($categoriesTable->checkIfAliasExists($categoryId, $alias)){
	   $alias = StringHelper::increment($alias, 'dash');
	  }
	  return $alias;
	 }

	
	function store( $data )
	{	
		$row =$this->getTable();
		
		$pk = (!empty($data['id'])) ? $data['id'] : -2;

		if(!empty($name) && empty($data["name"]))
			$data["name"] = $name;
		
		$data["alias"]= JAdsUtil::getAlias($data["name"],$data["alias"]);
		$data["alias"] = $this->checkAlias($pk, $data["alias"]);

		// Bind the form fields to the table
		if (!$row->bind($data)) 
		{
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		// Make sure the record is valid
		if (!$row->check()) {
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}

		// Store the web link table to the database
		if (!$row->store()) {
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		$cids = JFactory::getApplication()->input->get( 'attributes', array(0), 'post', 'array' );
		$categoryId = JFactory::getApplication()->input->get( 'id', 0);
		$pic_name = JFactory::getApplication()->input->get( 'pic_name', 0 );

		if(empty($categoryId) || $categoryId==0)
			$categoryId = $row->id;
		$this->id= $categoryId;
		
		$this->saveCategoryAttributes($categoryId,$cids);
		$this->saveCategoryPicture($categoryId,$pic_name);

		return true;
	}

	function saveCategoryPicture($categoryId,$pic_name){
		
		$table = $this->getTable('categorypictures');

		if(isset($categoryId)&&($pic_name)){
			if(!$table->deleteCategoryPictures($categoryId)){
				$application = JFactory::getApplication();
				$application->enqueueMessage( $table->getError(), 'error');
				return false;
				}			
				$table = $this->getTable('categorypictures');
				$table->category_id = $categoryId;
				$table->name = $pic_name;
				if(!$table->store()){
					$application = JFactory::getApplication();
					$application->enqueueMessage( $table->getError(), 'error');
					return false;
				}
			}
		return true;
	}

	function saveCategoryAttributes($categoryId,$attributes){
		
		$table = $this->getTable('categoryattributesmapping');

		if(isset($categoryId))
			if(!$table->deleteCategoryMappings($categoryId)){
				$application = JFactory::getApplication();
				$application->enqueueMessage( $table->getError(), 'error');
				return false;
			}
		if (count( $attributes )>0) {
			foreach($attributes as $cid) {
				$table = $this->getTable('categoryattributesmapping');
				$table->category_id = $categoryId;
				$table->attribute_id = $cid;
				if(!$table->store()){
					$application = JFactory::getApplication();
					$application->enqueueMessage( $table->getError(), 'error');
					return false;
				}
			}
		}
		return true;
	}

	function initSearchFilter(){
	
		$post =  JFactory::getApplication()->input->get->getArray();
		$searchFilter = new stdClass();
		$searchFilter->filter_name = JFactory::getApplication()->input->get("filter_name","");
		$searchFilter->filter_status = JFactory::getApplication()->input->get("filter_status","-1");
		return $searchFilter;
	}


	function getHierarchyCategories ($searchFilter) {
		$row =$this->getTable();
		$categories = $row->getHierarchyCategories($searchFilter,$this->getState('limitstart'),$this->getState('limit'));
		$this->_total = $row->getCategoriesCount($searchFilter);
		return $categories;
	}



}
?>