<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
 
jimport('joomla.application.component.modeladmin');


class JClassifiedsManagerModelCategoryAttribute extends JModelAdmin
{ 

	/**
	 * Model context string.
	 *
	 * @var		string
	 */
	protected $_context		= 'com_jclassifiedsmanager.categoryattribute';


		/**
	 * Returns a Table object, always creating it
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  JTable	A database object
	*/
	public function getTable($type = 'CategoryAttributes', $prefix = 'Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the menu item form.
	 *
	 * @param   array  $data		Data for the form.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		//exit;
		// The folder and element vars are passed when saving the form.
		if (empty($data))
		{
			$item= $this->getItem();
			// The type should already be set.
		}
		// Get the form.
		$form = $this->loadForm('com_jclassifiedsmanager.categoryattribute', 'item', array('control' => 'jform', 'load_data' => $loadData), true);
		if (empty($form))
		{
			return false;
		}
		
		return $form;
	}

	function getAttribute()
	{
		// Load the data
		$row =$this->getTable();
		$attributeId = JFactory::getApplication()->input->get('id',0);
		$row->load($attributeId);
		return $row;
	}
	
	function getAttributeOptions(){
		$row =$this->getTable();
		$id = JFactory::getApplication()->input->get("id",0);
		$attributeOptions = $row->getAttributeOptions($id);
		return $attributeOptions;
	}
	function getAttributeTypes(){
		$row =$this->getTable('ManageCategoryAttributeTypes');
		$attributeTypes = $row->getAttributeTypes();
		return $attributeTypes;
	}
	function getAttributeType($id){
		$row =$this->getTable('ManageCategoryAttributeTypes');
		$attributeTypes = $row->getAttributeType($id);
		return $attributeTypes;
	}

	function store( $data )
	{	
		$row =$this->getTable();
		// Bind the form fields to the table
		if (!$row->bind($data)) 
		{
			$this->setError($row->getError());
			return false;
		}
		// Make sure the record is valid
		if (!$row->check()) {
			$this->setError($row->getError());
			return false;
		}

		// Store the web link table to the database
		if (!$row->store()) {
			$this->setError( $row->getError() );
			return false;
		}
		$this->id = $row->id;
		$data['id'] = $row->id;
		if(!$this->saveAttributeOptions($data))
			return false;
		return true;
	}
	
	function saveAttributeOptions($data){
		$rowOpt =$this->getTable("managecategoryattributeoptions");
		$rowOpt->deleteAllAtributeOptions($data['id']);
		$optionsArray = $data['option_name'];
		
		foreach ($optionsArray as $key=>$value){
			$rowOpt =$this->getTable("managecategoryattributeoptions");
			$rowOpt->name = $value;
			$rowOpt->attribute_id = $data['id'];
			if (!$rowOpt->store()) {
				$application = JFactory::getApplication();
				$application->enqueueMessage( $rowOpt->getError(), 'error');
				return false;
			}
		}
		return true;
	}


}
?>