<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.model'); 

class JClassifiedsManagerModelCategoryAttributes extends JModelLegacy
{ 
	function __construct()
	{
		parent::__construct();
		$mainframe = JFactory::getApplication();
		
		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart = JFactory::getApplication()->input->getInt('limitstart', 0, '', 'int');
		
		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		$this->_total = 0;
	}
	function initSearchFilter(){
	
		$post =  JFactory::getApplication()->input->get->getArray();
		$searchFilter = new stdClass();
		$searchFilter->filter_name = JFactory::getApplication()->input->get("filter_name","");
		$searchFilter->filter_status = JFactory::getApplication()->input->get("filter_status","-1");
		return $searchFilter;
	}


	function getAllAttributes($searchFilter){
		$row =$this->getTable();
		$attributes = $row->getAllAttributes($searchFilter);
		return $attributes;
	}
	function getPagination()
	{
		// Load the content if it doesn't already exist
		if (empty($this->_pagination)) {
			$this->_pagination = new JPagination($this->_total, $this->getState('limitstart'), $this->getState('limit') );
		}
		return $this->_pagination;
	}
	
	function changeStatus($post){
		$attrIds = implode(',',$post);
		$row =$this->getTable();
		if(!$row->changeStatus($attrIds)){
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		return true;
	}
	
	function publish($post){
		$attrIds = implode(',',$post['cid']);
		if (!$attrIds) {
			return false;
		}
		$row =$this->getTable();
		if(!$row->publishItems($attrIds)){
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		return true;
	}
	function unpublish($post){
		$attrIds = implode(',',$post['cid']);
		if (!$attrIds) {
			return false;
		}
		$row =$this->getTable();
		if(!$row->unpublish($attrIds)){
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		return true;
	}


	function deleteAttributes($post){
		$attrIds = implode(',',$post['cid']);

		$rowOpt =$this->getTable("managecategoryattributeoptions");
		$rowOpt->deleteAllAtributeOptions($attrIds);
		
		$row =$this->getTable();
		if(!$row->deleteAllAtributes($attrIds)){
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		return true;
	}

}
?>