<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.model');

class JClassifiedsManagerModelCurrencies extends JModelLegacy
{
	function __construct()
	{
		parent::__construct();
		$mainframe = JFactory::getApplication();
		
		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart = JFactory::getApplication()->input->getInt('limitstart', 0, '', 'int');
		
		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		$this->_total = 0;
	}
	function getAllCurrencies()
	{
		// Load the data
		$row =$this->getTable();
		$currencies = $row->getAllCurrencies();
		$this->_total = count($currencies);
		return $currencies;
	}
	
	function getPagination()
	{
		// Load the content if it doesn't already exist
		if (empty($this->_pagination)) {
			$this->_pagination = new JPagination($this->_total, $this->getState('limitstart'), $this->getState('limit') );
		}
		return $this->_pagination;
	}

	
	function delete($post){
		$currenciesIds = implode(',',$post['cid']);
		$row =$this->getTable();
		if(!$row->deleteAllCurrencies($currenciesIds)){
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		return true;
	}
	function changeDefault($post){
		$id = $post['cid'][0];
		$row =$this->getTable();
		$row->resetDefault($id);
		if(!$row->changeDefault($id)){
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		return true;
	}
	
	

}
?>