<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');
jimport('joomla.html.pagination');

class JClassifiedsManagerModelDisplayAds extends JModelLegacy
{
	function __construct()
	{
		parent::__construct();
		$mainframe = JFactory::getApplication();
		
		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart = JFactory::getApplication()->input->getInt('limitstart', 0, '', 'int');
		
		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		$this->_total = 0;
	
	}
	function getParentCategories()
	{
		// Load the data
		$row = $this->getTable('categories');
		$categories = $row->getParentCategoriesWithCount();
		return $categories;
	}
	function getSelectedCategory()
	{
		// Load the data
		$row = $this->getTable('categories');
		$categoryId = JFactory::getApplication()->input->get('categoryId',0);
		$row->load($categoryId);
		return $row->name;
	}
	
	
	function getAllAds(){
		$row = $this->getTable('manageads');
		$ads = $row->getAllAds();
		$this->_total = count($ads);
		return $ads;
		
	}
	function getAllAdTypes(){
		// Load the data
		$row = $this->getTable('manageadtypes');
		$categories = $row->getAllAdTypes();
		return $categories;
	}
	function getAdType(){
		// Load the data
		$row = $this->getTable('manageadtypes');
		$adTypeId = JFactory::getApplication()->input->get('adtype',1);
		$adType = $row->getAdType($adTypeId);
		return $adType;
	}
	
	
	function getAllCurrencies(){
		// Load the data
		$row = $this->getTable('currencies');
		$currencies = $row->getAllCurrencies();
		return $currencies;
	}
	
	function getAllUserTypes(){
		// Load the data
		$row = $this->getTable('manageusertypes');
		$userTypes = $row->getAllUserTypes();
		return $userTypes;
	}
	function getJSONSubCategories(){
		$categoryId = JFactory::getApplication()->input->get('category_id');
		if(isset($categoryId)){
			$row = $this->getTable('categories');
			$categories = $row->getSubCategories($categoryId);
			return json_encode($categories);
		}
		return null;
	}
	
	#get category attributes function 
	function getAjaxCategoryAttributes(){
		$categoryId = JFactory::getApplication()->input->get('category_id');
		if(isset($categoryId)){
			$row =$this->getTable('categoryattributes');
			$categoryAttributes = $row->getCategoryAttributes($categoryId);
			return $categoryAttributes;
		}
		return "";
	}
	function renderFilterAttributes($categoryAttributes)
	{
		include 'components/com_jclassifiedsmanager/classes/attributeRenderer.php';
		$attributeRenderer= new attributeRenderer();
		$content = $attributeRenderer->renderFilterAttributes($categoryAttributes);
		return $content;
	}
	function renderFilteredGalleryAds(){
		$stateId = JFactory::getApplication()->input->get('stateId');
		if(isset($stateId)){
			$row =$this->getTable('manageads');
			$ads = $row->getGalleryAds($stateId);
			if(count($ads)>0)
				$content = $this->renderGalleryAdsContent($ads);
			else 
				$content = JText::_("LNG_ADS_NOT_FOUND");;
		}
		return $content;
	}
	
	function renderGalleryAdsContent($ads){
	
		$content ='';
		
		foreach ($ads as $ad){
			if(count($ad->picture_id)==0)
				$ad->picture_id = "no_image.jpg";
			$content .= "<div id='adGallery'>";
            $content .= "<a href='".JRoute::_( "index.php?option=".JAdUtils::getExtensionName()."&controller=displayads&view=displayads&task=viewad&id=". $ad->id."&categoryId=". $ad->category_id."&adtype=". $ad->ad_type_id."&stateId=". $ad->state."&searchbar=". JFactory::getApplication()->input->get("searchbar",""))."' title='".JText::_('LNG_CLICK_TO_VIEW')."'>
					 <div class='photo'><span></span><a href='".JRoute::_( "index.php?option=".JAdUtils::getExtensionName()."&controller=displayads&view=displayads&task=viewad&id=". $ad->id."&categoryId=". $ad->category_id."&adtype=". $ad->ad_type_id."&stateId=". $ad->state."&searchbar=". JFactory::getApplication()->input->get("searchbar",""))."' rel='".JURI::root()."components/com_jclassifiedsmanager/imageupload/uploaded_images/med_".$ad->picture_id."' class='zoomple'><img style='width:130px;height:100px;'  src='".JURI::root()."components/com_jclassifiedsmanager/imageupload/uploaded_images/thumb_".$ad->picture_id."'></a></div>";
			$content .= "<div id='galleryAdDesc'>".substr($ad->title,0,20)."...</div> <div id='galleryAdPrice'>".$ad->price." ".$ad->currency."</div>";
			$content .= "</a></div>";
		}
		return $content;
	}
	 
	
	function getDefaultCurrency(){
		$currencyTable =$this->getTable('currencies');
		$currency = $currencyTable->getDefaultCurrency();
		return $currency;
	}
	
	function renderFilteredAds()
	{
		$filterParams =  array();
		$filterParams['attrOptions'] = JFactory::getApplication()->input->get('attributeOptions',0);
		$filterParams['adType'] = JFactory::getApplication()->input->get('adType',1);
		$filterParams['priceLow'] = JFactory::getApplication()->input->get('priceLow',null);
		$filterParams['priceHigh'] = JFactory::getApplication()->input->get('priceHigh',null);
		$filterParams['stateId'] = JFactory::getApplication()->input->get('stateId',null);
		$filterParams['categoryId']= JFactory::getApplication()->input->get('categoryId',null);
		$filterParams['searchKeyword']= JFactory::getApplication()->input->get('searchKeyword',null);
		$filterParams['limit']= JFactory::getApplication()->input->get('limit',null);
		$filterParams['limitStart']= JFactory::getApplication()->input->get('limitStart',null);
		$filterParams['sortBy']= JFactory::getApplication()->input->get('sortAdsBy',null);
		$filterParams['sliderAttributes']= $this->processSliderAttributes(JFactory::getApplication()->input->get('sliderAttributes',null));
		$filterParams['userTypeId']= JFactory::getApplication()->input->get('userTypeId',null);
		$filterParams['categoryLevel'] = 1;
		
		$catTable =$this->getTable('categories');
		if($filterParams['categoryId']!=null)
			$filterParams['categoryLevel'] = $catTable->getCategoryLevel($filterParams['categoryId']);
		
		$adsTable =$this->getTable('manageads');
		$ads = $adsTable->searchAds($filterParams);
		$content = JText::_("LNG_SEARCH_CRITERIA_NOT_FOUND");
		if(count($ads['records'])>0){
			$content = $this->renderAdsContent($ads['records']);
			$content['total'] =$ads['total'];
			$content = json_encode($content);
		}
		else{ 
			$dataEmpty = array();
			$dataEmpty['content'] = JText::_("LNG_SEARCH_CRITERIA_NOT_FOUND");
			$dataEmpty['total'] = 0;
			$data['min'] =50;
			$data['max'] =1000;
			$content = json_encode($dataEmpty);
		}			
		return $content;
	}
	function processSliderAttributes($attributes){
		$processedArray = array();
		if(strlen($attributes)>0){
			$attributesArray = explode(",",$attributes);
			foreach($attributesArray as $key=>$attrib) {
				$processedArray[$key] = explode("|",$attrib);
			}
		}
		return $processedArray;
	}
	
	function renderAdsContent($ads){
		$minimum = $maximum = $ads[0]->price;
		$sortBy = JFactory::getApplication()->input->get('sortBy',null);
		
		$data = array();
		$content = '<table class="adsTable">';
		$content .= '<tr><td colspan="6" align="right">'.JText::_("LNG_SORT_BY").': <select onChange="sortAds(this.value)" id="sortAdsBy" name="sortAdsBy"><option value="creation_date desc" '. ($sortBy=="creation_date desc"?'selected':'').' >'. JText::_("LNG_NEWEST_ADS").'</option><option value="price asc" '.($sortBy=="price asc"?'selected':'').'>'. JText::_("LNG_CHEAPEST_ADS").'</option><option value="price desc" '.($sortBy=="price desc"?'selected':'').'>'. JText::_("LNG_PRICIER_ADS").'</option><select></td></tr>';
		
		foreach ($ads as $key=>$ad){
			if(count($ad->picture_id)==0)
				$ad->picture_id = "no_image.jpg";
				
			$content .= "<tr>";
			$content .= "<td><a href='".JRoute::_( "index.php?option=".JAdUtils::getExtensionName()."&controller=displayads&view=displayads&task=viewad&id=". $ad->id."&categoryId=". $ad->category_id."&adtype=". $ad->ad_type_id."&stateId=". $ad->state."&searchbar=". JFactory::getApplication()->input->get("searchbar",""))."' title='".JText::_('LNG_CLICK_TO_VIEW')."'><div class='photo'><span></span><img width='110px' height='100px' src='".JURI::root()."components/com_jclassifiedsmanager/imageupload/uploaded_images/thumb_".$ad->picture_id."'></div></a></td>";
			$content .= "<td colspan='2'><a href='".JRoute::_( "index.php?option=".JAdUtils::getExtensionName()."&controller=displayads&view=displayads&task=viewad&id=". $ad->id."&categoryId=". $ad->category_id."&adtype=". $ad->ad_type_id."&stateId=". $ad->state."&searchbar=". JFactory::getApplication()->input->get("searchbar",""))."' title='".JText::_('LNG_CLICK_TO_VIEW')."'><B>".$ad->title."</B></a>";
			$content .= " <br/> ".substr($ad->description, 0,75)."... <br/> <br/>".JText::_('LNG_CATEGORY').": <b>".$ad->category."</b>&nbsp;".JText::_('LNG_POSTED').": <b>".JAdUtils::getDateADFormat($ad->creation_date)."</b></td>"; 
			$content .= "<td><i>".$ad->price." ".$ad->currency."</i></td>";
			$content .= "<td>".$ad->city."</td>";
			$content .= "</tr>";
			 
			if ($minimum > $ad->price) {
				$minimum =  $ad->price;
			}
			if ($maximum < $ad->price) {
				$maximum = $ad->price;
			}
		}
		$content .= "</table>";
		$data['content'] =$content;
		$data['min'] =$minimum;
		$data['max'] =$maximum;

		return $data;
	}
	
	function renderFilteredCategories()
	{
		$filterParams['attrOptions'] = JFactory::getApplication()->input->get('attributeOptions',0);
		$filterParams['adType'] = JFactory::getApplication()->input->get('adType',1);
		$filterParams['priceLow'] = JFactory::getApplication()->input->get('priceLow',null);
		$filterParams['priceHigh'] = JFactory::getApplication()->input->get('priceHigh',null);
		$filterParams['stateId'] = JFactory::getApplication()->input->get('stateId',null);
		$filterParams['categoryId']= JFactory::getApplication()->input->get('categoryId',null);
		$filterParams['searchKeyword']= JFactory::getApplication()->input->get('searchKeyword',null);
		$filterParams['limit']= JFactory::getApplication()->input->get('limit',null);
		$filterParams['limitStart']= JFactory::getApplication()->input->get('limitStart',null);
	
	
		$adsTable =$this->getTable('manageads');
		$categories = $adsTable->getSearchCategories($filterParams);
		$content = JText::_("LNG_NO_CATEGORIES_FOUND");
		//print_r($categories);
		if(count($categories)>0)
		$content = $this->renderCategoryContent($categories,$filterParams['categoryId']);
		return $content;
	}

	function renderCategoryContent($categories,$selectedCategory){
	
		$content ='<div class="search-category-box">';
		$content .='<ul id="filterCategoryUl">';
		$prevMainCategory = "";
		$prevSubCategory = "";
		$prevSubCategory2 = "";
		$index = 0; 
		
		foreach ($categories as $filterCategory){
			$class="";
			$hasLeafs=false;
			

			if($prevMainCategory!=$filterCategory->main_category_id){	
				if($filterCategory->main_category_id == $selectedCategory)
					$class='class="selectedlink"';
				if(isset($categories[$index+1]) && $categories[$index+1]->main_category_id==$filterCategory->main_category_id)
					$hasLeafs=true;
				
				$content .='<li id="cat'.$filterCategory->main_category_id.'" onclick="removeSelectedCategory();this.addClass(\'selectedlink\');" '.$class.'><div>';  	 										
				$content .='<a class="categoryLabel" href="javascript:void(0)" onclick="getCategoryAttributes('.$filterCategory->main_category_id.'); "><div class="catFilterLabel">'.$filterCategory->catname.'('.$filterCategory->countCat.')</div></a>';
				if($hasLeafs==true)
					$content .='<a href="javascript:void(0)" onclick="displaySubCat(\'cat'.$filterCategory->main_category_id.'\',1); "><div id="categoryExpand" class="closed">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div> </a>';
		
				$content .='</li>';
				$prevMainCategory = $filterCategory->main_category_id;
			}
			else if ($prevSubCategory!=$filterCategory->firstSub){
				$class='class="firstSub"';
				if(isset($categories[$index+1]) && $categories[$index+1]->firstSub==$filterCategory->firstSub)
					$hasLeafs=true;
				
				if($filterCategory->firstSub == $selectedCategory)
					$class='class="selectedlink firstSub"';
				$content .='<li id="cat'.$filterCategory->main_category_id.'_'.$filterCategory->subCategoryId.'" onclick="removeSelectedCategory();this.addClass(\'selectedlink\');" '.$class.'>';
				$content .='<a href="javascript:void(0)" onclick="getCategoryAttributes('.$filterCategory->subCategoryId.'); "><div class="catFilterLabel">'.$filterCategory->firstSub.'('.$filterCategory->countCat.')</div></a>';
				if($hasLeafs==true)
					$content .='<a href="javascript:void(0)" onclick="displaySubCat(\'cat'.$filterCategory->subCategoryId.'\',2); "><div id="categoryExpand" class="closed">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div> </a>';
				
				$content .='</div></li>';
				$prevSubCategory = $filterCategory->firstSub;
			}
			else if($prevSubCategory2!=$filterCategory->secondSub){
				$class='class="secondSub"';
				if($filterCategory->secondSub == $selectedCategory)
					$class='class="selectedlink secondSub"';
				$content .='<li id="cat'.$filterCategory->main_category_id.'_'.$filterCategory->subCategoryId.'_'.$filterCategory->secondSubId.'" onclick="removeSelectedCategory();this.addClass(\'selectedlink\');" '.$class.'>';
				$content .='<a href="javascript:void(0)" onclick="getCategoryAttributes('.$filterCategory->secondSubId.'); "><div class="catFilterLabel">'.$filterCategory->secondSub.'('.$filterCategory->countCat.')</div></a>';
				$content .='</li>';
				$prevSubCategory2 = $filterCategory->secondSub;
			}
			$index++;
		}
		$content .=  '</ul>';
		$content .=  '</div>';
		
		return $content;
	}
  
 	function getAdDetails(){
 		$adTable =$this->getTable('manageads');
 		$adId = JFactory::getApplication()->input->get("id",0);
 		$adDetails = $adTable->getAdDetailsDetailed($adId);
 		return $adDetails;
 	}
 	function getAllUserAds(){
 		$adTable =$this->getTable('manageads');
 		$userId = JFactory::getUser()->id;
 		$applicationSettings = getApplicationSettings();
 		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;
 		$adDetails = $adTable->getAllUserAds($userId,$validPeriod);
 		return $adDetails;
 	}
 	function sendAbuseEmail(){
 		try
 		{
 			$applicationSettings = getApplicationSettings();
 			$message = JFactory::getApplication()->input->get('abuseMessage',null);
 			$email = JFactory::getApplication()->input->get('reporterEmail',null);
 			$currentURL = urldecode(JFactory::getApplication()->input->get('currentURL',null));
 			
 			$emailBody =JText::_("LNG_ABUSE_NOTIFICATION")."<br/><br/>"; 
 			$emailBody .= JText::_("LNG_URL")." : ".$currentURL."<br/>";
 			$emailBody .= JText::_("LNG_FROM_EMAIL")." : ".$email."<br/>";
 			$emailBody .= JText::_("LNG_MESSAGE").":".$message."<br/>";
 			$mode		 = 1 ;//html
 			
			
 			// Send mail to administrator set in application settings
 			$result = JFactory::getMailer()->sendMail($applicationSettings->company_email, $applicationSettings->company_name,$applicationSettings->company_email,JText::_("LNG_ABUSE_REPORT_EMAIL") , $emailBody ,$mode);
 			if($result)
 				return JText::_("LNG_EMAIL_SENT");
 			else 
 				return JText::_("LNG_ERROR_SENDING_EMAIL");
 		}
 		catch (Exception $e){
 			print_r($e);
 			exit;
 		}
 			
 	}
 	function sendEmailToFriend(){
 		try
 		{
 			$applicationSettings = getApplicationSettings();
 			$message = JFactory::getApplication()->input->get('message',null);
 			$email = JFactory::getApplication()->input->get('friendEmail',null);
 			$currentURL = JFactory::getApplication()->input->get('currentURL',null);

 			$emailBody =JText::_("LNG_RECOMMEND_NOTIFICATION")."<br/><br/>";
 			$emailBody .= JText::_("LNG_MESSAGE").":".$message."<br/>";
 			$emailBody .= JText::_("LNG_URL").":".$currentURL."<br/>";
 			$mode		 = 1 ;//html
 			
 			
 			// Send mail to administrator set in application settings
 			$result = JFactory::getMailer()->sendMail($applicationSettings->company_email, $applicationSettings->company_name,$email,JText::_("LNG_FRIEND_RECOMMENDED_EMAIL") , $emailBody,$mode );
 			if($result)
 				return JText::_("LNG_EMAIL_SENT");
 			else
 				return JText::_("LNG_ERROR_SENDING_EMAIL");
 		}
 		catch (Exception $e){
 			print_r($e);
 			exit;
 		}
 	
 	}
 	function getGalleryAds(){
 		$adTable =$this->getTable('manageads');
 		$stateId = JFactory::getApplication()->input->get('stateId',null);
 		$ads = $adTable->getGalleryAds($stateId);
 		return $ads;
 	}
 	function setViewCounter($ads){
 		$adTable =$this->getTable('manageads');
 		$arrayIds = array();
 		foreach($ads as $ad){
 		 array_push($arrayIds, $ad->id);
 		}
 		$adIds = implode(",", $arrayIds);
 		if(strlen($adIds)>0){
 		if(!$adTable->setViewCounter($adIds)) 
 			return false;
 		else 
 			return true;
 		}
 		return false;
 	}
 	
}