<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.modeladmin');


class JClassifiedsManagerModelEmailTemplate extends JModelAdmin
{ 

	/**
	 * Returns a Table object, always creating it
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  Table	A database object
	*/
	public function getTable($type = 'EmailTemplates', $prefix = 'Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the menu item form.
	 *
	 * @param   array  $data		Data for the form.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		//exit;
		// The folder and element vars are passed when saving the form.
		if (empty($data))
		{
			$item= $this->getItem();
			// The type should already be set.
		}
		// Get the form.
		$form = $this->loadForm('com_jclassifiedsmanager.emailtemplate', 'item', array('control' => 'jform', 'load_data' => $loadData), true);
		if (empty($form))
		{
			return false;
		}
		
		return $form;
	}


	function __construct()
	{
		parent::__construct();
		$array 	= JFactory::getApplication()->input->get('email_id',  0, '', 'array');
		if(isset($array[0])) $this->setId((int)$array[0]);
		$this->_data		= false;
			
	}
	function setId($email_id)
	{
		// Set id and wipe data
		$this->_email_id		= $email_id;
		$this->_data			= null;
	}
	
	
	function &getData()
	{
		// Load the data
		if (!empty( $this->_email_id )) 
		{
			$query = 	' SELECT * FROM #__classifiedsmanager_emails'.
						' WHERE email_id = '.$this->_email_id;
			
			$this->_db->setQuery( $query );
			$this->_data = $this->_db->loadObject();
					
					
		}
		
		if ( !$this->_data ) 
		{
			$this->_data = new stdClass();
			$this->_data->email_id 				= null;
			$this->_data->email_name			= null;
			$this->_data->email_subject			= null;
			
			$this->_data->email_type			= null;			
			$this->_data->email_content			= null;			
			$this->_data->is_default			= null;
			
		}

		return $this->_data;
	}

	function store($data)
	{	
		$row =$this->getTable();

		// Bind the form fields to the table
		if (!$row->bind($data)) 
		{
			$this->setError($row->getError());
			return false;
		}
		// Make sure the record is valid
		if (!$row->check()) {
			$this->setError($row->getError());
			return false;
		}

		// Store the web link table to the database
		if (!$row->store()) {
			$this->setError( $row->getError() );
			return false;
		}
		$this->email_id = $row->email_id;
		return true;
	}
}
?>