	
<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.model'); 

class JClassifiedsManagerModelJClassifiedsManager extends JModelLegacy
{ 

	function getAdsCount()
	{
		// Load the data
		$row = $this->getTable('manageads');
		$ads = $row->getAdsCount();
		return $ads;
	}
	

	function getAdsCountMonth()
	{
		// Load the data
		$row = $this->getTable('manageads');
		$ads = $row->getAdsCountMonth();
		return $ads;
	}

	function getAdsViews()
	{
		// Load the data
		$row = $this->getTable('manageads');
		$ads = $row->getAdsViews();
		return $ads;
	}
	

	function getPromotedAdsCount()
	{
		// Load the data
		$row = $this->getTable('manageads');
		$ads = $row->getPromotedAdsCount();
		return $ads;
	}

	function getPromotedAdsCountMonth()
	{
		// Load the data
		$row = $this->getTable('manageads');
		$ads = $row->getPromotedAdsCountMonth();
		return $ads;
	}


	function getTotalIncome()
	{
		// Load the data
		$row = $this->getTable('manageads');
		$ads = $row->getTotalIncome();
		
		return $ads;
	}

	function getMonthIncome()
	{
		// Load the data
		$row = $this->getTable('manageads');
		$ads = $row->getMonthIncome();
		
		return $ads;
	}


	


	/**
	 * 
	 */
	public function getServerNews() {
		$rss = new DOMDocument();
		$rss->load('https://www.cmsjunkie.com/news/rss/');

		$feeds = array();
		foreach ($rss->getElementsByTagName('item') as $node) {
			$item = array ( 
				'title' => $node->getElementsByTagName('title')->item(0)->nodeValue,
				'link' => $node->getElementsByTagName('link')->item(0)->nodeValue,
				'description' => $node->getElementsByTagName('description')->item(0)->nodeValue,
				'publish_date' => $node->getElementsByTagName('pubDate')->item(0)->nodeValue
			);
			array_push($feeds, $item);
		}
		return $feeds;
	}
	
	/**
	 * Get the latest news from local database and prepare them
	 * 
	 * @param unknown_type $limit
	 */
	public function getLocalNews($limit=3) {

		// $limit -> the limit of the news to be displayed in the dashboard

		$row =$this->getTable('rssnews');
		$news = $row->getLocalNews($limit);
		
		foreach($news as $item){
			$publish_ago = JAdsUtil::convertTimestampToAgo($item->publish_date); 
			$item->publish_ago = $publish_ago;
			$item->new = false;
			
			// $time = strftime('%Y-%m-%d',(strtotime('7 days ago')));
			$time = JFactory::getDate(strtotime('7 days ago'))->format('Y-m-d');

			// $retrieve_date = strftime('%Y-%m-%d',(strtotime($item->retrieve_date)));
			$retrieve_date = JFactory::getDate(strtotime($item->retrieve_date))->format('Y-m-d');
			//For 7 days from the moment of the retrieve_date the news will be displayed like NEW
			if($time < $retrieve_date) {
				$item->new = true;
			}
			
			$item->description = mb_strimwidth(strip_tags($item->description), 0, 200, '...');
			$item->publishDateS = date('l, M d, Y', strtotime($item->publish_date));
		}
		
		return $news;
	}


	
	/**
	 * Get the latest news from server and store the new ones
	 * 
	 */
	public function getLatestServerNews() {

		$row =$this->getTable('rssnews');
		$lastNews = $row->getLocalLastNews();

		if (empty($lastNews)) {
			$serverNews = $this->getServerNews();
			$this->storeNews($serverNews);
		}else{
			$days_ago = NEWS_REFRESH_PERIOD; // refresh records after specified days
			$check_date = date('Y-m-d H:i:s',(strtotime($days_ago.' days ago')));
			$lastNewsRetrieveDate = date('Y-m-d H:i:s', strtotime($lastNews->retrieve_date));
			
			if($check_date > $lastNewsRetrieveDate) {
				$serverNews = $this->getServerNews();
				$localNews = $this->getLocalNews();
	
				$feeds = array();
				foreach($serverNews as $singleServerNews) {
					$title = str_replace(' & ', ' &amp; ', $singleServerNews['title']);
					$link = $singleServerNews['link'];
					$description = $singleServerNews['description'];
					$publish_date = date('Y-m-d H:i:s', strtotime($singleServerNews['publish_date']));
	
					$flag = true;
					foreach ($localNews as $singleLocalNews) {
						$singleLocalNews_publish_date = date('Y-m-d H:i:s', strtotime($singleLocalNews->publish_date));
						if($publish_date == $singleLocalNews_publish_date) {
							$flag = false;
						}
					}
	
					if($flag) {
						$item = array ( 
							'title' => $title,
							'link' => $link,
							'description' => $description,
							'publish_date' => $publish_date
						);
						array_push($feeds, $item);
					}
				}
	
				//if there are new news store them
				if(!empty($feeds)) {
					$this->storeNews($feeds);
					return $this->getLocalNews(3);
				}
			}
		}
	}

	/**
	 * Store the news into database
	 * 
	 * @param unknown_type $feeds
	 */
	public function storeNews($feeds) {
		foreach($feeds as $feed) {
			$title = str_replace(' & ', ' &amp; ', $feed['title']);
			$link = $feed['link'];
			$description = $feed['description'];
			$publish_date = date('Y-m-d H:i:s', strtotime($feed['publish_date']));
			$retrieve_date = date('Y-m-d H:i:s');

			$item = new stdClass();
			$item->title = $title;
			$item->link = $link;
			$item->description = $description;
			$item->publish_date = $publish_date;
			$item->retrieve_date = $retrieve_date;
			
			$result = JFactory::getDbo()->insertObject('#__classifiedsmanager_news', $item);
		}
	}


}
?>