<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access

defined('_JEXEC') or die( 'Restricted access' );
jimport('joomla.filesystem.file');
jimport('joomla.application.component.model');

class JClassifiedsManagerModelLanguage extends JModelLegacy
{

	function __construct()
	{
		parent::__construct();
	}

	function getData()
	{
		// Load the data
	}

    /**
     * @param $string
     * @return string
     * Function to check and format the content to UTF-8 Encoding
     */
    private function make_safe_for_utf8_use($string) {
        $encoding = mb_detect_encoding($string, "UTF-8,WINDOWS-1252");

        if ($encoding != 'UTF-8') {
            return iconv($encoding, 'UTF-8//TRANSLIT', $string);
        } else {
            return $string;
        }
    }

    /**
     * @param $array1
     * @param $array2
     * @return array
     * Method that takes two arrays and return the uniqie array
     */
    private function uniqueValues($array1,$array2)
    {
        $finalArray = array();
        if (!empty($array1)) {
            foreach ($array1 as $k => $value) {
                foreach ($array2 as $key => $values) {
                    $value2 = preg_replace('/([\r\n\t])/','', $values);
                    if ($value == $value2) {
                        $finalArray[$key] = $value2;
                    }
                }
            }
        }

        $a = array_diff($array1,$finalArray);
        $b = array_diff($finalArray,$array1);
        $c = array_merge($a,$b);

        return array_unique($c);
    }

    /**
     * @param $code
     * @return mixed
     * Method to save the language files
     */
    function saveLanguage($code)
    {
        set_time_limit(300);
        $content = JFactory::getApplication()->input->get('content', '', 'RAW');
        $custom_content = JFactory::getApplication()->input->get('custom_content', '', 'RAW');
        $app = JFactory::getApplication();

        if (empty($code)) {
            $app->enqueueMessage(JText::_('Code not specified', true));
            return;
        }


        $path = JPATH_COMPONENT_ADMINISTRATOR.DS.'language'.DS.$code.DS.$code.'.'.getAdComponentName().'.ini';
        $newPath = JPATH_COMPONENT_ADMINISTRATOR.DS.'language'.DS.$code.DS.$code.'-custom.'.getAdComponentName().'.ini';

        //save the language file 
        if(file_exists($path)) {
            if (!empty($content)){

                $content = $this->make_safe_for_utf8_use($content);

                JFile::write($path,$content);
                $msg = JText::_('LNG_SETTINGS_APPLICATION_SAVED', true);
            }else{
                $msg = JText::_('LNG_LANGUAGE_SUCCESSFULLY_SAVED', true);
            }
        } else {
            $app->enqueueMessage('File not found : '.$path);
            $msg = $app->enqueueMessage(JText::_('LNG_ERROR_SAVING_SETTINGS_APPLICATION', true),'error');
        }


        $formattedContentWithUTF8 = $this->make_safe_for_utf8_use($custom_content);

        $contentToSave = preg_split('/([\r\n\t])/', $formattedContentWithUTF8);
        $uniqueValues = array_unique($contentToSave);

        //check if the costum file already exists 
        switch(file_exists($newPath)){
            case false:
                if (!empty($custom_content) && $custom_content!='') { 
                    //save the costum content in the existing file
                    foreach ($uniqueValues as $k => $value) {
                        if($k == 0 ) {
                            $firstValue = $uniqueValues[0];
                            $firstValue = PHP_EOL.$firstValue.PHP_EOL;
                            $this->fileAppend($path,$firstValue);
                        } else if($k  >= 1) {
                            $formatedContent = $value.PHP_EOL;
                            $this->fileAppend($path,$formatedContent);
                        }
                    }
                    JFile::write($newPath,$formattedContentWithUTF8);
                    $msg = JText::_('LNG_SETTINGS_APPLICATION_SAVED', true);
                }
                break;

            case true:
                if (!empty($custom_content) && !empty($uniqueValues)) {
                    //save the costum content in the new file
                    $fileValues = file($newPath);
                    $array = $this->uniqueValues($uniqueValues,$fileValues);
                    foreach ($array as $k => $value) {
                        if($k == 0 ) {
                            $firstValue = $array[0];
                            $firstValue = PHP_EOL.$firstValue.PHP_EOL;
                            $this->fileAppend($path,$firstValue);
                        } else if($k  >= 1) {
                            $formatedContent = $value.PHP_EOL;
                            $this->fileAppend($path,$formatedContent);
                        }
                    }
                    JFile::write($newPath,$formattedContentWithUTF8);
                    $msg = JText::_('LNG_SETTINGS_APPLICATION_SAVED', true);

                }
                if(empty($custom_content) || $custom_content==''){
                    $delete = $this->deleteFile($newPath);
                    $msg = JText::_($delete, true);
                }
                break;

            default:
                $app->enqueueMessage('File not found : '.$newPath);
                $msg = $app->enqueueMessage(JText::_('LNG_ERROR_SAVING_SETTINGS_APPLICATION', true),'error');
                break;

        }
        set_time_limit(60);
        return $msg;
    }

	function getFile(){
		$app =JFactory::getApplication();
		$code = JFactory::getApplication()->input->getString('code');
		if(empty($code)){
			$app->enqueueMessage(JText::_('Code not specified',true));
			return;
		}
	
		$file = new stdClass();
		$file->name = $code;
		
		$path = JPATH_COMPONENT_ADMINISTRATOR.DS.'language'.DS.$code.DS.$code.'.'.getAdComponentName().'.ini';
        $customPath = JPATH_COMPONENT_ADMINISTRATOR.DS.'language'.DS.$code.DS.$code.'-custom.'.getAdComponentName().'.ini';
		$file->path = $path;
        $file->customPath = $customPath;
	
		jimport('joomla.filesystem.file');
		$showLatest = true;
		$loadLatest = false;

		

		if(JFile::exists($path)){
			$file->content = file_get_contents($path);
			if(empty($file->content)){
				$app->enqueueMessage('File not found : '.$path);
			}
		} else{
			$loadLatest = true;
			$file->content = file_get_contents(JPATH_COMPONENT_ADMINISTRATOR.DS.'language'.DS.'en-GB'.DS.'en-GB.'.getAdComponentName().'.ini');
		}


        if(JFile::exists($customPath)){
            $file->custom_content = file_get_contents($customPath);
            if(empty($file->custom_content)){
                $app->enqueueMessage('File not found : '.$customPath);
            }

        }else{
            $file->custom_content = " ";
        }
		// $this->assignRef('file',$file);
		return $file;
	}
    
    /**
     * @param $code
     * @return mixed
     * Method sent the language files .ini and .sys.ini 
     */
    function send_email($code) {

        $subject = "New language proposal for J-ClassifiedsManager -  $code";
        $body = "Hi,<br/><br/>Please find attached the language files for $code language.";
        $to = LANGUAGE_RECEIVING_EMAIL;

        # Invoke JMail Class
        $mailer = JFactory::getMailer();
        $mailer->addRecipient($to);
        $mailer->setSubject($subject);
        $mailer->setBody($body);

        $mailer->isHTML(true);

        // gets the path of the language files
        $languageFile = JPATH_COMPONENT_ADMINISTRATOR.DS.'language'.DS.$code.DS.$code.'.'.getAdComponentName().'.ini';
        $systemLanguageFile = JPATH_COMPONENT_ADMINISTRATOR.DS.'language'.DS.$code.DS.$code.'.'.getAdComponentName().'.sys.ini';

        //attach the files on the email 
        if (file_exists($languageFile)) { $mailer->addAttachment($languageFile); }
        if (file_exists($systemLanguageFile)) { $mailer->addAttachment($systemLanguageFile); }

        if( $mailer->send() ) {
            $msg = JText::_('LNG_LANGUAGE_FILES_SUCCESSFULLY_SEND', true);
        } else {
            $msg = JText::_('LNG_SOMETHING_WENT_WRONG', true);
        }
        return $msg;
    }

    /**
     * @param $code
     * @return mixed
     * Method to delete a language folder from the language directory 
     */
    function deleteFolder($code) {
        $deleteFolder = JFolder::delete(JPATH_COMPONENT_ADMINISTRATOR.DS.'language'.DS.$code);
        if($deleteFolder) {
            $msg = JText::_('LNG_LANGUAGE_PACK_SUCCESSFULLY_DELETED', true);
        } else {
            $msg = JText::_('LNG_LANGUAGE_PACK_NOT_DELETED', true);
        }
        return $msg;
    }

    /**
     * @param $absolutePath
     * @param $contentt
     * @return bool
     *
     * Method to create or write a file the custom translation content
     */
    protected function fileWriteCreate($absolutePath, $contentt)
    {
        //chmod($absolutePath,0777);
        $newFilePath = fopen($absolutePath, 'w') or die("Could not open or create file!");
        // Read/write functions with write/create new file
        fwrite($newFilePath, $contentt);
        fclose($newFilePath);
        //chmod($absolutePath,0755);
        return true;
    }

    /**
     * @param $path
     * @param $content
     * @return bool
     * Function to append/override translation Values
     */
    protected function fileAppend($path, $content)
    {
        //chmod($path,0777);
        $filePath = fopen($path, 'a+') or die("Could not open the file!");
        // Read/write functions with write/create new file
        fwrite($filePath, $content);
        fclose($filePath);
        //chmod($path,0755);
        return true;
    }

    /**
     * @param $path
     * @return string
     * Method to unlink or delete the file if the content is left empty
     */
    protected function deleteFile($path)
    {
        if(unlink($path)) {
            return 'Custom Language Values deleted';
        }
        else {
            return 'Unable to delete Custom Language Values in file:'.$path;
        }
    }
}
?>