<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.model'); 
require_once( JPATH_COMPONENT_SITE.'/models/editad.php' );
require_once 'components/com_jclassifiedsmanager/models/orders.php';

class JClassifiedsManagerModelManageAd extends JClassifiedsManagerModelEditAd
{



	function __construct()
	{
		parent::__construct();
		$this->log = Logger::getInstance();
	}
	function getEditions(){
 		
 		$result = $this->_getList("SHOW TABLES LIKE '%editions%' ");
 		$tableExists = count($result) > 0;
 		$editions = array();
 	
 		if($tableExists){
	 		$query = ' SELECT * from #__editions';
			$editions = $this->_getList( $query );
 		}
 		return $editions;
 	}


	function getParentCategories()
	{
		// Load the data
		$row =$this->getTable('categories');
		$categories = $row->getParentCategories();
		return $categories;
	}
	function getAllAdTypes(){
		// Load the data
		$row = $this->getTable('manageadtypes');
		$categories = $row->getAllAdTypes();
		return $categories;
	}
	function getAllCurrencies(){
		// Load the data
		$row = $this->getTable('currencies');
		$currencies = $row->getAllCurrencies();
		return $currencies;
	}
	
	function getAllUserTypes(){
		// Load the data
		$row = $this->getTable('manageusertypes');
		$userTypes = $row->getAllUserTypes();
		return $userTypes;
	}
	function getJSONSubCategories(){
		$categoryId = JFactory::getApplication()->input->get('category_id');
		if(isset($categoryId)){
			$row = $this->getTable('categories');
			$categories = $row->getSubCategories($categoryId);
			return json_encode($categories);
		}
		return null;
	}
	function checkUserAd($userId){
		$adId = JFactory::getApplication()->input->get("ad_id",0);
		$adTable =$this->getTable('manageads');
		$ads =$adTable->checkAdOwner($userId,$adId);
		if(count($ads)>0)
			return true;
		else 
			return false;
	}
	function uploadFiles(){
		
		include("components/com_jclassifiedsmanager/imageupload/includes/settings.php");
		include("components/com_jclassifiedsmanager/imageupload/includes/class_CRW.php");
		
		$uploaddir ="components/com_jclassifiedsmanager/imageupload/".$uploaddir;
		$uploadedFile = $uploaddir . basename($_FILES['uploadfile']['name']);
		$file_name=basename( $_FILES['uploadfile']['name']) ;
		$extension = substr($file_name, strrpos($file_name, "."));
		$extension = strtolower($extension);
		
		$resizer=new CRW();
		$new_name=$resizer->new_name();
		
		if (move_uploaded_file($_FILES['uploadfile']['tmp_name'], $uploadedFile)) {
		
			rename($uploadedFile, $uploaddir.$originalImagePrefix.$new_name.$extension);
			 
		
			foreach($formatsImages as $format)
			{
				$formatSplit=explode(',', $format);
				$prefix=$formatSplit[0];
				$newWidth=$formatSplit[1];
				$newHeight=$formatSplit[2];
				 
				if($action=="crop")
				{
					$resizer->cropImage($uploaddir, $originalImagePrefix.$new_name.$extension, $newWidth, $newHeight, $prefix,$new_name);
				}
				elseif($action=="resize"){
		
					$resizer->image_resize($uploaddir, $originalImagePrefix.$new_name.$extension, $newWidth,  $prefix, $new_name);
					 
				}
		
				/*++++++++++WATERMARK++++++++++++*/
				if ($watermarkIsActive == 1 && $newWidth>$minImageWidthForWatermark) {
					$resizer->watermarkImage($uploaddir .$prefix . $new_name . $extension, $watermarkImage, $watermarkPosition);
					 
				}
				/*+++++++++++WATERMARK++++++++++++++*/
		
		
			}
		
			echo $new_name.$extension;//output new image name
		} else {
			echo "error";
		}
	}
	
	#get category attributes function 
	function getAjaxCategoryAttributes(){
		$categoryId = JFactory::getApplication()->input->get('category_id');
		if(isset($categoryId)){
			$row =$this->getTable('categoryattributes');
			$categoryAttributes = $row->getCategoryAttributes($categoryId);
			return $categoryAttributes;
		}
		return "";
	}
	function renderCategoryAttributes($categoryAttributes,$adAttributes)
	{
		include 'components/com_jclassifiedsmanager/classes/attributeRenderer.php';
		$attributeRenderer= new attributeRenderer();
		$content = $attributeRenderer->renderAttributes($categoryAttributes,$adAttributes);
		return $content;
	}

 
 	function getAdId(){
 		return $this->ad_id;
 	}
 	
 	#get ad details
 	// function getAdDetails(){
 	// 	$adTable =$this->getTable('manageads');
 	// 	$adId = JFactory::getApplication()->input->get("ad_id",0);
 	// 	$adDetails = $adTable->getAdDetails($adId);
 	// 	return $adDetails;
 	// }
 	
 	#get ad attributes
 	function getAdAttributes(){
 		$adTableAttr =$this->getTable('manageadattributes');
 		$adId = JFactory::getApplication()->input->get("ad_id",0);
 		if(!is_numeric($adId))
 			$adId =0;
 		$adAttributes = $adTableAttr->getAdAttributes($adId);
 		return $adAttributes;
 	}
 	
 	function createJoomlaUser($name,$email){

 		//$acl = JFactory::getACL(); Acl will work only in Joomla1.5/1.6
 	
 		/* get the com_user params */
 		$mainframe = JFactory::getApplication('site');
 		$mainframe->initialise();
 		$config = JFactory::getConfig();

 		// "generate" a new JUser Object 			
 		$user = JFactory::getUser(0); // it's important to set the "0" otherwise your admin user information will be loaded
 		
 		$data = array(); // array for all user settings
 	
 		$usersParams = &JComponentHelper::getParams( 'com_users' ); // load the Params
 		$sendpassword = $usersParams->get('sendpassword', 1);
 		
 		$names = explode(" ",$name);
 		$firstname = $names[0]; // generate $firstname
 		if(isset($names[1]))
 		$lastname = $names[1]; // generate $lastname
 		else $lastname="";
 		$username = $email; // username is the same as email
 		
 		$data['fromname']	= $config->get('fromname');
 		$data['mailfrom']	= $config->get('mailfrom');
 		$data['sitename']	= $config->get('sitename');
 		$data['siteurl']	= JUri::root();
 	
 		//original logic of name creation
 		//$data['name'] = $firstname.' '.$lastname; // add first- and lastname
 		$data['name'] = $firstname." ".$lastname; // add first- and lastname
 	
 		$data['username'] = $username; // add username
 		$data['email'] = $email; // add email
 		//there's no gid field in #__users table from Joomla_1.7/2.5
 	
 		$usertype = 'Registered';//this is not necessary!!!
 		jimport('joomla.application.component.helper');
 		/* this part of the snippet from here: /plugins/user/joomla/joomla.php*/
 		$config = JComponentHelper::getParams('com_users');
 		// Default to Registered.
 		$defaultUserGroup = $config->get('new_usertype', 2);
 		//default to defaultUserGroup i.e.,Registered
 		$data['groups']=array($defaultUserGroup);
 		$data['password'] 	= JUserHelper::genRandomPassword(10);
 		$password = $data['password'];
 			
 			
 		//$data['password2'] = $password; // confirm the password
 		$data['sendEmail'] = 0; // should the user receive system mails?
 		
 		/* Now we can decide, if the user will need an activation */
 		$useractivation = $usersParams->get( 'useractivation' ); // in this example, we load the config-setting
 		//echo $useractivation;exit();
 		if ($useractivation == 1) {
 			// yeah we want an activation
 	
 			jimport('joomla.user.helper'); // include libraries/user/helper.php
 			$data['block'] = 1; // block the User
 			$data['activation'] =JApplicationHelper::getHash( JUserHelper::genRandomPassword() ); // set activation hash (don't forget to send an activation email)
 	
 		}
 		else { // no we need no activation
 	
 			$data['block'] = 0; // don't block the user
 			$data['activation'] = 0; //activate the user 
 		}
 		
 		if (!$user->bind($data)) {
 			// now bind the data to the JUser Object, if it not works....
 			throw new Exception(JText::_( $user->getError()));
 		
 		}
 		
 		if (!$user->save()) {
 			// if the user is NOT saved...
 			throw new Exception(JText::_( $user->getError()));
 		
 		}
 		
 		$uri = JURI::getInstance();
 		$base = $uri->toString(array('scheme', 'user', 'pass', 'host', 'port'));
 		$data['activate'] = $base.JRoute::_('index.php?option=com_users&task=registration.activate&token='.$data['activation'], false);
 		
 		$emailSubject	= JText::sprintf(
 						'COM_USERS_EMAIL_ACCOUNT_DETAILS',
 		$data['name'],
 		$data['sitename']
 		);
 		
 		if ($useractivation == 1) {
 			$emailSubject	= JText::sprintf(
 							'COM_USERS_EMAIL_ACCOUNT_DETAILS',
 			$data['name'],
 			$data['sitename']
 			);
 			
	 		if ($sendpassword)
	 		{
	 			$emailBody = JText::sprintf(
	 							'COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY',
	 			$data['name'],
	 			$data['sitename'],
	 			$data['siteurl'].'index.php?option=com_users&task=registration.activate&token='.$data['activation'],
	 			$data['siteurl'],
	 			$data['username'],
	 			$data['password_clear']
	 			);
	 		}
	 		else
	 		{
	 			$emailBody = JText::sprintf(
	 							'COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY_NOPW',
	 			$data['name'],
	 			$data['sitename'],
	 			$data['siteurl'].'index.php?option=com_users&task=registration.activate&token='.$data['activation'],
	 			$data['siteurl'],
	 			$data['username']
	 			);
	 		}
 		}
 		else
 		{
 		
			$emailSubject	= JText::sprintf(
 						'COM_USERS_EMAIL_ACCOUNT_DETAILS',
 			$data['name'],
 			$data['sitename']
 			);
 		
 			
 			$emailBody = JText::sprintf(
 						'COM_USERS_EMAIL_LOGIN_DETAILS',
 			$data['name'],
 			$data['sitename'],
 			$data['siteurl'].'index.php?option=com_users&task=login',
 			$data['username'],
			$password
 			);
 		}
 		
 		// Send the registration email.
 		$return = JFactory::getMailer()->sendMail($data['mailfrom'], $data['fromname'], $data['email'], $emailSubject, $emailBody);
 	
 	
 		return $user; // else return the new JUser object 	
 	}
 	function generatePassword($text, $is_cripted = false)
 	{
 		$password 	=  $text;
 		if( $is_cripted ==false )
 		return $password;
 			
 		$salt 		= JUserHelper::genRandomPassword(32);
 		$crypt 		= JUserHelper::getCryptedPassword($password, $salt);
 		$password 	= $crypt.":".$salt;
 		return $password;
 	}
 	function sendNotificationToAdmins($message){
 		try
 		{
	 		$applicationSettings = getApplicationSettings();
	 		$message= "There was an error in submitting an ad ".$message;
	 		
	 		// Send mail to administrator set in application settings 
			JFactory::getMailer()->sendMail($applicationSettings->company_email, $applicationSettings->company_name,$applicationSettings->company_email, "Error in submitting an add", $message );
	 	}
 		catch (Exception $e){
 			print_r($e);
 			exit;
 		}
 	}
 	function getPaymentProcessors(){
 		$table =$this->getTable('paymentprocessors');
 		$paymentProcessors = $table->getActivePaymentProcessors();
 		return $paymentProcessors;
 	}
 	function getActivePromotionPlans(){
 		$row = $this->getTable('promotionplans');
 		return $row->getActivePromotionPlans();
 	}
 	
 	function getPaymentMethods(){
 		$paymentMethods = PaymentService::getPaymentProcessors();
 		return $paymentMethods;
 	}
 	
	
}