<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport('joomla.application.component.model'); 
require_once( JPATH_COMPONENT_SITE.'/models/editad.php' );
require_once 'components/com_jclassifiedsmanager/models/orders.php';


class JClassifiedsManagerModelManageAds extends JClassifiedsManagerModelEditAd
{ 
	function __construct()
	{
		parent::__construct();
		$mainframe = JFactory::getApplication();
		
		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart = JFactory::getApplication()->input->getInt('limitstart', 0, '', 'int');
		
		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		$this->_total = 0;
	}


	function getAllAds($searchFilter)
	{
		// Load the data
		$row =$this->getTable();
		$ads = $row->getAllAds($searchFilter,$this->getState('limitstart'),$this->getState('limit'));
		$this->_total = $row->getAdsCount();
		return $ads;
	}
	function initSearchFilter(){
		
		$post =  JFactory::getApplication()->input->get->getArray(); 
		$searchFilter = new stdClass(); 
		$searchFilter->filter_name = JFactory::getApplication()->input->get("filter_name","");
		$searchFilter->filter_ad_type = JFactory::getApplication()->input->get("filter_ad_type","-1");
		$searchFilter->filter_status = JFactory::getApplication()->input->get("filter_status","-1");
		$searchFilter->filter_category = JFactory::getApplication()->input->get("filter_category","0");
		$searchFilter->filter_state = JFactory::getApplication()->input->get("filter_state","");
		$searchFilter->filter_sub_category = JFactory::getApplication()->input->get("filter_sub_category","0");
		$searchFilter->filter_sub_category2 = JFactory::getApplication()->input->get("filter_sub_category2","0");
		$searchFilter->filter_city = JFactory::getApplication()->input->get("filter_city","0");
		$searchFilter->filter_phone = JFactory::getApplication()->input->get("filter_phone","");
		$searchFilter->filter_edition= JFactory::getApplication()->input->get("filter_edition","0");
		$searchFilter->filter_keyword = JFactory::getApplication()->input->get("filter_keyword","");
		return $searchFilter;
	}
	function getAllAdTypes(){
		// Load the data
		$row = $this->getTable('manageadtypes');
		$categories = $row->getAllAdTypes();
		return $categories;
	}
	function getParentCategories()
	{
		// Load the data
		$row =$this->getTable('categories');
		$categories = $row->getParentCategories();
		return $categories;
	}
	
	function getPagination()
	{
		// Load the content if it doesn't already exist
		if (empty($this->_pagination)) {
			$this->_pagination = new JPagination($this->_total, $this->getState('limitstart'), $this->getState('limit') );
		}
		return $this->_pagination;
	}
	
	function changeStatus($post){
		$attrIds = implode(',',$post);
		$row =$this->getTable();
		if(!$row->changeStatus($attrIds)){
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		return true;
	}
	
	function changeFeaturedStatus($post){
		$attrIds = implode(',',$post);
		$row =$this->getTable();
		if(!$row->changeFeaturedStatus($attrIds)){
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		return true;
	}
	
	function getPaymentStatuses(){
		$row = $this->getTable('paymentstatus');
		$currencies = $row->getPaymentStatuses();
		return $currencies;
	}
	
	function publishAds($post){
		$attrIds = implode(',',$post['cid']);
		if (!$attrIds) {
			return false;
		}
		$row =$this->getTable();
		if(!$row->publishItems($attrIds)){
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		return true;
	}

	function unpublish($post){
		$attrIds = implode(',',$post['cid']);
		if (!$attrIds) {
			return false;
		}
		$row =$this->getTable();
		if(!$row->unpublish($attrIds)){
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		return true;
	}
	function deleteAds($post){
	
		$message = "";
		$adId = implode(',',$post['cid']);
		try
		{
			if(isset($adId) && strlen($adId)>0){
	
				//delete ad attributes
				$adAttrTable = $this->getTable("manageadattributes");
				//$adAttrTable->deleteAdAttributes($adId);
	
				//delete ad pictures
				$adPicTable = $this->getTable("manageadpictures");
				//$adPicTable->deleteAdPictures($adId);
	
				
				$adIds= explode(",",$adId);
				foreach($adIds as $adId){
					$adTable = $this->getTable("manageads");
					//delete ad users
					$adTable->load($adId);
					if(!empty($adTable->user_id)){
						$userAds = $adTable->getAllUserAds($adTable->user_id);
						if(count($userAds)==1){
							$adUsersTable = $this->getTable("manageadusers");
							$adUsersTable->load($adTable->user_id);
							$instance = JUser::getInstance($userid);
							$instance->delete();
							$adUsersTable->delete();
						}
					}
					//delete ad

					$adTable->delete();
				}
				$message = JText::_("LNG_AD_SUCCESSFULLY_DELETED");
			}
		}
		catch(Exception $e){
			$message = JText::_("LNG_AD_NOT_DELETED");
			var_dump($e);exit;
		}
		return $message;
	}
	
	function changePaymentStatus(){
		$ordersTable = $this->getTable("manageorders");
		$message = JText::_("LNG_PAYMENT_STATUS_CHANGED");
		$orderId = JFactory::getApplication()->input->get("orderId","");
		$orderStatus = JFactory::getApplication()->input->get("orderStatus","");
		$adID = JFactory::getApplication()->input->get("ad_id","");
		
		if (!$ordersTable->changePaymentStatus($orderId,$orderStatus))
			$message = JText::_("LNG_ERROR_CHANGING_PAYMENT_STATUS");
		
		//send invoice
		if($orderStatus==JCLS_PAYMENT_STATUS_PAID){
			$adData= AdService::getAdDetails($adID,$orderId);
			EmailService::sendInvoiceEmail($adData);
		}
		
		return $message;
	}
	
	function promoteAdAdmin(){
		$message = JText::_("LNG_AD_PROMOTED_SUCCESSFULLY");
		$orderStatus = JCLS_PAYMENT_STATUS_PAID;
		$adID = JFactory::getApplication()->input->get("ad_id","");
	
		$orders =  JModelLegacy::getInstance('Orders','JClassifiedsManagerModel');
		$orderId = $orders->createNewPaidOrder($adID,$orderStatus);
	
		//send invoice
		$adData= AdService::getAdDetails($adID,$orderId);
		EmailService::sendInvoiceEmail($adData);
	
		return $message;
	}
}
?>