<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');
require_once JPATH_COMPONENT_SITE.'/classes/payment/paymentfactory.php';

class JClassifiedsManagerModelPromoteAd extends JModelLegacy
{
	function __construct()
	{
		parent::__construct();
		$this->log = Logger::getInstance();
	}
	
 	function getPaymentProcessors(){
 		$paymentMethods = PaymentService::getPaymentProcessors();
 		return $paymentMethods;
 	}
 	function getPaymentPlans(){
 		$row = $this->getTable('managepaymentplans');
 		return $row->getPaymentPlans();
 	}
 	function promoteAd(){
 		$adId = JFactory::getApplication()->input->get("ad_id",null);
 		$adTable = $this->getTable("manageads");
 		$adTable->load($adId);

 		$data = get_object_vars($adTable);//convert object to array 
 		
 		$data["payment_plan_id"] = JFactory::getApplication()->input->get("payment_plan_id",null);
 		$data["payment_processor_code"] = JFactory::getApplication()->input->get("payment_processor_code",null);
 		$data["ad_id"] = $adId;
	 		
 		//get user data 
 		$usersTable = $this->getTable("manageusers");
 		$usersTable->load($adTable->user_id);
 		
 		$data["name"] = $usersTable->name; 
 		$data["email"] = $usersTable->email;
 		$data["phone"] = $usersTable->phone;
 		$data["user_type_id"] = $usersTable->user_type_id;
 			
 		
 		return $this->processPayment($data);
 	}
 	
 	function processPayment($data){
 		//retrieve payment processor 
 		$processorType = $data["payment_processor_code"];
 		
 		$this->log->LogDebug("processing payment ".$processorType);
 		//get processor to be called
 		$processor = PaymentService::createPaymentProcessor($processorType);

 	
 		//retrieve payment plan for order description
 		$paymentPlan = $this->getTable("managepaymentplans");
 		$paymentPlan->load($data["payment_plan_id"]);
 		
 		$currencies = $this->getTable("currencies");
 		$defaultCurrency = $currencies->getDefaultCurrency()->code;
		
 		$processorTable = $this->getTable("paymentprocessors");
 		$processorInfo = $processorTable->getProcessorByCode($processorType);
 			
 		//set client data
 		$clientData = (object)array();
 		$nameArray = explode(" ",$data["name"]);
 		$clientData->type=$data["user_type_id"]==1?"person":"company";
 		if(count($nameArray)>1){
 			$clientData->first_name = $nameArray[0];
 			$clientData->last_name = $nameArray[1];
 		}
 		else{
 			$clientData->first_name = $data["name"];
 			$clientData->last_name ="";
 		} 
 		$clientData->fiscal_number = "n/a";
 		$clientData->identity_number = "n/a";
 		$clientData->country = $data["country"];
 		$clientData->county = $data["state"];
 		$clientData->city= $data["city"];
 		$clientData->zip_code = "n/a";
 		$clientData->_address = "n/a";
 		$clientData->email = $data["email"];
 		$clientData->mobile_phone = $data["phone"];
 		$clientData->bank = "n/a";
 		$clientData->iban = "n/a";
 			
 		//set order data
 		$orderData = (object)array();
 		$orderData->amount  = $paymentPlan->price;
 		$period = " ".JText::_("LNG_PLAN_".strtoupper($paymentPlan->period_unit));
 		$orderData->description = JText::_("LNG_PAYMENT_PROMOTE_AD")." ".$paymentPlan->period." ".$period;
 		$orderData->period = $paymentPlan->period." ".$period;
 		$orderData->currency = $defaultCurrency;
 		 	
 			
 		//save order and retrieve order id
 		$ordersTable = $this->getTable("manageorders");
 		$ordersTable->ad_id = $data["ad_id"];
 		//$ordersTable->currency = $defaultCurrency;
 		$ordersTable->description = $orderData->description;
 		$ordersTable->payment_plan_id = $data["payment_plan_id"];
 		$ordersTable->payment_processor_id = $processorInfo->id;
 		$ordersTable->payment_status_id = JCLS_PAYMENT_STATUS_PENDING; //PENDING AS DEFAULT
 			
 		if(!$ordersTable->store())
 			throw  new Exception(JText::_("LNG_ERROR_ADDING_ORDER").$ordersTable->getError());
 		$this->log->LogDebug("created order id ". $ordersTable->id);
 		// set order id for processing
 		$orderData->order_id = $ordersTable->id;
 		$orderData->ad_id = $data["ad_id"];
 			
 		$this->log->LogDebug("send payment to processor");
 		//call charge function on the processor
 		return $processor->processTransaction($clientData,$orderData,null);
 	}
 	
 	function renewAd(){
 		$adId = JFactory::getApplication()->input->get("ad_id",null);
 		$adTable = $this->getTable("manageads");
 		return $adTable->renewAd($adId);
 	}
}