<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport('joomla.application.component.modeladmin');


class JClassifiedsManagerModelPromotionPlan extends JModelAdmin
{ 
	/**
	 * Model context string.
	 *
	 * @var		string
	 */
	protected $_context		= 'com_jclassifiedsmanager.promotionplan';



	function __construct(){
		parent::__construct();
	}


	/**
	 * Returns a Table object, always creating it
	 *
	 * @param   type	The table type to instantiate
	 * @param   string	A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  JTable	A database object
	*/
	public function getTable($type = 'PromotionPlans', $prefix = 'Table', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	function getPromotionPlan(){
		$row =$this->getTable();
		$id = JFactory::getApplication()->input->get("id",0);
		$row->load($id);
		return $row;
	}
	
	function store( $data ){
		$row =$this->getTable();
		// Bind the form fields to the table
		if (!$row->bind($data))
		{
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		// Make sure the record is valid
		if (!$row->check()) {
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
	
		// Store the web link table to the database
		if (!$row->store()) {
			$application = JFactory::getApplication();
			$application->enqueueMessage( $row->getError(), 'error');
			return false;
		}
		$this->id= $row->id;
		$data["id"] = $row->id;
		return true;
	}

	function getAllCurrencies(){
		$model = $this->getTable('currencies');
		return $model->getAllCurrencies(); 
	}


	/**
	 * Method to get the menu item form.
	 *
	 * @param   array  $data		Data for the form.
	 * @param   boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return  JForm	A JForm object on success, false on failure
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		//exit;
		// The folder and element vars are passed when saving the form.
		if (empty($data))
		{
			$item= $this->getItem();
			// The type should already be set.
		}
		// Get the form.
		$form = $this->loadForm('com_jclassifiedsmanager.promotionplan', 'item', array('control' => 'jform', 'load_data' => $loadData), true);
		if (empty($form))
		{
			return false;
		}
		
		return $form;
	}


}
?>