DROP TABLE IF EXISTS `#__classifiedsmanager_ads`;
CREATE TABLE `#__classifiedsmanager_ads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(70) DEFAULT NULL,
  `description` text,
  `price` decimal (12,2) NOT NULL DEFAULT '0.0' ,
  `category_id` int(11) DEFAULT NULL,
  `sub_category_id` int(11) DEFAULT NULL,
  `sub_category_id2` int(11) DEFAULT NULL,
  `ad_type_id` int(11) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `city` varchar(150) DEFAULT NULL,
  `state` varchar(150) DEFAULT NULL,
  `country` varchar(150) DEFAULT NULL,
  `creation_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `name` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `user_id` int(11) DEFAULT NULL,
  `user_type_id` tinyint(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `counter` int(11) DEFAULT '0',
  `renewal_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `editions` varchar(145) NOT NULL DEFAULT '',
  `featured` TINYINT( 1 ) NOT NULL DEFAULT '0',
  `start_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `end_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `source` varchar(10) NOT NULL DEFAULT '',
  `phone` varchar(15) NOT NULL DEFAULT '',
  `ip_address` varchar(16) NOT NULL DEFAULT '0.0.0.0',
  `latitude` varchar(45) DEFAULT NULL,
  `longitude` varchar(45) DEFAULT NULL,
  `view_count` int(11) NOT NULL DEFAULT '0',
  `alias` varchar(100) NOT NULL DEFAULT '',
  `softdelete` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__classifiedsmanager_ad_attributes`;
CREATE TABLE `#__classifiedsmanager_ad_attributes` (
  `ad_id` int(11) NOT NULL,
  `attribute_id` int(11) NOT NULL,
  `value` varchar(250) DEFAULT NULL,
  `option_id` varchar(255) NOT NULL,
  PRIMARY KEY (`ad_id`,`attribute_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__classifiedsmanager_ad_attributes` (`ad_id`, `attribute_id`, `value`, `option_id`) VALUES
(14, 29, NULL, '1200'),
(14, 30, NULL, '1469'),
(14, 31, NULL, 'galoordo'),
(14, 32, NULL, '34567'),
(14, 33, NULL, '1520'),
(14, 34, NULL, '1399'),
(14, 35, NULL, '106'),
(14, 36, NULL, '1409'),
(14, 37, NULL, '1418'),
(14, 45, NULL, '2012'),
(15, 29, NULL, '7889'),
(15, 30, NULL, ''),
(15, 31, NULL, '0'),
(15, 32, NULL, '0'),
(15, 33, NULL, '1523'),
(15, 34, NULL, '1402'),
(15, 35, NULL, '106'),
(15, 36, NULL, ''),
(15, 45, NULL, '0'),
(16, 38, NULL, '1417'),
(17, 38, NULL, '1416'),
(20, 29, NULL, '1500'),
(20, 30, NULL, '1438'),
(20, 31, NULL, 'SR3'),
(20, 32, NULL, '12000'),
(20, 33, NULL, '1529'),
(20, 34, NULL, '1402'),
(20, 35, NULL, '107'),
(20, 36, NULL, '1409'),
(20, 45, NULL, '2013');

DROP TABLE IF EXISTS `#__classifiedsmanager_ad_type`;
CREATE TABLE `#__classifiedsmanager_ad_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status`  tinyint(1) DEFAULT 1,
  `code` varchar(50) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

INSERT INTO `#__classifiedsmanager_ad_type` (`id`, `name`, `code`, `status`, `ordering`) VALUES
(1, 'Offer', 'offer',1 , 1),
(2, 'Request', 'request',1, 2),
(3, 'Trade', 'trade',1, 3),
(4, 'Tent', 'rent',1, 4),
(5, 'Donation', 'donation',1, 5);

DROP TABLE IF EXISTS `#__classifiedsmanager_application_settings`;
CREATE TABLE `#__classifiedsmanager_application_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_name` varchar(255) DEFAULT NULL,
  `company_email` varchar(255) DEFAULT NULL,
  `terms_conditions` text,
  `usage_rules` text,
  `ad_availability_period` int(11) DEFAULT NULL,
  `ad_availability_unit` varchar(5) DEFAULT NULL,
  `logo_path` varchar(255) NOT NULL,
  `enable_ad_gallery` tinyint(1)  NOT NULL DEFAULT '0',
  `order_id` VARCHAR(255) DEFAULT NULL,
  `order_email` VARCHAR(255) DEFAULT NULL,
  `enable_google_map_clustering` tinyint(1)  NOT NULL DEFAULT '0',
  `enable_map_auto_show` tinyint(1)  NOT NULL DEFAULT '0',
  `enable_multilingual` tinyint(1)  NOT NULL DEFAULT '0',
  `enable_seo` tinyint(1)  NOT NULL DEFAULT '0',
  `enable_id_url` tinyint(1)  NOT NULL DEFAULT '0',
  `menu_id` VARCHAR(7) DEFAULT NULL,
  `enable_paid_classifieds` tinyint(1)  NOT NULL DEFAULT '0',
  `enable_video` tinyint(1)  NOT NULL DEFAULT '0',
  `enable_social` tinyint(1)  NOT NULL DEFAULT '0',
  `enable_ad_promoting` tinyint(1)  NOT NULL DEFAULT '0',
  `max_photos` int(7)  NOT NULL DEFAULT '4',
  `max_videos` int(7)  NOT NULL DEFAULT '4',
  `enable_captcha` tinyint(1)  NOT NULL DEFAULT '0',
  `expire_ads_option` tinyint(1)  NOT NULL DEFAULT '0',
  `google_map_key` VARCHAR(45) NULL,
  `menu_item_id` VARCHAR(45) NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;


INSERT INTO `#__classifiedsmanager_application_settings` (`id`, `company_name`, `company_email`, `terms_conditions`, `usage_rules`, `ad_availability_period`, `ad_availability_unit`, `logo_path`) VALUES
(1, 'Ad Manager', 'info@cmsjunkie.com', '<p>\r\n	text</p>', '<p>\r\n	text</p>', 2, 'WEEK', '/logo/logo.png');

DROP TABLE IF EXISTS `#__classifiedsmanager_category`;
CREATE TABLE `#__classifiedsmanager_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_category_id` int(11) DEFAULT NULL,
  `description` varchar(500) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `alias` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=120 ;

INSERT INTO `#__classifiedsmanager_category` (`id`, `parent_category_id`, `description`, `status`, `name`, `alias`) VALUES
(12, -1, '', 1, 'Real Estate', 'real-state'),
(13, -1, '', 1, 'Auto', 'auto'),
(14, -1, '', 1, 'Pets', 'pets'),
(17, 12, '', 1, 'Apartments & Condos', 'apartments-&-condos'),
(18, 12, '', 1, 'Land', 'land'),
(21, -1, 'Handmade', 1, 'Handmade', 'handmade'),
(22, -1, 'Vacations', 1, 'Accomodation', 'accomodation'),
(24, -1, 'Fashion', 1, 'Fashion', 'fashion'),
(25, -1, 'Cosmetics', 1, 'Cosmetics', 'cosmetics'),
(28, -1, 'Jobs', 1, 'Jobs', 'jobs'),
(29, -1, 'Services', 1, 'Services', 'services'),
(31, 13, 'Cars', 1, 'Cars', 'cars'),
(32, 13, '', 1, 'Boats', 'boats'),
(33, 13, '', 1, 'Motorcycle', 'motorcycle'),
(34, 13, '', 1, 'RVs & Trailers', 'rvs-&-trailers'),
(35, 58, '', 1, 'TV & Audio', 'tv-&-audio'),
(36, -1, '', 1, 'Cellphones', 'cellphones'),
(38, 14, 'Animal, Pets Services', 1, 'Animal, Pets Services', 'animal,-pets-services'),
(40, 14, '', 1, 'Accesories', 'accesories'),
(41, 21, 'Glas painting, accuarela', 1, 'Painting', 'painting'),
(42, 21, '', 1, 'Ceramics', 'ceramics'),
(43, 21, '', 1, 'Brodering', 'brodering'),
(44, 21, '', 1, 'Handcrafted', 'handcrafted'),
(45, 21, '', 1, 'Gifts', 'gifts'),
(46, 21, 'Other Handcrafts', 1, 'Handmade', 'handmade'),
(47, 24, '', 1, 'Kids', 'kids'),
(48, 24, '', 1, 'Women', 'women'),
(49, 24, '', 1, 'Men', 'men'),
(50, 24, '', 1, 'Babies', 'babies'),
(51, 25, '', 1, 'Skin Care', 'skin-care'),
(52, 25, '', 1, 'Body Care', 'body-care'),
(53, 25, '', 1, 'Makeup', 'makeup'),
(54, 25, '', 1, 'Hair', 'hair'),
(55, 25, '', 1, 'Perfumes', 'perfumes'),
(58, -1, '', 1, 'Appliances', 'appliances'),
(59, 58, '', 1, 'Desktops', 'desktops'),
(60, -1, '', 1, 'Cameras & Camcordes', 'camera-&-camcordes'),
(61, 60, '', 1, 'Cameras', 'cameras'),
(62, 60, '', 1, 'Camcorders', 'camcorders'),
(63, 60, '', 1, 'Accesories', 'accesories'),
(64, 58, '', 1, 'Air conditioner', 'air-conditioner'),
(66, 58, '', 1, 'Frigidairs', 'frigidairs'),
(68, 58, '', 1, 'Cooking Appliances', 'cooking-appliances'),
(69, 58, '', 1, 'Washing Machines', 'washing-machines'),
(70, 58, '', 1, 'Vaccums', 'vaccums'),
(71, 35, '', 1, 'TVs', 'tvs'),
(72, 71, '', 1, 'Led TV', 'led-tv'),
(73, 71, '', 1, 'LCD TV', 'lcd-tv'),
(74, 71, '', 1, 'Plasma TV', 'plasma-tv'),
(75, 35, '', 1, 'Players', 'players'),
(76, 35, '', 1, 'Home Cinema', 'home-cinema'),
(77, 35, '', 1, 'Audio', 'audio'),
(78, 59, '', 1, 'Laptops', 'laptops'),
(79, 59, '', 1, 'PC', 'pc'),
(80, 59, '', 1, 'Tablets', 'tablets'),
(81, 59, '', 1, 'Printers', 'printers'),
(82, 59, '', 1, 'Networking', 'networking'),
(86, 80, '', 1, 'Accesories', 'accesories'),
(87, 30, '', 1, 'Sport', 'sport'),
(88, -1, '', 1, 'Kids World', 'kids-world'),
(89, 13, 'Parts & Accesories', 1, 'Parts & Accesories', 'parts-&-accesories'),
(90, 12, '', 1, 'Commercial Spaces', 'commercial-spaces'),
(91, 29, '', 1, 'Computer Repairs', 'computer-repairs'),
(92, 29, '', 1, 'Auto Services', 'auto-services'),
(93, 29, '', 1, 'Interior Design', 'interior-design'),
(94, 29, '', 1, 'Accounting', 'accounting'),
(95, 29, '', 1, 'Tutoring', 'tutoring'),
(96, 29, '', 1, 'Training Courses', 'training-courses'),
(97, 29, '', 1, 'Event Planning', 'event-planning'),
(98, 29, '', 1, 'Marketing', 'marketing'),
(99, 29, '', 1, 'Insurance', 'insurance'),
(100, 29, '', 1, 'Translations', 'translations'),
(101, 29, '', 1, 'Other Services', 'other-services'),
(102, 28, '', 1, 'Permanent', 'permanent'),
(103, 28, '', 1, 'Temporary', 'temporary'),
(104, 28, '', 1, 'Project Based', 'project-based'),
(105, 28, '', 1, 'Others', 'others'),
(106, 21, 'Antiques', 1, 'Antiques', 'antiques'),
(107, 24, 'Accesories', 1, 'Accesories', 'accesories'),
(113, 22, '', 1, 'Bed & Breakfast', 'bed-&-breakfast'),
(114, 22, '', 1, 'Hotel', 'hotel'),
(115, 22, '', 1, 'Hostel', 'hostel'),
(116, 22, '', 1, 'Cottage', 'cottage'),
(117, 22, '', 1, 'Motel', 'motel');

DROP TABLE IF EXISTS `#__classifiedsmanager_category_attributes`;
CREATE TABLE `#__classifiedsmanager_category_attributes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `attribute_type_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `is_mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `show_in_filter` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=55 ;

INSERT INTO `#__classifiedsmanager_category_attributes` (`id`, `name`, `code`, `attribute_type_id`, `status`, `is_mandatory`, `show_in_filter`) VALUES
(20, 'Building type', 'building_type', 3, 1, 0, 1),
(25, 'Buidling Quality', 'build_quality', 3, 1, 0, 1),
(26, 'Parking', 'parking', 4, 1, 0, 1),
(27, 'No. of parcels', 'no_parcels', 2, 1, 0, 1),
(28, 'Size', 'size', 1, 1, 0, 1),
(29, 'Cilinders capacity(cm3)', 'cilinder_capacity', 1, 1, 0, 1),
(30, 'Make', 'car_make', 2, 1, 0, 1),
(31, 'Model', 'car_model', 1, 1, 0, 1),
(32, 'Mileage', 'car_mileage', 1, 1, 0, 1),
(33, 'Color', 'color', 2, 1, 0, 1),
(34, 'Fuel Type', 'fuel_type', 2, 1, 0, 1),
(35, 'Gear box', 'gear_box', 4, 1, 1, 1),
(36, 'Poluting type', 'polution_rate', 2, 1, 0, 1),
(37, 'Registration status', 'registration_status', 4, 1, 0, 1),
(38, 'Making', 'type', 3, 1, 0, 1),
(40, 'Gender', 'gender', 3, 1, 0, 1),
(41, 'TVs', 'type_tv', 3, 1, 0, 1),
(42, 'Players', 'players', 1, 1, 0, 1),
(43, 'Jobs', 'jobs', 3, 1, 0, 1),
(44, 'Field', 'activity_field', 2, 1, 0, 1),
(45, 'Make year', 'make_year', 1, 1, 0, 1),
(46, 'Lodging Category', 'lodging_category', 3, 1, 1, 1),
(47, 'No. rooms', 'room_number', 1, 1, 1, 0),
(48, 'Lodging capacity', 'lodging_capacity', 1, 1, 0, 0),
(49, 'Web page', 'web_page', 1, 1, 0, 0),
(50, 'Room amenities', 'room_amenities', 3, 1, 0, 1),
(51, 'Conference Room', 'conference_room', 2, 1, 0, 1),
(52, 'Recreation', 'Recreation', 3, 1, 0, 1),
(53, 'Restaurant', 'restaurant', 2, 1, 0, 1),
(54, 'Stars', 'hotel_stars', 3, 1, 1, 1);

DROP TABLE IF EXISTS `#__classifiedsmanager_category_attributes_mapping`;
CREATE TABLE `#__classifiedsmanager_category_attributes_mapping` (
  `category_id` int(11) NOT NULL,
  `attribute_id` int(11) NOT NULL,
  PRIMARY KEY (`category_id`,`attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__classifiedsmanager_category_attributes_mapping` (`category_id`, `attribute_id`) VALUES
(12, 20),
(12, 21),
(12, 25),
(12, 26),
(12, 27),
(13, 29),
(13, 30),
(13, 31),
(13, 32),
(13, 33),
(13, 34),
(13, 35),
(13, 36),
(13, 45),
(14, 0),
(17, 20),
(17, 21),
(17, 25),
(17, 26),
(18, 21),
(19, 27),
(19, 28),
(20, 27),
(20, 28),
(21, 38),
(22, 0),
(24, 0),
(25, 0),
(28, 43),
(28, 44),
(29, 0),
(30, 0),
(31, 29),
(31, 30),
(31, 31),
(31, 32),
(31, 33),
(31, 34),
(31, 35),
(31, 36),
(31, 37),
(31, 45),
(32, 0),
(33, 0),
(34, 0),
(35, 25),
(36, 0),
(38, 0),
(40, 0),
(41, 38),
(42, 38),
(43, 38),
(44, 0),
(45, 0),
(46, 0),
(47, 0),
(48, 0),
(49, 0),
(50, 0),
(51, 0),
(52, 0),
(53, 0),
(54, 0),
(55, 0),
(58, 41),
(58, 42),
(59, 0),
(60, 0),
(61, 0),
(62, 0),
(63, 0),
(64, 0),
(66, 0),
(68, 0),
(69, 0),
(70, 0),
(71, 0),
(72, 0),
(73, 0),
(74, 0),
(75, 0),
(76, 0),
(77, 0),
(78, 0),
(79, 0),
(80, 0),
(81, 0),
(82, 0),
(86, 0),
(87, 0),
(88, 0),
(89, 0),
(90, 0),
(91, 0),
(92, 0),
(93, 0),
(94, 0),
(95, 0),
(96, 0),
(97, 0),
(98, 0),
(99, 0),
(100, 0),
(101, 0),
(102, 43),
(102, 44),
(103, 43),
(103, 44),
(104, 43),
(104, 44),
(105, 43),
(105, 44),
(106, 0),
(107, 0),
(113, 46),
(113, 47),
(113, 48),
(113, 49),
(113, 50),
(113, 51),
(113, 52),
(114, 47),
(114, 48),
(114, 49),
(114, 50),
(114, 51),
(114, 53),
(114, 54),
(115, 47),
(115, 48),
(115, 49),
(116, 47),
(116, 49),
(116, 50),
(117, 47),
(117, 49),
(117, 50),
(117, 53);

-- --------------------------------------------------------

--
-- Table structure for table `#__classifiedsmanager_category_attribute_options`
--

DROP TABLE IF EXISTS `#__classifiedsmanager_category_attribute_options`;
CREATE TABLE `#__classifiedsmanager_category_attribute_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_id` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1584 ;

--
-- Dumping data for table `#__classifiedsmanager_category_attribute_options`
--

INSERT INTO `#__classifiedsmanager_category_attribute_options` (`id`, `attribute_id`, `name`) VALUES
(80, 25, 'Luxury'),
(81, 25, 'Medium'),
(82, 25, 'Standard'),
(106, 35, 'Manual'),
(107, 35, 'Automatic'),
(108, 35, 'Semiautomatic'),
(1028, 41, 'LCD TV'),
(1029, 41, 'Led TV'),
(1030, 41, 'Plasma TV'),
(1031, 41, 'Led - PLasma'),
(1181, 44, 'Sales'),
(1182, 44, 'Engineering'),
(1183, 44, 'Social Assistance'),
(1184, 44, 'Medicine'),
(1185, 44, 'Workers,Contractors'),
(1186, 44, 'Sales'),
(1187, 44, 'Accounting'),
(1188, 44, 'Other services'),
(1304, 29, ''),
(1305, 40, 'Men'),
(1306, 40, 'Kids'),
(1307, 40, 'Women'),
(1398, 31, ''),
(1399, 34, 'Gas'),
(1400, 34, 'GPL'),
(1401, 34, 'Hybrid/Electric'),
(1402, 34, 'Diesel'),
(1403, 36, 'euro 1'),
(1404, 36, 'euro 2 '),
(1405, 36, 'euro 3 '),
(1406, 36, 'euro 4 '),
(1407, 36, 'euro 5 '),
(1408, 36, 'euro 6 '),
(1409, 36, 'non euro '),
(1410, 27, '1'),
(1411, 27, '2'),
(1412, 27, '3'),
(1413, 26, 'yes'),
(1414, 26, 'no'),
(1415, 42, ''),
(1416, 38, 'Industrial'),
(1417, 38, 'Manual'),
(1418, 37, 'registered'),
(1419, 37, 'not registered'),
(1420, 37, 'can be registered'),
(1421, 28, ''),
(1422, 20, 'Apartament'),
(1423, 20, 'Apartment Building'),
(1424, 20, 'House'),
(1425, 20, 'Villa'),
(1426, 43, 'Canada'),
(1427, 43, 'Outside'),
(1428, 32, ''),
(1429, 30, 'Aberth'),
(1430, 30, 'Acura'),
(1431, 30, 'Alfa Romeo'),
(1432, 30, 'Alpina'),
(1433, 30, 'Others'),
(1434, 30, 'Aston Martin'),
(1435, 30, 'Audi'),
(1436, 30, 'Austin'),
(1437, 30, 'Bentley'),
(1438, 30, 'BMW'),
(1439, 30, 'Brilliance'),
(1440, 30, 'Bugatti'),
(1441, 30, 'Buick'),
(1442, 30, 'Cadillac'),
(1443, 30, 'Caterhan'),
(1444, 30, 'Chevrolet'),
(1445, 30, 'Chrysler'),
(1446, 30, 'Citroen'),
(1447, 30, 'Cobra'),
(1448, 30, 'Corvette'),
(1449, 30, 'Dacia'),
(1450, 30, 'Daewoo'),
(1451, 30, 'Daihatsu'),
(1452, 30, 'Dastun'),
(1453, 30, 'De Tomaso'),
(1454, 30, 'Dodge'),
(1455, 30, 'Ferrary'),
(1456, 30, 'Fiat'),
(1457, 30, 'Ford'),
(1458, 30, 'GMC'),
(1459, 30, 'Honda'),
(1460, 30, 'Hummer'),
(1461, 30, 'Hyundai'),
(1462, 30, 'Infiniti'),
(1463, 30, 'Isuzu'),
(1464, 30, 'Jaguar'),
(1465, 30, 'Jeep'),
(1466, 30, 'Kia'),
(1467, 30, 'KTM'),
(1468, 30, 'Lada'),
(1469, 30, 'Lamborghini'),
(1470, 30, 'Lancia'),
(1471, 30, 'Land Rover'),
(1472, 30, 'Lexus'),
(1473, 30, 'Ligier'),
(1474, 30, 'Lincoln'),
(1475, 30, 'Logan'),
(1476, 30, 'Lotus'),
(1477, 30, 'Mahindra'),
(1478, 30, 'Marca'),
(1479, 30, 'Maserati'),
(1480, 30, 'Maybach'),
(1481, 30, 'Mazda'),
(1482, 30, 'Mercedes Benz'),
(1483, 30, 'MG'),
(1484, 30, 'Mini'),
(1485, 30, 'Mitsubishi'),
(1486, 30, 'Morgan'),
(1487, 30, 'Nissan'),
(1488, 30, 'Oldsmobile'),
(1489, 30, 'Opel'),
(1490, 30, 'Peogeot'),
(1491, 30, 'Piaggio'),
(1492, 30, 'Plymouth'),
(1493, 30, 'Pontiac'),
(1494, 30, 'Porshe'),
(1495, 30, 'Proton'),
(1496, 30, 'Renault'),
(1497, 30, 'Rolls Royce'),
(1498, 30, 'Rover'),
(1499, 30, 'Saab'),
(1500, 30, 'Santana'),
(1501, 30, 'Seat'),
(1502, 30, 'Skoda'),
(1503, 30, 'Smart'),
(1504, 30, 'Sonstige'),
(1505, 30, 'Ssang Yong'),
(1506, 30, 'Subaru'),
(1507, 30, 'Suzuki'),
(1508, 30, 'Talbot'),
(1509, 30, 'Tata'),
(1510, 30, 'Tico'),
(1511, 30, 'Toyota'),
(1512, 30, 'Trabant'),
(1513, 30, 'Triumph'),
(1514, 30, 'Volvo'),
(1515, 30, 'VW'),
(1516, 30, 'Wartburg'),
(1517, 30, 'Wiesmann'),
(1518, 30, 'Matiz'),
(1519, 33, 'White'),
(1520, 33, 'Blue'),
(1521, 33, 'Another'),
(1522, 33, 'Gold'),
(1523, 33, 'Yellow'),
(1524, 33, 'Grey'),
(1525, 33, 'Indigo'),
(1526, 33, 'Brown'),
(1527, 33, 'Black'),
(1528, 33, 'Orange'),
(1529, 33, 'Red'),
(1530, 33, 'Green'),
(1531, 33, 'Violet '),
(1532, 33, 'Silver'),
(1533, 33, 'Perl'),
(1534, 33, 'Cameleon'),
(1535, 33, 'Cherry'),
(1541, 46, '1 '),
(1542, 46, '2 '),
(1543, 46, '3 '),
(1544, 46, '4 '),
(1545, 46, '5 '),
(1546, 50, 'TV'),
(1547, 50, 'Fridge'),
(1548, 50, 'Own bathroom'),
(1549, 50, 'Shared bathroom'),
(1550, 50, 'Hot water'),
(1551, 50, 'Internet'),
(1552, 50, 'Air conditioning'),
(1553, 51, 'Yes'),
(1554, 51, 'No'),
(1555, 52, 'Local Guide'),
(1556, 52, 'Pool'),
(1557, 52, 'Biliard/Tennis'),
(1558, 52, 'Horse back riding'),
(1559, 52, 'Slay tours'),
(1560, 52, 'ATV rental'),
(1561, 52, 'Bike rental'),
(1565, 45, ''),
(1569, 53, 'Yes'),
(1570, 53, 'No'),
(1576, 54, '1'),
(1577, 54, '2'),
(1578, 54, '3'),
(1579, 54, '4'),
(1580, 54, '5'),
(1581, 49, ''),
(1582, 47, ''),
(1583, 48, '');

DROP TABLE IF EXISTS `#__classifiedsmanager_category_attribute_types`;
CREATE TABLE `#__classifiedsmanager_category_attribute_types` (
  `id` int(11) NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__classifiedsmanager_category_attribute_types` (`id`, `code`, `name`) VALUES
(1, 'input', 'Input'),
(2, 'select_box', 'Select Box'),
(3, 'checkbox', 'Checkbox(Multiple Select)'),
(4, 'radio', 'Radio(Single Select)');

DROP TABLE IF EXISTS `#__classifiedsmanager_countries`;
CREATE TABLE `#__classifiedsmanager_countries` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` char(255) NOT NULL,
  `currency` char(255) NOT NULL,
  `currency_short` char(50) NOT NULL,
  `currency_symbol` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=244 ;

INSERT INTO `#__classifiedsmanager_countries` (`id`, `name`, `currency`, `currency_short`, `currency_symbol`) VALUES
(1, 'Andorra', 'Euro', 'EUR', '&#8364;'),
(2, 'United Arab Emirates', 'UAE Dirham', 'AED', NULL),
(3, 'Afghanistan', 'Afghani', 'AFA', NULL),
(4, 'Antigua and Barbuda', 'East Caribbean Dollar', 'XCD', NULL),
(5, 'Anguilla', 'East Caribbean Dollar', 'XCD', NULL),
(6, 'Albania', 'Lek', 'ALL', NULL),
(7, 'Armenia', 'Armenian Dram', 'AMD', NULL),
(8, 'Netherlands Antilles', 'Netherlands Antillean guilder', 'ANG', NULL),
(9, 'Angola', 'Kwanza', 'AOA', NULL),
(11, 'Argentina', 'Argentine Peso', 'ARS', NULL),
(12, 'American Samoa', 'US Dollar', 'USD', '&#36;'),
(13, 'Austria', 'Euro', 'EUR', '&#8364;'),
(14, 'Australia', 'Australian dollar', 'AUD', NULL),
(15, 'Aruba', 'Aruban Guilder', 'AWG', NULL),
(16, 'Azerbaijan', 'Azerbaijani Manat', 'AZM', NULL),
(17, 'Bosnia and Herzegovina', 'Convertible Marka', 'BAM', NULL),
(18, 'Barbados', 'Barbados Dollar', 'BBD', NULL),
(19, 'Bangladesh', 'Taka', 'BDT', NULL),
(20, 'Belgium', 'Euro', 'EUR', '&#8364;'),
(21, 'Burkina Faso', 'CFA Franc BCEAO', 'XOF', NULL),
(22, 'Bulgaria', 'Lev', 'BGL', NULL),
(23, 'Bahrain', 'Bahraini Dinar', 'BHD', NULL),
(24, 'Burundi', 'Burundi Franc', 'BIF', NULL),
(25, 'Benin', 'CFA Franc BCEAO', 'XOF', NULL),
(26, 'Bermuda', 'Bermudian Dollar', 'BMD', NULL),
(27, 'Brunei Darussalam', 'Brunei Dollar', 'BND', NULL),
(28, 'Bolivia', 'Boliviano', 'BOB', NULL),
(29, 'Brazil', 'Brazilian Real', 'BRL', NULL),
(30, 'The Bahamas', 'Bahamian Dollar', 'BSD', NULL),
(31, 'Bhutan', 'Ngultrum', 'BTN', NULL),
(32, 'Bouvet Island', 'Norwegian Krone', 'NOK', NULL),
(33, 'Botswana', 'Pula', 'BWP', NULL),
(34, 'Belarus', 'Belarussian Ruble', 'BYR', NULL),
(35, 'Belize', 'Belize Dollar', 'BZD', NULL),
(36, 'Canada', 'Canadian Dollar', 'CAD', NULL),
(37, 'Cocos (Keeling) Islands', 'Australian Dollar', 'AUD', NULL),
(38, 'Congo', 'Franc Congolais', 'CDF', NULL),
(39, 'Central African Republic', 'CFA Franc BEAC', 'XAF', NULL),
(41, 'Switzerland', 'Swiss Franc', 'CHF', '&#8355;'),
(42, 'Cote d''Ivoire', 'CFA Franc BCEAO', 'XOF', NULL),
(43, 'Cook Islands', 'New Zealand Dollar', 'NZD', NULL),
(44, 'Chile', 'Chilean Peso', 'CLP', NULL),
(45, 'Cameroon', 'CFA Franc BEAC', 'XAF', NULL),
(46, 'China', 'Yuan Renminbi', 'CNY', NULL),
(47, 'Colombia', 'Colombian Peso', 'COP', NULL),
(48, 'Costa Rica', 'Costa Rican Colon', 'CRC', NULL),
(49, 'Cuba', 'Cuban Peso', 'CUP', NULL),
(50, 'Cape Verde', 'Cape Verdean Escudo', 'CVE', NULL),
(51, 'Christmas Island', 'Australian Dollar', 'AUD', NULL),
(52, 'Cyprus', 'Cyprus Pound', 'CYP', NULL),
(53, 'Czech Republic', 'Czech Koruna', 'CZK', NULL),
(54, 'Germany', 'Euro', 'EUR', '&#8364;'),
(55, 'Djibouti', 'Djibouti Franc', 'DJF', NULL),
(56, 'Denmark', 'Danish Krone', 'DKK', NULL),
(57, 'Dominica', 'East Caribbean Dollar', 'XCD', NULL),
(58, 'Dominican Republic', 'Dominican Peso', 'DOP', NULL),
(59, 'Algeria', 'Algerian Dinar', 'DZD', NULL),
(60, 'Ecuador', 'US dollar', 'USD', '&#36;'),
(61, 'Estonia', 'Kroon', 'EEK', NULL),
(62, 'Egypt', 'Egyptian Pound', 'EGP', NULL),
(63, 'Western Sahara', 'Moroccan Dirham', 'MAD', NULL),
(64, 'Eritrea', 'Nakfa', 'ERN', NULL),
(65, 'Spain', 'Euro', 'EUR', '&#8364;'),
(66, 'Ethiopia', 'Ethiopian Birr', 'ETB', NULL),
(67, 'Finland', 'Euro', 'EUR', '&#8364;'),
(68, 'Fiji', 'Fijian Dollar', 'FJD', NULL),
(69, 'Falkland Islands (Islas Malvinas)', 'Falkland Islands Pound', 'FKP', NULL),
(70, 'Micronesia, Federated States', 'US dollar', 'USD', '&#36;'),
(71, 'Faroe Islands', 'Danish Krone', 'DKK', NULL),
(72, 'France', 'Euro', 'EUR', '&#8364;'),
(74, 'Gabon', 'CFA Franc BEAC', 'XAF', NULL),
(75, 'Grenada', 'East Caribbean Dollar', 'XCD', NULL),
(76, 'Georgia', 'Lari', 'GEL', NULL),
(77, 'French Guiana', 'Euro', 'EUR', '&#8364;'),
(78, 'Guernsey', 'Pound Sterling', 'GBP', '&#163;'),
(79, 'Ghana', 'Cedi', 'GHC', NULL),
(80, 'Gibraltar', 'Gibraltar Pound', 'GIP', NULL),
(81, 'Greenland', 'Danish Krone', 'DKK', NULL),
(82, 'The Gambia', 'Dalasi', 'GMD', NULL),
(83, 'Guinea', 'Guinean Franc', 'GNF', NULL),
(84, 'Guadeloupe', 'Euro', 'EUR', '&#8364;'),
(85, 'Equatorial Guinea', 'CFA Franc BEAC', 'XAF', NULL),
(86, 'Greece', 'Euro', 'EUR', '&#8364;'),
(87, 'South Georgia and the South Sandwich Islands', 'Pound Sterling', 'GBP', '&#163;'),
(88, 'Guatemala', 'Quetzal', 'GTQ', NULL),
(89, 'Guam', 'US Dollar', 'USD', '&#36;'),
(90, 'Guinea-Bissau', 'CFA Franc BCEAO', 'XOF', NULL),
(91, 'Guyana', 'Guyana Dollar', 'GYD', NULL),
(92, 'Hong Kong (SAR)', 'Hong Kong Dollar', 'HKD', NULL),
(93, 'Heard Island and McDonald Islands', 'Australian Dollar', 'AUD', NULL),
(94, 'Honduras', 'Lempira', 'HNL', NULL),
(95, 'Croatia', 'Kuna', 'HRK', NULL),
(96, 'Haiti', 'Gourde', 'HTG', NULL),
(97, 'Hungary', 'Forint', 'HUF', NULL),
(98, 'Indonesia', 'Rupiah', 'IDR', NULL),
(99, 'Ireland', 'Euro', 'EUR', '&#8364;'),
(100, 'Israel', 'New Israeli Sheqel', 'ILS', NULL),
(102, 'India', 'Indian Rupee', 'INR', NULL),
(103, 'British Indian Ocean Territory', 'US Dollar', 'USD', '&#36;'),
(104, 'Iraq', 'Iraqi Dinar', 'IQD', NULL),
(105, 'Iran', 'Iranian Rial', 'IRR', NULL),
(106, 'Iceland', 'Iceland Krona', 'ISK', NULL),
(107, 'Italy', 'Euro', 'EUR', '&#8364;'),
(108, 'Jersey', 'Pound Sterling', 'GBP', '&#163;'),
(109, 'Jamaica', 'Jamaican dollar', 'JMD', NULL),
(110, 'Jordan', 'Jordanian Dinar', 'JOD', NULL),
(111, 'Japan', 'Yen', 'JPY', '&#165;'),
(112, 'Kenya', 'Kenyan shilling', 'KES', NULL),
(113, 'Kyrgyzstan', 'Som', 'KGS', NULL),
(114, 'Cambodia', 'Riel', 'KHR', NULL),
(115, 'Kiribati', 'Australian dollar', 'AUD', NULL),
(116, 'Comoros', 'Comoro Franc', 'KMF', NULL),
(117, 'Saint Kitts and Nevis', 'East Caribbean Dollar', 'XCD', NULL),
(118, 'Korea, North', 'North Korean Won', 'KPW', NULL),
(119, 'Korea, South', 'Won', 'KRW', NULL),
(120, 'Kuwait', 'Kuwaiti Dinar', 'KWD', NULL),
(121, 'Cayman Islands', 'Cayman Islands Dollar', 'KYD', NULL),
(122, 'Kazakhstan', 'Tenge', 'KZT', NULL),
(123, 'Laos', 'Kip', 'LAK', NULL),
(124, 'Lebanon', 'Lebanese Pound', 'LBP', NULL),
(125, 'Saint Lucia', 'East Caribbean Dollar', 'XCD', NULL),
(126, 'Liechtenstein', 'Swiss Franc', 'CHF', '&#8355;'),
(127, 'Sri Lanka', 'Sri Lanka Rupee', 'LKR', NULL),
(128, 'Liberia', 'Liberian Dollar', 'LRD', NULL),
(129, 'Lesotho', 'Loti', 'LSL', NULL),
(130, 'Lithuania', 'Lithuanian Litas', 'LTL', NULL),
(131, 'Luxembourg', 'Euro', 'EUR', '&#8364;'),
(132, 'Latvia', 'Latvian Lats', 'LVL', NULL),
(133, 'Libya', 'Libyan Dinar', 'LYD', NULL),
(134, 'Morocco', 'Moroccan Dirham', 'MAD', NULL),
(135, 'Monaco', 'Euro', 'EUR', '&#8364;'),
(136, 'Moldova', 'Moldovan Leu', 'MDL', NULL),
(137, 'Madagascar', 'Malagasy Franc', 'MGF', NULL),
(138, 'Marshall Islands', 'US dollar', 'USD', '&#36;'),
(139, 'Macedonia', 'Denar', 'MKD', NULL),
(140, 'Mali', 'CFA Franc BCEAO', 'XOF', NULL),
(141, 'Burma', 'kyat', 'MMK', NULL),
(142, 'Mongolia', 'Tugrik', 'MNT', NULL),
(143, 'Macao', 'Pataca', 'MOP', NULL),
(144, 'Northern Mariana Islands', 'US Dollar', 'USD', '&#36;'),
(145, 'Martinique', 'Euro', 'EUR', '&#8364;'),
(146, 'Mauritania', 'Ouguiya', 'MRO', NULL),
(147, 'Montserrat', 'East Caribbean Dollar', 'XCD', NULL),
(148, 'Malta', 'Maltese Lira', 'MTL', NULL),
(149, 'Mauritius', 'Mauritius Rupee', 'MUR', NULL),
(150, 'Maldives', 'Rufiyaa', 'MVR', NULL),
(151, 'Malawi', 'Kwacha', 'MWK', NULL),
(152, 'Mexico', 'Mexican Peso', 'MXN', NULL),
(153, 'Malaysia', 'Malaysian Ringgit', 'MYR', NULL),
(154, 'Mozambique', 'Metical', 'MZM', NULL),
(155, 'Namibia', 'Namibian Dollar', 'NAD', NULL),
(156, 'New Caledonia', 'CFP Franc', 'XPF', NULL),
(157, 'Niger', 'CFA Franc BCEAO', 'XOF', NULL),
(158, 'Norfolk Island', 'Australian Dollar', 'AUD', NULL),
(159, 'Nigeria', 'Naira', 'NGN', NULL),
(160, 'Nicaragua', 'Cordoba Oro', 'NIO', NULL),
(161, 'Netherlands', 'Euro', 'EUR', '&#8364;'),
(162, 'Norway', 'Norwegian Krone', 'NOK', NULL),
(163, 'Nepal', 'Nepalese Rupee', 'NPR', NULL),
(164, 'Nauru', 'Australian Dollar', 'AUD', NULL),
(165, 'Niue', 'New Zealand Dollar', 'NZD', NULL),
(166, 'New Zealand', 'New Zealand Dollar', 'NZD', NULL),
(167, 'Oman', 'Rial Omani', 'OMR', NULL),
(168, 'Panama', 'balboa', 'PAB', NULL),
(169, 'Peru', 'Nuevo Sol', 'PEN', NULL),
(170, 'French Polynesia', 'CFP Franc', 'XPF', NULL),
(171, 'Papua New Guinea', 'Kina', 'PGK', NULL),
(172, 'Philippines', 'Philippine Peso', 'PHP', NULL),
(173, 'Pakistan', 'Pakistan Rupee', 'PKR', NULL),
(174, 'Poland', 'Zloty', 'PLN', NULL),
(175, 'Saint Pierre and Miquelon', 'Euro', 'EUR', '&#8364;'),
(176, 'Pitcairn Islands', 'New Zealand Dollar', 'NZD', NULL),
(177, 'Puerto Rico', 'US dollar', 'USD', '&#36;'),
(179, 'Portugal', 'Euro', 'EUR', '&#8364;'),
(180, 'Palau', 'US dollar', 'USD', '&#36;'),
(181, 'Paraguay', 'Guarani', 'PYG', NULL),
(182, 'Qatar', 'Qatari Rial', 'QAR', NULL),
(183, 'R', 'Euro', 'EUR', '&#8364;'),
(184, 'Romania', 'Leu', 'RON', NULL),
(185, 'Russia', 'Russian Ruble', 'RUB', NULL),
(186, 'Rwanda', 'Rwanda Franc', 'RWF', NULL),
(187, 'Saudi Arabia', 'Saudi Riyal', 'SAR', NULL),
(188, 'Solomon Islands', 'Solomon Islands Dollar', 'SBD', NULL),
(189, 'Seychelles', 'Seychelles Rupee', 'SCR', NULL),
(190, 'Sudan', 'Sudanese Dinar', 'SDD', NULL),
(191, 'Sweden', 'Swedish Krona', 'SEK', NULL),
(192, 'Singapore', 'Singapore Dollar', 'SGD', NULL),
(193, 'Saint Helena', 'Saint Helenian Pound', 'SHP', NULL),
(194, 'Slovenia', 'Tolar', 'SIT', NULL),
(195, 'Svalbard', 'Norwegian Krone', 'NOK', NULL),
(196, 'Slovakia', 'Slovak Koruna', 'SKK', NULL),
(197, 'Sierra Leone', 'Leone', 'SLL', NULL),
(198, 'San Marino', 'Euro', 'EUR', '&#8364;'),
(199, 'Senegal', 'CFA Franc BCEAO', 'XOF', NULL),
(200, 'Somalia', 'Somali Shilling', 'SOS', NULL),
(201, 'Suriname', 'Suriname Guilder', 'SRG', NULL),
(202, 'S', 'Dobra', 'STD', NULL),
(203, 'El Salvador', 'El Salvador Colon', 'SVC', NULL),
(204, 'Syria', 'Syrian Pound', 'SYP', NULL),
(205, 'Swaziland', 'Lilangeni', 'SZL', NULL),
(206, 'Turks and Caicos Islands', 'US Dollar', 'USD', '&#36;'),
(207, 'Chad', 'CFA Franc BEAC', 'XAF', NULL),
(208, 'French Southern and Antarctic Lands', 'Euro', 'EUR', '&#8364;'),
(209, 'Togo', 'CFA Franc BCEAO', 'XOF', NULL),
(210, 'Thailand', 'Baht', 'THB', NULL),
(211, 'Tajikistan', 'Somoni', 'TJS', NULL),
(212, 'Tokelau', 'New Zealand Dollar', 'NZD', NULL),
(213, 'Turkmenistan', 'Manat', 'TMM', NULL),
(214, 'Tunisia', 'Tunisian Dinar', 'TND', NULL),
(215, 'Tonga', 'Pa''anga', 'TOP', NULL),
(216, 'East Timor', 'Timor Escudo', 'TPE', NULL),
(217, 'Turkey', 'Turkish Lira', 'TRL', NULL),
(218, 'Trinidad and Tobago', 'Trinidad and Tobago Dollar', 'TTD', NULL),
(219, 'Tuvalu', 'Australian Dollar', 'AUD', NULL),
(220, 'Taiwan', 'New Taiwan Dollar', 'TWD', NULL),
(221, 'Tanzania', 'Tanzanian Shilling', 'TZS', NULL),
(222, 'Ukraine', 'Hryvnia', 'UAH', NULL),
(223, 'Uganda', 'Uganda Shilling', 'UGX', NULL),
(224, 'United Kingdom', 'Pound Sterling', 'GBP', '&#163;'),
(225, 'United States Minor Outlying Islands', 'US Dollar', 'USD', '&#36;'),
(226, 'United States', 'US Dollar', 'USD', '&#36;'),
(227, 'Uruguay', 'Peso Uruguayo', 'UYU', NULL),
(228, 'Uzbekistan', 'Uzbekistan Sum', 'UZS', NULL),
(229, 'Holy See (Vatican City)', 'Euro', 'EUR', '&#8364;'),
(230, 'Saint Vincent and the Grenadines', 'East Caribbean Dollar', 'XCD', NULL),
(231, 'Venezuela', 'Bolivar', 'VEB', NULL),
(232, 'British Virgin Islands', 'US dollar', 'USD', '&#36;'),
(233, 'Virgin Islands', 'US Dollar', 'USD', '&#36;'),
(234, 'Vietnam', 'Dong', 'VND', NULL),
(235, 'Vanuatu', 'Vatu', 'VUV', NULL),
(236, 'Wallis and Futuna', 'CFP Franc', 'XPF', NULL),
(237, 'Samoa', 'Tala', 'WST', NULL),
(238, 'Yemen', 'Yemeni Rial', 'YER', NULL),
(239, 'Mayotte', 'Euro', 'EUR', '&#8364;'),
(240, 'Yugoslavia', 'Yugoslavian Dinar', 'YUM', NULL),
(241, 'South Africa', 'Rand', 'ZAR', NULL),
(242, 'Zambia', 'Kwacha', 'ZMK', NULL),
(243, 'Zimbabwe', 'Zimbabwe Dollar', 'ZWD', NULL);

DROP TABLE IF EXISTS `#__classifiedsmanager_currency`;
CREATE TABLE `#__classifiedsmanager_currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `symbol` varchar(20) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `CHK_UNIQUE` (`code`,`symbol`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT INTO `#__classifiedsmanager_currency` (`id`, `name`, `code`, `symbol`, `is_default`) VALUES
(1, 'US Dollar', 'USD', '$', 1);

DROP TABLE IF EXISTS `#__classifiedsmanager_emails`;
CREATE TABLE `#__classifiedsmanager_emails` (
  `email_id` int(10) NOT NULL AUTO_INCREMENT,
  `email_subject` char(255) NOT NULL,
  `email_name` char(255) NOT NULL,
  `email_type` varchar(20) NOT NULL ,
  `email_content` blob NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`email_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

INSERT INTO `#__classifiedsmanager_emails` (`email_id`, `email_subject`, `email_name`, `email_type`, `email_content`, `is_default`) VALUES
(7, 'Contact request', 'Contact Seller Email', 'Contact Seller Email', 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, 0),
(6, 'Abuse Email', 'Abuse Email', 'Abuse Email', 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, 0),
(3, 'Invoice for Ad Promoting', 'Invoice Email', 'Invoice Email', 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, 1),
(4, 'Activation Email', 'Activation Email', 'Activation Email', 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, 0),
(5, 'Email to Friend', 'Email to Friend', 'Email to Friend', 0x3c646976207374796c653d226d617267696e3a203070783b206261636b67726f756e642d636f6c6f723a20236634663366343b20666f6e742d66616d696c793a2048656c7665746963612c417269616c2c73616e732d73657269663b20666f6e742d73697a653a20313270783b223e0d0a3c7461626c6520626f726465723d2230222077696474683d2231303025222063656c6c73706163696e673d2230222063656c6c70616464696e673d223022206267636f6c6f723d2223463446334634223e0d0a3c74626f64793e0d0a3c74723e0d0a3c7464207374796c653d2270616464696e673a20313570783b223e3c63656e7465723e0d0a3c7461626c652077696474683d22353730222063656c6c73706163696e673d2230222063656c6c70616464696e673d22302220616c69676e3d2263656e74657222206267636f6c6f723d2223666666666666223e0d0a3c74626f64793e0d0a3c74723e0d0a3c746420616c69676e3d226c656674223e0d0a3c646976207374796c653d22626f726465723a20736f6c69642031707820236439643964393b223e0d0a3c7461626c65207374796c653d226c696e652d6865696768743a20312e363b20666f6e742d73697a653a20313270783b20666f6e742d66616d696c793a2048656c7665746963612c417269616c2c73616e732d73657269663b20626f726465723a20736f6c69642031707820236666666666663b20636f6c6f723a20233434343b2220626f726465723d2230222077696474683d2231303025222063656c6c73706163696e673d2230222063656c6c70616464696e673d223022206267636f6c6f723d2223666666666666223e0d0a3c74626f64793e0d0a3c74723e0d0a3c7464207374796c653d22636f6c6f723a20236666666666663b2220636f6c7370616e3d2232222076616c69676e3d22626f74746f6d22206865696768743d223330223ec2a03c2f74643e0d0a3c2f74723e0d0a3c74723e0d0a3c7464207374796c653d226c696e652d6865696768743a20333270783b2070616464696e672d6c6566743a20333070783b222076616c69676e3d22626173656c696e65223e5b636f6d70616e795f6c6f676f5d3c2f74643e0d0a3c2f74723e0d0a3c2f74626f64793e0d0a3c2f7461626c653e0d0a3c7461626c65207374796c653d226d617267696e2d746f703a20313570783b206d617267696e2d72696768743a20333070783b206d617267696e2d6c6566743a20333070783b20636f6c6f723a20233434343b206c696e652d6865696768743a20312e363b20666f6e742d73697a653a20313270783b20666f6e742d66616d696c793a20417269616c2c73616e732d73657269663b2220626f726465723d2230222077696474683d22353130222063656c6c73706163696e673d2230222063656c6c70616464696e673d223022206267636f6c6f723d2223666666666666223e0d0a3c74626f64793e0d0a3c74723e0d0a3c7464207374796c653d22626f726465722d746f703a20736f6c69642031707820236439643964393b20626f726465722d626f74746f6d3a20736f6c69642031707820236439643964393b2220636f6c7370616e3d2232223e0d0a3c646976207374796c653d2270616464696e673a203135707820303b223e48656c6c6f2c203c6272202f3e3c6272202f3e4120667269656e64207265636f6d6d656e6465642074686520666f6c6c6f77696e672061643a3c2f6469763e0d0a3c646976207374796c653d2270616464696e673a203135707820303b223e5b61645f75726c5d3c2f6469763e0d0a3c646976207374796c653d2270616464696e673a203135707820303b223e776974682074686973206d6573736167653a3c2f6469763e0d0a3c646976207374796c653d2270616464696e673a203135707820303b223e5b757365725f6d6573736167655d3c6272202f3e3c6272202f3e205468616e6b20796f752c0d0a3c6469763e5b636f6d70616e795f6e616d655d205465616d3c2f6469763e0d0a3c2f6469763e0d0a3c2f74643e0d0a3c2f74723e0d0a3c2f74626f64793e0d0a3c2f7461626c653e0d0a3c7461626c65207374796c653d226c696e652d6865696768743a20312e353b20666f6e742d73697a653a20313270783b20666f6e742d66616d696c793a20417269616c2c73616e732d73657269663b206d617267696e2d72696768743a20333070783b206d617267696e2d6c6566743a20333070783b2220626f726465723d2230222077696474683d22353130222063656c6c73706163696e673d2230222063656c6c70616464696e673d223022206267636f6c6f723d2223666666666666223e0d0a3c74626f64793e0d0a3c7472207374796c653d22666f6e742d73697a653a20313170783b20636f6c6f723a20233939393939393b222076616c69676e3d226d6964646c65223e0d0a3c74643e5b636f6d70616e795f6e616d655d3c2f74643e0d0a3c74643ec2a03c2f74643e0d0a3c2f74723e0d0a3c74723e0d0a3c7464207374796c653d22636f6c6f723a20236666666666663b2220636f6c7370616e3d223222206865696768743d223135223ec2a03c2f74643e0d0a3c2f74723e0d0a3c2f74626f64793e0d0a3c2f7461626c653e0d0a3c2f6469763e0d0a3c2f74643e0d0a3c2f74723e0d0a3c2f74626f64793e0d0a3c2f7461626c653e0d0a3c2f63656e7465723e3c2f74643e0d0a3c2f74723e0d0a3c2f74626f64793e0d0a3c2f7461626c653e0d0a3c2f6469763e, 0),
(2, 'Ad Confirmation Email', 'Ad Confirmation Email', 'Confirmation Email', 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, 1);

DROP TABLE IF EXISTS `#__classifiedsmanager_orders`;
CREATE TABLE `#__classifiedsmanager_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) DEFAULT NULL,
  `ad_id` int(11) DEFAULT NULL,
  `payment_plan_id` int(11) DEFAULT NULL,
  `payment_processor_id` int(11) DEFAULT NULL,
  `payment_status_id` int(11) DEFAULT NULL,
  `reason_text` varchar(255) DEFAULT NULL,
  `creation_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=66 ;

DROP TABLE IF EXISTS `#__classifiedsmanager_payment_processors`;
CREATE TABLE `#__classifiedsmanager_payment_processors` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `timeout` int(5) NOT NULL,
  `mode` enum('live','test') NOT NULL DEFAULT 'live',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

INSERT INTO `#__classifiedsmanager_payment_processors` (`id`, `code`, `name`, `timeout`, `mode`, `status`) VALUES
(6, 'mobilpay', 'Credit Card', 24, 'test', 1),
(7, 'wiretransfer', 'Wire Transfer', 25, 'live', 1),
(9, 'paypal', 'PayPal', 1, 'test', 1),
(11, 'cash', 'Cash', 2, 'live', 0);

DROP TABLE IF EXISTS `#__classifiedsmanager_payment_processor_extrafields`;
CREATE TABLE `#__classifiedsmanager_payment_processor_extrafields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `column_name` varchar(100) DEFAULT NULL,
  `column_value` varchar(255) DEFAULT NULL,
  `processor_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=115 ;

INSERT INTO `#__classifiedsmanager_payment_processor_extrafields` (`id`, `column_name`, `column_value`, `processor_id`) VALUES
(90, 'paypal_email', 'info@cmsjunkie.com', 9),
(107, 'bank_name', 'TD', 7),
(108, 'Bank_Account_Holder_Name', 'CMSJunkie', 7),
(109, 'Bank_Account_Number', '1232-3445-2324-2342', 7),
(110, 'Bank_Address', '30 FreePark street', 7),
(111, 'Bank_City', 'Toronto', 7),
(112, 'Bank_Country', 'Canada', 7),
(113, 'Swift_Code', '1233', 7),
(114, 'IBAN', '12334', 7);

DROP TABLE IF EXISTS `#__classifiedsmanager_payment_status`;
CREATE TABLE `#__classifiedsmanager_payment_status` (
  `id` int(11) NOT NULL,
  `name` varchar(50) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__classifiedsmanager_payment_status` (`id`, `name`, `code`, `description`) VALUES
(1, 'Paid', 'PAID', NULL),
(2, 'Pending', 'PENDING', NULL),
(3, 'Cancelled', 'CANCELLED', NULL),
(4, 'Not Paid', 'NOT_PAID', NULL);

DROP TABLE IF EXISTS `#__classifiedsmanager_pictures`;
CREATE TABLE `#__classifiedsmanager_pictures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(500) DEFAULT NULL,
  `ad_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `order_num` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__classifiedsmanager_category_pictures`;
CREATE TABLE `#__classifiedsmanager_category_pictures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__classifiedsmanager_promotion_plans`;
CREATE TABLE `#__classifiedsmanager_promotion_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `price` int(11) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `period` int(11) DEFAULT NULL,
  `period_unit` varchar(10) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `type` tinyint(1) DEFAULT '1',  
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

INSERT INTO `#__classifiedsmanager_promotion_plans` (`id`, `name`, `price`, `status`, `period`, `period_unit`, `currency_id`,`type`) VALUES
(1, 'Promote Ad', 16, 1, 1, 'WEEK', 1,1),
(2, 'Promote Ad Free (Admin only)', 0, 0, 2, 'WEEK', 1,1),
(3, 'Promote Ad', 35, 1, 3, 'WEEK', 1,1),
(4, 'Promote Ad', 45, 1, 1, 'MONTH', 1,1);

DROP TABLE IF EXISTS `#__classifiedsmanager_state`;
CREATE TABLE `#__classifiedsmanager_state` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=66 ;

INSERT INTO `#__classifiedsmanager_state` (`id`, `code`, `name`, `country_id`) VALUES
(1, 'AB', 'Alberta', 92),
(2, 'BC', 'British Columbia', 36),
(3, 'MB', 'Manitoba', 36),
(4, 'NB', 'New Brunswick', 36),
(5, 'NL', 'Newfoundland and Labrador', 36),
(6, 'NT', 'North West Territories', 36),
(7, 'NS', 'Nova Scotia', 36),
(8, 'NU', 'Nunavut', 36),
(9, 'ON', 'Ontario', 36),
(10, 'PE', 'Prince Edward Island', 36),
(11, 'QC', 'Quebec', 36),
(12, 'SK', 'Saskatchewan', 36),
(13, 'YT', 'Yukon Territories', 36),
(14, 'AL', 'Alabama', 2),
(15, 'AK', 'Alaska', 2),
(16, 'AZ', 'Arizona', 2),
(17, 'AR', 'Arkansas', 2),
(18, 'CA', 'California', 2),
(19, 'CO', 'Colorado', 2),
(20, 'CT', 'Connecticut', 2),
(21, 'DE', 'Delaware', 2),
(22, 'DC', 'Dist. Columbia', 2),
(23, 'FL', 'Florida', 2),
(24, 'GA', 'Georgia', 2),
(25, 'HI', 'Hawaii', 2),
(26, 'ID', 'Idaho', 2),
(27, 'IL', 'Illinois', 2),
(28, 'IN', 'Indiana', 2),
(29, 'IA', 'Iowa', 2),
(30, 'KS', 'Kansas', 2),
(31, 'KY', 'Kentucky', 2),
(32, 'LA', 'Louisiana', 2),
(33, 'ME', 'Maine', 2),
(34, 'MD', 'Maryland', 2),
(35, 'MA', 'Massachusetts', 2),
(36, 'MI', 'Michigan', 2),
(37, 'MN', 'Minnesota', 2),
(38, 'MS', 'Mississippi', 2),
(39, 'MO', 'Missouri', 2),
(40, 'MT', 'Montana', 2),
(41, 'NE', 'Nebraska', 2),
(42, 'NV', 'Nevada', 2),
(43, 'NH', 'New Hampshire', 2),
(44, 'NJ', 'New Jersey', 2),
(45, 'NM', 'New Mexico', 2),
(46, 'NY', 'New York', 2),
(47, 'NC', 'North Carolina', 2),
(48, 'ND', 'North Dakota', 2),
(49, 'OH', 'Ohio', 2),
(50, 'OK', 'Oklahoma', 2),
(51, 'OR', 'Oregon', 2),
(52, 'PA', 'Pennsylvania', 2),
(53, 'PR', 'Puerto Rico', 2),
(54, 'RI', 'Rhode Island', 2),
(55, 'SC', 'South Carolina', 2),
(56, 'SD', 'South Dakota', 2),
(57, 'TN', 'Tennessee', 2),
(58, 'TX', 'Texas', 2),
(59, 'UT', 'Utah', 2),
(60, 'VT', 'Vermont', 2),
(61, 'VA', 'Virginia', 2),
(62, 'WA', 'Washington', 2),
(63, 'WV', 'West Virginia', 2),
(64, 'WI', 'Wisconsin', 2),
(65, 'WY', 'Wyoming', 2);

DROP TABLE IF EXISTS `#__classifiedsmanager_users`;
CREATE TABLE `#__classifiedsmanager_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `joomla_user_id` int(11) DEFAULT NULL,
  `user_type_id` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `address` varchar(550) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

DROP TABLE IF EXISTS `#__classifiedsmanager_user_type`;
CREATE TABLE `#__classifiedsmanager_user_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(500) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT INTO `#__classifiedsmanager_user_type` (`id`, `description`, `name`) VALUES
(1, NULL, 'LNG_PHYSICAL_PERSON'),
(2, NULL, 'LNG_JURIDICAL_PERSON');

DROP TABLE IF EXISTS `#__classifiedsmanager_bookmarks`;
CREATE TABLE `#__classifiedsmanager_bookmarks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ad_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=9 ;

DROP TABLE IF EXISTS `#__classifiedsmanager_ad_videos`;
CREATE TABLE `#__classifiedsmanager_ad_videos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ad_id` int(11) DEFAULT NULL,
  `url` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=47 ;

CREATE TABLE `#__classifiedsmanager_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `description` text,
  `publish_date` DATETIME DEFAULT NULL,
  `retrieve_date` DATETIME DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;