<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class TableCategories extends JTable
{
	var $id	         		    = NULL;
	var $name    				= NULL;
	var $description   			= NULL;
	var $status					= NULL;
	var $parent_category_id     = NULL;
	


	/**
	 * Constructor
	 *
	 * @param object Database connector object
	 */
	function __construct(& $db) {
	
		parent::__construct('#__classifiedsmanager_category', 'id', $db);
	}
	 	
	function getAllCategories($searchFilter,$limitstart,$limit){
		$whereCond = "";
		$limit = intVal($limit); 
		
		$searchFilter->filter_name  = $this->_db->escape( $searchFilter->filter_name );
		$searchFilter->filter_status  = intval( $searchFilter->filter_status );
		
		if(strlen($searchFilter->filter_name)>0){
			$whereCond = "and (locate(lower('".$searchFilter->filter_name."'),lower(a.name)))>0 ";
			$limitstart = 0;
		}
		if($searchFilter->filter_status>-1){
			$whereCond .= " and a.status=".$searchFilter->filter_status;
			$limitstart = 0; 
		}
	
		$query = " SELECT a.*,b.name  as parent_name,c.attributes 
				   FROM #__classifiedsmanager_category a 
			           left join #__classifiedsmanager_category b on a.parent_category_id =b.id
			           left join 
					   (
						   select category_id, 
						   		  GROUP_CONCAT(DISTINCT attribute_name ORDER BY attribute_name DESC SEPARATOR ',')  attributes
						   from (
						  			select a.category_id,b.name as attribute_name 
						  			from #__classifiedsmanager_category_attributes_mapping a 
				                   	left join #__classifiedsmanager_category_attributes b on a.attribute_id=b.id
				           ) as d 
						   group by category_id
						) as c on a.id=c.category_id
					where 1=1 $whereCond	
					order by b.name,a.name";

		$this->_db->setQuery( $query,$limitstart,$limit);
		return $this->_db->loadObjectList();
	}

	function getCategoriesCount($searchFilter){
		$whereCond = "";
		if(strlen($searchFilter->filter_name)>0)
		$whereCond = "and (locate(lower('".$searchFilter->filter_name."'),lower(a.name)))>0 ";
		if($searchFilter->filter_status>-1)
		$whereCond .= " and a.status=".$searchFilter->filter_status;
		
		$query = " SELECT count(*) totalCategories
					   FROM #__classifiedsmanager_category a 
				           left join #__classifiedsmanager_category b on a.parent_category_id =b.id
				           left join 
						   (
							   select category_id, 
							   		  GROUP_CONCAT(DISTINCT attribute_name ORDER BY attribute_name DESC SEPARATOR ',')  attributes
							   from (
							  			select a.category_id,b.name as attribute_name 
							  			from #__classifiedsmanager_category_attributes_mapping a 
					                   	left join #__classifiedsmanager_category_attributes b on a.attribute_id=b.id
					           ) as d 
							   group by category_id
							) as c on a.id=c.category_id
							where 1=1 $whereCond";
	
		$this->_db->setQuery( $query );
		return $this->_db->loadObject()->totalCategories;
	
	}
	function getCategoryLevel($categoryId){
		$query = " SELECT if(c.id>0,3,if(b.id>0,2,1)) categoryLevel
					   FROM #__classifiedsmanager_category a 
				           left join #__classifiedsmanager_category b on a.parent_category_id =b.id
				           left join #__classifiedsmanager_category c on b.parent_category_id =c.id
						where a.id =  $categoryId			
		";
	
		$this->_db->setQuery( $query );
		return $this->_db->loadObject()->categoryLevel;
	}
	
	function getCategories(){
		$query = " SELECT a.*
						   FROM #__classifiedsmanager_category a 
						   order by name";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	
	}
	
	function getParentCategories(){
		$query = " SELECT a.*
					   FROM #__classifiedsmanager_category a 
				       where (a.parent_category_id is null or a.parent_category_id=-1)
				       and a.status=1
					   order by name";
		$this->_db->setQuery( $query );
		
		return $this->_db->loadObjectList();
	
	}
	function getParentCategoriesWithCount(){
		$query = " SELECT a.*,count(b.id) as catCount
						   FROM #__classifiedsmanager_category a 
						   left join #__classifiedsmanager_ads b on a.id=b.category_id
					       where (a.parent_category_id is null or a.parent_category_id=-1)
					       and a.status=1
					       group by a.id 
						   order by name";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	
	}
	
	function getCategory(){
		$query = ' SELECT * FROM #__classifiedsmanager_category';
		$this->_db->setQuery( $query );
		return $this->_db->loadObject();
	}
	function getCategoryAttributes($categoryId){
		$query = " 		select b.id
			  			from #__classifiedsmanager_category_attributes_mapping a 
	                   	inner join #__classifiedsmanager_category_attributes b on a.attribute_id=b.id
	                   	where a.category_id= $categoryId
				 ";
		$this->_db->setQuery( $query );
		return $this->_db->loadColumn();
	}
	function deleteAllCategories($ids){
		$query = "delete from #__classifiedsmanager_category where id in ($ids)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}

	function changeStatus($id){
		$query = 	"UPDATE #__classifiedsmanager_category SET status = IF(status=1, 0, 1) WHERE id in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	function publishItems($id){
		$query = 	"UPDATE #__classifiedsmanager_category SET status = 1 WHERE id in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	function unpublish($id){
		$query = 	"UPDATE #__classifiedsmanager_category SET status = 0 WHERE id in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	function getSubCategories($categoryId){
		$query = 	"select id,name
			  			from #__classifiedsmanager_category 
	                   	where status=1
						and parent_category_id= $categoryId";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	}
	function getParentCategory($categoryId){
		$query = "select parent_category_id
				  from #__classifiedsmanager_category
				  where status=1
				  and id= $categoryId limit 1";
		$this->_db->setQuery( $query );
		return $this->_db->loadObject()->parent_category_id;
	}
	function getCategoryLevels(){

		$query = 	"select a.main_category_id,b.id as subcategory_1_level,b.subcategory_2_level 
					 from (
						select a.id as main_category_id 
						from #__classifiedsmanager_category a 
						where (a.parent_category_id = -1 or  a.parent_category_id =null)
					 ) a
					left join
					( 
						select a.id,GROUP_CONCAT(DISTINCT b.id  SEPARATOR ',') as  subcategory_2_level,a.parent_category_id
						from #__classifiedsmanager_category a
						left join #__classifiedsmanager_category b on a.id=b.parent_category_id
						where (a.parent_category_id!=null or a.parent_category_id!=0)
						group by a.id,a.parent_category_id
					) b on a.main_category_id = b.parent_category_id
					order by a.main_category_id";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	}


	function checkIfAliasExists($id, $alias){
		$db =JFactory::getDBO();
		$query = "SELECT count(*) as nr FROM #__classifiedsmanager_category  WHERE alias='$alias' and id<>$id";
		$db->setQuery($query);
		$result = $db->loadObject();
		return $result->nr;
	}
	
	//gets all main categories with : ad count for each category , picture
	function getParentCategoriesWithCount_pictures($searchFilter= null ){

		$whereCondadCategory="";

		if(isset($searchFilter["categoryIds"]) && is_array($searchFilter["categoryIds"])){
			 $arrayadcategories = implode(",", $searchFilter["categoryIds"]) ;
			 if(!empty($arrayadcategories))			
			 	$whereCondadCategory = "and a.id in ($arrayadcategories)";
		}

		//Ad availability period
		$applicationSettings = JAdsUtil::getApplicationSettings();
 		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;

 		$adValidCheck = "left join
 							(
			                	select a.ad_id, b.type as type, max(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) - CURDATE() >=0
			                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)- CURDATE() >=0
			                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)- CURDATE() >=0
			                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)- CURDATE() >=0
			                     END ) 
			                     as valid,
			                     max(date(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) 
			                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)
			                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)
			                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)
			                     END )) endDate
			                    from #__classifiedsmanager_orders a 
			                    inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
			                    where a.payment_status_id=1
			                     group by a.ad_id
						    ) j on a.id = j.ad_id "; 

 		$advalidCond = "and ( j.valid > 0 or ( date_add(date(a.renewal_date),INTERVAL $validPeriod) - CURDATE() >0 ) )
 						and a.softdelete != 1";

		$query = " SELECT c.*,count(a.id) as catCount ,p.name as picture_name, count(c.id) as nrOfSubCat
						   FROM #__classifiedsmanager_category c
						   left join ( select id,category_id ,renewal_date,softdelete from #__classifiedsmanager_ads where status=1) as a on c.id=a.category_id
						   $adValidCheck
						   left join #__classifiedsmanager_category_pictures p on c.id=p.category_id
					       where (c.parent_category_id is null or c.parent_category_id=-1)
					       and c.status=1
					       $whereCondadCategory
					       $advalidCond
					       group by c.id
						   order by name";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	
	}

	//gets all subcategories and counts ads for that subcategory
	function getSubCategoriesWithCount(){


		//Ad availability period
		$applicationSettings = JAdsUtil::getApplicationSettings();
 		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;
 		
		$adValidCheck = "left join
 							(
			                	select a.ad_id, b.type as type, max(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) - CURDATE() >=0
			                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)- CURDATE() >=0
			                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)- CURDATE() >=0
			                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)- CURDATE() >=0
			                     END ) 
			                     as valid,
			                     max(date(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) 
			                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)
			                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)
			                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)
			                     END )) endDate
			                    from #__classifiedsmanager_orders a 
			                    inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
			                    where a.payment_status_id=1
			                     group by a.ad_id
						    ) j on a.id = j.ad_id "; 

 		$advalidCond = "and ( j.valid > 0 or ( date_add(date(a.renewal_date),INTERVAL $validPeriod) - CURDATE() >0 ) )
 						and a.softdelete != 1";

		$query = " SELECT c.*,count(a.id ) as subcatCount
						   FROM #__classifiedsmanager_category c
						   left join ( select id,category_id,sub_category_id ,renewal_date,softdelete from #__classifiedsmanager_ads where status=1) a on c.id=a.sub_category_id
						   $adValidCheck
						   where (c.parent_category_id is not null and c.parent_category_id != 0)
					       and c.status=1
					       $advalidCond
					       group by c.id
						   order by c.id";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	
	}


	function getHierarchyCategories($searchFilter,$limitstart,$limit){


		$whereCond = "";
		$whereCondstatus= "";

		$searchFilter->filter_name  = $this->_db->escape( $searchFilter->filter_name );
		$searchFilter->filter_status  = intval( $searchFilter->filter_status );
		
		if(strlen($searchFilter->filter_name)>0){
			$whereCond = "and (locate(lower('".$searchFilter->filter_name."'),lower(a.joincategoryname)))>0 ";
			$limitstart = 0;
		}
		if($searchFilter->filter_status>-1){
			$whereCondstatus = " and a.status=".$searchFilter->filter_status;
			$limitstart = 0;
		}
		
		$query = " select distinct a.* from 
				        (select catname,firstSub,secondSub,joinCategoryId,main_category_id,subCategoryId,secondSubId,attributes, status, alias ,joincategoryname from 
							(  select distinct a.id as main_category_id , a.name as catname, null as firstSub, null as secondSub, a.id as joinCategoryId , null as secondSubId,  null as subCategoryId
						       from #__classifiedsmanager_category a 
						       where (a.parent_category_id = -1 or a.parent_category_id =null)
						      
						       union 
						       
						       select distinct a.id as main_category_id, a.name as catname, b.name as firstSub, null as secondSub ,b.id joinCategoryId, null as secondSubId, b.id as subCategoryId
				               from #__classifiedsmanager_category a 
				               inner join #__classifiedsmanager_category b on a.id=b.parent_category_id
				               where (a.parent_category_id=null or a.parent_category_id=-1)
						         			        
						       union 
						        
						       select distinct a.id as main_category_id, a.name as catname, b.mainCat as firstSub, b.subCat as secondSub ,b.id joinCategoryId, b.id secondSubId, b.parentCat as subCategoryId
							   from #__classifiedsmanager_category a 
						       left join 
					            ( select b.id ,a.parent_category_id,b.parent_category_id as parentCat, a.name as mainCat, b.name as subCat 
					               from #__classifiedsmanager_category a 
					               left join #__classifiedsmanager_category b on a.id=b.parent_category_id
					               where (a.parent_category_id!=null or a.parent_category_id!=0)
					               and b.id>0
					               
				        		) b on a.id = b.parent_category_id
						            
						        where (a.parent_category_id = -1 or  a.parent_category_id =null)
						        and b.id>0 
						       
					       ) a 
				 	  	  left join 
						  (
							   select category_id, 
							   		  GROUP_CONCAT(DISTINCT attribute_name ORDER BY attribute_name DESC SEPARATOR ',')  attributes
							   from (
							  			select a.category_id,b.name as attribute_name 
							  			from #__classifiedsmanager_category_attributes_mapping a 
					                   	left join #__classifiedsmanager_category_attributes b on a.attribute_id=b.id
					           ) as d 
							   group by category_id
							)  c on a.joinCategoryId=c.category_id
				 	  	  left join 
						  (
							  select a.id,a.status as status , a.alias as alias ,a.name as joincategoryname
							  from #__classifiedsmanager_category a
							  where 1=1
							  $whereCondstatus
							  			
							)  s on a.joinCategoryId=s.id
						
             ) a 
			where 1=1
			$whereCond
			order by a.catname,a.main_category_id,firstSub,secondSub
		";

		$this->_db->setQuery( $query,$limitstart,$limit);
		$result = $this->_db->loadObjectList();

		return $result;
		
	}
	
}