<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class TableCategoryAttributes extends JTable
{
	/**
	 * Constructor
	 *
	 * @param object Database connector object
	 */
	function __construct(& $db) {
	
		parent::__construct('#__classifiedsmanager_category_attributes', 'id', $db);
	}

	function getAttributeOptions($attributeId=0){
		$query = " 		select b.*
			  			from #__classifiedsmanager_category_attributes a 
	                   		 left join #__classifiedsmanager_category_attribute_options b on a.id=b.attribute_id
	                   	where a.id= $attributeId
	                   	order by b.name asc
				 ";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	}
	function getAllAttributes($searchFilter){
		
		$whereCond = "";
		if(isset($searchFilter->filter_name))
			if(strlen($searchFilter->filter_name)>0)
				$whereCond = "and (locate(lower('".$searchFilter->filter_name."'),lower(a.name)))>0 ";

		if(isset($searchFilter->filter_status))
			if($searchFilter->filter_status>-1)
				$whereCond .= " and a.status=".$searchFilter->filter_status;
		
		$query = " 		select a.*,b.options,c.name as attributeTypeName
				  			from #__classifiedsmanager_category_attributes a 
							left join 
				  			  (
								   select attribute_id, 
								   		  GROUP_CONCAT(DISTINCT name ORDER BY name asc SEPARATOR ',')  options
								   from #__classifiedsmanager_category_attribute_options
								   group by attribute_id
							  ) as b on a.id=b.attribute_id
		             		left join #__classifiedsmanager_category_attribute_types c on a.attribute_type_id=c.id
		             		where 1=1 $whereCond
		             		order by a.name asc
						 ";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	}
	
	function getCategoryAttributes($categoryId){
		$query = "SET SESSION group_concat_max_len = 100000";
		$this->_db->setQuery( $query );
		$this->_db->execute();
		
		$query = " 		select a.*,b.options,b.optionsIDS,c.name as attributeTypeName,c.code as attributeCode,e.minAttrValue, e.maxAttrValue
					  			from #__classifiedsmanager_category_attributes a 
								left join 
					  			  (
									   select attribute_id, 
									   		  GROUP_CONCAT(DISTINCT name ORDER BY name asc SEPARATOR ',')  options,
									   		  GROUP_CONCAT(DISTINCT id ORDER BY name asc SEPARATOR ',')  optionsIDS
									   from #__classifiedsmanager_category_attribute_options
									   group by attribute_id
								  ) as b on a.id=b.attribute_id
			             		left join #__classifiedsmanager_category_attribute_types c on a.attribute_type_id=c.id
			             		inner join #__classifiedsmanager_category_attributes_mapping d on a.id=d.attribute_id
			             		left join 
					  			  (
									   select attribute_id,max(option_id) maxAttrValue ,min(option_id) minAttrValue
									   from #__classifiedsmanager_ad_attributes
									   group by attribute_id
								  ) as e on a.id=e.attribute_id
			             where 
			             	  a.status=1
			             	  and d.category_id=".$categoryId."
							  order by a.name asc";
		$this->_db->setQuery( $query );
		$result = $this->_db->loadObjectList();
		return $result;
		
	}
	function deleteAllAtributes($attributeIds){
		$query = "delete from #__classifiedsmanager_category_attributes where id in ($attributeIds)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	function changeStatus($id){
		$query = 	"UPDATE #__classifiedsmanager_category_attributes SET status = IF(status=1, 0, 1) WHERE id in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	function publishItems($id){
		$query = 	"UPDATE #__classifiedsmanager_category_attributes SET status = 1 WHERE id in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	function unpublish($id){
		$query = 	"UPDATE #__classifiedsmanager_category_attributes SET status = 0 WHERE id in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
}