<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class TableCurrencies extends JTable
{
	var $id						= null;
	var $name					= null;
	var $symbol					= null;
	var $code					= null;	
	var $is_default				= null;
	/**
	 * Constructor
	 *
	 * @param object Database connector object
	 */
	function __construct(& $db) {

		parent::__construct('#__classifiedsmanager_currency', 'id', $db);
	}
	
	function setKey($k)
	{
		$this->_tbl_key = $k;
	}
	function getAllCurrencies(){
		$query = ' SELECT * FROM #__classifiedsmanager_currency';
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	}
	function getDefaultCurrency(){
		$query = ' SELECT * FROM #__classifiedsmanager_currency where is_default=1';
		$this->_db->setQuery( $query );
		return $this->_db->loadObject();
	}
	function changeDefault($id){
		$query = 	"UPDATE #__classifiedsmanager_currency SET is_default = IF(is_default=1, 0, 1) WHERE id in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;		
	}
	function resetDefault($id){
		$query = 	"UPDATE #__classifiedsmanager_currency SET is_default = 0 WHERE id not in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	function deleteAllCurrencies($ids){
		$query = "delete from #__classifiedsmanager_currency where id in ($ids)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	

}