<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class TableManageAds extends JTable
{
	/**
	 * Constructor
	 *
	 * @param object Database connector object
	 */
	function __construct($_db) {
	
		parent::__construct('#__classifiedsmanager_ads', 'id', $_db);
		$date = JFactory::getDate();
		$this->creation_date = $date->toSql();
		//$this->renewal_date = $date->toSql();
		
	}
	
	function getAdDetails($adId){
		$query = "SELECT a.*,b.picture_ids
						   FROM #__classifiedsmanager_ads a 
					           left join 
							   (
								   select ad_id, 
								   		  GROUP_CONCAT(DISTINCT name ORDER BY order_num asc SEPARATOR ',')  picture_ids
								   from #__classifiedsmanager_pictures d
								   group by ad_id
								) as b on a.id=b.ad_id
					where a.id=".$adId;
		//echo $query;
		$this->_db->setQuery( $query );
		return $this->_db->loadObject();
	}
	
	function getAllUserAds($userId,$validPeriod="6 MONTH"){
		$query = "     
				 SELECT a.*,b.picture_id,c.name as currency,d.name as category, j.status as status_id, h.type as promotion_type, h.endDate,h.valid as isPromoted,if (h.valid>0 or (date_add(date(a.renewal_date),INTERVAL $validPeriod) - CURDATE() >0),true,false) as adValid,greatest((date_add(date(a.renewal_date),INTERVAL $validPeriod)),ifnull(h.endDate,a.renewal_date)) as expiryDate
							   FROM #__classifiedsmanager_ads a 
					           left join 
								   (   select ad_id, name as picture_id
									   from #__classifiedsmanager_pictures 
									   where order_num=1
									) as b on a.id=b.ad_id
								inner join #__classifiedsmanager_currency c on a.currency_id = c.id
								inner join 
								( select id,name 
								  from #__classifiedsmanager_category 
								  where 1 = 1 
								) d on a.category_id = d.id
								inner join #__classifiedsmanager_users g on a.user_id = g.id
								left join 
				                (
				                   select a.ad_id, b.type as type, max(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) - CURDATE() >=0
				                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)- CURDATE() >=0
				                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)- CURDATE() >=0
				                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)- CURDATE() >=0
				                     END ) 
				                     as valid,
				                     max(date(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) 
				                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)
				                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)
				                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)
				                     END )) endDate
				                    from #__classifiedsmanager_orders a 
				                    inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
				                    where a.payment_status_id=1
				                     group by a.ad_id
							      ) h on a.id = h.ad_id   
							    left join 
				                (  
				                   select id, payment_status_id as status, ad_id
				                   from #__classifiedsmanager_orders 
				                   where id in (select 
				                   					max(id) 
				                   					from #__classifiedsmanager_orders 
				                   					group by ad_id
				                   				)				 
							      ) j on a.id = j.ad_id                             
								where g.joomla_user_id=$userId
								and a.softdelete != 1
								order by creation_date desc";
		$this->_db->setQuery( $query);
		//echo $query;
		//exit;
		return $this->_db->loadObjectList();
	}
	
	function getAdDetailsDetailed($adId){
		//Ad availability period
		$applicationSettings = JAdsUtil::getApplicationSettings();
 		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;

		$query = " 
				SELECT a.*,b.picture_ids,c.email,c.name as userName,c.user_type_id,c.user_type,d.name as currency
		                  ,g.name as category, g.alias as category_alias,h.name as sub_category,i.name as sub_category2,j.attributeNameValues , if (h.valid>0 or (date_add(date(a.renewal_date),INTERVAL $validPeriod) - CURDATE() >0),true,false) as adValid
							   FROM #__classifiedsmanager_ads a 
						           left join 
								   (
									   select ad_id, 
									   		  GROUP_CONCAT(DISTINCT name ORDER BY order_num asc SEPARATOR ',')  picture_ids
									   from #__classifiedsmanager_pictures d
									   group by ad_id
									) as b on a.id=b.ad_id
									left join 
									(
										select a.*,b.name as user_type,c.name as juserName
										from  #__classifiedsmanager_users a
										left join #__classifiedsmanager_user_type b on a.user_type_id = b.id 
										left join #__users c on a.joomla_user_id = a.id
									) as c on a.user_id=c.id
									left join #__classifiedsmanager_currency d on a.currency_id =d.id
									left join #__classifiedsmanager_category g on a.category_id =g.id
									left join #__classifiedsmanager_category h on a.sub_category_id =h.id
									left join #__classifiedsmanager_category i on a.sub_category_id2 =i.id
									left join 
									(select a.ad_id, GROUP_CONCAT(DISTINCT concat('<b>',b.name ,'</b>' ,': ' , if(b.attribute_type_id=1,a.option_id,c.name)) SEPARATOR ', ') as attributeNameValues from
										#__classifiedsmanager_ad_attributes a
										left join #__classifiedsmanager_category_attributes b on a.attribute_id = b.id
										left join #__classifiedsmanager_category_attribute_options c on  a.attribute_id = c.attribute_id and a.option_id = c.id
										group by a.ad_id 
									) j on a.id = j.ad_id 
									left join 
					                (
					                   select a.ad_id, b.type as type, max(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) - CURDATE() >=0
					                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)- CURDATE() >=0
					                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)- CURDATE() >=0
					                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)- CURDATE() >=0
					                     END ) 
					                     as valid,
					                     max(date(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) 
					                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)
					                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)
					                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)
					                     END )) endDate
					                    from #__classifiedsmanager_orders a 
					                    inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
					                    where a.payment_status_id=1
					                     group by a.ad_id
								      ) h on a.id = h.ad_id  									
						where a.id = $adId ";
		$this->_db->setQuery( $query );
		return $this->_db->loadObject();
	}
	
	function getAddAttributes($adId){
		$query = "select a.ad_id, b.name as attrName, if(b.attribute_type_id=1,a.option_id,c.name) as attrValue from
										#__classifiedsmanager_ad_attributes a
										left join #__classifiedsmanager_category_attributes b on a.attribute_id = b.id
										left join #__classifiedsmanager_category_attribute_options c on  a.attribute_id = c.attribute_id and a.option_id = c.id
										where a.ad_id = $adId";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	}
	
	function getAllAds($searchFilter,$limitStart,$limit, $orderBy=""){
		$whereCond = "";
		

		if(strlen($searchFilter->filter_name)>0){
			$escaped_filtername= $this->_db->escape( $searchFilter->filter_name );
			$whereCond = " and (locate(lower('".$escaped_filtername."'),lower(f.name)))>0 ";
			}
		if($searchFilter->filter_ad_type>0)
			$whereCond .= " and a.ad_type_id =".$searchFilter->filter_ad_type;
		if($searchFilter->filter_category>0)
			$whereCond .= " and a.category_id =".$searchFilter->filter_category;
		if($searchFilter->filter_sub_category>0)
			$whereCond .= " and a.sub_category_id =".$searchFilter->filter_sub_category;
		if($searchFilter->filter_sub_category2>0)
			$whereCond .= " and a.sub_category_id2=".$searchFilter->filter_sub_category2;
		if(strlen($searchFilter->filter_state)>0)
			$whereCond .= " and a.state like '%".$searchFilter->filter_state."%'";
		if(!empty($searchFilter->filter_city)){
			$searchFilter->filter_city = $this->_db->escape( $searchFilter->filter_city );
			$whereCond .= " and (a.city like '%".$searchFilter->filter_city."%')";
			}
		if(!empty($searchFilter->filter_phone)){
			$escaped_filterphone = $this->_db->escape( $searchFilter->filter_phone );
			$whereCond .= " and (a.phone like '%".$escaped_filterphone."%')";
			}
		if(intVal($searchFilter->filter_status)>-1)
			$whereCond .= " and a.status=".$searchFilter->filter_status;
		if(isset($searchFilter->filter_edition) && $searchFilter->filter_edition>0)
			$whereCond .= " and Locate('-$searchFilter->filter_edition-', a.editions)>0 ";

		if(strlen($searchFilter->filter_keyword)>0){
			$escaped_keyword  = $this->_db->escape( $searchFilter->filter_keyword );
			$whereCond .= " and (locate(lower('".$escaped_keyword."'),lower(a.description))>0 or locate(lower('".$escaped_keyword."'),lower(a.title))>0)";
		}

		if(empty($orderBy)){
			$orderBy = " a.id desc ";
		}
		
		$query = " 			   SELECT a.*,b.picture_id,z.name as adType, z.code as adCode, c.name as currency,d.name as category,f.name as username,h.id as orderId, h.payment_status_id, h.type as promotion_type, h.promoteDate,h.processorName,greatest((date_add(date(a.renewal_date),INTERVAL 2 WEEK)),ifnull(h.promoteDate,a.renewal_date)) as expiry_date
							   FROM #__classifiedsmanager_ads a 
						           left join 
								   (
									   select ad_id, 
									   		  GROUP_CONCAT(DISTINCT name ORDER BY order_num asc SEPARATOR ',')  picture_id
									   from #__classifiedsmanager_pictures 
									   where order_num=1
									   group by ad_id
									) as b on a.id=b.ad_id
									inner join #__classifiedsmanager_ad_type z on a.ad_type_id = z.id
									inner join #__classifiedsmanager_currency c on a.currency_id = c.id
									inner join #__classifiedsmanager_category d on a.category_id = d.id
									left join #__classifiedsmanager_users f on a.user_id = f.id
									left join 
				               		(
					                   select a.*,c.name as processorName, b.type as type, 
					                     date(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) 
					                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)
					                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)
					                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)
					                     END ) promoteDate
					                    from (SELECT a.* 
												FROM #__classifiedsmanager_orders a
												INNER JOIN (
													SELECT MAX( id ) id, ad_id
													FROM #__classifiedsmanager_orders
													GROUP BY ad_id
												)b ON a.id = b.id
										) a 
					                    inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
					                    inner join #__classifiedsmanager_payment_processors c  on a.payment_processor_id = c.id
								      ) h on a.id = h.ad_id
						where 1=1 $whereCond
						order by $orderBy";
		$this->_db->setQuery( $query,$limitStart,$limit);
		$data= $this->_db->loadObjectList();
		
		$this->_db->setQuery( $query);
		$this->_db->execute();
		/*if(count($data))
			$data['total']= $this->_db->getNumRows();*/
		
		return $data;
	}
	function changeStatus($id){
		$query = 	"UPDATE #__classifiedsmanager_ads SET status = IF(status=1, 0, 1) WHERE id in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	
	function changeFeaturedStatus($id){
		$query = 	"UPDATE #__classifiedsmanager_ads SET featured = IF(featured=1, 0, 1) WHERE id in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	
	function publishItems($id){
		$query = 	"UPDATE #__classifiedsmanager_ads SET status = 1 WHERE id in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	function unpublish($id){
		$query = 	"UPDATE #__classifiedsmanager_ads SET status = 0 WHERE id in ($id)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}

	
	function getAdsCount(){
		$query = " SELECT count(*) as adCount
								   FROM #__classifiedsmanager_ads a 
							           left join 
									   (
										   select ad_id, 
										   		  GROUP_CONCAT(DISTINCT name ORDER BY order_num asc SEPARATOR ',')  picture_id
										   from #__classifiedsmanager_pictures 
										   where order_num=1
										   group by ad_id
										) as b on a.id=b.ad_id
										left join #__classifiedsmanager_currency c on a.currency_id = c.id
										left join #__classifiedsmanager_category d on a.category_id = d.id
							where a.id=a.id
							and a.status=1";
		$this->_db->setQuery( $query);
		return $this->_db->loadObject()->adCount;
	}
	
	//retrieve maximum pe ad type, used for priceSlider init 
	function getMaxiumPricePerAdType($filterParams){
		
		$query = " select IFNULL(max(a.price),0) as maxtypeprice  
				   from #__classifiedsmanager_ads a 
				   ";
		
		$this->_db->setQuery( $query);
		return $this->_db->loadObject()->maxtypeprice;
	}
	
	function searchAds($filterParams){
		$whereCond = "";
		$attWhereCond = "";
		$attInputWhereCond = "";
		$catWhereCond = "";
		$regionWhereCond = "";
		$sortBy = "creation_date desc";
		$data = array();
		$distanceQuery = "";
		$having = "";

		//Ad availability period
		$applicationSettings = JAdsUtil::getApplicationSettings();
 		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;

		if(!empty($filterParams['stateId']))
			$whereCond .= " and a.state = '".$filterParams['stateId']."'";
		if(isset($filterParams['priceLow']) && !empty($filterParams['priceHigh']) && empty($filterParams['paginationRefresh']) && ($filterParams['userDefinedPrices']=="1"))
			$whereCond .= " and a.price between ".$filterParams['priceLow']." and ".$filterParams['priceHigh'];

		//menu item parameters
		$whereCondadType="";
		$whereCondadCategory="";
		$whereCondadCity="";
		$whereCondadState="";

		if(strlen($filterParams['adType'])>0 && intVal($filterParams['adType'])>0){
				$whereCondadType="";
				$whereCond .= " and a.ad_type_id =".$filterParams['adType'];
			}


		//menu item ad category parameter 
		if(isset($filterParams["adscategories"]) && is_array($filterParams["adscategories"])){
			 $arrayadcategories = implode(",", $filterParams["adscategories"]) ;
			 if(!empty($arrayadcategories))			
			 	$whereCondadCategory = "and ( a.category_id in ($arrayadcategories)
			 							  or a.sub_category_id in ($arrayadcategories)
			 							  or a.sub_category_id2 in ($arrayadcategories) )";
		}

		//menu item city parameter 
		if(isset($filterParams["adscities"]) && is_array($filterParams["adscities"])){
			 $arraycities = "'" .implode("','", str_replace("'", " ", $filterParams["adscities"])). "'" ;
			 if(!empty($arraycities) && $arraycities != "'0'")	
			 	$whereCondadCity = " and a.city in ($arraycities)";
		}else{
			if(!empty($filterParams["citySearch"])){
				$filterParams['citySearch'] = $this->_db->escape( $filterParams['citySearch'] );
				$whereCond .= " and a.city LIKE '%".$filterParams['citySearch']."%'";
			}
		}

		//menu item state parameter 
		if(isset($filterParams["adsstates"]) && is_array($filterParams["adsstates"])){
			 $arraystates = "'" .implode("','", str_replace("'", " ", $filterParams["adsstates"])). "'" ;
			 if(!empty($arraystates) && $arraystates != "'0'" )
			 	$whereCondadState = " and a.state in ($arraystates)";
		}else{
			if(!empty($filterParams["regionSearch"])){
				$filterParams['regionSearch'] = $this->_db->escape( $filterParams['regionSearch'] );
				$whereCond .=  " and a.state LIKE '%".$filterParams['regionSearch']."%'";
			}
		}
		//Filter through latitude and longtitude taken form the zipcode or geolocation

		if(!empty($filterParams['latitude']))
			$latitude = $filterParams['latitude'];			
		if(!empty($filterParams['longitude']))
			$longitude = $filterParams['longitude'];
		if(!empty($filterParams['geo-loc-radius']) || $filterParams['geo-loc-radius'] ==0 )
			$radius = $filterParams['geo-loc-radius'];


		if(!empty($latitude) && !empty($longitude) && $radius>=0){
			$distanceQuery = ", 3956 * 2 * ASIN(SQRT( POWER(SIN(($latitude -abs( a.latitude)) * pi()/180 / 2),2) + COS($latitude * pi()/180 ) * COS( abs( a.latitude) *  pi()/180) * POWER(SIN(($longitude -  a.longitude) *  pi()/180 / 2), 2) )) as distance";
			if(!empty($filterParams['geo-loc-radius']))
			$having = "having distance < $radius";
		}
		$categoryId = null;
		if(!empty($filterParams['categoryId'])){
			$categoryId = $filterParams['categoryId'];
		}		
		else if(!empty($filterParams['categorySearch'])){
			$categoryId = $filterParams['categorySearch'];
		}

		if(!empty($categoryId)){
			switch ($filterParams['categoryLevel']){
				case 3:
					$catWhereCond = "inner join ( select id,name from #__classifiedsmanager_category where (id = ".$categoryId." or parent_category_id=".$categoryId.")) d on a.sub_category_id2 = d.id";
					break;
				case 2:
					$catWhereCond = "inner join ( select id,name from #__classifiedsmanager_category where (id = ".$categoryId." or parent_category_id=".$categoryId.")) d on a.sub_category_id = d.id";
					break;
				case 1:
					$catWhereCond = "inner join ( select id,name from #__classifiedsmanager_category where (id = ".$categoryId." or parent_category_id=".$categoryId.")) d on a.category_id = d.id";
					break;
			}
		}
		else 
			$catWhereCond = "inner join ( select id,name from #__classifiedsmanager_category ) d on a.category_id = d.id";
					
		if(!empty($filterParams['searchKeyword']) && strlen($filterParams['searchKeyword'])>0){
			$filterParams['searchKeyword']  = $this->_db->escape($filterParams['searchKeyword']);
			$whereCond .= " and (locate(lower('".$filterParams['searchKeyword']."'),lower(a.description))>0 or locate(lower('".$filterParams['searchKeyword']."'),lower(a.title))>0)";
		}
		if(!empty($filterParams['userTypeId']) && strlen($filterParams['userTypeId'])>0 && $filterParams['userTypeId']>0)
			$whereCond .= " and f.user_type_id =".$filterParams['userTypeId'];

		if(!empty($filterParams['sortBy']) && strlen($filterParams['sortBy'])>0)
			$sortBy = $filterParams['sortBy'];

		if(count($filterParams['sliderAttributes'])>0){
			$attInputWhereCond = " inner join
								(select distinct ad_id 
							     from #__classifiedsmanager_ad_attributes 
								 where 1 = 1";
			foreach($filterParams['sliderAttributes'] as $sliderAttr){
				$attInputWhereCond .= "  and (attribute_id =".$sliderAttr[0]." and option_id between ".$sliderAttr[1]." and ".$sliderAttr[2]." )";
			}
			$attInputWhereCond .=" )h on a.id=h.ad_id";
		}

		if(!empty($filterParams['attrOptions']) && strlen($filterParams['attrOptions'])>0 && $filterParams['attrOptions']!=0){
			$attrCount = count(explode(",",$filterParams['attrOptions']));
			$attWhereCond = " inner join
									(
									 select * from (
						                 select ad_id, count(option_id) as matchedOptions 
									     from #__classifiedsmanager_ad_attributes 
										 where 1 = 1 and option_id in (".$filterParams['attrOptions'].")  group by ad_id
									 )a where  a.matchedOptions = $attrCount 
								 )f on a.id=f.ad_id";
		}

	
		$query = "  
			SELECT a.*,b.picture_id,c.code as currency,ifnull(i.name, ifnull(h.name,g.name)) as category, if(LENGTH(a.editions) > 1, 1, 0) as paidAd ,j.valid
						$distanceQuery
					   FROM #__classifiedsmanager_ads a 
			           left join 
						   (   select ad_id, name as picture_id
							   from #__classifiedsmanager_pictures 
							   where order_num=1
							) as b on a.id=b.ad_id
						left join #__classifiedsmanager_category g on a.category_id =g.id
						left join #__classifiedsmanager_category h on a.sub_category_id =h.id
						left join #__classifiedsmanager_category i on a.sub_category_id2 =i.id
						inner join #__classifiedsmanager_currency c on a.currency_id = c.id
						inner join #__classifiedsmanager_users f on a.user_id = f.id
						left join
				                (
				                   select a.ad_id, b.type as type, max(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) - CURDATE() >=0
				                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)- CURDATE() >=0
				                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)- CURDATE() >=0
				                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)- CURDATE() >=0
				                     END ) 
				                     as valid,
				                     max(date(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) 
				                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)
				                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)
				                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)
				                     END )) endDate
				                    from #__classifiedsmanager_orders a 
				                    inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
				                    where a.payment_status_id=1
				                     group by a.ad_id
							      ) j on a.id = j.ad_id 
						
						$catWhereCond
						$attWhereCond
						$attInputWhereCond

						where 1 
						and 1 
						and a.status=1
						and a.softdelete != 1
		                $whereCond  $whereCondadCity $whereCondadType $whereCondadState $whereCondadCategory
		                $having
		                and  ( j.valid > 0 or ( date_add(date(a.renewal_date),INTERVAL $validPeriod) - CURDATE() >0 ) )
						order by featured desc,  $sortBy";

		//echo $query;exit;

		$this->_db->setQuery( $query, $filterParams['limitStart'], $filterParams['limit'] );
		$data['records']= $this->_db->loadObjectList();


		$this->_db->setQuery( $query);
		$this->_db->execute();
		
		$data['total']= $this->_db->getNumRows();
		
		return $data;
	}
	function getSearchCategories($filterParams){
		$whereCond = "";
		$attWhereCond = "";
		$catWhereCond = "";
	
		//Ad availability period
		$applicationSettings = JAdsUtil::getApplicationSettings();
 		$validPeriod = $applicationSettings->ad_availability_period." ".$applicationSettings->ad_availability_unit;

 		$adValidCheck = "left join
 							(
			                	select a.ad_id, b.type as type, max(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) - CURDATE() >=0
			                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)- CURDATE() >=0
			                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)- CURDATE() >=0
			                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)- CURDATE() >=0
			                     END ) 
			                     as valid,
			                     max(date(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) 
			                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)
			                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)
			                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)
			                     END )) endDate
			                    from #__classifiedsmanager_orders a 
			                    inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
			                    where a.payment_status_id=1
			                     group by a.ad_id
						    ) j on a.id = j.ad_id "; 

 		$advalidCond = "and ( j.valid > 0 or ( date_add(date(a.renewal_date),INTERVAL $validPeriod) - CURDATE() >0 ) )
 						and a.softdelete != 1";



		if(isset($filterParams["attrOptions"]) && strlen($filterParams["attrOptions"])>0 && $filterParams["attrOptions"]!=0){
			$attrCount = count(explode(",",$filterParams['attrOptions']));
			$attWhereCond = " inner join
									(
									 select * from (
						                 select ad_id, count(option_id) as matchedOptions
									     from #__classifiedsmanager_ad_attributes
										 where 1 = 1 and option_id in (".$filterParams['attrOptions'].")  group by ad_id
									  )a where  a.matchedOptions = $attrCount
							 )f on a.id=f.ad_id";
		}		
		if(!empty($filterParams["adType"]))
			$whereCond .= " and a.ad_type_id =".$filterParams['adType'];
		if(isset($filterParams["stateId"]) && strlen($filterParams['stateId'])>0 && $filterParams['stateId']>0)
			$whereCond .= " and a.state =".$filterParams['stateId'];
		if(isset($filterParams["priceLow"]) && strlen($filterParams['priceLow'])>0 && strlen($filterParams['priceHigh'])>0 && ($filterParams['userDefinedPrices']=="1"))
			$whereCond .= " and a.price between ".$filterParams['priceLow']." and ".$filterParams['priceHigh'];
		if(isset($filterParams["categoryId"]) && strlen($filterParams['categoryId'])>0)
			$catWhereCond .= " and (id = ".$filterParams['categoryId']." or parent_category_id=".$filterParams['categoryId'].")";
		if(isset($filterParams["searchKeyword"]) && strlen($filterParams['searchKeyword'])>0){
			$filterParams['searchKeyword']  = $this->_db->escape($filterParams['searchKeyword']);
			$whereCond .= " and (locate(lower('".$filterParams['searchKeyword']."'),lower(a.description))>0 or locate(lower('".$filterParams['searchKeyword']."'),lower(a.title))>0)";
		}
		if(!empty($filterParams["citySearch"])){
			$filterParams['citySearch'] = $this->_db->escape( $filterParams['citySearch'] );
			$whereCond .= " and a.city LIKE '%".$filterParams['citySearch']."%'";
		}

		$query = "   
		  		   select distinct a.* from 
		        (select main_category_id,catname,firstSub,secondSub,joinCategoryId,subCategoryId,secondSubId,ifNull(b.countCat,0)  countCat , status from (

			       select distinct a.id as main_category_id,a.name catname, null as firstSub, null as secondSub, a.id as joinCategoryId , null as secondSubId,  null as subCategoryId ,a.status as status
			       from #__classifiedsmanager_category a 
			       where (a.parent_category_id = -1 or a.parent_category_id =null)
			       and a.status=1
			        
			       union 
			       
			       select distinct a.id as main_category_id,a.name catname, b.name as firstSub, null as secondSub ,b.id joinCategoryId, null as secondSubId, b.id as subCategoryId ,a.status as status
	               from #__classifiedsmanager_category a 
	               inner join #__classifiedsmanager_category b on a.id=b.parent_category_id
	               where (a.parent_category_id=null or a.parent_category_id=-1)
			       and a.status=1

			       union 
			        
			       select distinct a.id as main_category_id,a.name catname, b.mainCat as firstSub, b.subCat as secondSub ,b.id joinCategoryId, b.id secondSubId, b.parentCat as subCategoryId ,a.status as status
				   from #__classifiedsmanager_category a 
			       left join 
				            ( select b.id ,a.parent_category_id,b.parent_category_id as parentCat, a.name as mainCat, b.name as subCat
				               from #__classifiedsmanager_category a 
				               left join #__classifiedsmanager_category b on a.id=b.parent_category_id
				               where (a.parent_category_id!=null or a.parent_category_id!=0)
				               and b.id>0
			            ) b on a.id = b.parent_category_id
			            
			        where (a.parent_category_id = -1 or  a.parent_category_id =null)		
			        and b.id>0 
			        and a.status=1
			    ) a 
				
			    left join      
			    (			        
			   		(select a.sub_category_id category_id, count(*) countCat
					from #__classifiedsmanager_ads a 
					$adValidCheck
					$attWhereCond
					inner join 
					 (select * from #__classifiedsmanager_category
		             where (parent_category_id != 0 or  parent_category_id !=null)	
		            ) b on a.sub_category_id = b.id  

					where 1 and 1 
					and a.status=1
					$advalidCond
					$whereCond					
					group by a.sub_category_id
		            ) 
		            
		            union
		            
		            (select a.sub_category_id2 category_id, count(*) countCat
					from #__classifiedsmanager_ads a 
					$adValidCheck
					$attWhereCond
					inner join 
					 (select * from #__classifiedsmanager_category
		             where (parent_category_id != 0 or  parent_category_id !=null)	
		            ) b on a.sub_category_id2 = b.id    
					where 1 and 1 
					and a.status=1
					$advalidCond
					$whereCond
					group by a.sub_category_id2
		            ) 
		            
		            union
			        
			        (
				        select a.category_id ,b.countCat from 
					    (   
					    	select distinct a.id as category_id,a.name catname, a.id as subcategory
			       			from #__classifiedsmanager_category a 
			       			where (a.parent_category_id = -1 or a.parent_category_id =null)
					    
			       			union 
			       			
					    	select distinct a.id as category_id,a.name catname,ifnull(b.id,a.id) subcategory 
					        from #__classifiedsmanager_category a 
					        left join 
					            ( select a.id ,a.parent_category_id
					               from #__classifiedsmanager_category a 
					               left join #__classifiedsmanager_category b on a.id=b.parent_category_id
					               where (a.parent_category_id!=null or a.parent_category_id!=0)
					          
					            ) b on a.id = b.parent_category_id
					            
					        where (a.parent_category_id = -1 or  a.parent_category_id =null)
					        
					       union 
					       
					       select distinct a.id as category_id,a.name catname,ifnull(b.id,a.id) subcategory 
					       from #__classifiedsmanager_category a 
					       left join 
					            ( select b.id ,a.parent_category_id
					               from #__classifiedsmanager_category a 
					               left join #__classifiedsmanager_category b on a.id=b.parent_category_id
					               where (a.parent_category_id!=null or a.parent_category_id!=0)
					            ) b on a.id = b.parent_category_id
					            
					        where (a.parent_category_id = -1 or  a.parent_category_id =null)																												
			           ) a 
				        left join 
				        (
				            select a.category_id, count(*) countCat
							from #__classifiedsmanager_ads a 
							$adValidCheck
							$attWhereCond
							where 1 and 1 
							and a.status=1
							$advalidCond 
							$whereCond
				            group by a.category_id
		                ) b on a.subcategory = b.category_id
		                  group by a.category_id,a.catname


	                 ) 
      	        )  b on a.joinCategoryId = b.category_id
          ) a order by a.catname,a.main_category_id,firstSub,secondSub
		";
		$this->_db->setQuery( $query);
		return $this->_db->loadObjectList();
		
	}
	function getGalleryAds($stateId=null){
		$whereCond = "";
		if($stateId!=null && $stateId>0)
			$whereCond = " and a.state='".$stateId."'";
		
		$query = "     SELECT a.*,b.picture_id,c.code as currency
					   FROM #__classifiedsmanager_ads a 
					   left join 
					   (
						   select ad_id, 
						   		  GROUP_CONCAT(DISTINCT name ORDER BY order_num asc SEPARATOR ',')  picture_id
						   from #__classifiedsmanager_pictures 
						   where order_num=1
						   group by ad_id
						) as b on a.id=b.ad_id 
						inner join #__classifiedsmanager_currency c on a.currency_id = c.id
						inner join 
						(
							select a.* 
							from #__classifiedsmanager_orders a 
								 inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
							where  
							(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) - CURDATE() >=0
		                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)- CURDATE() >=0
		                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)- CURDATE() >=0
		                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)- CURDATE() >=0
		                     END ) 
							and b.type = 1
						) d on a.id = d.ad_id
						where d.payment_status_id=1
							  and a.status = 1
							  $whereCond
						order by a.counter asc limit 4";
		$this->_db->setQuery( $query);

		return $this->_db->loadObjectList();
		
	}
	function setViewCounter($adIds){
		$query = 	"UPDATE #__classifiedsmanager_ads SET counter = counter+1 WHERE id in ($adIds)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	function renewAd($adIds){
		$query = 	"UPDATE #__classifiedsmanager_ads SET renewal_date = curdate(),status=1 WHERE id in ($adIds)";
		$this->_db->setQuery( $query );
		if (!$this->_db->execute())
		{
			return false;
		}
		return true;
	}
	
	function checkAdOwner($userId, $adId){
		$query = 	"select * 
		             from  #__classifiedsmanager_ads a
		             inner join #__classifiedsmanager_users b on a.user_id = b.id
		             WHERE a.id =$adId
					 and b.joomla_user_id = $userId";
		$this->_db->setQuery($query);
		return $this->_db->loadObject();
	}
	
	function getExpiredAds($validPeriod,$referenceDays){
		$query = "select * from(
						 SELECT a.id,a.title,a.status,f.email,f.name,h.endDate,h.valid as isPromoted,if (h.valid>0 or (date_add(date(a.renewal_date),INTERVAL $validPeriod) - CURDATE() >0),true,false) as adValid,greatest((date_add(date(a.renewal_date),INTERVAL $validPeriod)),ifnull(h.endDate,a.renewal_date)) as expiryDate
									   FROM #__classifiedsmanager_ads a 
							           inner join #__classifiedsmanager_users f on a.user_id = f.id
										left join 
						                (
						                   select a.ad_id,max(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) - CURDATE() >=0
						                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)- CURDATE() >=0
						                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)- CURDATE() >=0
						                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)- CURDATE() >=0
						                     END ) 
						                     as valid,
						                     max(date(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) 
						                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)
						                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)
						                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)
						                     END )) endDate
						                    from #__classifiedsmanager_orders a 
						                    inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
						                    where a.payment_status_id=1
						                     group by a.ad_id
									      ) h on a.id = h.ad_id                              
						) a where a.expiryDate < date_sub(NOW(), INTERVAL $referenceDays DAY) and a.status=1";
		$this->_db->setQuery( $query);
		//echo $query;
		//exit;
		return $this->_db->loadObjectList();		
	}
	
	function getPromoToExpireAds($referenceDays){
		$query = "			 SELECT a.*,d.*
							 FROM #__classifiedsmanager_ads a 
							 inner join 
								(
									select a.*,a.id as orderId
									from #__classifiedsmanager_orders a 
										 inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
									where  
									(CASE b.period_unit  when 'DAY' then date_add(date(a.creation_date),INTERVAL b.period DAY) - CURDATE() <=$referenceDays
				                          WHEN 'WEEK' then date_add(date(a.creation_date),INTERVAL b.period WEEK)- CURDATE() <=$referenceDays
				                          WHEN 'MONTH' then date_add(date(a.creation_date),INTERVAL b.period MONTH)- CURDATE() <=$referenceDays
				                          WHEN 'YEAR' then date_add(date(a.creation_date),INTERVAL b.period YEAR)- CURDATE() <=$referenceDays
				                     END ) 
								) d on a.id = d.ad_id
							WHERE a.email <> '' 
							and d.payment_status_id = ".JCLS_PAYMENT_STATUS_PAID; 
		
		$this->_db->setQuery( $query);
		return $this->_db->loadObjectList();
	}
	
	
	
	function getPaymentDetails($adId){
		$query = "		 SELECT a.id,a.title,a.status,b.*
										   FROM #__classifiedsmanager_ads a 
										        inner join 
								                (
								                    SELECT a.* from
								                    (SELECT a.* 
														FROM #__classifiedsmanager_orders a
														INNER JOIN (
															SELECT MAX( id ) id, ad_id
															FROM #__classifiedsmanager_orders
															GROUP BY ad_id
														)b ON a.id = b.id
													) a
						                    	   inner join #__classifiedsmanager_payment_processors c on a.payment_processor_id = c.id 
									          	   inner join #__classifiedsmanager_promotion_plans b  on a.payment_plan_id = b.id
									          	   where a.id = $adId
							                       group by a.ad_id
							                       order by a.ad_id desc limit 1,1
										      ) b on a.id = b.ad_id                              
							";
		$this->_db->setQuery( $query);
		//echo $query;
		//exit;
		return $this->_db->loadObjectList();
	}
	
	
	public function getEditions(){
		$query =" select * from  #__editions ";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	}
	
	function getCategoriesForExport(){
		$query = "select *  from #__classifiedsmanager_category order by parent_category_id, name";
		$this->_db->setQuery( $query);
	
		return $this->_db->loadObjectList();
	}
	
	function getAllStates(){
		$query = " select distinct a.state as state
				   from #__classifiedsmanager_ads a
				   order by state
		";
		$this->_db->setQuery( $query);
		return $this->_db->loadObjectList();
	}
	
	function getAllCities(){
		$query = " select distinct a.city as city
				   from #__classifiedsmanager_ads a
				   order by city
		";
		$this->_db->setQuery( $query);
		return $this->_db->loadObjectList();
	}
	
	function getAdsReport($reportType,$dayLag){
		$whereCond = "";
		$dayDiff = "-".$dayLag.' day';
		$dateStart =  date('Y-m-d',(strtotime ($dayDiff)));
		$dateEnd = new DateTime('NOW'); 
		$dateEnd->modify( '+1 day' );
		$dateEnd =  date_format($dateEnd,'Y-m-d');
		
	
		$db =JFactory::getDBO();
		$query = "	SELECT
					count(c.id) adsTotal,
					(CASE '$reportType' WHEN 'DAY' then concat(Month(c.creation_date),'-',Day(c.creation_date),'-',Year(c.creation_date))
						WHEN 'WEEK' then  concat('W',Week(c.creation_date))
						WHEN 'MONTH' then concat(Month(c.creation_date),'-','01','-',Year(c.creation_date))
						WHEN 'YEAR' then  concat(Year(c.creation_date))
					END) as groupUnit
					FROM #__classifiedsmanager_ads c
					where c.creation_date between '$dateStart' and '$dateEnd'
					$whereCond
					GROUP BY groupUnit
					ORDER BY groupUnit asc";
		$db->setQuery($query);
		return $db->loadObjectList();
	}


	function getTotalIncome(){
		$query	= "	select a.*,a.id as order_id,b.code,c.price, SUM(c.price) as sumincome ,c.currency,c.period,c.period_unit,d.code as processorType from  
		            #__classifiedsmanager_orders a 
		            inner join #__classifiedsmanager_payment_status b on a.payment_status_id  = b.id
		            inner join 
		            	(select c.*,a.code as currency 
		            	  from #__classifiedsmanager_promotion_plans c
		            	  	   left join #__classifiedsmanager_currency a
		            	  	   on c.currency_id = a.id
		           	) c on a.payment_plan_id = c.id
		           	inner join #__classifiedsmanager_payment_processors d on a.payment_processor_id = d.id
		           	where a.payment_status_id = 1
		           	group by b.id";
		$this->_db->setQuery( $query );
		$result = $this->_db->loadObject();
		return $result;
	}


	function getMonthIncome(){
		$query	= "	select a.*,a.id as order_id,b.code,c.price, SUM(c.price) as sumincome ,c.currency,c.period,c.period_unit,d.code as processorType from  
		            #__classifiedsmanager_orders a 
		            inner join #__classifiedsmanager_payment_status b on a.payment_status_id  = b.id
		            inner join 
		            	(select c.*,a.code as currency 
		            	  from #__classifiedsmanager_promotion_plans c
		            	  	   left join #__classifiedsmanager_currency a
		            	  	   on c.currency_id = a.id
		           	) c on a.payment_plan_id = c.id
		           	inner join #__classifiedsmanager_payment_processors d on a.payment_processor_id = d.id
		           	where a.payment_status_id = 1
		           	and MONTH(a.creation_date)=MONTH(NOW())
		           	group by b.id";
		$this->_db->setQuery( $query );
		$result = $this->_db->loadObject();
		return $result;
	}


	function getAdsCountMonth(){
		$query = " SELECT count(*) as adCount
								   FROM #__classifiedsmanager_ads a 
							           left join 
									   (
										   select ad_id, 
										   		  GROUP_CONCAT(DISTINCT name ORDER BY order_num asc SEPARATOR ',')  picture_id
										   from #__classifiedsmanager_pictures 
										   where order_num=1
										   group by ad_id
										) as b on a.id=b.ad_id
										left join #__classifiedsmanager_currency c on a.currency_id = c.id
										left join #__classifiedsmanager_category d on a.category_id = d.id
							where a.id=a.id
							and MONTH(a.creation_date)=MONTH(NOW()) ";
		$this->_db->setQuery( $query);
		return $this->_db->loadObject()->adCount;
	}

	function getPromotedAdsCount(){
		$query	= "	select COUNT(DISTINCT ad_id) as adscount from  
		            #__classifiedsmanager_orders a 
		           	where a.payment_status_id = 1";
		$this->_db->setQuery( $query );
		$result = $this->_db->loadObject();
		return $result;
	}

	function getPromotedAdsCountMonth(){
		$query	= "	select COUNT(DISTINCT ad_id) as adscount  from  
		            #__classifiedsmanager_orders a 
		           	where a.payment_status_id = 1
		           	and MONTH(a.creation_date)=MONTH(NOW())";
		$this->_db->setQuery( $query );
		$result = $this->_db->loadObject();
		return $result;
	}

	function increaseViewCount($adId){
		$db =JFactory::getDBO();
		$query = "update  #__classifiedsmanager_ads set view_count = view_count + 1 where id=$adId";
		$db->setQuery($query);
		return $db->execute();
	}


	function getAdsViews(){
		$query	= "	select sum(view_count) as adsviews  from  
		            #__classifiedsmanager_ads ";
		$this->_db->setQuery( $query );
		$result = $this->_db->loadObject();
		return $result;
	}


	function checkIfAliasExists($id, $alias){
		$db =JFactory::getDBO();
		$query = "SELECT count(*) as nr FROM #__classifiedsmanager_ads  WHERE alias='$alias' and id<>$id";
		$db->setQuery($query);
		$result = $db->loadObject();
		return $result->nr;
	}
	

	function getUserAdsViews($userId){
		$db =JFactory::getDBO();
		$query	= "	select sum(view_count) as adsviews  
					from  #__classifiedsmanager_ads a
		            inner join #__classifiedsmanager_users b on a.user_id = b.id
		            where b.joomla_user_id =$userId ";

		$this->_db->setQuery( $query );
		$result = $this->_db->loadObject();
		return $result;
	}

	function getUserAdsCount($userId){
		$query	= "	select count(*) as adCount  
					from  #__classifiedsmanager_ads a
		            inner join #__classifiedsmanager_users b on a.user_id = b.id
		            where b.joomla_user_id =$userId ";
		            
		$this->_db->setQuery( $query);
		$result = $this->_db->loadObject()->adCount;
		return $result;
	}

	function getUserBookmarkCount($userId){
		$query	= "	select count(*) as bookmarkCount  
					from  #__classifiedsmanager_bookmarks 
		            where user_id =$userId ";
		            
		$this->_db->setQuery( $query);
		$result = $this->_db->loadObject()->bookmarkCount;
		return $result;
	}

	//soft deletes an ad
	function softDeleteAd($adId){
		$db =JFactory::getDBO();
		$query = "update  #__classifiedsmanager_ads set softdelete = 1 where id=$adId";
		$db->setQuery($query);
		return $db->execute();
	}



}


