<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class TableManageAdTypes extends JTable
{
	var $id	         		    = NULL;
	var $name    				= NULL;
	var $description   			= NULL;
	/**
	 * Constructor
	 *
	 * @param object Database connector object
	 */
	function __construct(& $db) {

		parent::__construct('#__classifiedsmanager_ad_type', 'id', $db);
	}
	function getAllAdTypes(){
		$query = " SELECT * FROM #__classifiedsmanager_ad_type 
									where status = 1
									order by ordering asc  ";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	}
	function getAdType($adTypeId){
		$query = " SELECT name FROM #__classifiedsmanager_ad_type where id=$adTypeId ";
		$this->_db->setQuery( $query );
		return $this->_db->loadObject()->name;
	}
	function getAdTypesWithCount(){
		$query = " SELECT a.*,count(b.id) as catCount
							   FROM #__classifiedsmanager_ad_type a 
							   left join #__classifiedsmanager_ads b on a.id=b.ad_type_id
						       where (a.parent_category_id is null or a.parent_category_id=-1)
						       and a.status=1
						       group by a.id 
							   order by name";
		$this->_db->setQuery( $query );
		return $this->_db->loadObjectList();
	
	}

	function getAdTypeOrder(){
		$query = " SELECT max(ordering)+1 as adtypeOrder  FROM #__classifiedsmanager_ad_type";
		//dmp($query);
		$this->_db->setQuery( $query );
		return $this->_db->loadObject()->adtypeOrder;
	}


}