<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view' );
jimport('joomla.html.pane');
jimport('joomla.html.pagination');

class JClassifiedsManagerViewCategories extends JClassifiedsManageAdminView
{

	function display($tpl = null)
	{
		
		$this->user_id = JFactory::getApplication()->input->get('user_id');
		$function = $this->getLayout();
		if(method_exists($this,$function)) 
			$tpl = $this->$function();
		$this->setLayout('default');
		parent::display($tpl);
	}

	function listing()
	{
		$model = $this->getModel();
		$this->searchFilter = $model->initSearchFilter();
		
		//$categories = $model->getAllCategories($this->searchFilter);

		$categories = $model->getHierarchyCategories($this->searchFilter);
		$this->rows=$categories;

		$this->addToolbar();
		//pagination
		$pagination =$this->get('Pagination');
		$this->pagination=$pagination;
		return null;
	}

	function addToolbar(){
		JToolBarHelper::title(  'J-ClassifiedsManager :'.JText::_('LNG_MANAGE_CATEGORIES'), 'user.png' );
		JToolBarHelper::addNew('category.edit'); 
		JToolBarHelper::deleteList(JText::_('LNG_ARE_YOU_SURE_YOU_WANT_TO_DELETE'), 'categories.delete', JText::_('LNG_DELETE'), 'Delete', false, false );
		JToolBarHelper::publish('categories.publish');
		JToolBarHelper::unpublish('categories.unpublish');
		JToolBarHelper::custom( 'jclassifiedsmanager.dashboard', JAdsUtil::getDashBoardIcon(), 'home', JText::_('LNG_ADS_DASHBOARD'),false, false );
        JToolBarHelper::help('', false, DOCUMENTATION_URL.'settingupclassifieds.html#categories');

        //JAdsHelper::addSubmenu('categories');
	}
	
}