<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access');
JHtml::_('formbehavior.chosen', '#parent_category_id');

?>

<script type="text/javascript">
	window.addEventListener('load', function() {
        jQuery('.multiselect').multi({
            'enable_search': true,
            'search_placeholder': '<?php echo JText::_("LNG_SEARCH") . "...";?>'
        });

		imageUploader("#file-upload",
		'<?php echo JURI::root()?>components/com_jclassifiedsmanager/helpers/upload.php?t=<?php echo strtotime('now')?>&resizeImage=0&_root_app=<?php echo urlencode(JPATH_ROOT)?>&_target=<?php echo urlencode(PATH_PICTURES.CAT_PICTURE_PATH)?><?php echo $this->category->id;?>/',
		".fileinput-button",
		"",
		"",
		1,
		"setUpPicture");
	});
</script>

<div id="jcls-container" class="jcls-container jcls-edit-container">
	    <form action="index.php" method="post" name="adminForm" id="adminForm" >
			<div class="row">
				<div class="col-md-8">
					<fieldset class="boxed">
						<h2><?php echo JText::_( 'LNG_CATEGORY_SETTINGS' ); ?> </h2>
						
						<div class="form-group">
							<label for="name"><?php echo JText::_('LNG_NAME') ?></label>
							<input 
								type		= "text"
								name		= "name"
								id			= "name"
								value		= "<?php echo $this->category->name;?>"
								size		= 106
								class		= "form-control validate[required,maxSize[60]]"
							/>
						</div>
						<div class="form-group">
							<label for="alias"><?php echo JText::_('LNG_ALIAS') ?></label>
							<input 
								type		= "text"
								name		= "alias"
								id			= "alias"
								value		= '<?php echo $this->category->alias;?>'
								size		= 106
								placeholder="<?php echo JText::_('LNG_AUTO_GENERATE_FROM_NAME')?>"
								class		= "form-control"
							/>
						</div>
						<div class="form-group">
							<label for="parent_category_id"><?php echo JText::_('LNG_PARENT_CATEGORY') ?></label>
							<select name="parent_category_id" id="parent_category_id" style="width:100%;" class="form-control"> 
								<option value='-1'><?php echo JText::_('LNG_ROOT'); ?></option>
								<?php

									$prevMainCategory = "";
									$prevSubCategory = "";
									$prevSubCategory2 = "";
									$index = 0; 
									$selected="";

									foreach ($this->categories as $filterCategory){
													
										if($prevMainCategory!=$filterCategory->main_category_id){	
											if ($filterCategory->main_category_id == $this->category->parent_category_id) {
												$selected="selected";
											}
											echo "<option value='$filterCategory->main_category_id' $selected>$filterCategory->catname</option>";
											$selected="";
											$prevMainCategory = $filterCategory->main_category_id;
										}
										else if ($prevSubCategory!=$filterCategory->firstSub){
											if ($filterCategory->subCategoryId == $this->category->parent_category_id) {
												$selected="selected";
												
											}
											echo "<option value='$filterCategory->subCategoryId' $selected> - $filterCategory->firstSub</option>";
											$selected="";
											$prevSubCategory = $filterCategory->firstSub;
										}
										else if($prevSubCategory2!=$filterCategory->secondSub){
											if ($filterCategory->secondSubId == $this->category->parent_category_id) {
												$selected="selected";
											
											}
											echo "<option value='$filterCategory->secondSubId' $selected> -- $filterCategory->secondSub</option>";
											$selected="";
											$prevSubCategory2 = $filterCategory->secondSub;
										}
										$index++;
									}

								?>
							</select>	
						</div>
						<div class="form-group">
							<label for="description"><?php echo JText::_('LNG_DESCRIPTION') ?></label>
							<textarea 
								name		= "description"	
								id			= "description"
								rows="3"
								cols="20"
								class="form-control"
							><?php if(isset($this->category->description)) echo $this->category->description;?></textarea>
						</div>
					</fieldset>

					<fieldset class="boxed" >
						<h2><?php echo JText::_('LNG_UPLOAD_PICTURES'); ?> </h2>
						<div class="jupload logo-jupload">
							<div class="jupload-body">
								<div class="jupload-files">
									<div class="jupload-files-img image-fit-contain" id="picture-preview">
										<?php if(!empty($this->picture->name)) {
											echo "<img  id='itemImg' src='".JURI::root().PATH_PICTURES.CAT_PICTURE_PATH.$this->category->id.'/'.$this->picture->name."'/>";
										}else{
											echo "<i class='la la-image'></i>";
										} ?>
									</div>
								</div>
							</div>
							<?php if ($this->category->id){ ?>
								<div class="jupload-footer">
									<div class="dropzone dropzone-previews" id="file-upload">
										<!-- The fileinput-button span is used to style the file input field as button -->
										<span class="btn btn-success fileinput-button dz-clickable" style="margin-right: 0.25rem !important; display: inline-block;">
											<i class="glyphicon glyphicon-plus"></i>
											<span><?php echo JText::_("LNG_ADD_FILE")?></span>
										</span>
										<button  class="btn btn-primary start" id="submitAll">
											<i class="glyphicon glyphicon-upload"></i>
											<span><?php echo JText::_("LNG_UPLOAD")?></span>
										</button>
									</div>
								</div>
							<?php } else { ?>
								<div class="alert alert-danger">
									<p><?php echo JText::_('LNG_SAVE_TO_UPLOAD'); ?> </p>
								</div>
							<?php } ?>
						</div>
					</fieldset>

					<fieldset class="boxed" >
						<h2><?php echo JText::_( 'LNG_ASSIGN_ATTRIBUTES' ); ?></h2>
						<div class="textInfo"><?php echo JText::_( 'LNG_MAPPING_INFORMATION' ); ?></div>
						<div class="form-container">
                                <div class="form-group">
									<label for="attributes"><?php echo JText::_('LNG_ATTRIBUTES')?> </label>
									<select id="attributes" class="multiselect" multiple="multiple" name="attributes[]" size="10">
										<?php
											for($i = 0,$a = count($this->attributes);$i<$a;$i++){
												$row =$this->attributes[$i];

												if(in_array($row->id,$this->categoryAttributes)>0){
													$selected = "selected='selected'";
												}
												else
													$selected = "";
												echo "<option value='$row->id' $selected >$row->name</option>";
											}
										?>
									</select>
								</div>
                            </div>
						<br/>


						<input type="hidden" name="pic_name" id="pic_name" value="">
						<input type="hidden" name="id" value="<?php echo $this->category->id;?>" />
						<input type="hidden" name="option" value="<?php echo getAdComponentName()?>" />
						<input type="hidden" name="task" value="" />
						<input type="hidden" name="controller" value="category" />
						<input type="hidden" name="view" value="category" />
						<?php echo JHTML::_( 'form.token' ); ?>
					</fieldset>
				</div>
			</div>
    </form>
</div>
<script type="text/javascript">
	

	function myValidate(f) {
		   var isError = jQuery("#adminForm").validationEngine('validate');
		   return isError;
		}

		Joomla.submitbutton = function(pressbutton) 
		{
			if (pressbutton == 'category.save' || pressbutton == 'category.apply'){
				var isValid = myValidate('#adminForm') ;
				if (isValid == true) {
					Joomla.submitform(pressbutton, document.getElementById('adminForm'));
				}
			}else{
				pressbutton = 'categories.listing';
				jQuery("#adminForm").validationEngine('detach');
				Joomla.submitform(pressbutton, document.getElementById('adminForm'));
			
			}
		}



	function setUpPicture(path){
		jQuery("#imageLocation").val("<?php echo CAT_PICTURE_PATH.$this->category->id;?>" + path);
		var img_new = document.createElement('img');
		img_new.setAttribute('src', "<?php echo JURI::root().PATH_PICTURES.CAT_PICTURE_PATH.$this->category->id;?>/" + path );
		img_new.setAttribute('class', 'category-picture');
		jQuery("#picture-preview").children().remove();
		jQuery("#picture-preview").append(img_new);	
		jQuery('#pic_name').val(path);
			
	}

    jQuery(document).ready(function () {
        addingClasses("td.btn-group");
    });
</script>
</fieldset>
