<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view' );
jimport('joomla.html.pane');

class JClassifiedsManagerViewCategory extends JClassifiedsManageAdminView
{

	function display($tpl = null)
	{
		$this->user_id = JFactory::getApplication()->input->get('user_id');
		
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');

		$model = $this->getModel();
		$this->includePictureFunctions();
		$this->includeMultipleLayout();
		$this->includeValidation();

		$this->category = $model->getCategory();
		$this->categoryAttributes = $model->getCategoryAttributes();
		$this->attributes = $model->getAllAttributes();
		$this->picture = $model->getCategoryImage();

		//parent category dropdown
		$this->searchFilter = $model->initSearchFilter();
		$this->categories= $model-> getHierarchyCategories($this->searchFilter);


		JFactory::getApplication()->input->set( 'hidemainmenu', 1 ); 
		$this->addToolbar();
		parent::display($tpl);
	}
	

	
	function addToolbar(){
		JToolBarHelper::title(  'J-ClassifiedsManager :'.JText::_('LNG_EDIT_CATEGORY'), 'generic.png' );
		JToolBarHelper::apply('category.apply');
		JToolBarHelper::save('category.save');
		JToolBarHelper::custom( 'categories.listing', 'cancel.png', 'cancel.png', 'Cancel',false, false );
        JToolBarHelper::help('', false, DOCUMENTATION_URL.'settingupclassifieds.html#categories');
	}

	
	function includePictureFunctions(){
        // JHTML::_('stylesheet', 	'components/'.getAdComponentName().'/assets/js/dropzone/dropzone.css');
        // JHTML::_('stylesheet', 	'components/'.getAdComponentName().'/assets/js/dropzone/basic.css');
        JHTML::_('script', 	    'components/'.getAdComponentName().'/assets/js/dropzone/dropzone.js');
        JHTML::_('script',      'components/'.getAdComponentName().'/assets/js/dropzone/ImageUploader.js');
	}

	function includeMultipleLayout(){
		$doc = JFactory::getDocument();
		JHTML::_('stylesheet', 'components/com_jclassifiedsmanager/assets/css/common.css' );
		JHTML::_('stylesheet', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.10/themes/ui-lightness/jquery-ui.css' );
		JHTML::_('stylesheet', 	'components/com_jclassifiedsmanager/assets/css/multi.css');
		JHTML::_('script', 	    'components/com_jclassifiedsmanager/assets/js/multi.js');
	}
	
	function includeValidation(){
		$doc = JFactory::getDocument();
		JHTML::_('stylesheet', JURI::root().'/components/com_jclassifiedsmanager/assets/css/validation/validationEngine.jquery.css' );
		JHTML::_('stylesheet', JURI::root().'/components/com_jclassifiedsmanager/assets/css/validation/template.css' );

		$tag = JAdsUtil::getJoomlaLanguage();
		
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/js/validation/languages/jquery.validationEngine-".$tag.".js");
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/js/validation/jquery.validationEngine.js");
	}
	
}