<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view' );
jimport('joomla.html.pane');
jimport('joomla.html.pagination');

class JClassifiedsManagerViewCategoryAttributes extends JClassifiedsManageAdminView
{

	function display($tpl = null)
	{
		
		$this->user_id = JFactory::getApplication()->input->get('user_id');
		$function = $this->getLayout();
		if(method_exists($this,$function)) 
			$tpl = $this->$function();
		$this->setLayout('default');
		parent::display($tpl);
	}
	
	function listing()
	{
		$model = $this->getModel();
		$this->searchFilter = $model->initSearchFilter();
		
		$attributes = $model->getAllAttributes($this->searchFilter);
		$this->rows = $attributes;
		
		$this->addToolbar();
		//pagination
		$this->pagination = $this->get('Pagination');
		
		
		return null;
	}
	
	function addToolbar(){
		JToolBarHelper::title(  'J-ClassifiedsManager :'.JText::_('LNG_MANAGE_ATTRIBUTES'), 'user.png' );
		JToolBarHelper::addNew('categoryattribute.edit'); 
		JToolBarHelper::deleteList(JText::_('LNG_ARE_YOU_SURE_YOU_WANT_TO_DELETE'), 'categoryattributes.delete', JText::_('LNG_DELETE'), 'Delete', false, false );
		JToolBarHelper::publish('categoryattributes.publish');
		JToolBarHelper::unpublish('categoryattributes.unpublish');
		JToolBarHelper::custom( 'jclassifiedsmanager.dashboard', JAdsUtil::getDashBoardIcon(), 'home', JText::_('LNG_ADS_DASHBOARD'),false, false );
	}

}