<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access');
?>

<div id="jcls-container" class="jcls-container jcls-edit-container">
	<form action="index.php" class="form-horizontal" method="post" name="adminForm" id="adminForm" >
		<div class="row">
			<div class="col-md-8">
				<fieldset class="boxed">
					<h2> <?php echo JText::_('LNG_CURRENCY_SETTINGS'); ?></h2>
					<div class="form-group">
						<label for="currency_options"><?php echo JText::_('LNG_PREDEFINED_CURRENCIES') ?></label>
						<select name="currency_options" id="currency_options" class="form-control" onClick="transferValues(this.value)"> 
							<?php 
								foreach($this->predefinedCurrencies as $currency){
									echo "<option value='$currency->currency|$currency->currency_short|$currency->currency_symbol'>$currency->name - $currency->currency</option>";
								}
							?>
						</select>
					</div>
					<div class="form-group">
						<label for="name"><?php echo JText::_('LNG_NAME') ?></label>
						<input 
							type		= "text"
							name		= "name"
							id			= "name"
							value		= '<?php echo $this->item->name;?>'
							size		= 60
							class		= "form-control validate[required,maxSize[60]]"
						/>
					</div>
					<div class="form-group">
						<label for="code"><?php echo JText::_('LNG_CODE') ?></label>
						<input 
							type		= "text"
							name		= "code"
							id			= "code"
							value		= '<?php echo $this->item->code;?>'
							size		= 60
							class		= "form-control"
						/>
					</div>

					<div class="form-group">
						<label for="code"><?php echo JText::_('LNG_SYMBOL') ?></label>
						<input 
							type		= "text"
							name		= "symbol"
							id			= "symbol"
							value		= '<?php echo $this->item->symbol;?>'
							size		= 60
							class		= "form-control"
						/>
					</div>
				</fieldset>
            </div>
        </div>
						      
			 <script language="javascript" type="text/javascript">

			 	function myValidate(f) {
				   var isError = jQuery("#adminForm").validationEngine('validate');
				   return isError;
				}

				Joomla.submitbutton = function(pressbutton) 
				{
					if (pressbutton == 'currency.save' || pressbutton == 'currency.apply'){
						var isValid = myValidate('#adminForm') ;
						if (isValid == true) {
							Joomla.submitform(pressbutton, document.getElementById('adminForm'));
						}
					}else{
						pressbutton = 'currencies.listing';
						jQuery("#adminForm").validationEngine('detach');
						Joomla.submitform(pressbutton, document.getElementById('adminForm'));
					
					}
				}

				function transferValues(currencyObject){
					var currencyArray = currencyObject.split("|");
					document.getElementById('name').value=currencyArray[0]; 
					document.getElementById('code').value=currencyArray[1]; 
					document.getElementById('symbol').value=currencyArray[2]; 
				}

			</script>  
			<input type="hidden" name="id" value="<?php echo $this->item->id;?>" />
	      	<input type="hidden" name="option" value="<?php echo getAdComponentName()?>" />
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="controller" value="currency" />
			<input type="hidden" name="view" value="currency" />
			<?php echo JHTML::_( 'form.token' ); ?> 
	    </form>
</div>
