<?php 
/**
 * Main view responsable for creating the extension menu structure and admin template
 * 
 * @package    JBusinessDirectory
 * @subpackage  com_jclassifiedsmanager
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later; 
 */
 
JHtml::_('stylesheet', 'components/com_jclassifiedsmanager/assets/css/font-awesome.css');
JHtml::_('stylesheet', 'components/com_jclassifiedsmanager/assets/css/line-awesome.css');
JHtml::_('stylesheet', 'components/com_jclassifiedsmanager/assets/css/metisMenu.css');

require_once JPATH_COMPONENT_SITE.'/helpers/helper.php';

class JClassifiedsManageAdminView extends JViewLegacy{
	
	var $section_name="";
	var $section_description = "";
	
	function __construct($config = array()){
		parent::__construct($config);
		$this->appSettings = JAdsUtil::getApplicationSettings();
		$this->section_name= JText::_("LNG_".strtoupper($this->_name));
		$this->section_description = JText::_("LNG_".strtoupper($this->_name)."_HEADER_DESCR");
	}
	
	/**
	 * Generate the main display for extension views
	 * 
	 * @param unknown_type $tpl
	 */
	public function display($tpl = null)
	{
		$content = $this->loadTemplate($tpl);
	
		if ($content instanceof Exception)
		{
			return $content;
		}
		
		$input = JFactory::getApplication()->input;
		if($input->get('hidemainmenu')){
			echo $content;
			return;
		}
	
		$template = new stdClass();
		$template->content = $content;
		$template->menus = $this->generateMenu();
		$this->checkAccessRights($template->menus);
		$this->setActiveMenus($template->menus, $this->_name);
		
		//include the template and create the view
		$path = JPATH_ADMINISTRATOR . '/components/com_jclassifiedsmanager/theme/template.php';
		$templateFileExists = JFile::exists($path);
		
		$templateContent = $content;
	
		if($templateFileExists){
			ob_start();
			
			// Include the requested template filename in the local scope
			// (this will execute the view logic).
			include $path;
			
			// Done with the requested template; get the buffer and
			// clear it.
			$templateContent = ob_get_contents();
			ob_end_clean();
		}
		
		echo $templateContent;
	}
	
	/**
	 * Check for selected menu and set it active
	 * 
	 */
	private function setActiveMenus(&$menus, $view){
		foreach($menus as &$menu){
			if(($menu["view"] == $view) || ($menu["task"] == $view.'.listing')){
				$menu["active"] = true;
			}
			if(isset($menu["submenu"])){
				foreach($menu["submenu"] as &$submenu){
					if($submenu["view"] == $view){
						$submenu["active"] = true;
						$menu["active"] = true;
					}
				}
			}
		}
	}
	
	/**
	 * Check the access rights for the menu items
	 * @param unknown_type $menus
	 */
	private function checkAccessRights(&$menus){
		$actions = JAdsHelper::getActions();
		
		foreach($menus as &$menu){
			if(!$actions->get($menu["access"])){
				unset($menu);
				continue;
			}
			if(isset($menu["submenu"])){
				foreach($menu["submenu"] as &$submenu){
					if(!$actions->get($submenu["access"])){
						unset($submenu);
						continue;
					}
				}
			}
		}
		
		return $menus;
	}
	
	/**
	 * Build the menu items with all subments
	 * 
	 */
	private function generateMenu(){
		$menus = array();

		$menuItem  = array(
				"title" => JText::_('LNG_ADS_DASHBOARD'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&view=jclassifiedsmanager",
				"view" => "jclassifiedsmanager",
				"task" => "",
				"icon" => "dir-icon-th-large");
		$menus[] = $menuItem;
		
		$menuItem  = array(
				"title" => JText::_('LNG_APPLICATION_SETTINGS'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&view=applicationsettings",
				"view" => "applicationsettings",
				"task" => "",
				"icon" => "dir-icon-cog");
		$menus[] = $menuItem;
		
		$menuItem  = array(
				"title" => JText::_('LNG_PAYMENT_PROCESSORS'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&task=paymentprocessors.listing",
				"view" => "",
				"task" => "paymentprocessors.listing",
				"icon" => "dir-icon-money");
		$menus[] = $menuItem;
		
		$menuItem  = array(
				"title" => JText::_('LNG_PAYMENT_PLANS'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&task=promotionplans.listing",
				"view" => "",
				"task" => "promotionplans.listing",
				"icon" => "dir-icon-level-up");
		$menus[] = $menuItem;
		
		$menuItem  = array(
				"title" => JText::_('LNG_CURRENCY_SETTINGS'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&task=currencies.listing",
				"view" => "",
				"task" => "currencies.listing",
				"icon" => "dir-icon-dollar");
		$menus[] = $menuItem;
		
		$menuItem  = array(
				"title" => JText::_('LNG_EMAIL_TEMPLATES'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&view=emailtemplates",
				"view" => "emailtemplates",
				"task" => "",
				"icon" => "dir-icon-envelope");
		$menus[] = $menuItem;
		
		$menuItem  = array(
				"title" => JText::_('LNG_MANAGE_CATEGORIES'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&task=categories.listing",
				"view" => "",
				"task" => "categories.listing",
				"icon" => "dir-icon-sitemap");
		$menus[] = $menuItem;
		
		$menuItem  = array(
				"title" => JText::_('LNG_MANAGE_CATEGORY_ATTRIBUTES'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&task=categoryattributes.listing",
				"view" => "",
				"task" => "categoryattributes.listing",
				"icon" => "dir-icon-database");
		$menus[] = $menuItem;

		$menuItem  = array(
				"title" => JText::_('LNG_AD_TYPES'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&view=adtypes",
				"view" => "",
				"task" => "adtypes.listing",
				"icon" => "dir-icon-tasks");
		$menus[] = $menuItem;
		
		$menuItem  = array(
				"title" => JText::_('LNG_MANAGE_ADS'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&task=manageads.listing",
				"view" => "",
				"task" => "manageads.listing",
				"icon" => "dir-icon-file-alt");
		$menus[] = $menuItem;
		
		$menuItem  = array(
				"title" => JText::_('LNG_UPDATE'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&view=updates",
				"view" => "updates",
				"task" => "",
				"icon" => "dir-icon-download");
		$menus[] = $menuItem;
			
		$menuItem  = array(
				"title" => JText::_('LNG_ABOUT'),
				"access"=> "core.admin",
				"link" => "index.php?option=com_jclassifiedsmanager&view=about",
				"view" => "about",
				"task" => "",
				"icon" => "dir-icon-info-sign");
		$menus[] = $menuItem;
		

	
		return $menus;
	}
	
	public function setSectionDetails($name, $description){
		$this->section_name = $name;
		$this->section_description = $desciption;
	}
}