<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view' );
jimport('joomla.html.pane');
jimport('joomla.html.pagination');
$appSettings = JAdsUtil::getApplicationSettings();
$key= !empty($appSettings->google_map_key)?"&key=".$appSettings->google_map_key: "";
JHTML::_('script', 'https://maps.google.com/maps/api/js?sensor=true&libraries=places'.$key);

class JClassifiedsManagerViewManageAd extends JClassifiedsManageAdminView
{

	function display($tpl = null)
	{
		
		$function = $this->getLayout();
		
		$model = $this->getModel();
		$this->categories = $model->getParentCategories();
		$this->adTypes = $model->getAllAdTypes();
		$currencies = $model->getAllCurrencies();
		$this->currencies = $currencies;
		$states = JAdsUtil::getAllStates();
		$this->states= $states;
		$userTypes = $model->getAllUserTypes();
		$this->userTypes=$userTypes;
		
		#get ad details 
		$this->adDetails = $model->getAdDetails();	
		#get payment plans
		$this->paymentPlans = $model->getActivePromotionPlans();
		#get payment proccessors 
		$this->paymentProcessors = $model->getPaymentMethods();
		
		$this->ad_id = JFactory::getApplication()->input->get("ad_id",null);
		$this->appSettings = JAdsUtil::getApplicationSettings();
		$this->includeMapFunctions();
		$this->includePictureFunctions();
		$this->editions = $model->getEditions();
		JFactory::getApplication()->input->set( 'hidemainmenu', 1 );
		$this->addToolbar();
		parent::display($tpl);
	}
	

	function addToolbar(){		
		JToolBarHelper::apply('managead.apply');
		JToolBarHelper::save('managead.save');
		JToolBarHelper::title(JText::_('LNG_COM_J_AD_MANAGER').': '.JText::_('LNG_EDIT_ADS'), 'user.png' );
		JToolBarHelper::custom( 'manageads.listing', 'cancel.png', 'cancel.png', 'Cancel',false, false );
        JToolBarHelper::help('', false, DOCUMENTATION_URL.'settingupclassifieds.html#editing-an-ad');
	}


	function includeMapFunctions(){

		$doc = JFactory::getDocument();
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/js/map_functions.js");
		
	
	}

	function includePictureFunctions(){
		$doc = JFactory::getDocument();
		$appSettings = JAdsUtil::getInstance()->getApplicationSettings();
		
		require_once JPATH_COMPONENT_SITE.'/imageupload/includes/settings.php';
		require_once JPATH_COMPONENT_SITE."/imageupload/includes/functions.php";
		
		JHTML::_('stylesheet', JURI::root().'/components/com_jclassifiedsmanager/assets/css/general.css' );
		JHTML::_('stylesheet', JURI::root().'/components/com_jclassifiedsmanager/imageupload/css/style.css' );
		JHTML::_('stylesheet', JURI::root().'components/com_jclassifiedsmanager/imageupload/css/jquery.Jcrop.css' );
		JHTML::_('stylesheet', JURI::root().'components/com_jclassifiedsmanager/imageupload/fancybox/jquery.fancybox-1.3.4.css' );
		JHTML::_('stylesheet', JURI::root().'components/com_jclassifiedsmanager/assets/css/validation/validationEngine.jquery.css' );
		JHTML::_('stylesheet', JURI::root().'components/com_jclassifiedsmanager/assets/css/validation/template.css' );
		
		
		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/imageupload/js/jquery-1.7.min.js");
		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/imageupload/js/jquery-ui-1.7.3.custom.min.js");
		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/imageupload/js/ajaxupload.3.5.js");
		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/imageupload/js/jquery.Jcrop.min.js");
		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/imageupload/fancybox/jquery.mousewheel-3.0.4.pack.js");
		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/imageupload/fancybox/jquery.fancybox-1.3.4.pack.js");
		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/imageupload/js/scrollingcarousel.2.0.min.js");
		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/assets/js/jquery.blockUI.js");
		$tag = JAdsUtil::getJoomlaLanguage();
		
		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/assets/js/validation/languages/jquery.validationEngine-".$tag.".js");
		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/assets/js/validation/jquery.validationEngine.js");
				
		JHTML::_('stylesheet', JURI::root().'components/com_jclassifiedsmanager/imageupload/css/jquery.hoverscroll.css' );
		JHTML::_('stylesheet', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1/themes/smoothness/jquery-ui.css' );
		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/imageupload/js/jquery.hoverscroll.js");

		$max_photonr = $appSettings->max_photos;
		$doc->addScriptDeclaration('
		window.onload = function()	{
			jQuery.noConflict();
		};
		var max_photonr="'.($max_photonr).'";
		'
		);

		JHTML::_('script', JURI::root()."components/com_jclassifiedsmanager/imageupload/js/jUpload.js");
		
		JHTML::_('script', JURI::root()."/components/com_jclassifiedsmanager/assets/js/map_functions.js");


	}
	
}