<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view' );
jimport('joomla.html.pane');
jimport('joomla.html.pagination');
JHtml::_('bootstrap.tooltip');
JHtml::_('bootstrap.framework');

class JClassifiedsManagerViewManageAds extends JClassifiedsManageAdminView
{

	function display($tpl = null)
	{
		
		$function = $this->getLayout();
		if(method_exists($this,$function)) 
			$tpl = $this->$function();
		$this->setLayout('default');
		parent::display($tpl);
	}
	
	function listing()
	{
		$model = $this->getModel();

		$this->searchFilter = $model->initSearchFilter();
		$this->rows = $model->getAllAds($this->searchFilter);
		$this->adTypes = $model->getAllAdTypes();
		$this->categories = $model->getParentCategories();
		$this->states = JAdsUtil::getAllStates();
		$this->cities = JAdsUtil::getAllCities();
		
		$this->paymentStatuses = $model->getPaymentStatuses();
		
		$this->editions = $model->getEditions();
		$this->appSettings = JAdsUtil::getApplicationSettings();
		
		$this->addToolbar();
		//pagination
		$this->pagination=$this->get('Pagination');

		return null;
	}

	function export(){
		$model = $this->getModel();
		$this->searchFilter = $model->initSearchFilter();
			
		$this->adContent = $model->getAdsForExport();
		//dumps($this->adContent);
		
		JToolBarHelper::title(JText::_('LNG_COM_J_AD_MANAGER').': '.JText::_('LNG_EXPORT_ADS'), 'user.png' );
		JToolBarHelper::custom( 'manageads.listing', 'back.png', 'back.png', 'Back',false, false );
		$tpl = "export";
		return $tpl;
		
	}
	
	function addToolbar(){
		JToolBarHelper::title(JText::_('LNG_COM_J_AD_MANAGER').': '.JText::_('LNG_MANAGE_ADS'), 'user.png' );
		JToolBarHelper::addNew('managead.edit');
		JToolBarHelper::publish('manageads.publish');
		JToolBarHelper::unpublish('manageads.unpublish');
		JToolBarHelper::deleteList(JText::_('LNG_ARE_YOU_SURE_YOU_WANT_TO_DELETE'), 'manageads.delete', JText::_('LNG_DELETE'), 'Delete', false, false );
		JToolBarHelper::custom( 'jclassifiedsmanager.dashboard', JAdsUtil::getDashBoardIcon(), 'home', JText::_('LNG_ADS_DASHBOARD'),false, false );
		//JAdsHelper::addSubmenu('manageads');
        JToolBarHelper::help('', false, DOCUMENTATION_URL.'settingupclassifieds.html#managing-ads');
    }

	
}