<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access');
JHtml::_('formbehavior.chosen', 'select');
?>

<div id="jcls-container" class="jcls-container jcls-edit-container">
	<form action="index.php" method="post" name="adminForm" id="adminForm">
		<div class="row">
			<div class="col-md-8">
				<fieldset class="boxed">
					<h2> <?php echo JText::_('LNG_PLAN_SETTINGS'); ?></h2>
					<div class="form-group">
						<label for="name"><?php echo JText::_('LNG_PLAN_NAME') ?></label>
						<input 
							type		= "text"
							name		= "name"
							id			= "name"
							value		= "<?php echo $this->item->name;?>"
							size		= 40
							class		= "form-control validate[required,maxSize[60]]"
						/>
					</div>
					<div class="form-group">
						<label for="type"><?php echo JText::_('LNG_PROMOTION_TYPE')?></label>
						<select name="type" id="type" class="form-control input-medium chosen-select"> 
							<option value='<?php echo PROMOTION_PLAN_PROMOTION ?>' <?php if($this->item->type== PROMOTION_PLAN_PROMOTION) echo "selected";?> ><?php echo JText::_("LNG_PROMOTION")?></option>
							<option value='<?php echo PROMOTION_PLAN_RENEWAL ?>' <?php if($this->item->type== PROMOTION_PLAN_RENEWAL) echo "selected";?>><?php echo JText::_("LNG_RENEWAL")?></option>
							<option value='<?php echo PROMOTION_PLAN_AD_LISTING ?>' <?php if($this->item->type== PROMOTION_PLAN_AD_LISTING) echo "selected";?>><?php echo JText::_("LNG_AD_LISTING_PAYMENT")?></option>
						</select>
					</div>

					<div class="form-group">
						<label for="price"><?php echo JText::_('LNG_PLAN_PRICE')?></label>
						<input 
							type		= "text"
							name		= "price"
							id			= "price"
							value		= '<?php echo $this->item->price;?>'
							size		= 40
							class		= "form-control"
						/> 	
					</div>
					<div class="form-group">
						<label for="period"><?php echo JText::_('LNG_PROMOTION_DURATION')?></label>
						<div class="row">
							<div class="col-md" style="padding-left: 0px;">
								<select name="period" id="period" class="form-control">
									<?php 
										for($i=0;$i<30;$i++){
											if($this->item->period==$i)
												echo "<option value='$i' selected>$i</option>";
											else 
												echo "<option value='$i'>$i</option>";
										}
									?>
								</select>
							</div>
							<div class="col-md">
								<select name="period_unit" id="period_unit" class="form-control">
									<option value='DAY' <?php if($this->item->period_unit=='DAY') echo "selected";?> ><?php echo JText::_("LNG_DAYS")?></option>
									<option value='WEEK' <?php if($this->item->period_unit=='WEEK') echo "selected";?>><?php echo JText::_("LNG_WEEKS")?></option>
									<option value='MONTH'  <?php if($this->item->period_unit=='MONTH') echo "selected";?>><?php echo JText::_("LNG_MONTHS")?></option>
									<option value='YEAR' <?php if($this->item->period_unit=='YEAR') echo "selected";?>><?php echo JText::_("LNG_YEARS")?></option>
								</select>
							</div>
						</div>
					</div>

					<div class="form-group">
						<label for="currency_id"><?php echo JText::_('LNG_CURRENCY')?></label>
						<select name="currency_id" id="currency_id" class="form-control">
							<?php 
								foreach ($this->currencies as $currency){
									if($currency->id == $this->item->currency_id)
										echo "<option value='$currency->id' selected>$currency->name</option>";
									else 
										echo "<option value='$currency->id'>$currency->name</option>";
								}
							?>
						</select>
					</div>

					<div class="form-group">
					<label for="status"><?php echo JText::_('LNG_ACTIVE') ?> </label>
						<fieldset id="status_fld" class="radio btn-group btn-group-yesno">
							<input type="radio" class="validate[required]" name="status" id="status1"
									value="1" <?php echo $this->item->status == true ? 'checked="checked"' : "" ?> />
							<label class="btn" for="status1"><?php echo JText::_('LNG_YES') ?></label>
							<input type="radio" class="validate[required]" name="status" id="status0"
									value="0" <?php echo $this->item->status == false ? 'checked="checked"' : "" ?> />
							<label class="btn" for="status0"><?php echo JText::_('LNG_NO') ?></label>
						</fieldset>
					</div>
				</fieldset>
			</div>	
		</div>

		<input type="hidden" name="id" value="<?php echo $this->item->id;?>" />
		<input type="hidden" name="option" value="<?php echo getAdComponentName()?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="controller" value="promotionplans" />
		<input type="hidden" name="view" value="promotionplans" />
	</form>
</div>	
	 <script language="javascript" type="text/javascript">


	 	function myValidate(f) {
		   var isError = jQuery("#adminForm").validationEngine('validate');
		   return isError;
		}

		Joomla.submitbutton = function(pressbutton) 
		{
			if (pressbutton == 'promotionplan.save' || pressbutton == 'promotionplan.apply'){
				var isValid = myValidate('#adminForm') ;
				if (isValid == true) {
					Joomla.submitform(pressbutton, document.getElementById('adminForm'));
				}
			}else{
				pressbutton = 'promotionplans.listing';
				jQuery("#adminForm").validationEngine('detach');
				Joomla.submitform(pressbutton, document.getElementById('adminForm'));
			
			}
		}

        jQuery(document).ready(function () {
            addingClasses("td.btn-group");
        });
	</script>  