<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
defined( '_JEXEC' ) or die( 'Restricted access' );

require_once JPATH_COMPONENT_SITE.'/classes/payment/paymentprocessorinterface.php';

class Cash implements iPaymentProcessor{
	
	public function initialize($data){
		$this->code =  $data->code;
		$this->name =  $data->name;
		$this->timeout = $data->timeout;
		$this->mode = $data->mode;
	}
	
	public function getPaymentDetails($adData){
		$result = JText::_('LNG_PROCESSOR_CASH');
		return $result;
		}
	
	public function processTransaction($clientData,$orderData,$cardData){
		$result = new stdClass();
		$result->amount =  $orderData->amount;
		$result->payment_date = date("Y-m-d");
		$result->response_code = 0;
		$result->order_id = $orderData->order_id;
		$result->processor_code = $this->code;
		$result->orderMessage = "";
		$result->status = JCLS_PAYMENT_STATUS_PAID;
		$result->payment_status = JCLS_PAYMENT_STATUS_PAID;
		$result->msg = "";
		return $result;
	}
	
	public function getPaymentProcessorHtml(){
		$html ="<ul id=\"payment_form_$this->code\" class=\"form-list\">
			<li>
			    ".JText::_('LNG_PROCESSOR_DESCRIPTION_CASH')."
			    </li>
			</ul>";
	
		return $html;
	}

	public function getHtmlFields(){
	
	}
}