<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access

require_once dirname(__FILE__) .'/payment/request/abstract.php';
require_once dirname(__FILE__) .'/payment/request/card.php';
require_once dirname(__FILE__) .'/payment/invoice.php';
require_once dirname(__FILE__) .'/payment/address.php';
require_once dirname(__FILE__) .'/payment/request/notify.php';
require_once dirname(dirname(__FILE__)) .'/paymentfactory.php';
require_once $_SERVER['DOCUMENT_ROOT']."/components/com_jclassifiedsmanager/helpers/logger.php";
require_once $_SERVER['DOCUMENT_ROOT']."/components/com_jclassifiedsmanager/helpers/defines.php";


try{
	$log = Logger::getInstance(dirname(dirname(dirname(dirname(__FILE__))))."/logs/site-log-".date("d-m-Y").".log",1);
	$log->LogDebug("received confirmation from mobilpay");
	$errorCode 		= 0;
	$errorType		= Mobilpay_Payment_Request_Abstract::CONFIRM_ERROR_TYPE_NONE;
	$errorMessage	= '';
	
	$orderStatus = JCLS_PAYMENT_STATUS_PENDING;
	
	if (strcasecmp($_SERVER['REQUEST_METHOD'], 'post') == 0)
	{
		if(isset($_POST['env_key']) && isset($_POST['data']))
		{
			#calea catre cheia privata
			#cheia privata este generata de mobilpay, accesibil in Admin -> Conturi de comerciant -> Detalii -> Setari securitate
			$privateKeyFilePath = dirname(__FILE__) .'/keys/private.key';
			try
			{
				$objPmReq = Mobilpay_Payment_Request_Abstract::factoryFromEncrypted($_POST['env_key'], $_POST['data'], $privateKeyFilePath);
		    	switch($objPmReq->objPmNotify->action)
		    	{
				#orice action este insotit de un cod de eroare si de un mesaj de eroare. Acestea pot fi citite folosind $cod_eroare = $objPmReq->objPmNotify->errorCode; respectiv $mesaj_eroare = $objPmReq->objPmNotify->errorMessage;
				#pentru a identifica ID-ul comenzii pentru care primim rezultatul platii folosim $id_comanda = $objPmReq->orderId;
		        case 'confirmed':
					#cand action este confirmed avem certitudinea ca banii au plecat din contul posesorului de card si facem update al starii comenzii si livrarea produsului
		        	$errorMessage = $objPmReq->objPmNotify->getCrc();
		    		$orderStatus = STATUS_PAID;
		            break;
				case 'confirmed_pending':
					#cand action este confirmed_pending inseamna ca tranzactia este in curs de verificare antifrauda. Nu facem livrare/expediere. In urma trecerii de aceasta verificare se va primi o noua notificare pentru o actiune de confirmare sau anulare.
		        	$errorMessage = $objPmReq->objPmNotify->getCrc();
		        	$orderStatus = JCLS_PAYMENT_STATUS_PENDING;
		        	
		            break;
				case 'paid_pending':
					#cand action este paid_pending inseamna ca tranzactia este in curs de verificare. Nu facem livrare/expediere. In urma trecerii de aceasta verificare se va primi o noua notificare pentru o actiune de confirmare sau anulare.
		        	$errorMessage = $objPmReq->objPmNotify->getCrc();
		        	$orderStatus = JCLS_PAYMENT_STATUS_PENDING;
		        	
		            break;
				case 'paid':
					#cand action este paid inseamna ca tranzactia este in curs de procesare. Nu facem livrare/expediere. In urma trecerii de aceasta procesare se va primi o noua notificare pentru o actiune de confirmare sau anulare.
		        	$errorMessage = $objPmReq->objPmNotify->getCrc();
		        	$orderStatus = JCLS_PAYMENT_STATUS_PENDING;
		        	
		            break;
				case 'canceled':
					#cand action este canceled inseamna ca tranzactia este anulata. Nu facem livrare/expediere.
		        	$errorMessage = $objPmReq->objPmNotify->getCrc();
		        	$orderStatus = JCLS_PAYMENT_STATUS_CANCELLED;
		        	
		            break;
				case 'credit':
					#cand action este credit inseamna ca banii sunt returnati posesorului de card. Daca s-a facut deja livrare, aceasta trebuie oprita sau facut un reverse. 
		        	$errorMessage = $objPmReq->objPmNotify->getCrc();
		        	$orderStatus = JCLS_PAYMENT_STATUS_CANCELLED;
		        	
		            break;
		        default:
		        	$errorType		= Mobilpay_Payment_Request_Abstract::CONFIRM_ERROR_TYPE_PERMANENT;
		            $errorCode 		= Mobilpay_Payment_Request_Abstract::ERROR_CONFIRM_INVALID_ACTION;
		            $errorMessage 	= 'mobilpay_refference_action paramaters is invalid';
		            $orderStatus = JCLS_PAYMENT_STATUS_PENDING;
		             
		            break;
		    	}
			}
			catch(Exception $e)
			{
				$log->LogDebug("Exception in handling mobilpay response".$e->getMessage());
				
				$errorType 		= Mobilpay_Payment_Request_Abstract::CONFIRM_ERROR_TYPE_TEMPORARY;
				$errorCode		= $e->getCode();
				$errorMessage 	= $e->getMessage();
			}
		}
		else
		{
			$log->LogDebug("Invalid post parameters: env_key or data missing ".$e->getMessage());
				
			$errorType 		= Mobilpay_Payment_Request_Abstract::CONFIRM_ERROR_TYPE_PERMANENT;
			$errorCode		= Mobilpay_Payment_Request_Abstract::ERROR_CONFIRM_INVALID_POST_PARAMETERS;
			$errorMessage 	= 'mobilpay.ro posted invalid parameters';
		}
	}
	else 
	{
		$errorType 		= Mobilpay_Payment_Request_Abstract::CONFIRM_ERROR_TYPE_PERMANENT;
		$errorCode		= Mobilpay_Payment_Request_Abstract::ERROR_CONFIRM_INVALID_POST_METHOD;
		$errorMessage 	= 'invalid request metod for payment confirmation';
	}
	$log->LogDebug("got response: type=".$errorType." code=".$errorCode." message=".$errorMessage);
	
	/*header('Content-type: application/xml');
	echo "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
	if($errorCode == 0)
	{
		echo "<crc>{$errorMessage}</crc>";
	}
	else
	{
		echo "<crc error_type=\"{$errorType}\" error_code=\"{$errorCode}\">{$errorMessage}</crc>";
	}*/
	if(isset($objPmReq->orderId)){
		$message = "message:".$errorMessage."_error code:".$errorCode."_type=".$errorType;
		$message = "";
		
		$log->LogDebug("updating order status for order: ".$objPmReq->orderId." with status ".$orderStatus);
		$orderURL='http://'.$_SERVER['SERVER_NAME'].'/index.php?option=com_jclassifiedsmanager&controller=manageorders&task=updateOrder&orderId='.$objPmReq->orderId."&orderMessage=".$message."&orderStatus=".$orderStatus;
		$log->LogDebug("calling url ".$orderURL);
		header("Location: ".$orderURL);
		exit;
	}
}
catch(Exception $e){
	$log->LogDebug("Exception in handling card confirm".$e->getMessage());
}
