<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

require_once dirname(__FILE__) .'/payment/request/abstract.php';
require_once dirname(__FILE__) .'/payment/request/card.php';
require_once dirname(__FILE__) .'/payment/invoice.php';
require_once dirname(__FILE__) .'/payment/address.php';
require_once dirname(__FILE__) .'/payment/request/notify.php';
require_once JPATH_COMPONENT_SITE.'/classes/payment/paymentprocessorinterface.php';

class mobilpay implements iPaymentProcessor{
	
	var $paymentUrlTest = 'http://sandboxsecure.mobilpay.ro';
	var $paymentUrl = 'https://secure.mobilpay.ro';
	var $signature = 'V6TG-DADA-1S2E-YSJ1-7C3T';
	var $x509FilePath;
	var $privateKeyPath;
	var $returnUrl;
	var $confirmUrl; 

	public function initialize($data){
		$this->code =  $data->code;
		$this->name =  $data->name;
		$this->mode = $data->mode;
		$this->fields = $data->fields;
		
		$this->returnUrl = 'http://'.$_SERVER['SERVER_NAME'].'/components/com_jclassifiedsmanager/classes/payment/mobilpay/orderstatus.php';
		$this->confirmUrl = 'http://'.$_SERVER['SERVER_NAME'].'/components/com_jclassifiedsmanager/classes/payment/mobilpay/cardconfirm.php';
		$this->x509FilePath 	=  dirname(__FILE__) .'/keys/public.cer';
		$this->privateKeyPath 	=  dirname(__FILE__) .'/keys/private.key';
		$this->_log_file ="log.txt"; 
		$this->payURL = $this->mode=="test"?$this->paymentUrlTest:$this->paymentUrl;
		
	}
	
	
	public function processTransaction($clientData,$orderData,$cardData){
		try
		{
			srand((double) microtime() * 1000000);
			$objPmReqCard 						= new Mobilpay_Payment_Request_Card();
			#merchant account signature - generated by mobilpay.ro for every merchant account
			#semnatura contului de comerciant - mergi pe www.mobilpay.ro Admin -> Conturi de comerciant -> Detalii -> Setari securitate
			$objPmReqCard->signature 			= $this->signature;
			#you should assign here the transaction ID registered by your application for this commercial operation
			#order_id should be unique for a merchant account
			$objPmReqCard->orderId 				= $orderData->orderId;
			#supply return_url and/or confirm_url only if you want to overwrite the ones configured for the service/product when it was created
			#if you don't want to supply a different return/confirm URL, just let it null
			$objPmReqCard->confirmUrl 			= $this->confirmUrl;
			$objPmReqCard->returnUrl 			= $this->returnUrl;
		
			#detalii cu privire la plata: moneda, suma, descrierea
			#payment details: currency, amount, description
			$objPmReqCard->invoice = new Mobilpay_Payment_Invoice();
			$objPmReqCard->invoice->currency	= "RON";
			$objPmReqCard->invoice->amount		= $orderData->amount;
			$objPmReqCard->invoice->installments= '2,3';
			$objPmReqCard->invoice->details		= $orderData->description;
		
			#detalii cu privire la adresa posesorului cardului
			#details on the cardholder address
			$billingAddress 				= new Mobilpay_Payment_Address();
			$billingAddress->type			= $clientData->type;
			$billingAddress->firstName		= $clientData->first_name;
			$billingAddress->lastName		= $clientData->last_name;
			$billingAddress->fiscalNumber	= $clientData->fiscal_number;
			$billingAddress->identityNumber	= $clientData->identity_number;
			$billingAddress->country		= $clientData->country;
			$billingAddress->county			= $clientData->county;
			$billingAddress->city			= $clientData->city;
			$billingAddress->zipCode		= $clientData->zip_code;
			$billingAddress->address		= $clientData->_address;
			$billingAddress->email			= $clientData->email;
			$billingAddress->mobilePhone	= $clientData->mobile_phone;
			$billingAddress->bank			= $clientData->bank;
			$billingAddress->iban			= $clientData->iban;
			$objPmReqCard->invoice->setBillingAddress($billingAddress);
		
			#detalii cu privire la adresa de livrare
			#details on the shipping address
			$objPmReqCard->invoice->setShippingAddress($billingAddress);
			$objPmReqCard->encrypt($this->x509FilePath);

			$postData = array();
			$postData["data"] = $objPmReqCard->getEncData(); 
			$postData["env_key"] = $objPmReqCard->getEnvKey();

			$this->sendCardRequest($postData,$this->payURL);
		}
		catch(Exception $e)
		{
			throw $e; 
		}		
		
	}
	function getPaymentGatewayUrl(){
		return $this->payURL;
	}
	
	public function getPaymentDetails($adData){
		return JText::_('LNG_PROCESSOR_MOBILPAY_DETAIL',true);
	}
		
	public function getPaymentProcessorHtml(){
		$html ="<ul id=\"payment_form_$this->code\" class=\"form-list\">
				<li>
				    ".JText::_('LNG_PROCESSOR_DESCRIPTION_MOBILPAY')."
				    </li>
				</ul>";
	
		return $html;
	}
	
	protected function sendCardRequest($data,$url)
	{
		require_once dirname(__FILE__) .'/cardredirect.php';
		exit;
	}
			
	public function getHtmlFields(){
		
	}
}