<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
//defined('_JEXEC') or die('Restricted access');

class processorFactory{

	//get processor instance based on the class name 
	function getProcessor($processorType){
		$processorPath = JPATH_COMPONENT_SITE.'/classes/payment/'.$processorType."/".$processorType.".php"; // processor will be in processorName folder, proccessorName class
		require_once $processorPath;
		if (class_exists($processorType)){
			$processor = new $processorType();
		}
		else 
			throw new Exception("Processor $processorType does not exist");
		
		return $processor;
	}
	
	function getProcessorData($processorId){
		$db		= JFactory::getDBO();
		$query	= "	SELECT * FROM #__classifiedsmanager_payment_processors where id= '$processorId'";
		$db->setQuery( $query );
		$processorSettings =   $db->loadObject();
		
		//get extra fields
		$query	= "	SELECT * FROM #__classifiedsmanager_payment_processor_extrafields where processor_id = '$processorId'";
		$db->setQuery( $query );
		$results = $db->loadObjectList();
		foreach($results as $result){
			$columnName  =$result->column_name;
			$processorSettings->$columnName = $result->column_value;
		}
		return $processorSettings;
		
	}
		
}