<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

require_once JPATH_COMPONENT_SITE.'/classes/payment/paymentprocessorinterface.php';

class Paypal implements iPaymentProcessor {
	
	var $type;
	var $name;
	
	var $paypal_email;
	var $mode;
	var $paymentUrlTest = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
	var $paymentUrl = 'https://www.paypal.com/cgi-bin/webscr';
	
	var $notifyUrl;
	var $returnUrl;
	var $cancelUrl;
	
	var $currencyCode;
	var $amount;
	var $itemNumber;
	var $itemName;
	var $adId;
	

	public function initialize($data){
		$this->code =  $data->code;
		$this->name =  $data->name;
		$this->mode = $data->mode;
		$this->paypal_email = $data->fields['paypal_email'];
		$this->returnUrl = JRoute::_('index.php?option=com_jclassifiedsmanager&controller=paymentprocessor&task=processResponse',false,-1);
		$this->notifyUrl = JRoute::_('index.php?option=com_jclassifiedsmanager&controller=paymentprocessor&task=processAutomaticResponse',false,-1);
		$this->cancelUrl = JRoute::_('index.php?option=com_jclassifiedsmanager&controller=paymentprocessor&task=processCancelResponse',false,-1);
	}
	
	
	public function getPaymentGatewayUrl(){
		if($this->mode=="test"){
			return $this->paymentUrlTest;
		}else{
			return $this->paymentUrl;
		}
	}
	
	public function getPaymentProcessorHtml(){
		$html ="<ul id=\"payment_form_$this->type\" class=\"form-list\">
		<li>
		    ".JText::_('LNG_PROCESSOR_DESCRIPTION_PAYPAL')."
		    </li>
		</ul>";
		
		return $html;
	}
	
	public function getHtmlFields() {
		
		$this->notifyUrl.="&processor=paypal";
		$this->returnUrl.="&processor=paypal";
		
		$html  = '';
		$html .= sprintf('<input type="hidden" name="cmd" id="cmd" value="_xclick"/>');
		$html .= sprintf('<input type="hidden" name="charset" id="charset" value="utf-8">');
		$html .= sprintf('<input type="hidden" name="item_name" id="item_name" value="%s">', $this->itemName);
		$html .= sprintf('<input type="hidden" name="item_number" id="item_number" value="%s">', $this->itemNumber);
		$html .= sprintf('<input type="hidden" name="no_shipping" id="no_shipping" value="1">');
		$html .= sprintf('<input type="hidden" name="business" id="business" value="%s">',$this->paypal_email);
		$html .= sprintf('<input type="hidden" name="cbt" id="cbt" value="%s">',JText::_('LNG_CONTINUE_PAYMENT',true));
		
		$html .= sprintf('<input type="hidden" name="notify_url" id="notify_url" value="%s">', $this->notifyUrl);
		$html .= sprintf('<input type="hidden" name="return" id="return" value="%s">', $this->returnUrl);
		$html .= sprintf('<input type="hidden" name="cancel_return" id="cancel_return" value="%s">', $this->cancelUrl);
		
		$html .= sprintf('<input type="hidden" name="amount" value="%d" />', $this->amount);
		$html .= sprintf('<input type="hidden" name="currency_code" value="%s" />', $this->currencyCode);
		$html .= sprintf('<input type="hidden" name="custom" value="%s" />', $this->adId);
	
		return $html;
	}
	
	public function processTransaction($clientData,$orderData,$cardData){
		$this->amount = $orderData->amount;
		$this->itemName = $orderData->description;
		$this->itemNumber = $orderData->order_id;
		$this->currencyCode = $orderData->currency;
		$this->adId = $orderData->ad_id;
		$result = new stdClass();
		$result->amount =  $orderData->amount;
		$result->payment_date = date("Y-m-d");
		$result->response_code = 0;
		$result->order_id = $orderData->order_id;
		$result->processor_code = $this->code;
		$result->status = JCLS_PAYMENT_REDIRECT;
		$result->payment_status = JCLS_PAYMENT_STATUS_PENDING;
		$result->payment_processor = $this;
		$result->msg = "";
		
		return $result;
	}
	
	public function processResponse($data){
		$result = new stdClass();
		$result->transaction_id = $data["txn_id"];
		$result->amount = $data["mc_gross"];
		$result->payment_date = $data["payment_date"];
		$result->response_code = $data["payment_status"];
		$result->order_id = $data["item_number"];
		$result->currency= $data["mc_currency"];
		$result->ad_id= $data["custom"];
		$result->processor_type = $this->type;
		$result->status = JCLS_PAYMENT_STATUS_PAID;
		$result->payment_status = JCLS_PAYMENT_STATUS_PAID;
		$result->msg = "";
		return $result;
	}

	public function getPaymentDetails($data){
		return JText::_('LNG_PROCESSOR_PAYPAL',true);
	}
}