<?php
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
defined( '_JEXEC' ) or die( 'Restricted access' );

require_once JPATH_COMPONENT_SITE.'/classes/payment/paymentprocessorinterface.php';

class WireTransfer implements iPaymentProcessor{
	
	public function initialize($data){
		$this->code =  $data->code;
		$this->name =  $data->name;
		$this->timeout = $data->timeout;
		$this->mode = $data->mode;
		$this->fields = $data->fields;
	}
	
	public function getPaymentDetails($adData){
		$result = "";
	
		$result = str_replace(EMAIL_MAX_DAYS_PAYD,	floor($this->timeout/(24)), JText::_('LNG_PROCESSOR_PAYMENT_MANUAL'));
		$toPay = $adData->orderData->price;
		$result .= str_replace(EMAIL_ORDER_AMOUNT, $toPay."(".$adData->orderData->currency.")", JText::_('LNG_PROCESSOR_BANK_TRANSFER_EMAIL_TEXT'));
		ob_start();
		?>
				<br/><br/>
				<TABLE>
					<?php
					foreach($this->fields as $column=>$value){?>
					<TR>
						<TD align=left width=40% nowrap>
							<b><?php echo JText::_('LNG_'.strtoupper($column),true);?> :</b>
						</TD> 
						<TD>
							<?php echo $value?>
						</TD>
					</TR>
					<?php } ?>
				</TABLE>
				<br/><br/>
			<?php
			$result = $result.ob_get_contents();
			$text = JText::_("LNG_PROCESSOR_BANK_TRANSFER_EMAIL_TEXT_IBAN");
			$result = $result.$text;
			$result = $result.JText::_("LNG_PROCESSOR_BANK_TRANSFER_EMAIL_TEXT_USER");
			ob_end_clean();
			
			return $result;
		}
	
	public function processTransaction($clientData,$orderData,$cardData){
		$result = new stdClass();
		$result->amount =  $orderData->amount;
		$result->payment_date = date("Y-m-d");
		$result->response_code = 0;
		$result->order_id = $orderData->order_id;
		$result->processor_code = $this->code;
		$result->status = JCLS_PAYMENT_STATUS_PENDING;
		$result->payment_status = JCLS_PAYMENT_STATUS_PENDING;
		$result->msg = "";
		return $result;
	}
	
	public function getPaymentProcessorHtml(){
		$html ="<ul id=\"payment_form_$this->code\" class=\"form-list\">
			<li>
			    ".JText::_('LNG_PROCESSOR_DESCRIPTION_WIRETRANSFER')."
			    </li>
			</ul>";
	
		return $html;
	}

	public function getHtmlFields(){
	
	}
}