<?php 
/*------------------------------------------------------------------------
# JClassifiedsManager
# author CMSJunkie
# copyright Copyright (C) 2012 CMSJunkie.com. All Rights Reserved.
# @license - https://www.gnu.org/licenses/agpl-3.0.en.html GNU/GPL
# Websites: http://www.CMSJunkie.com
# Technical Support:  Forum - http://www.CMSJunkie.com/forum/j-classifiedsmanager/?p=1
-------------------------------------------------------------------------*/
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

JTable::addIncludePath('administrator/components/com_jclassifiedsmanager/tables');

class AdService{
	function __construct()
	{
		$this->log = Logger::getInstance();
	}

	public static function  getAdDetails($adId,$orderId=null)
	{
		$adData = new stdClass();
		$adTable = JTable::getInstance('ManageAds','Table', array());
		$adDetails = $adTable->getAdDetailsDetailed($adId); 
		$adData->adDetails = $adDetails;

		if($orderId!=null){
			$orderTable = JTable::getInstance('ManageOrders','Table', array());
			$orderDetails = $orderTable->getOrderDetails($orderId);
		}
		else	
			$orderDetails = $adTable->getPaymentDetails($adId);
		
		$adData->orderData= $orderDetails; 
		$adData->appSettings = JAdsUtil::getInstance()->getApplicationSettings();
		$adData->adDetailsHtml = self::getHtmlAdDetails($adDetails);
		
		if(isset($orderDetails) && isset($orderDetails->order_id)){
			$processor = PaymentService::createPaymentProcessor($orderDetails->processorType); 
			$adData->paymentInformation = $processor->getPaymentDetails($adData);
		}
		else {
			$adData->paymentInformation = JText::_("LNG_NONE_SELECTED");
			$adData->orderData =new stdClass();
			$adData->orderData->order_id =""; 
			$adData->orderData->description ="";
			$adData->orderData->creation_date ="";
		}	

		return $adData;		
	}
	
	static function getHtmlAdDetails($adDetails){
			$result = "";
			ob_start();
			?>
			<div id = "adDetails">
				<TABLE>
					<TR>
						<TD align=left width=40% >
							<?php echo JText::_('LNG_LOCATION').":".$adDetails->state.':'.$adDetails->city;?>
							<br/>
							<?php echo JText::_('LNG_CATEGORY').':'.$adDetails->category;?>
							
						</TD> 
					</TR>
					<TR>
						<TD align=left width=40% >
							<b>	
							<?php echo $adDetails->title;?>
							</b>
						</TD> 
					</TR>					
					<TR>
						<TD align=left width=40% nowrap>
							<?php echo "<b>	".JTEXT::_('LNG_PRICE')."</b> :".$adDetails->price." ".$adDetails->currency;?>
						</TD> 
					</TR>					
					<TR>
						<TD align=left width=40% >
							<?php echo $adDetails->attributeNameValues;?>
						</TD> 
					</TR>
					<TR>
						<TD align=left width=40% >
							 <?php echo $adDetails->description;?>
						</TD> 
					</TR>
				</TABLE>
				<br/><br/>
			<?php
			$result = $result.ob_get_contents();
			ob_end_clean();
			return $result;
	}
	
}


?>